/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.intrinsic;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.ITensuraEPCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import io.github.Memoires.trmysticism.api.Contract;
import io.github.Memoires.trmysticism.capability.race.IMysticismPlayerCapability;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.util.ContractMagicTable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ContractSkill
extends Skill {
    public ContractSkill() {
        super(Skill.SkillType.INTRINSIC);
    }

    @Nullable
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/intrinsic/contract.png");
    }

    public int modes() {
        return 3;
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        int modes = this.modes();
        if (reverse) {
            return ((instance.getMode() - 2) % modes + modes) % modes + 1;
        }
        return instance.getMode() % modes + 1;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.contract.contract");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.contract.dissolve");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.contract.force_summon");
            default -> Component.m_237119_();
        };
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        MysticismPlayerCapability.getFrom(player).ifPresent(cap -> {
            Contract activeContract = cap.getActiveContract();
            switch (instance.getMode()) {
                case 1: {
                    if (activeContract != null) {
                        ServerPlayer contractee = player.m_20194_().m_6846_().m_11259_(activeContract.getContracteeUUID());
                        if (contractee == null) {
                            return;
                        }
                        MutableComponent alreadyContractedMessage = Component.m_237110_((String)"trmysticism.message.contract.already_contracted", (Object[])new Object[]{player.m_5446_()});
                        player.m_5661_((Component)alreadyContractedMessage.m_130940_(ChatFormatting.RED), false);
                        return;
                    }
                    Player target = this.getPlayerInFront(player, 3.0);
                    if (target == null) break;
                    this.sendContractRequest(target, player);
                    break;
                }
                case 2: {
                    if (activeContract == null) {
                        MutableComponent dissolveFailMessage = Component.m_237115_((String)"trmysticism.message.contract.dissolve_fail");
                        player.m_5661_((Component)dissolveFailMessage.m_130940_(ChatFormatting.RED), false);
                        return;
                    }
                    ServerPlayer contractee = player.m_20194_().m_6846_().m_11259_(activeContract.getContracteeUUID());
                    if (contractee == null) {
                        return;
                    }
                    MysticismPlayerCapability.getFrom((Player)contractee).ifPresent(arg_0 -> ContractSkill.lambda$onPressed$0(activeContract, (Player)contractee, player, arg_0));
                    break;
                }
                case 3: {
                    if (activeContract == null) {
                        return;
                    }
                    ServerPlayer contractee = player.m_20194_().m_6846_().m_11259_(activeContract.getContracteeUUID());
                    if (contractee == null) {
                        cap.setSummonStatus(true);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer sp = (ServerPlayer)player;
                            if (cap.getSavedGamemode() != null) {
                                sp.m_143403_(cap.getSavedGamemode());
                                cap.setSavedGamemode(null);
                            } else {
                                sp.m_143403_(GameType.SURVIVAL);
                            }
                            sp.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)player));
                        }
                        return;
                    }
                    if (cap.getSummonStatus()) {
                        if (!TensuraPlayerCapability.isSpiritualForm((Player)player)) {
                            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.message.contract.not_spiritual_form").m_130940_(ChatFormatting.RED), false);
                            return;
                        }
                        cap.setSummonStatus(false);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer sp = (ServerPlayer)player;
                            cap.setSavedGamemode(sp.f_8941_.m_9290_());
                            if (sp.m_9236_().m_46472_() != contractee.m_9236_().m_46472_()) {
                                SkillHelper.moveAcrossDimensionTo((Entity)sp, (Entity)contractee);
                            } else {
                                sp.m_6021_(contractee.m_20185_(), contractee.m_20186_(), contractee.m_20189_());
                            }
                            sp.m_143403_(GameType.SPECTATOR);
                            cap.setPendingCameraTarget(contractee.m_20148_());
                            cap.setCameraRetryTicks(20);
                        }
                        MutableComponent forceSummonSelfMessage = Component.m_237115_((String)"trmysticism.message.contract.cancel_force_summon_contractor");
                        MutableComponent forceSummonOtherMessage = Component.m_237110_((String)"trmysticism.message.contract.cancel_force_summon_contractee", (Object[])new Object[]{player.m_5446_()});
                        player.m_5661_((Component)forceSummonSelfMessage.m_130940_(ChatFormatting.RED), false);
                        contractee.m_5661_((Component)forceSummonOtherMessage.m_130940_(ChatFormatting.RED), false);
                        break;
                    }
                    cap.setSummonStatus(true);
                    TensuraEPCapability.getFrom((LivingEntity)player).ifPresent(arg_0 -> ContractSkill.lambda$onPressed$1((Player)contractee, arg_0));
                    SkillHelper.moveAcrossDimensionTo((Entity)player, (Entity)contractee);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)player;
                        if (cap.getSavedGamemode() != null) {
                            sp.m_143403_(cap.getSavedGamemode());
                            cap.setSavedGamemode(null);
                        } else {
                            sp.m_143403_(GameType.SURVIVAL);
                        }
                        sp.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)player));
                    }
                    MutableComponent forceSummonSelfMessage = Component.m_237115_((String)"trmysticism.message.contract.start_force_summon_contractor");
                    MutableComponent forceSummonOtherMessage = Component.m_237110_((String)"trmysticism.message.contract.start_force_summon_contractee", (Object[])new Object[]{player.m_5446_()});
                    player.m_5661_((Component)forceSummonSelfMessage.m_130940_(ChatFormatting.GREEN), false);
                    contractee.m_5661_((Component)forceSummonOtherMessage.m_130940_(ChatFormatting.GREEN), false);
                    break;
                }
            }
        });
    }

    private Player getPlayerInFront(Player player, double distance) {
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 lookVec = player.m_20154_();
        Vec3 reachPos = eyePos.m_82549_(lookVec.m_82490_(distance));
        AABB aabb = player.m_20191_().m_82369_(lookVec.m_82490_(distance)).m_82400_(1.0);
        return player.f_19853_.m_45976_(Player.class, aabb).stream().filter(target -> target != player && target.m_20191_().m_82335_(eyePos, reachPos)).findFirst().orElse(null);
    }

    private void sendContractRequest(Player target, Player source) {
        Contract contract = new Contract(source, target);
        MysticismPlayerCapability.getFrom(target).ifPresent(cap -> cap.offerContract(contract));
        MutableComponent message = Component.m_237110_((String)"trmysticism.message.contract.request", (Object[])new Object[]{source.m_5446_()}).m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)"[VIEW]").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/mysticism spirit viewContract " + contract.getId())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("/mysticism spirit viewContract " + contract.getId()))))));
        MutableComponent contractSentMessage = Component.m_237110_((String)"trmysticism.message.contract.contract_sent", (Object[])new Object[]{target.m_5446_()});
        target.m_5661_((Component)message, false);
        target.m_5661_((Component)Component.m_237110_((String)"trmysticism.message.contract.contract_id", (Object[])new Object[]{contract.getId()}), false);
        source.m_5661_((Component)contractSentMessage.m_130940_(ChatFormatting.GREEN), false);
    }

    private static /* synthetic */ void lambda$onPressed$1(Player contractee, ITensuraEPCapability contractorCap) {
        contractorCap.setTemporaryOwner(contractee.m_20148_());
    }

    private static /* synthetic */ void lambda$onPressed$0(Contract activeContract, Player contractee, Player player, IMysticismPlayerCapability contracteeCap) {
        if (contracteeCap.dissolveContract(activeContract)) {
            MutableComponent dissolveSelfMessage = Component.m_237110_((String)"trmysticism.message.contract.dissolve_contractor", (Object[])new Object[]{contractee.m_5446_()});
            MutableComponent dissolveOtherMessage = Component.m_237110_((String)"trmysticism.message.contract.dissolve_contractee", (Object[])new Object[]{player.m_5446_()});
            player.m_5661_((Component)dissolveSelfMessage.m_130940_(ChatFormatting.RED), false);
            contractee.m_5661_((Component)dissolveOtherMessage.m_130940_(ChatFormatting.RED), false);
            if (contractee instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)contractee;
                ContractMagicTable.revoke(sp, activeContract.getElement(), activeContract.getGrantedTier());
            }
        }
    }
}

