/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.intrinsic;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.entity.magic.lightning.LightningBolt;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.IForgeRegistry;

public class DissonanceSkill
extends Skill {
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/intrinsic/dissonance.png");
    }

    public DissonanceSkill() {
        super(Skill.SkillType.INTRINSIC);
    }

    public double getObtainingEpCost() {
        return 100.0;
    }

    public int modes() {
        return 1;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 30000.0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Race playerRace = TensuraPlayerCapability.getRace((LivingEntity)entity);
        if (playerRace == null || !playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DISSONANCE_DEITY))) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.dissonance.not_deity").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            return;
        }
        Level level = entity.m_9236_();
        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            Vec3 targetPos;
            this.addMasteryPoint(instance, entity);
            LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)50.0, (boolean)false, (boolean)false);
            if (target != null) {
                targetPos = target.m_20182_();
            } else {
                BlockHitResult result = SkillHelper.getPlayerPOVHitResult((Level)level, (Entity)entity, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)50.0);
                targetPos = result.m_82450_();
            }
            Vec3[] directions = new Vec3[]{new Vec3(1.0, 0.0, 0.0), new Vec3(-1.0, 0.0, 0.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, -1.0), new Vec3(1.0, 0.0, 1.0), new Vec3(-1.0, 0.0, 1.0), new Vec3(1.0, 0.0, -1.0), new Vec3(-1.0, 0.0, -1.0)};
            int numRings = 3;
            double initialRadius = 3.0;
            double radiusIncrement = 3.0;
            for (int ring = 0; ring < numRings; ++ring) {
                double radius = initialRadius + (double)ring * radiusIncrement;
                for (Vec3 direction : directions) {
                    ServerPlayer serverPlayer;
                    Vec3 boltPos = targetPos.m_82520_(direction.f_82479_ * radius, 0.0, direction.f_82481_ * radius);
                    LightningBolt bolt = new LightningBolt(level, (Entity)entity);
                    ServerPlayer var10001 = entity instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)entity) : null;
                    bolt.m_20879_(var10001);
                    bolt.setMpCost(this.magiculeCost(entity, instance));
                    bolt.setTensuraDamage(300.0f);
                    bolt.setAdditionalVisual(2);
                    bolt.setRadius(3.0f);
                    bolt.setSkill(instance);
                    bolt.m_146884_(boltPos);
                    level.m_7967_((Entity)bolt);
                }
            }
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 0.5f, 1.0f);
            instance.setCoolDown(3);
        }
    }
}

