/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.intrinsic;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.intrinsic.DragonSkinSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.item.TensuraArmourMaterials;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

public class ExoskeletonSkill
extends Skill {
    protected static final UUID EXOSKELETON = UUID.fromString("8ae21129-7fd5-4541-8b83-e75bfe33b7a8");

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/intrinsic/exoskeleton.png");
    }

    public ExoskeletonSkill() {
        super(Skill.SkillType.INTRINSIC);
    }

    public boolean canBeToggled(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        return instance.isMastered(entity);
    }

    public void onPressed(@NotNull ManasSkillInstance instance, @NotNull LivingEntity entity) {
        if (!instance.isMastered(entity)) {
            AttributeInstance toughness;
            this.checkDragonSkin(entity);
            entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11673_, SoundSource.PLAYERS, 1.0f, 1.0f);
            AttributeInstance armor = entity.m_21204_().m_22146_(Attributes.f_22284_);
            if (armor != null && armor.m_22111_(EXOSKELETON) == null) {
                armor.m_22125_(new AttributeModifier(EXOSKELETON, "Exoskeleton", (double)this.calculateArmor(entity), AttributeModifier.Operation.ADDITION));
            }
            if ((toughness = entity.m_21051_(Attributes.f_22285_)) != null && toughness.m_22111_(EXOSKELETON) == null) {
                toughness.m_22125_(new AttributeModifier(EXOSKELETON, "Exoskeleton", (double)this.calculateToughness(entity), AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public void onRelease(ManasSkillInstance instance, @NotNull LivingEntity entity, int heldTicks) {
        if (!instance.isMastered(entity)) {
            AttributeInstance toughness;
            entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11672_, SoundSource.PLAYERS, 1.0f, 1.0f);
            AttributeInstance armor = entity.m_21051_(Attributes.f_22284_);
            if (armor != null) {
                armor.m_22127_(EXOSKELETON);
            }
            if ((toughness = entity.m_21051_(Attributes.f_22285_)) != null) {
                toughness.m_22127_(EXOSKELETON);
            }
        }
    }

    public boolean onHeld(ManasSkillInstance instance, @NotNull LivingEntity living, int heldTicks) {
        if (!instance.isMastered(living)) {
            if (heldTicks % 200 == 0 && heldTicks > 0) {
                instance.addMasteryPoint(living);
            }
            return true;
        }
        return false;
    }

    public void onToggleOn(@NotNull ManasSkillInstance instance, @NotNull LivingEntity entity) {
        AttributeInstance toughness;
        AttributeInstance armor = entity.m_21051_(Attributes.f_22284_);
        if (armor != null && armor.m_22111_(EXOSKELETON) == null) {
            armor.m_22125_(new AttributeModifier(EXOSKELETON, "Exoskeleton", (double)this.calculateArmor(entity), AttributeModifier.Operation.ADDITION));
        }
        if ((toughness = entity.m_21051_(Attributes.f_22285_)) != null && toughness.m_22111_(EXOSKELETON) == null) {
            toughness.m_22125_(new AttributeModifier(EXOSKELETON, "Exoskeleton", (double)this.calculateToughness(entity), AttributeModifier.Operation.ADDITION));
        }
        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11673_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void onToggleOff(@NotNull ManasSkillInstance instance, LivingEntity entity) {
        AttributeInstance toughness;
        AttributeInstance armor = entity.m_21051_(Attributes.f_22284_);
        if (armor != null) {
            armor.m_22127_(EXOSKELETON);
        }
        if ((toughness = entity.m_21051_(Attributes.f_22285_)) != null) {
            toughness.m_22127_(EXOSKELETON);
        }
        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11672_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    protected int calculateArmor(LivingEntity entity) {
        int armor = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            armor += this.getMaterial(entity).m_7365_(slot);
        }
        Race playerRace = TensuraPlayerCapability.getRace((LivingEntity)entity);
        return playerRace != null && (playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.ANT)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.HARDSHELL_ANT)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.HARDSHELL_ANT_INSECTAR)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.HARDSHELL_ANT_SAINT)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.EARTH_SOUL_INSECT)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DIVINE_HARDSHELL_ANT))) ? armor : armor / 2;
    }

    protected float calculateToughness(LivingEntity entity) {
        Race playerRace = TensuraPlayerCapability.getRace((LivingEntity)entity);
        return playerRace != null && (playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.ANT)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.HARDSHELL_ANT)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.HARDSHELL_ANT_INSECTAR)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.HARDSHELL_ANT_SAINT)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.EARTH_SOUL_INSECT)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DIVINE_HARDSHELL_ANT))) ? this.getMaterial(entity).m_6651_() * 2.0f : this.getMaterial(entity).m_6651_() * 4.0f;
    }

    protected ArmorMaterial getMaterial(LivingEntity entity) {
        TensuraArmourMaterials material = TensuraArmourMaterials.MONSTER_LEATHER_D;
        double EP = TensuraEPCapability.getEP((LivingEntity)entity);
        if (EP >= 4000000.0) {
            material = TensuraArmourMaterials.HIHIIROKANE;
        } else if (EP >= 800000.0) {
            material = TensuraArmourMaterials.MONSTER_LEATHER_SPECIAL_A;
        } else if (EP >= 80000.0) {
            material = TensuraArmourMaterials.MONSTER_LEATHER_A;
        } else if (EP >= 50000.0) {
            material = TensuraArmourMaterials.MONSTER_LEATHER_B;
        } else if (EP >= 25000.0) {
            material = TensuraArmourMaterials.MONSTER_LEATHER_C;
        }
        return material;
    }

    public boolean canTick(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        return instance.isMastered(entity);
    }

    public void onTick(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        if (instance.isToggled()) {
            this.checkDragonSkin(entity);
        }
    }

    private void checkDragonSkin(@NotNull LivingEntity entity) {
        SkillAPI.getSkillsFrom((Entity)entity).getSkill((ManasSkill)IntrinsicSkills.DRAGON_SKIN.get()).ifPresent(skill -> {
            if (skill.isToggled()) {
                skill.setToggled(false);
                skill.onToggleOff(entity);
                skill.markDirty();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.lack_requirement.toggled_off", (Object[])new Object[]{((DragonSkinSkill)IntrinsicSkills.DRAGON_SKIN.get()).getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
            }
        });
    }
}

