/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.intrinsic;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.registry.dimensions.TensuraDimensions;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class HellGateSkill
extends Skill {
    public HellGateSkill() {
        super(Skill.SkillType.INTRINSIC);
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/intrinsic/hell_gate.png");
    }

    public double getObtainingEpCost() {
        return 100.0;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 10000.0;
    }

    public int modes() {
        return 2;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.hell_gate.hell");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.hell_gate.overworld");
            default -> Component.m_237119_();
        };
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        ResourceKey currentDimension = entity.f_19853_.m_46472_();
        ResourceKey targetDimension = null;
        if (instance.getMode() == 1 && currentDimension != TensuraDimensions.HELL) {
            targetDimension = TensuraDimensions.HELL;
        } else if (instance.getMode() == 2 && currentDimension != Level.f_46428_) {
            targetDimension = Level.f_46428_;
        }
        ServerLevel targetLevel = Objects.requireNonNull(entity.m_20194_()).m_129880_(targetDimension);
        if (targetLevel != null) {
            BlockPos targetPos = new BlockPos(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            targetLevel.m_46865_(targetPos);
            SkillHelper.moveAcrossDimensionTo((Entity)entity, (double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_(), (float)entity.m_146908_(), (float)entity.m_146909_(), (ServerLevel)targetLevel);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.m_150110_().f_35936_) {
                    player.m_150110_().f_35935_ = true;
                    player.m_6885_();
                }
            }
            instance.addMasteryPoint(entity);
            if (!instance.isMastered(entity)) {
                instance.setCoolDown(600);
            } else {
                instance.setCoolDown(300);
            }
        }
    }
}

