/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.intrinsic;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.event.SkillGriefEvent;
import com.github.manasmods.tensura.world.TensuraGameRules;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class HellHallSkill
extends Skill {
    public HellHallSkill() {
        super(Skill.SkillType.INTRINSIC);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/intrinsic/hell_hall.png");
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 5000.0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance) && TensuraGameRules.canSkillGrief((Level)level)) {
            BlockState currentState;
            int y;
            int z;
            int x;
            BlockPos pos = entity.m_20097_();
            int radius = instance.isMastered(entity) ? 8 : 4;
            boolean success = false;
            boolean waterDetected = false;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int x2 = -radius; x2 <= radius; ++x2) {
                    for (int z2 = -radius; z2 <= radius; ++z2) {
                        for (int y2 = -radius * 2; y2 <= 0; ++y2) {
                            BlockPos newPos = pos.m_7918_(x2, y2, z2);
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)newPos.m_123341_() + 0.5, (double)newPos.m_123342_() + 0.5, (double)newPos.m_123343_() + 0.5, 1, 0.1, 0.1, 0.1, 0.01);
                        }
                    }
                }
            }
            for (x = -radius; x <= radius; ++x) {
                for (z = -radius; z <= radius; ++z) {
                    for (y = -radius * 2; y <= 0; ++y) {
                        BlockPos newPos = pos.m_7918_(x, y, z);
                        currentState = level.m_8055_(newPos);
                        if (!currentState.m_60713_(Blocks.f_49990_)) continue;
                        waterDetected = true;
                        break;
                    }
                    if (waterDetected) break;
                }
                if (waterDetected) break;
            }
            if (!waterDetected) {
                for (x = -radius; x <= radius; ++x) {
                    for (z = -radius; z <= radius; ++z) {
                        for (y = -radius * 2; y <= 0; ++y) {
                            SkillGriefEvent.Pre preGrief;
                            BlockPos newPos = pos.m_7918_(x, y, z);
                            currentState = level.m_8055_(newPos);
                            if (currentState.m_60795_() || !(currentState.m_60800_((BlockGetter)level, newPos) >= 0.0f) || MinecraftForge.EVENT_BUS.post((Event)(preGrief = new SkillGriefEvent.Pre((Entity)entity, instance, newPos)))) continue;
                            level.m_7731_(newPos, Blocks.f_49991_.m_49966_(), 3);
                            success = true;
                        }
                    }
                }
                if (success) {
                    this.addMasteryPoint(instance, entity);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    if (!instance.isMastered(entity)) {
                        instance.setCoolDown(10);
                    } else {
                        instance.setCoolDown(5);
                    }
                }
            }
        }
    }
}

