/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.intrinsic;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.intrinsic.DragonSkinSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.item.TensuraArmourMaterials;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraftforge.registries.IForgeRegistry;

public class MagisteelBodySkill
extends Skill {
    protected static final UUID MAGISTEEL_BODY = UUID.fromString("e5e4b8b8-cbf8-41df-aa88-c4a0d94168cb");

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/intrinsic/magisteel_body.png");
    }

    public MagisteelBodySkill() {
        super(Skill.SkillType.INTRINSIC);
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        AttributeInstance toughness;
        AttributeInstance armor = entity.m_21051_(Attributes.f_22284_);
        if (armor != null && armor.m_22111_(MAGISTEEL_BODY) == null) {
            armor.m_22125_(new AttributeModifier(MAGISTEEL_BODY, "Magisteel Body", (double)this.calculateArmor(entity, instance), AttributeModifier.Operation.ADDITION));
        }
        if ((toughness = entity.m_21051_(Attributes.f_22285_)) != null && toughness.m_22111_(MAGISTEEL_BODY) == null) {
            toughness.m_22125_(new AttributeModifier(MAGISTEEL_BODY, "Magisteel Body", (double)this.calculateToughness(entity, instance), AttributeModifier.Operation.ADDITION));
        }
        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11673_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        AttributeInstance toughness;
        AttributeInstance armor = entity.m_21051_(Attributes.f_22284_);
        if (armor != null) {
            armor.m_22127_(MAGISTEEL_BODY);
        }
        if ((toughness = entity.m_21051_(Attributes.f_22285_)) != null) {
            toughness.m_22127_(MAGISTEEL_BODY);
        }
        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11672_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    protected int calculateArmor(LivingEntity entity, ManasSkillInstance instance) {
        int armor = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            armor += this.getMaterial(entity).m_7365_(slot);
        }
        Race playerRace = TensuraPlayerCapability.getRace((LivingEntity)entity);
        return playerRace != null && (playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(TensuraRaces.METAL_SLIME.getId())) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.GREATER_DOLL)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.ARCH_DOLL)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DAEMON_DOLL)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DEVIL_DOLL)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.CHAOS_DOLL)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.CHAOS_METALLOID)) || this.canUseSkill(entity, instance)) ? armor : armor * 0;
    }

    protected float calculateToughness(LivingEntity entity, ManasSkillInstance instance) {
        Race playerRace = TensuraPlayerCapability.getRace((LivingEntity)entity);
        return playerRace != null && (playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(TensuraRaces.METAL_SLIME.getId())) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.GREATER_DOLL)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.ARCH_DOLL)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DAEMON_DOLL)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DEVIL_DOLL)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.CHAOS_DOLL)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.CHAOS_METALLOID)) || this.canUseSkill(entity, instance)) ? this.getMaterial(entity).m_6651_() * 4.0f : this.getMaterial(entity).m_6651_() * 0.0f;
    }

    public boolean canUseSkill(LivingEntity entity, ManasSkillInstance instance) {
        if (!(entity instanceof Player)) {
            return false;
        }
        return TensuraPlayerCapability.getFrom((Player)((Player)entity)).map(cap -> !cap.isSpiritualForm() && instance.isTemporarySkill()).orElse(false);
    }

    protected ArmorMaterial getMaterial(LivingEntity entity) {
        TensuraArmourMaterials material = TensuraArmourMaterials.LOW_MAGISTEEL;
        double EP = TensuraEPCapability.getEP((LivingEntity)entity);
        if (EP >= 1000000.0) {
            material = TensuraArmourMaterials.HIHIIROKANE;
        } else if (EP >= 550000.0) {
            material = TensuraArmourMaterials.ADAMANTITE;
        } else if (EP >= 80000.0) {
            material = TensuraArmourMaterials.PURE_MAGISTEEL;
        } else if (EP >= 50000.0) {
            material = TensuraArmourMaterials.HIGH_MAGISTEEL;
        } else if (EP >= 25000.0) {
            material = TensuraArmourMaterials.LOW_MAGISTEEL;
        }
        return material;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public boolean isTemporary(ManasSkillInstance instance) {
        return instance.isTemporarySkill();
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.isToggled()) {
            SkillAPI.getSkillsFrom((Entity)entity).getSkill((ManasSkill)IntrinsicSkills.DRAGON_SKIN.get()).ifPresent(skill -> {
                if (skill.isToggled()) {
                    skill.setToggled(false);
                    skill.onToggleOff(entity);
                    skill.markDirty();
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.lack_requirement.toggled_off", (Object[])new Object[]{((DragonSkinSkill)IntrinsicSkills.DRAGON_SKIN.get()).getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                }
            });
        }
    }
}

