/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.intrinsic.AbsorbDissolveSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.TensuraAdvancementsHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class AdephagaSkill
extends Skill {
    private static final Set<Item> EDIBLE_ITEMS = new HashSet<Item>();

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/adephaga.png");
    }

    public AdephagaSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public double getObtainingEpCost() {
        return 300000.0;
    }

    public int getMaxMastery() {
        return 2000;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.ENGORGER.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Player player;
        Skill previousSkill = (Skill)UniqueSkills.ENGORGER.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player && (player = (Player)entity).m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                int currentUltimates = cap.getCurrentUltimates();
                cap.setCurrentUltimates(currentUltimates + 1);
            });
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
            return;
        }
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return;
        }
        if (instance.getMastery() >= 0 && !instance.isTemporarySkill() && entity instanceof Player) {
            player = (Player)entity;
            if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                storage.forgetSkill((ManasSkill)previousSkill);
            }
            player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
        }
    }

    public int modes() {
        return 2;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.adephaga.consume");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.adephaga.amplify");
            default -> Component.m_237119_();
        };
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled();
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        entity.m_7292_(new MobEffectInstance((MobEffect)MysticismMobEffects.DEVOURER.get(), 240, 0, false, false, false));
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        this.onTick(instance, entity);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_175826_, (double)1.0);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        entity.m_21195_((MobEffect)MysticismMobEffects.DEVOURER.get());
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_175826_, (double)1.0);
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        switch (instance.getMode()) {
            case 1: {
                ItemStack itemStack = entity.m_21205_();
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                if (itemStack.m_41619_()) {
                    List<ManasSkillInstance> targetSkills;
                    LivingEntity living = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)3.0, (boolean)true);
                    if (living == null || !((double)living.m_21223_() <= (double)living.m_21233_() * 0.1)) break;
                    if (living instanceof Player) {
                        Player playerTarget = (Player)living;
                        if (playerTarget.m_150110_().f_35934_) {
                            return;
                        }
                    }
                    if (living.m_6469_(TensuraDamageSources.heartEat((Entity)living), living.m_21233_() * 10.0f)) {
                        this.addMasteryPoint(instance, entity);
                    }
                    if ((targetSkills = List.copyOf(SkillAPI.getSkillsFrom((Entity)living).getLearnedSkills().stream().toList())).isEmpty()) break;
                    for (ManasSkillInstance targetInstance : targetSkills) {
                        if (targetInstance.isTemporarySkill() || targetInstance.getMastery() < 0 || targetInstance.getSkill() == this || !(entity instanceof Player)) continue;
                        Player player = (Player)entity;
                        if (SkillUtils.learnSkill((LivingEntity)entity, (ManasSkill)targetInstance.getSkill(), (int)-2)) {
                            int duration = instance.isMastered(entity) ? 7200 : 3600;
                            targetInstance.setRemoveTime(duration);
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.success_drain", (Object[])new Object[]{targetInstance.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
                            continue;
                        }
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.already_have", (Object[])new Object[]{targetInstance.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                } else {
                    itemStack.m_41774_(1);
                    for (AbsorbDissolveSkill.Dissolving dissolving : AbsorbDissolveSkill.Dissolving.values()) {
                        if (!dissolving.getItem().equals(itemStack.m_41720_())) continue;
                        this.addMasteryPoint(instance, entity);
                        if (entity instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)entity;
                            if (itemStack.m_41720_().equals(TensuraMaterialItems.SLIME_IN_A_BUCKET.get())) {
                                TensuraAdvancementsHelper.grant((ServerPlayer)serverPlayer, (ResourceLocation)TensuraAdvancementsHelper.Advancements.TRAITOR);
                            }
                            serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
                        }
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                                cap.setMagicule(cap.getMagicule() + (double)(dissolving.getMagicule() * 2));
                                if (cap.getMagicule() > player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get())) {
                                    cap.setMagicule(player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get()));
                                }
                            });
                        }
                        if (dissolving.getHeal() > 0.0f) {
                            entity.m_5634_(dissolving.getHeal());
                        }
                        level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                }
                break;
            }
            case 2: {
                MobEffectInstance effectInstance;
                if (!instance.isToggled()) {
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.mode.need_toggle_on", (Object[])new Object[]{this.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                    }
                    if (!entity.m_6144_()) {
                        return;
                    }
                    instance.setToggled(true);
                    instance.onToggleOn(entity);
                }
                if ((effectInstance = entity.m_21124_((MobEffect)MysticismMobEffects.DEVOURER.get())) != null && effectInstance.m_19564_() != 0) {
                    if (!entity.m_20096_() && !entity.m_20072_()) {
                        return;
                    }
                    if (SkillHelper.outOfMagicule((LivingEntity)entity, (double)10000.0)) {
                        return;
                    }
                    this.addMasteryPoint(instance, entity);
                    double dist = entity.m_6047_() ? 7.5 : 15.0;
                    BlockHitResult result = SkillHelper.getPlayerPOVHitResultFromPos((Level)level, (LivingEntity)entity, (ClipContext.Fluid)ClipContext.Fluid.NONE, (ClipContext.Block)ClipContext.Block.COLLIDER, (double)dist, (Vec3)entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0));
                    Vec3 source = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
                    Vec3 offSetToTarget = Vec3.m_82512_((Vec3i)result.m_82425_()).m_82546_(source);
                    for (int particleIndex = 1; particleIndex < Mth.m_14107_((double)offSetToTarget.m_82553_()); ++particleIndex) {
                        Vec3 particlePos = source.m_82549_(offSetToTarget.m_82541_().m_82490_((double)particleIndex));
                        ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_175826_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                        AABB aabb = new AABB(new BlockPos(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_)).m_82400_(1.0);
                        List livingEntityList = level.m_6443_(LivingEntity.class, aabb, entityData -> !entityData.m_7306_((Entity)entity));
                        if (livingEntityList.isEmpty()) continue;
                        float bonus = instance.isMastered(entity) ? 500.0f : 200.0f;
                        float amount = (float)(entity.m_21133_(Attributes.f_22281_) + (double)bonus);
                        for (LivingEntity pLivingEntity : livingEntityList) {
                            if (pLivingEntity.m_6469_((DamageSource)this.sourceWithMP(DamageSource.m_19370_((LivingEntity)entity), entity, instance), amount)) {
                                ItemStack stack = entity.m_21205_();
                                stack.m_41720_().m_7579_(stack, pLivingEntity, entity);
                                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                            }
                            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123813_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                    entity.m_183634_();
                    SkillHelper.riptidePush((LivingEntity)entity, (float)3.0f);
                    entity.f_19864_ = true;
                    break;
                }
                if (SkillHelper.outOfMagicule((LivingEntity)entity, (double)10000.0)) {
                    return;
                }
                this.addMasteryPoint(instance, entity);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_175826_, (double)1.0);
                entity.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.ENGORGEMENT.get(), 2400, 1, false, false, false), (Entity)entity);
                entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12054_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public boolean canEatItem(ItemStack itemStack) {
        return EDIBLE_ITEMS.contains(itemStack.m_41720_());
    }

    static {
        EDIBLE_ITEMS.add(Items.f_41953_);
        EDIBLE_ITEMS.add(Items.f_41952_);
        EDIBLE_ITEMS.add((Item)TensuraMaterialItems.LOW_MAGISTEEL_INGOT.get());
        EDIBLE_ITEMS.add((Item)TensuraMaterialItems.HIGH_MAGISTEEL_INGOT.get());
        EDIBLE_ITEMS.add((Item)TensuraMaterialItems.PURE_MAGISTEEL_INGOT.get());
        EDIBLE_ITEMS.add((Item)TensuraMaterialItems.ADAMANTITE_NUGGET.get());
        EDIBLE_ITEMS.add((Item)TensuraMaterialItems.HIHIIROKANE_NUGGET.get());
    }
}

