/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.manascore.attribute.ManasCoreAttributes;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.common.ThoughtCommunicationSkill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.ability.skill.intrinsic.CharmSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.battlewill.ProjectileArts;
import com.github.manasmods.tensura.registry.battlewill.UtilityArts;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.github.manasmods.tensura.world.TensuraGameRules;
import com.google.common.collect.ImmutableList;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.registry.skill.ExtraSkills;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AmaterasuSkill
extends Skill {
    public static final ImmutableList<MobEffect> SPACE_TIME;
    protected static final UUID ACCELERATION;

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/amaterasu.png");
    }

    public int getMaxMastery() {
        return 2000;
    }

    public AmaterasuSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public double getObtainingEpCost() {
        return 500000.0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.COMMANDER.get(), (TensuraSkill)com.github.manasmods.tensura.registry.skill.ExtraSkills.FLAME_DOMINATION.get(), (TensuraSkill)ProjectileArts.OGRE_FLAME.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Player player;
        double cost;
        Player player2;
        Player player3;
        if (entity instanceof Player && (player3 = (Player)entity).m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                int currentUltimates = cap.getCurrentUltimates();
                cap.setCurrentUltimates(currentUltimates + 1);
            });
        }
        if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
            Skill lightAndHeat = (Skill)ExtraSkills.LIGHT_AND_HEAT_DOMINATION.get();
            if (entity instanceof Player && !(player2 = (Player)entity).m_7500_()) {
                cost = lightAndHeat.getObtainingEpCost() * (double)player2.f_19853_.m_46469_().m_46215_(TensuraGameRules.MP_SKILL_COST) / 100.0;
                TensuraPlayerCapability.getFrom((Player)player2).ifPresent(cap -> {
                    cap.setBaseMagicule(cap.getBaseMagicule() + cost, (LivingEntity)player2, false);
                    TensuraPlayerCapability.sync((Player)player2);
                });
            }
            if (SkillUtils.learnSkill((LivingEntity)entity, (ManasSkill)lightAndHeat) && entity instanceof Player) {
                player2 = (Player)entity;
                player2.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{lightAndHeat.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            }
        }
        if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
            Skill multilayer = (Skill)com.github.manasmods.tensura.registry.skill.ExtraSkills.MULTILAYER_BARRIER.get();
            if (entity instanceof Player && !(player2 = (Player)entity).m_7500_()) {
                cost = multilayer.getObtainingEpCost() * (double)player2.f_19853_.m_46469_().m_46215_(TensuraGameRules.MP_SKILL_COST) / 100.0;
                TensuraPlayerCapability.getFrom((Player)player2).ifPresent(cap -> {
                    cap.setBaseMagicule(cap.getBaseMagicule() + cost, (LivingEntity)player2, false);
                    TensuraPlayerCapability.sync((Player)player2);
                });
            }
            if (SkillUtils.learnSkill((LivingEntity)entity, (ManasSkill)multilayer) && entity instanceof Player) {
                player2 = (Player)entity;
                player2.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{multilayer.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            }
        }
        Skill previousSkill = (Skill)UniqueSkills.COMMANDER.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
            return;
        }
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return;
        }
        if (instance.getMastery() >= 0 && !instance.isTemporarySkill() && entity instanceof Player) {
            player = (Player)entity;
            if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                storage.forgetSkill((ManasSkill)previousSkill);
            }
            player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
        }
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public double learningCost() {
        return 10000.0;
    }

    public int modes() {
        return 5;
    }

    public String modeLearningId(int mode) {
        return mode == 4 ? "HazeBlackFlame" : "None";
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return switch (instance.getMode()) {
                case 1 -> {
                    if (instance.getOrCreateTag().m_128451_("HazeBlackFlame") >= 200) {
                        yield 6;
                    }
                    if (this.canEquipHazeBF(entity)) {
                        yield 5;
                    }
                    yield 4;
                }
                case 2 -> 1;
                case 3 -> 2;
                case 4 -> 3;
                case 5 -> {
                    if (this.canEquipHazeBF(entity)) {
                        yield 4;
                    }
                    yield 3;
                }
                default -> 0;
            };
        }
        return switch (instance.getMode()) {
            case 1 -> 2;
            case 2 -> 3;
            case 3 -> {
                if (this.canEquipHazeBF(entity)) {
                    yield 4;
                }
                yield 1;
            }
            case 4 -> {
                if (instance.getOrCreateTag().m_128451_("HazeBlackFlame") >= 200) {
                    yield 5;
                }
                yield 1;
            }
            default -> 1;
        };
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 4 -> 5000.0;
            case 5 -> 250000.0;
            default -> 0.0;
        };
    }

    public double auraCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 5 -> 250000.0;
            default -> 0.0;
        };
    }

    private boolean canEquipHazeBF(LivingEntity entity) {
        return SkillUtils.hasSkill((Entity)entity, (ManasSkill)((ManasSkill)UtilityArts.HAZE.get()));
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.amaterasu.movement_communication");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.amaterasu.targeting_communication");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.amaterasu.will_control");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.amaterasu.haze_black_flame");
            case 5 -> Component.m_237115_((String)"trmysticism.skill.mode.amaterasu.prominence_acceleration");
            default -> Component.m_237119_();
        };
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMastery() < 0) {
            return false;
        }
        CompoundTag tag = instance.getOrCreateTag();
        return instance.getMode() != 4 && tag.m_128451_("HazeBlackFlame") <= 100;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        if (!UltimateUtils.insideConfig(instance.getSkillId())) {
            return false;
        }
        return instance.getMastery() >= 0;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled();
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(30.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && living.m_7307_((Entity)entity));
        if (!list.isEmpty()) {
            int level = instance.isMastered(entity) ? 3 : 2;
            for (LivingEntity target : list) {
                if (SkillHelper.isSubordinate((LivingEntity)target, (LivingEntity)entity)) {
                    return;
                }
                target.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.INSPIRATION.get(), 240, level, false, false, false), (Entity)entity);
            }
        }
        if (instance.isToggled()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get(), 200, 1, false, false, false));
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.HEAT_SENSE.get(), 200, 0, false, false, false));
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get(), 200, 0, false, false, false));
        }
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        DamageSource damageSource;
        LivingEntity entity;
        if (!(event.isCanceled() || !this.isInSlot(entity = event.getEntity()) || (damageSource = event.getSource()).m_19378_() || damageSource.m_19387_() || damageSource.m_7640_() == null || damageSource.m_7640_() != damageSource.m_7639_() || entity.m_217043_().m_188501_() > 0.5f)) {
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
            event.setCanceled(true);
            if (SkillUtils.canNegateDodge((LivingEntity)entity, (DamageSource)damageSource)) {
                event.setCanceled(false);
            }
        }
    }

    public void onProjectileHit(ManasSkillInstance instance, LivingEntity entity, ProjectileImpactEvent event) {
        if (this.isInSlot(entity) && !SkillUtils.isProjectileAlwaysHit((Projectile)event.getProjectile()) && !(entity.m_217043_().m_188501_() > 0.5f)) {
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
            event.setCanceled(true);
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        if (instance.getMode() == 1) {
            ThoughtCommunicationSkill.movementBehaviour((ManasSkillInstance)instance, (LivingEntity)entity);
        } else if (instance.getMode() == 2) {
            ThoughtCommunicationSkill.targetingBehaviour((ManasSkillInstance)instance, (LivingEntity)entity);
        } else if (instance.getMode() == 3) {
            CharmSkill.charm((ManasSkillInstance)instance, (LivingEntity)entity);
        } else if (instance.getMode() == 4) {
            if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                return;
            }
            int learnPoint = tag.m_128451_("HazeBlackFlame");
            if (learnPoint < 100) {
                tag.m_128405_("HazeBlackFlame", learnPoint + SkillUtils.getEarningLearnPoint((ManasSkillInstance)instance, (LivingEntity)entity, (boolean)true));
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (tag.m_128451_("HazeBlackFlame") >= 100) {
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(4)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    } else {
                        instance.setCoolDown(10);
                        SkillUtils.learningFailPenalty((LivingEntity)entity);
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(4)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                    }
                    player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                instance.markDirty();
            }
        } else if (instance.getMode() == 5 && (entity.m_20096_() || entity.m_20072_()) && !SkillHelper.outOfAura((LivingEntity)entity, (ManasSkillInstance)instance)) {
            this.addMasteryPoint(instance, entity);
            Level level = entity.m_9236_();
            int range = instance.isMastered(entity) ? 25 : 20;
            BlockHitResult result = SkillHelper.getPlayerPOVHitResult((Level)level, (Entity)entity, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)range);
            BlockPos resultPos = result.m_82425_().m_121945_(result.m_82434_());
            Vec3 vec3 = SkillHelper.getFloorPos((BlockPos)resultPos);
            if (!level.m_8055_(resultPos).m_60767_().m_76336_()) {
                vec3 = SkillHelper.getFloorPos((BlockPos)resultPos.m_7494_());
            }
            if (level.m_8055_(resultPos).m_60713_((Block)TensuraBlocks.LABYRINTH_BARRIER_BLOCK.get())) {
                level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else if (!entity.m_9236_().m_6857_().m_61937_(new BlockPos(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_()))) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.teleport.out_border").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
            } else {
                Vec3 source = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
                Vec3 offSetToTarget = vec3.m_82546_(source);
                TensuraDamageSource fireSource = this.sourceWithMP(TensuraDamageSources.blackFlame((Entity)entity), entity, instance);
                for (int particleIndex = 1; particleIndex < Mth.m_14107_((double)offSetToTarget.m_82553_()); ++particleIndex) {
                    Vec3 particlePos = source.m_82549_(offSetToTarget.m_82541_().m_82490_((double)particleIndex));
                    ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.BLACK_FIRE.get()), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                    TensuraParticleHelper.addServerParticlesAroundPos((RandomSource)entity.m_217043_(), (Level)level, (Vec3)particlePos, (ParticleOptions)ParticleTypes.f_123766_, (double)3.0);
                    TensuraParticleHelper.addServerParticlesAroundPos((RandomSource)entity.m_217043_(), (Level)level, (Vec3)particlePos, (ParticleOptions)((ParticleOptions)TensuraParticles.BLACK_FIRE.get()), (double)2.0);
                    AABB aabb = new AABB(new BlockPos(particlePos)).m_82400_(Math.max(entity.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get()), 2.0));
                    List livingEntityList = level.m_6443_(LivingEntity.class, aabb, targetx -> !targetx.m_7306_((Entity)entity) && !targetx.m_7307_((Entity)entity));
                    if (livingEntityList.isEmpty()) continue;
                    float bonus = 300.0f;
                    float amount = (float)(entity.m_21133_(Attributes.f_22281_) * entity.m_21133_((Attribute)ManasCoreAttributes.CRIT_MULTIPLIER.get()));
                    float finalDamage = !instance.isMastered(entity) ? (amount + bonus) * 3.0f : (amount + bonus) * 5.0f;
                    for (LivingEntity target : livingEntityList) {
                        if (!target.m_6469_((DamageSource)fireSource, finalDamage)) continue;
                        target.m_20254_(10);
                        ItemStack stack = entity.m_21205_();
                        stack.m_41720_().m_7579_(stack, target, entity);
                        target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.BLACK_BURN.get(), 200, 2));
                        entity.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_11702_, entity.m_5720_(), 1.0f, 1.0f);
                        if (!(level instanceof ServerLevel)) continue;
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_7726_().m_8394_((Entity)entity, (Packet)new ClientboundAnimatePacket((Entity)entity, 4));
                    }
                }
                entity.m_183634_();
                entity.m_19877_();
                entity.m_20219_(vec3);
                entity.f_19812_ = true;
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                instance.setCoolDown(!instance.isMastered(entity) ? 5 : 3);
            }
        }
    }

    public void onTouchEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        if (instance.isToggled() && !SkillHelper.outOfMagicule((LivingEntity)attacker, (double)5.0) && (DamageSourceHelper.isPhysicalAttack((DamageSource)e.getSource()) || e.getSource().m_7639_() instanceof AbstractArrow)) {
            int level;
            LivingEntity target = e.getEntity();
            int n = level = this.isMastered(instance, attacker) ? 3 : 1;
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                SkillHelper.addEffectWithSource((LivingEntity)target, (LivingEntity)player, (MobEffect)((MobEffect)TensuraMobEffects.BLACK_BURN.get()), (int)200, (int)level);
                target.m_20254_(10);
            } else {
                target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.BLACK_BURN.get(), 200, level, false, false, false));
                target.m_20254_(10);
            }
            attacker.m_9236_().m_6263_((Player)null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_11909_, SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)((ParticleOptions)TensuraParticles.BLACK_FIRE.get()), (double)1.0);
        }
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (instance.isToggled() && DamageSourceHelper.isSpatialDamage((DamageSource)e.getSource())) {
            e.setAmount(e.getAmount() * 4.0f);
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity living, int heldTicks) {
        CompoundTag tag = instance.getOrCreateTag();
        int learnPoint = tag.m_128451_("HazeBlackFlame");
        if (learnPoint < 100) {
            return false;
        }
        if (instance.getMode() == 4) {
            if (heldTicks % 20 == 0 && SkillHelper.outOfAura((LivingEntity)living, (ManasSkillInstance)instance)) {
                return false;
            }
            if (heldTicks % 100 == 0 && heldTicks > 0) {
                int masteryPoint = tag.m_128451_("HazeBlackFlame");
                if (masteryPoint < 200) {
                    tag.m_128405_("HazeBlackFlame", masteryPoint + SkillUtils.getBonusMasteryPoint((ManasSkillInstance)instance, (LivingEntity)living, (int)1));
                    if (tag.m_128451_("HazeBlackFlame") >= 200 && living instanceof Player) {
                        Player player = (Player)living;
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.mastery", (Object[])new Object[]{this.getModeName(4)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    }
                }
                this.addMasteryPoint(instance, living);
            }
            living.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_CONCEALMENT.get(), 5, 1, false, false, false));
            living.m_9236_().m_6263_((Player)null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_11909_, SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)living, (ParticleOptions)((ParticleOptions)TensuraParticles.BLACK_FIRE.get()), (double)1.0);
            ((ServerLevel)living.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.BLACK_FIRE.get()), living.m_20185_(), living.m_20186_() + (double)living.m_20206_() / 2.0, living.m_20189_(), 10, 0.08, 0.08, 0.08, 0.15);
            List list = living.m_9236_().m_6443_(LivingEntity.class, living.m_20191_().m_82400_(5.0), entity -> !entity.m_7306_((Entity)living) && entity.m_6084_() && !entity.m_7307_((Entity)living));
            if (!list.isEmpty()) {
                DamageSource damageSource = TensuraDamageSources.elementalAttack((String)"tensura.fire_attack", (Entity)living, (double)this.magiculeCost(living, instance), (ManasSkillInstance)instance, (boolean)false);
                for (LivingEntity target : list) {
                    target.m_20254_(10);
                    SkillHelper.addEffectWithSource((LivingEntity)target, (LivingEntity)living, (MobEffect)((MobEffect)TensuraMobEffects.BLACK_BURN.get()), (int)200, (int)1);
                    target.m_6469_(damageSource, 40.0f);
                }
            }
            return true;
        }
        return false;
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)true);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        int level;
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)false);
        if (entity.m_21023_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get()) && (level = Objects.requireNonNull(entity.m_21124_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get())).m_19564_()) == 1) {
            entity.m_21195_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get());
        }
        entity.m_21195_((MobEffect)TensuraMobEffects.HEAT_SENSE.get());
        entity.m_21195_((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get());
    }

    @NotNull
    public List<MobEffect> getImmuneEffects(ManasSkillInstance instance, LivingEntity entity) {
        return !instance.isMastered(entity) ? new ArrayList() : SPACE_TIME;
    }

    static {
        ACCELERATION = UUID.fromString("9a70f5c2-3c1b-4e9a-bb83-6e9e394e5b32");
        List<MobEffect> time_stops = ForgeRegistries.MOB_EFFECTS.getValues().stream().filter(effect -> effect.m_19482_().getString().contains("time_stop")).toList();
        SPACE_TIME = ImmutableList.builder().add((Object)((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get())).add((Object)((MobEffect)TensuraMobEffects.BURDEN.get())).add((Object)MobEffects.f_19597_).add((Object)MobEffects.f_19599_).add((Object)((MobEffect)TensuraMobEffects.OPPRESSION.get())).addAll(time_stops).build();
    }
}

