/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.intrinsic.CharmSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.template.TensuraHorseEntity;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.effect.instance.DazzledEffectInstance;
import io.github.Memoires.trmysticism.effect.instance.SpotlightEffectInstance;
import io.github.Memoires.trmysticism.network.MysticismNetwork;
import io.github.Memoires.trmysticism.network.play2server.SyncIdolModePacket;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class AmeNoUzumeSkill
extends Skill {
    private boolean idolMode;

    public AmeNoUzumeSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", this.idolMode ? "textures/skill/ultimate/ame_no_uzume_no_mikoto/ame_no_uzume_no_mikoto_idol.png" : "textures/skill/ultimate/ame_no_uzume_no_mikoto/ame_no_uzume_no_mikoto_acting.png");
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1 -> {
                if (instance.isMastered(entity)) {
                    yield 100000.0;
                }
                yield 175000.0;
            }
            case 2 -> 300000.0;
            case 3 -> 250000.0;
            case 4 -> 500000.0;
            default -> 0.0;
        };
    }

    public double getObtainingEpCost() {
        return 500000.0;
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)io.github.Memoires.trmysticism.registry.skill.UniqueSkills.CAPTIVATOR.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (!reverse) {
            if (this.idolMode) {
                return switch (instance.getMode()) {
                    case 1 -> 2;
                    case 2 -> {
                        if (instance.isMastered(entity)) {
                            yield 4;
                        }
                        yield 1;
                    }
                    default -> 1;
                };
            }
            return switch (instance.getMode()) {
                case 1 -> 3;
                case 3 -> {
                    if (instance.isMastered(entity)) {
                        yield 4;
                    }
                    yield 1;
                }
                default -> 1;
            };
        }
        if (this.idolMode) {
            return switch (instance.getMode()) {
                case 1 -> {
                    if (instance.isMastered(entity)) {
                        yield 4;
                    }
                    yield 2;
                }
                case 2 -> 1;
                case 4 -> 2;
                default -> 0;
            };
        }
        return switch (instance.getMode()) {
            case 1 -> {
                if (instance.isMastered(entity)) {
                    yield 4;
                }
                yield 3;
            }
            case 3 -> 1;
            case 4 -> 3;
            default -> 0;
        };
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.BEWILDER.get(), (TensuraSkill)io.github.Memoires.trmysticism.registry.skill.UniqueSkills.CAPTIVATOR.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public int modes() {
        return 4;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.ame_no_uzume_no_mikoto.performance");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.ame_no_uzume_no_mikoto.encore");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.ame_no_uzume_no_mikoto.spotlight");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.ame_no_uzume_no_mikoto.ornate_star");
            default -> Component.m_237119_();
        };
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public void onTick(ManasSkillInstance instance, LivingEntity living) {
        Level level = living.m_9236_();
        living.m_7292_(new MobEffectInstance(MobEffects.f_19595_, 240, 9, false, false, false));
        if (instance.isToggled()) {
            List nearby = level.m_6443_(LivingEntity.class, living.m_20191_().m_82400_(10.0), e -> e.m_6084_() && !e.m_7306_((Entity)living) && !e.m_7307_((Entity)living));
            for (LivingEntity other : nearby) {
                RandomSource randomSource = other.m_217043_();
                if (randomSource.m_188503_(2) != 0) continue;
                if (this.idolMode) {
                    other.m_147207_((MobEffectInstance)new DazzledEffectInstance((MobEffect)MysticismMobEffects.DAZZLED.get(), 60, 0, living, false, false, false), (Entity)living);
                    continue;
                }
                other.m_147207_((MobEffectInstance)new SpotlightEffectInstance((MobEffect)MysticismMobEffects.SPOTLIGHT.get(), 60, 0, living, false, false, false), (Entity)living);
            }
        }
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getMastery() >= 0;
    }

    public void setIdolModeClient(boolean idolMode) {
        this.idolMode = idolMode;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        UUID uuid = entity.m_20148_();
        if (instance.getMode() != 1 || !entity.m_6144_()) {
            if (instance.getMode() != 2) {
                if (instance.getMode() == 3) {
                    LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)(instance.isMastered(entity) ? 20.0 : 10.0), (boolean)false, (boolean)true);
                    if (target == null) {
                        instance.setCoolDown(10);
                        return;
                    }
                    if (target instanceof Player) {
                        Player targetPlayer = (Player)target;
                        if (targetPlayer.m_150110_().f_35934_) {
                            if (!(entity instanceof Player)) return;
                            Player player = (Player)entity;
                            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.captivator.target_immune").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                            return;
                        }
                    }
                    target.m_147207_((MobEffectInstance)new SpotlightEffectInstance((MobEffect)MysticismMobEffects.SPOTLIGHT.get(), instance.isMastered(entity) ? 600 : 400, 0, entity, false, false, false), (Entity)entity);
                    instance.addMasteryPoint(entity);
                    instance.setCoolDown(30);
                    return;
                }
                if (instance.getMode() != 4) return;
                if (!instance.isMastered(entity)) return;
                LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)20.0, (boolean)true, (boolean)true);
                if (target == null) {
                    instance.setCoolDown(10);
                    return;
                }
                target.m_147207_(new MobEffectInstance((MobEffect)MysticismMobEffects.MESMERIZED.get(), 200, 0, false, false, false), (Entity)entity);
                instance.setCoolDown(20);
                return;
            }
        } else {
            float radius = instance.isMastered(entity) ? 25.0f : 20.0f;
            List list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_((double)radius), livingEntity -> !livingEntity.m_7306_((Entity)entity) && livingEntity.m_6084_() && livingEntity.m_21023_((MobEffect)TensuraMobEffects.MIND_CONTROL.get()));
            if (list.isEmpty()) {
                return;
            }
            if (SkillHelper.outOfMagicule((LivingEntity)entity, (double)(this.magiculeCost(entity, instance) * (double)list.size()))) {
                return;
            }
            instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            this.addMasteryPoint(instance, entity);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                LivingEntity target = (LivingEntity)iterator.next();
                if (target instanceof Player) {
                    Player targetPlayer = (Player)target;
                    if (targetPlayer.m_150110_().f_35934_) continue;
                }
                if (!Objects.equals(uuid, TensuraEPCapability.getTemporaryOwner((LivingEntity)target))) continue;
                float damage = target.m_21223_();
                if (SkillUtils.hasSkill((Entity)target, (ManasSkill)((ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_NULLIFICATION.get()))) {
                    damage /= 10.0f;
                } else if (SkillUtils.hasSkill((Entity)target, (ManasSkill)((ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_RESISTANCE.get()))) {
                    damage /= 2.0f;
                }
                if (!target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.selfKill((Entity)entity), entity, instance), damage)) continue;
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123808_);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123792_);
            }
            return;
        }
        List nearby = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(10.0), e -> e.m_6084_() && !e.m_7306_((Entity)entity));
        Iterator list = nearby.iterator();
        while (true) {
            if (!list.hasNext()) {
                instance.setCoolDown(60);
                return;
            }
            LivingEntity other = (LivingEntity)list.next();
            if (!other.m_7307_((Entity)entity)) {
                if (other instanceof Player) {
                    Player targetPlayer = (Player)other;
                    if (targetPlayer.m_150110_().f_35934_) continue;
                }
                other.m_147207_((MobEffectInstance)new DazzledEffectInstance((MobEffect)MysticismMobEffects.DAZZLED.get(), instance.isMastered(entity) ? 900 : 600, 0, entity, false, false, false), (Entity)entity);
                continue;
            }
            other.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.INSPIRATION.get(), instance.isMastered(entity) ? 900 : 600, 2, false, false, false), (Entity)entity);
        }
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() != 1 || !this.isHeld(entity)) {
            return false;
        }
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            return false;
        }
        if (heldTicks > 300) {
            instance.addMasteryPoint(entity);
            this.onRelease(instance, entity, heldTicks);
            return false;
        }
        UUID playerUUID = entity.m_20148_();
        Level level = entity.m_9236_();
        List list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(20.0), target -> !target.m_7306_((Entity)entity) && target.m_6084_());
        for (LivingEntity target2 : list) {
            if (target2 instanceof Player) {
                Player targetPlayer = (Player)target2;
                if (targetPlayer.m_150110_().f_35934_) continue;
            }
            TensuraEPCapability.getFrom((LivingEntity)target2).ifPresent(cap -> {
                int effectLevel;
                int n = effectLevel = instance.isMastered(entity) ? 3 : 1;
                if (Objects.equals(cap.getTemporaryOwner(), playerUUID) || Objects.equals(cap.getPermanentOwner(), playerUUID)) {
                    target2.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.INSPIRATION.get(), 240, effectLevel, false, false, false), (Entity)entity);
                    return;
                }
                if (CharmSkill.canMindControl((LivingEntity)target2, (Level)level)) {
                    int duration;
                    int n2 = duration = SkillUtils.isSkillToggled((Entity)target2, (ManasSkill)((ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_RESISTANCE.get())) ? 12000 : 72000;
                    if (SkillUtils.isSkillToggled((Entity)target2, (ManasSkill)((ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_NULLIFICATION.get()))) {
                        duration = 300;
                    }
                    SkillHelper.checkThenAddEffectSource((LivingEntity)target2, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.MIND_CONTROL.get()), (int)duration, (int)0);
                    if (target2.m_21023_((MobEffect)TensuraMobEffects.MIND_CONTROL.get())) {
                        cap.setTemporaryOwner(playerUUID);
                        if (target2 instanceof Mob) {
                            Mob mob = (Mob)target2;
                            SkillHelper.removeTarget((Mob)mob);
                        }
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            if (target2 instanceof TamableAnimal) {
                                TamableAnimal animal = (TamableAnimal)target2;
                                animal.m_21828_(player);
                            } else if (target2 instanceof TensuraHorseEntity) {
                                TensuraHorseEntity horse = (TensuraHorseEntity)target2;
                                horse.m_30637_(player);
                            }
                        }
                        TensuraEPCapability.sync((LivingEntity)target2);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target2, (ParticleOptions)ParticleTypes.f_123798_);
                        level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11733_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                }
            });
        }
        return true;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 1 && this.isHeld(entity) && !entity.m_6144_()) {
            Player player;
            if (entity.m_9236_().m_5776_()) {
                if (entity instanceof Player) {
                    player = (Player)entity;
                    MysticismNetwork.sendToServer(new SyncIdolModePacket(player.m_20148_(), this.idolMode));
                }
            } else {
                boolean bl = this.idolMode = !this.idolMode;
            }
            if (entity instanceof Player) {
                player = (Player)entity;
                if (this.idolMode) {
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.ame_no_uzume_no_mikoto.performance.idol").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.LIGHT_PURPLE)), false);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.ame_no_uzume_no_mikoto.performance.acting").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE)), false);
                }
            }
            instance.setCoolDown(5);
        } else if (instance.getMode() == 1 && entity.m_6144_()) {
            UUID uuid = entity.m_20148_();
            float radius = instance.isMastered(entity) ? 25.0f : 20.0f;
            List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_((double)radius), livingEntity -> !livingEntity.m_7306_((Entity)entity) && livingEntity.m_6084_() && livingEntity.m_21023_((MobEffect)TensuraMobEffects.MIND_CONTROL.get()));
            if (list.isEmpty()) {
                return;
            }
            if (SkillHelper.outOfMagicule((LivingEntity)entity, (double)(this.magiculeCost(entity, instance) * (double)list.size()))) {
                return;
            }
            instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            this.addMasteryPoint(instance, entity);
            for (LivingEntity target : list) {
                if (!Objects.equals(uuid, TensuraEPCapability.getTemporaryOwner((LivingEntity)target))) continue;
                float damage = target.m_21223_();
                if (SkillUtils.hasSkill((Entity)target, (ManasSkill)((ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_NULLIFICATION.get()))) {
                    damage /= 10.0f;
                } else if (SkillUtils.hasSkill((Entity)target, (ManasSkill)((ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_RESISTANCE.get()))) {
                    damage /= 2.0f;
                }
                if (!target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.selfKill((Entity)entity), entity, instance), damage)) continue;
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123808_);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123792_);
            }
        }
    }
}

