/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.menu.SpatialMenu;
import com.github.manasmods.tensura.registry.dimensions.TensuraDimensions;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.github.manasmods.tensura.world.TensuraGameRules;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.entity.projectile.skill.AntaeusBlueProjectile;
import io.github.Memoires.trmysticism.entity.projectile.skill.AntaeusPurpleProjectile;
import io.github.Memoires.trmysticism.entity.projectile.skill.AntaeusRedProjectile;
import io.github.Memoires.trmysticism.entity.skill.LimitlessBarrierEntity;
import io.github.Memoires.trmysticism.registry.particles.MysticismParticles;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.network.NetworkHooks;

public class AntaeusSkill
extends Skill {
    protected static final UUID ACCELERATION = UUID.fromString("3f5b17d6-ecfd-4f97-b7c1-d3e4f9eb8574");

    public AntaeusSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/antaeus.png");
    }

    public int getMaxMastery() {
        return 2000;
    }

    public double getObtainingEpCost() {
        return 600000.0;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled();
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.isToggled()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get(), 200, 1, false, false, false));
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.HEAT_SENSE.get(), 200, 0, false, false, false));
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get(), 200, 0, false, false, false));
        }
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.OPPRESSOR.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)true);
        Level level = entity.m_9236_();
        LimitlessBarrierEntity barrier = new LimitlessBarrierEntity(level, entity);
        level.m_7967_((Entity)barrier);
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.OPPRESSOR.get(), (TensuraSkill)ExtraSkills.GRAVITY_DOMINATION.get(), (TensuraSkill)CommonSkills.GRAVITY_FIELD.get(), (TensuraSkill)CommonSkills.RANGED_BARRIER.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1, 2, 5 -> 125000.0;
            case 3 -> 500000.0;
            default -> 0.0;
        };
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        if (!event.isCanceled() && instance.isToggled()) {
            if (event.getSource().m_146707_()) {
                event.setCanceled(true);
            } else if (event.getSource().m_19360_() && !event.getSource().m_19387_()) {
                event.setCanceled(true);
            }
        }
    }

    public int modes() {
        return 6;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return switch (instance.getMode()) {
                case 1 -> 6;
                case 2 -> 1;
                case 3 -> 2;
                case 4 -> {
                    if (instance.isMastered(entity)) {
                        yield 3;
                    }
                    yield 2;
                }
                case 5 -> 4;
                case 6 -> 5;
                default -> 0;
            };
        }
        return switch (instance.getMode()) {
            case 1 -> 2;
            case 2 -> {
                if (instance.isMastered(entity)) {
                    yield 3;
                }
                yield 4;
            }
            case 3 -> 4;
            case 4 -> 5;
            case 5 -> 6;
            default -> 1;
        };
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)false);
        Level level = entity.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_45976_(LimitlessBarrierEntity.class, entity.m_20191_().m_82400_(50.0)).stream().filter(barrier -> barrier.getOwner() != null && barrier.getOwner().equals((Object)entity)).forEach(Entity::m_146870_);
        }
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.antaeus.repel_red");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.antaeus.attract_blue");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.antaeus.hollow_purple");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.antaeus.oppress");
            case 5 -> Component.m_237115_((String)"trmysticism.skill.mode.antaeus.bleve");
            case 6 -> Component.m_237115_((String)"trmysticism.skill.mode.antaeus.flicker");
            default -> Component.m_237119_();
        };
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        LivingEntity target = (LivingEntity)SkillHelper.getTargetingEntity(LivingEntity.class, (LivingEntity)entity, (double)20.0, (double)0.0, (boolean)false);
        switch (instance.getMode()) {
            case 1: {
                AntaeusRedProjectile red = new AntaeusRedProjectile(entity.m_9236_(), entity);
                red.f_19794_ = true;
                red.setSpeed(1.5f);
                red.setSize(1.0f);
                red.setSkill(instance);
                red.setLife(400);
                red.m_20242_(true);
                red.m_146884_(this.getRedPosition(entity, red));
                entity.m_9236_().m_7967_((Entity)red);
                tag.m_128405_("RedID", red.m_19879_());
                tag.m_128405_("PowerScale", 0);
                instance.markDirty();
                break;
            }
            case 2: {
                AntaeusBlueProjectile blue = new AntaeusBlueProjectile(entity.m_9236_(), entity);
                blue.f_19794_ = true;
                blue.setSpeed(1.5f);
                blue.setSize(1.0f);
                blue.setSkill(instance);
                blue.setLife(400);
                blue.m_20242_(true);
                blue.m_146884_(this.getBluePosition(entity, blue));
                entity.m_9236_().m_7967_((Entity)blue);
                tag.m_128405_("BlueID", blue.m_19879_());
                tag.m_128405_("PowerScale", 0);
                instance.markDirty();
                break;
            }
            case 3: {
                tag.m_128405_("PowerScale", 0);
                tag.m_128405_("PurpleID", 0);
                instance.markDirty();
                break;
            }
            case 4: {
                if (target == null) {
                    return;
                }
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) {
                        return;
                    }
                }
                if (target.m_21023_((MobEffect)TensuraMobEffects.OPPRESSION.get())) {
                    if (SkillHelper.outOfMagicule((LivingEntity)entity, (double)1400.0)) {
                        return;
                    }
                    instance.addMasteryPoint(entity);
                    instance.setCoolDown(instance.isMastered(entity) ? 5 : 10);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.oppression((Entity)entity), entity, instance), instance.isMastered(entity) ? 500.0f : 250.0f);
                    entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123747_, (double)1.0);
                    break;
                }
                if (SkillHelper.outOfMagicule((LivingEntity)entity, (double)300.0)) {
                    return;
                }
                instance.addMasteryPoint(entity);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                DamageSourceHelper.markHurt((LivingEntity)target, (Entity)entity);
                SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.OPPRESSION.get()), (int)600, (int)0, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123790_, (double)1.0);
                entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 5: {
                if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                    return;
                }
                if (target == null) {
                    return;
                }
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) {
                        return;
                    }
                }
                instance.addMasteryPoint(entity);
                instance.setCoolDown(instance.isMastered(entity) ? 5 : 10);
                if (instance.isMastered(entity)) {
                    target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.oppressionBleve((Entity)entity), entity, instance), 400.0f);
                } else {
                    target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.oppressionBleve((Entity)entity), entity, instance), 200.0f);
                }
                entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123747_, (double)1.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123812_, (double)1.0);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                target.m_20256_(target.m_20184_().m_82520_(0.0, 2.0, 0.0));
                target.f_19864_ = true;
            }
            case 6: {
                if (!entity.m_6047_()) {
                    return;
                }
                Level level = entity.m_9236_();
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    if (level.m_46472_() == TensuraDimensions.LABYRINTH) {
                        serverPlayer.m_6330_(SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    } else {
                        NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider(SpatialMenu::new, (Component)Component.m_237119_()), buf -> buf.writeBoolean(false));
                        serverPlayer.m_6330_(SoundEvents.f_11889_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                }
                entity.m_21195_((MobEffect)TensuraMobEffects.WARPING.get());
                instance.setCoolDown(instance.isMastered(entity) ? 10 : 20);
            }
        }
    }

    public void onRespawn(ManasSkillInstance instance, PlayerEvent.PlayerRespawnEvent event) {
        if (!event.isEndConquered()) {
            instance.getOrCreateTag().m_128379_("masteryPower", false);
            instance.markDirty();
        }
    }

    public void onNumberKeyPress(ManasSkillInstance instance, Player player, int keyNumber) {
        if (instance.isMastered((LivingEntity)player)) {
            CompoundTag tag = instance.getOrCreateTag();
            if (keyNumber == 0) {
                if (tag.m_128471_("masteryPower")) {
                    tag.m_128379_("masteryPower", false);
                    tag.m_128405_("scale", 10);
                    instance.markDirty();
                }
            } else {
                if (!tag.m_128471_("masteryPower")) {
                    tag.m_128379_("masteryPower", true);
                }
                tag.m_128405_("scale", keyNumber * 10 + 10);
                instance.markDirty();
            }
        }
    }

    private Vec3 getRedPosition(LivingEntity entity, AntaeusRedProjectile red) {
        double yOff = Math.min((double)(red.m_20206_() / 2.0f), (double)entity.m_20192_() - 0.5);
        Vec3 look = entity.m_20154_().m_82490_((double)(4 + (int)(red.getSize() / 10.0f)));
        return entity.m_146892_().m_82549_(look).m_82520_(0.0, -yOff, 0.0);
    }

    private Vec3 getBluePosition(LivingEntity entity, AntaeusBlueProjectile blue) {
        double yOff = Math.min((double)(blue.m_20206_() / 2.0f), (double)entity.m_20192_() - 0.5);
        Vec3 look = entity.m_20154_().m_82490_((double)(4 + (int)(blue.getSize() / 10.0f)));
        return entity.m_146892_().m_82549_(look).m_82520_(0.0, -yOff, 0.0);
    }

    private Vec3 getPurplePosition(LivingEntity entity, AntaeusPurpleProjectile purple) {
        double yOff = Math.min((double)(purple.m_20206_() / 2.0f), (double)entity.m_20192_() - 0.5);
        Vec3 look = entity.m_20154_().m_82490_((double)(10 + (int)(purple.getSize() / 10.0f)));
        return entity.m_146892_().m_82549_(look).m_82520_(0.0, -yOff, 0.0);
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 4 || instance.getMode() == 5) {
            return false;
        }
        Level level = entity.m_9236_();
        CompoundTag tag = instance.getOrCreateTag();
        switch (instance.getMode()) {
            case 1: {
                if (SkillHelper.outOfMagicule((LivingEntity)entity, (double)2000.0)) {
                    return false;
                }
                int id = tag.m_128451_("RedID");
                Entity idEntity = level.m_6815_(id);
                if (idEntity instanceof AntaeusRedProjectile) {
                    boolean shouldIncrease;
                    AntaeusRedProjectile red = (AntaeusRedProjectile)idEntity;
                    int max = instance.isMastered(entity) ? 100 : 50;
                    red.m_146884_(this.getRedPosition(entity, red));
                    boolean bl = instance.isMastered(entity) ? heldTicks % 2 == 0 : (shouldIncrease = heldTicks % 3 == 0);
                    if (heldTicks > 0 && shouldIncrease && tag.m_128451_("PowerScale") < max) {
                        if (heldTicks % 100 == 0) {
                            instance.addMasteryPoint(entity);
                        }
                        tag.m_128405_("PowerScale", tag.m_128451_("PowerScale") + 1);
                        instance.markDirty();
                        int power = tag.m_128451_("PowerScale") / 10;
                        if (power >= 1) {
                            red.setPower(power);
                            red.setMpCost(this.auraCost(entity, instance) * (double)power);
                            red.setSkill(instance);
                            red.setDamage(400.0f * (float)power);
                        }
                    }
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)((ParticleOptions)TensuraParticles.DARK_RED_LIGHTNING_SPARK.get()), (double)1.0);
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.power_scale", (Object[])new Object[]{(double)tag.m_128451_("PowerScale") / 5.0}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), true);
                    }
                    return true;
                }
                tag.m_128405_("RedID", 0);
                instance.markDirty();
                return false;
            }
            case 2: {
                if (SkillHelper.outOfMagicule((LivingEntity)entity, (double)2000.0)) {
                    return false;
                }
                int id = tag.m_128451_("BlueID");
                Entity idEntity = level.m_6815_(id);
                if (idEntity instanceof AntaeusBlueProjectile) {
                    boolean shouldIncrease;
                    AntaeusBlueProjectile blue = (AntaeusBlueProjectile)idEntity;
                    int max = instance.isMastered(entity) ? 100 : 50;
                    blue.m_146884_(this.getBluePosition(entity, blue));
                    boolean bl = instance.isMastered(entity) ? heldTicks % 2 == 0 : (shouldIncrease = heldTicks % 3 == 0);
                    if (heldTicks > 0 && shouldIncrease && tag.m_128451_("PowerScale") < max) {
                        if (heldTicks % 100 == 0) {
                            instance.addMasteryPoint(entity);
                        }
                        tag.m_128405_("PowerScale", tag.m_128451_("PowerScale") + 1);
                        instance.markDirty();
                        int power = tag.m_128451_("PowerScale") / 10;
                        if (power >= 1) {
                            blue.setPower(power);
                            blue.setMpCost(this.auraCost(entity, instance) * (double)power);
                            blue.setSkill(instance);
                            blue.setDamage(200.0f * (float)power);
                        }
                    }
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)((ParticleOptions)MysticismParticles.DARK_BLUE_LIGHTNING_SPARK.get()), (double)1.0);
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.power_scale", (Object[])new Object[]{(double)tag.m_128451_("PowerScale") / 5.0}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), true);
                    }
                    return true;
                }
                tag.m_128405_("BlueID", 0);
                instance.markDirty();
                return false;
            }
            case 3: {
                boolean shouldIncrease;
                if (SkillHelper.outOfMagicule((LivingEntity)entity, (double)5000.0)) {
                    return false;
                }
                int maxPower = 100;
                boolean bl = shouldIncrease = heldTicks % 2 == 0;
                if (heldTicks > 0 && shouldIncrease && tag.m_128451_("PowerScale") < maxPower) {
                    tag.m_128405_("PowerScale", tag.m_128451_("PowerScale") + 1);
                    instance.markDirty();
                }
                int power = tag.m_128451_("PowerScale") / 10;
                Entity idEntity = level.m_6815_(tag.m_128451_("PurpleID"));
                AntaeusPurpleProjectile purple = null;
                if (power >= 5) {
                    if (idEntity instanceof AntaeusPurpleProjectile) {
                        purple = (AntaeusPurpleProjectile)idEntity;
                    } else if (tag.m_128451_("PurpleID") == 0) {
                        purple = new AntaeusPurpleProjectile(level, entity);
                        purple.f_19794_ = true;
                        purple.setSpeed(1.5f);
                        purple.setSize(5.0f);
                        purple.setSkill(instance);
                        purple.setLife(100);
                        purple.m_20242_(true);
                        level.m_7967_((Entity)purple);
                        tag.m_128405_("PurpleID", purple.m_19879_());
                        instance.markDirty();
                    }
                    if (purple != null) {
                        purple.setPower(power);
                        purple.m_146884_(this.getPurplePosition(entity, purple));
                        purple.setMpCost(this.auraCost(entity, instance) * (double)power);
                        purple.setSkill(instance);
                        purple.setSize(5.0f + 0.1f * (float)power);
                        purple.setDamage(1000.0f * (float)power);
                        if (TensuraGameRules.canSkillGrief((Level)level)) {
                            purple.setExplosionRadius(Math.max(power - 10, 16));
                        }
                    }
                }
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)((ParticleOptions)TensuraParticles.DARK_PURPLE_LIGHTNING_SPARK.get()), (double)1.0);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.power_scale", (Object[])new Object[]{(double)tag.m_128451_("PowerScale") / 10.0}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), true);
                }
                return true;
            }
        }
        if (!tag.m_128471_("masteryPower")) {
            tag.m_128405_("scale", heldTicks);
        }
        if (tag.m_128451_("scale") > 100) {
            tag.m_128405_("scale", 100);
        }
        instance.markDirty();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.power_scale", (Object[])new Object[]{(double)tag.m_128451_("scale") / 10.0}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), true);
        }
        return true;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        Level level = entity.m_9236_();
        CompoundTag tag = instance.getOrCreateTag();
        if (this.isHeld(entity)) {
            if (instance.getMode() == 1) {
                int id = tag.m_128451_("RedID");
                Entity idEntity = level.m_6815_(id);
                if (idEntity instanceof AntaeusRedProjectile) {
                    AntaeusRedProjectile red = (AntaeusRedProjectile)idEntity;
                    int power = tag.m_128451_("PowerScale") / 10;
                    if (entity.m_6047_()) {
                        red.m_146870_();
                    }
                    if (power < 9) {
                        red.m_146870_();
                        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 3.0f, 1.0f);
                    } else {
                        double cost = this.magiculeCost(entity, instance) * (double)power;
                        if (SkillHelper.outOfMagicule((LivingEntity)entity, (double)cost)) {
                            red.m_146870_();
                            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 3.0f, 1.0f);
                        } else {
                            entity.m_21011_(InteractionHand.MAIN_HAND, true);
                            if (power >= 10) {
                                this.addMasteryPoint(instance, entity);
                            }
                            red.f_19794_ = false;
                            red.setMpCost(cost);
                            red.shootFromRot(entity.m_20154_());
                            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                    }
                } else {
                    tag.m_128405_("PurpleID", 0);
                    instance.markDirty();
                }
            } else if (instance.getMode() == 2) {
                int id = tag.m_128451_("BlueID");
                Entity idEntity = level.m_6815_(id);
                if (idEntity instanceof AntaeusBlueProjectile) {
                    AntaeusBlueProjectile blue = (AntaeusBlueProjectile)idEntity;
                    int power = tag.m_128451_("PowerScale") / 10;
                    if (entity.m_6047_()) {
                        blue.m_146870_();
                    }
                    if (power < 9) {
                        blue.m_146870_();
                        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 3.0f, 1.0f);
                    } else {
                        double cost = this.magiculeCost(entity, instance) * (double)power;
                        if (SkillHelper.outOfMagicule((LivingEntity)entity, (double)cost)) {
                            blue.m_146870_();
                            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 3.0f, 1.0f);
                        } else {
                            entity.m_21011_(InteractionHand.MAIN_HAND, true);
                            if (power >= 10) {
                                this.addMasteryPoint(instance, entity);
                            }
                            blue.f_19794_ = false;
                            blue.setMpCost(cost);
                            blue.shootFromRot(entity.m_20154_());
                            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                    }
                } else {
                    tag.m_128405_("BlueID", 0);
                    instance.markDirty();
                }
            } else if (instance.getMode() == 3) {
                int id = tag.m_128451_("PurpleID");
                Entity idEntity = level.m_6815_(id);
                if (idEntity instanceof AntaeusPurpleProjectile) {
                    AntaeusPurpleProjectile purple = (AntaeusPurpleProjectile)idEntity;
                    int power = tag.m_128451_("PowerScale") / 10;
                    if (entity.m_6047_()) {
                        purple.m_146870_();
                    }
                    if (power < 1) {
                        purple.m_146870_();
                        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 3.0f, 1.0f);
                    } else {
                        double cost = this.magiculeCost(entity, instance) * (double)power;
                        if (SkillHelper.outOfMagicule((LivingEntity)entity, (double)cost)) {
                            purple.m_146870_();
                            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 3.0f, 1.0f);
                        } else {
                            entity.m_21011_(InteractionHand.MAIN_HAND, true);
                            if (power >= 2) {
                                this.addMasteryPoint(instance, entity);
                            }
                            purple.f_19794_ = false;
                            purple.setMpCost(cost);
                            purple.shootFromRot(entity.m_20154_());
                            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                    }
                } else {
                    tag.m_128405_("PurpleID", 0);
                    instance.markDirty();
                }
            } else if (instance.getMode() == 6) {
                if (tag.m_128451_("scale") <= 0 || entity.m_6047_()) {
                    return;
                }
                if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                    float scale = (float)tag.m_128451_("scale") / 10.0f;
                    if (scale >= 2.0f) {
                        instance.addMasteryPoint(entity);
                    }
                    if (entity.m_20202_() != null) {
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity.m_20202_(), (ParticleOptions)ParticleTypes.f_123812_, (double)0.5);
                        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        SkillHelper.riptidePushVehicle((Entity)entity.m_20202_(), (LivingEntity)entity, (float)(scale * 3.0f));
                        entity.m_20202_().f_19864_ = true;
                        entity.m_20202_().f_19812_ = true;
                    } else {
                        SkillHelper.riptidePush((LivingEntity)entity, (float)(scale * 3.0f));
                        entity.f_19864_ = true;
                        entity.f_19812_ = true;
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123812_, (double)1.0);
                        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                }
            }
        }
    }
}

