/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import io.github.Memoires.trmysticism.util.TimerUtils;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.util.damage.MysticismDamageSources;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import org.jetbrains.annotations.Nullable;

public class AntevortaSkill
extends Skill {
    protected static final UUID ACCELERATION = UUID.fromString("6a3de994-cf4d-4d7e-a56d-f3b3141da2b6");

    public AntevortaSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    @Nullable
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/antevorta.png");
    }

    public double getObtainingEpCost() {
        return 300000.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return instance.getMastery() >= 0;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public int modes() {
        return 3;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 100000.0;
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.antevorta.attack_vectors");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.antevorta.future_sight");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.antevorta.roll_of_the_dice");
            default -> Component.m_237119_();
        };
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.SEER.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 3 : instance.getMode() - 1;
        }
        return instance.getMode() == 3 ? 1 : instance.getMode() + 1;
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.SEER.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)true);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)false);
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public void onTick(ManasSkillInstance instance, LivingEntity living) {
        if (this.isInSlot(living)) {
            living.m_7292_(new MobEffectInstance((MobEffect)MysticismMobEffects.ANTEVORTA_DETECTION.get(), 200, 0, false, false, false));
        }
        if (instance.isToggled()) {
            living.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get(), 200, 1, false, false, false));
            living.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.HEAT_SENSE.get(), 200, 0, false, false, false));
            living.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get(), 200, 0, false, false, false));
        }
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        CompoundTag tag = instance.getOrCreateTag();
        Entity damageSourceEntity = event.getSource().m_7639_();
        if (damageSourceEntity == null) {
            return;
        }
        String entityType = damageSourceEntity.m_6095_().toString();
        if (tag.m_128441_(entityType)) {
            int currentCount = tag.m_128451_(entityType);
            tag.m_128405_(entityType, Math.min(currentCount + 1, 100));
        } else {
            tag.m_128405_(entityType, 1);
        }
        int counter = tag.m_128451_(entityType);
        double negateChance = Math.min((double)counter * 0.5, 50.0);
        if ((double)event.getEntity().m_217043_().m_188503_(100) < negateChance) {
            event.setCanceled(true);
        }
    }

    public void onTakenDamage(ManasSkillInstance instance, LivingDamageEvent event) {
        CompoundTag tag = instance.getOrCreateTag();
        if (tag.m_128471_("AttackVectors")) {
            int hitCounter = tag.m_128451_("HitCounter");
            if (hitCounter < 5) {
                event.setAmount((float)((double)event.getAmount() * 0.8));
                tag.m_128405_("HitCounter", hitCounter + 1);
            } else {
                tag.m_128473_("AttackVectors");
                tag.m_128473_("HitCounter");
            }
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        Level level = entity.m_9236_();
        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            switch (instance.getMode()) {
                case 1: {
                    tag.m_128379_("AttackVectors", true);
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 2.0f, 1.0f);
                    instance.addMasteryPoint(entity);
                    if (instance.isMastered(entity)) {
                        instance.setCoolDown(30);
                        break;
                    }
                    instance.setCoolDown(60);
                    break;
                }
                case 2: {
                    if (entity.m_21023_((MobEffect)TensuraMobEffects.FUTURE_VISION.get())) {
                        entity.m_21195_((MobEffect)TensuraMobEffects.FUTURE_VISION.get());
                        level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    } else {
                        int duration = instance.isMastered(entity) ? 800 : 600;
                        entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.FUTURE_VISION.get(), duration, 0, false, false, false));
                        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11889_, SoundSource.PLAYERS, 2.0f, 1.0f);
                    }
                    instance.setCoolDown(10);
                    break;
                }
                case 3: {
                    this.rollOfTheDice(instance, entity);
                }
            }
        }
    }

    private void rollOfTheDice(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        int roll1 = entity.m_217043_().m_188503_(6) + 1;
        int roll2 = entity.m_217043_().m_188503_(6) + 1;
        TimerUtils.Timer timer = TimerUtils.getOrCreateTimer("Antevorta");
        timer.start(60, () -> {
            if (roll1 == roll2 && instance.isMastered(entity)) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (roll1 == 1) {
                        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11894_, SoundSource.PLAYERS, 2.0f, 1.0f);
                        player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.antevorta.roll_of_the_dice.snake_eyes_1").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), false);
                        player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.antevorta.roll_of_the_dice.snake_eyes_2").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_RED)), false);
                    } else if (roll1 == 6) {
                        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11894_, SoundSource.PLAYERS, 2.0f, 1.0f);
                        player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.antevorta.roll_of_the_dice.double_sixes_1").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), false);
                        player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.antevorta.roll_of_the_dice.double_sixes_2").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_RED)), false);
                    } else {
                        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 2.0f, 1.0f);
                        player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.antevorta.roll_of_the_dice.lucky_roll", (Object[])new Object[]{roll1}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), false);
                    }
                }
            } else if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.antevorta.roll_of_the_dice.dice_roll", (Object[])new Object[]{roll1}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), false);
                if (instance.isMastered(entity)) {
                    player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.antevorta.roll_of_the_dice.dice_roll", (Object[])new Object[]{roll2}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), false);
                }
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 2.0f, 1.0f);
            }
            if (instance.isMastered(entity) && roll1 != roll2) {
                this.applyEffectBasedOnRoll(entity, instance, roll1, false);
                this.applyEffectBasedOnRoll(entity, instance, roll2, false);
            } else {
                this.applyEffectBasedOnRoll(entity, instance, roll1, false);
            }
            if (instance.isMastered(entity)) {
                if (roll1 == 1 && roll2 == 1) {
                    this.applyEffectToNearbyEntities(entity, new MobEffectInstance((MobEffect)MysticismMobEffects.MARKED_FOR_DEATH.get(), 600, 0, false, false, false));
                } else if (roll1 == 6 && roll2 == 6) {
                    this.applyAllEffectsToNearbyEntities(entity);
                } else if (roll1 == roll2) {
                    this.applyEffectBasedOnRoll(entity, instance, roll1, true);
                }
            }
            timer.stop();
            timer.reset();
        });
        instance.addMasteryPoint(entity);
        if (!instance.isMastered(entity)) {
            instance.setCoolDown(60);
        } else {
            instance.setCoolDown(20);
        }
    }

    private void applyEffectBasedOnRoll(LivingEntity entity, ManasSkillInstance instance, int roll, boolean doubleEffect) {
        switch (roll) {
            case 1: {
                this.applyEffectToNearbyEntities(entity, new MobEffectInstance(MobEffects.f_19597_, 600, 4, false, false, false));
                break;
            }
            case 2: {
                this.applyEffectToNearbyEntities(entity, new MobEffectInstance((MobEffect)TensuraMobEffects.BURDEN.get(), 600, doubleEffect ? 9 : 4, false, false, false));
                break;
            }
            case 3: {
                this.applyEffectToNearbyEntities(entity, new MobEffectInstance((MobEffect)TensuraMobEffects.PARALYSIS.get(), 600, doubleEffect ? 9 : 4, false, false, false));
                break;
            }
            case 4: {
                this.applyEffectToNearbyEntities(entity, new MobEffectInstance(MobEffects.f_19620_, 600, doubleEffect ? 3 : 1, false, false, false));
                break;
            }
            case 5: {
                this.applyEffectToNearbyEntities(entity, new MobEffectInstance((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get(), doubleEffect ? 1200 : 600, 0, false, false, false));
                break;
            }
            case 6: {
                this.applyDamageToNearbyEntities(entity, instance);
            }
        }
    }

    private void applyEffectToNearbyEntities(LivingEntity entity, MobEffectInstance effect) {
        entity.m_9236_().m_6249_((Entity)entity, entity.m_20191_().m_82400_(30.0), e -> e instanceof LivingEntity).forEach(e -> {
            if (e instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)e;
                SkillHelper.addEffectWithSource((LivingEntity)target, (LivingEntity)entity, (MobEffectInstance)effect, (boolean)false);
            }
        });
    }

    private void applyDamageToNearbyEntities(LivingEntity entity, ManasSkillInstance instance) {
        entity.m_9236_().m_6249_((Entity)entity, entity.m_20191_().m_82400_(30.0), e -> e instanceof LivingEntity).forEach(e -> {
            if (e instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)e;
                DamageSource damageSource = MysticismDamageSources.antevorta((Entity)entity);
                target.m_6469_((DamageSource)this.sourceWithMP(damageSource, entity, instance), target.m_21223_() / 2.0f);
            }
        });
    }

    private void applyAllEffectsToNearbyEntities(LivingEntity entity) {
        this.applyEffectToNearbyEntities(entity, new MobEffectInstance(MobEffects.f_19597_, 600, 4, false, false, false));
        this.applyEffectToNearbyEntities(entity, new MobEffectInstance((MobEffect)TensuraMobEffects.BURDEN.get(), 600, 4, false, false, false));
        this.applyEffectToNearbyEntities(entity, new MobEffectInstance((MobEffect)TensuraMobEffects.PARALYSIS.get(), 600, 4, false, false, false));
        this.applyEffectToNearbyEntities(entity, new MobEffectInstance(MobEffects.f_19620_, 600, 1, false, false, false));
        this.applyEffectToNearbyEntities(entity, new MobEffectInstance((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get(), 600, 0, false, false, false));
    }
}

