/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.effect.template.MobEffectHelper;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import io.github.Memoires.trmysticism.registry.particles.MysticismParticles;
import io.github.Memoires.trmysticism.registry.skill.UniqueSkills;
import io.github.Memoires.trmysticism.util.TimerUtils;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class AntithesisSkill
extends Skill {
    public AntithesisSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/antithesis.png");
    }

    public int modes() {
        return 4;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.inverse.malice_exchange");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.inverse.redirect");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.antithesis.absolute_antithesis");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.antithesis.vital_shift");
            default -> Component.m_237119_();
        };
    }

    public double getObtainingEpCost() {
        return 600000.0;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 4 : instance.getMode() - 1;
        }
        return instance.getMode() == 4 ? 1 : instance.getMode() + 1;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.INVERSE.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.INVERSE.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        LivingEntity entity = event.getEntity();
        if (this.hasAbsoluteAntithesis()) {
            DamageSource damageSource = event.getSource();
            if (damageSource.m_7640_() != null) {
                Entity sourceEntity = event.getSource().m_7639_();
                if (sourceEntity != null) {
                    sourceEntity.f_19802_ = 0;
                    sourceEntity.m_6469_((DamageSource)DamageSourceHelper.turnTensura((DamageSource)event.getSource(), (Entity)entity), event.getAmount() * 1.0f);
                }
                event.setCanceled(true);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)((ParticleOptions)MysticismParticles.DARK_BLUE_LIGHTNING_SPARK.get()));
                TensuraParticleHelper.spawnServerParticles((Level)entity.f_19853_, (ParticleOptions)((ParticleOptions)MysticismParticles.DARK_BLUE_LIGHTNING_SPARK.get()), (double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_(), (int)55, (double)0.08, (double)0.08, (double)0.08, (double)0.5, (boolean)true);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        } else {
            DamageSource damageSource;
            float f = entity.m_217043_().m_188501_();
            float f2 = instance.isMastered(entity) ? 0.5f : 0.25f;
            if (f <= f2 && this.isInSlot(entity) && !(damageSource = event.getSource()).m_19378_() && damageSource.m_7640_() != null) {
                TensuraDamageSource source;
                if (damageSource instanceof TensuraDamageSource && (source = (TensuraDamageSource)damageSource).getIgnoreBarrier() >= 1.0f) {
                    return;
                }
                Entity var6 = damageSource.m_7639_();
                LivingEntity source2 = (LivingEntity)var6;
                if (TensuraEPCapability.getEP((LivingEntity)source2) >= TensuraEPCapability.getEP((LivingEntity)entity) * 0.5) {
                    return;
                }
                Entity sourceEntity = event.getSource().m_7639_();
                if (sourceEntity != null) {
                    sourceEntity.f_19802_ = 0;
                    sourceEntity.m_6469_((DamageSource)DamageSourceHelper.turnTensura((DamageSource)event.getSource(), (Entity)entity), event.getAmount() * 2.0f);
                }
                event.setCanceled(true);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)((ParticleOptions)MysticismParticles.DARK_BLUE_LIGHTNING_SPARK.get()));
                TensuraParticleHelper.spawnServerParticles((Level)entity.f_19853_, (ParticleOptions)((ParticleOptions)MysticismParticles.DARK_BLUE_LIGHTNING_SPARK.get()), (double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_(), (int)55, (double)0.08, (double)0.08, (double)0.08, (double)0.5, (boolean)true);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public boolean hasAbsoluteAntithesis() {
        TimerUtils.Timer timer = TimerUtils.getOrCreateTimer("absoluteAntithesisTimer");
        return timer.isActive();
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            switch (instance.getMode()) {
                case 1: {
                    this.maliceExchange(instance, entity);
                    break;
                }
                case 2: {
                    this.redirect(instance, entity);
                    break;
                }
                case 3: {
                    this.absoluteAntithesis(instance, entity);
                    break;
                }
                case 4: {
                    this.vitalShift(instance, entity);
                }
            }
        }
    }

    public void maliceExchange(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag skillTag = instance.getOrCreateTag();
        ArrayList<MobEffectInstance> savedEffects = new ArrayList<MobEffectInstance>();
        if (skillTag.m_128425_("SavedEffects", 9)) {
            ListTag savedEffectsTag = skillTag.m_128437_("SavedEffects", 10);
            for (int i = 0; i < savedEffectsTag.size(); ++i) {
                CompoundTag compoundTag = savedEffectsTag.m_128728_(i);
                MobEffectInstance effectInstance = MobEffectInstance.m_19560_((CompoundTag)compoundTag);
                if (effectInstance == null) continue;
                savedEffects.add(effectInstance);
            }
        }
        if (entity.m_6144_()) {
            if (!savedEffects.isEmpty()) {
                for (MobEffectInstance effect2 : savedEffects) {
                    entity.m_7292_(new MobEffectInstance(effect2));
                }
                savedEffects.clear();
                skillTag.m_128473_("SavedEffects");
                entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                List playerHarmfulEffects = entity.m_21220_().stream().filter(effect -> !effect.m_19544_().m_19486_()).collect(Collectors.toList());
                if (!playerHarmfulEffects.isEmpty()) {
                    for (MobEffectInstance mobEffectInstance : playerHarmfulEffects) {
                        entity.m_21195_(mobEffectInstance.m_19544_());
                        savedEffects.add(new MobEffectInstance(mobEffectInstance));
                    }
                    ListTag effectsToSave = new ListTag();
                    for (MobEffectInstance effect4 : savedEffects) {
                        CompoundTag effectTag = new CompoundTag();
                        effect4.m_19555_(effectTag);
                        effectsToSave.add((Object)effectTag);
                    }
                    skillTag.m_128365_("SavedEffects", (Tag)effectsToSave);
                    entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (entity instanceof Player) {
                        ((Player)entity).m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.malice_exchange.target_harmful_effects_saved").m_130940_(ChatFormatting.RED), true);
                    }
                    instance.setCoolDown(instance.isMastered(entity) ? 2 : 5);
                } else if (entity instanceof Player) {
                    ((Player)entity).m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.malice_exchange.no_harmful_effects").m_130940_(ChatFormatting.RED), true);
                }
            }
            return;
        }
        LivingEntity target = (LivingEntity)SkillHelper.getTargetingEntity(LivingEntity.class, (LivingEntity)entity, (double)30.0, (double)0.5, (boolean)true, (boolean)true);
        if (target == null) {
            if (entity instanceof Player) {
                ((Player)entity).m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.malice_exchange.no_target").m_130940_(ChatFormatting.RED), true);
            }
            return;
        }
        if (!savedEffects.isEmpty()) {
            for (MobEffectInstance mobEffectInstance : savedEffects) {
                target.m_7292_(new MobEffectInstance(mobEffectInstance));
            }
            savedEffects.clear();
            skillTag.m_128473_("SavedEffects");
            entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (entity instanceof Player) {
                ((Player)entity).m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.malice_exchange.saved_effects_applied").m_130940_(ChatFormatting.GREEN), true);
            }
        } else {
            List harmfulEffects = target.m_21220_().stream().filter(effect -> !effect.m_19544_().m_19486_()).collect(Collectors.toList());
            if (!harmfulEffects.isEmpty()) {
                for (MobEffectInstance effect2 : harmfulEffects) {
                    target.m_21195_(effect2.m_19544_());
                    savedEffects.add(new MobEffectInstance(effect2));
                }
                ListTag listTag = new ListTag();
                for (MobEffectInstance effect5 : savedEffects) {
                    CompoundTag effectTag = new CompoundTag();
                    effect5.m_19555_(effectTag);
                    listTag.add((Object)effectTag);
                }
                skillTag.m_128365_("SavedEffects", (Tag)listTag);
                entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (entity instanceof Player) {
                    ((Player)entity).m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.malice_exchange.target_harmful_effects_saved").m_130940_(ChatFormatting.RED), true);
                }
                instance.setCoolDown(instance.isMastered(entity) ? 2 : 5);
            } else if (entity instanceof Player) {
                ((Player)entity).m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.malice_exchange.no_harmful_effects").m_130940_(ChatFormatting.RED), true);
            }
        }
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return entity.m_21223_() < entity.m_21233_() / 6.6667f;
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        double radius = 10.0;
        Collection<LivingEntity> hostiles = this.getHostileMobsExcludingAllies(entity, radius);
        Collection playerEffects = entity.m_21220_();
        for (MobEffectInstance effect : playerEffects) {
            for (LivingEntity hostile : hostiles) {
                hostile.m_7292_(new MobEffectInstance(effect.m_19544_(), effect.m_19557_(), effect.m_19564_(), effect.m_19571_(), effect.m_19572_()));
            }
        }
        entity.m_21219_();
        float totalHealing = 0.0f;
        for (LivingEntity hostile : hostiles) {
            float damageAmount = hostile.m_21223_() * 0.3f;
            hostile.m_6469_(DamageSource.m_19367_((Entity)entity, (Entity)entity), damageAmount);
            totalHealing += damageAmount;
        }
        entity.m_5634_(totalHealing);
    }

    private Collection<LivingEntity> getHostileMobsExcludingAllies(LivingEntity entity, double radius) {
        return new ArrayList<LivingEntity>(entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(radius), target -> target.m_6084_() && !entity.m_7307_((Entity)target)));
    }

    public void redirect(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        if (MobEffectHelper.noTeleportation((LivingEntity)entity)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.spatial_blockade").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return;
        }
        Entity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)30.0, (double)0.2, (boolean)false, (boolean)false);
        if (target == null) {
            return;
        }
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        this.addMasteryPoint(instance, entity);
        Vec3 targetPos = new Vec3(target.m_20182_().m_7096_(), target.m_20182_().m_7098_(), target.m_20182_().m_7094_());
        Vec3 userPos = new Vec3(entity.m_20182_().m_7096_(), entity.m_20182_().m_7098_(), entity.m_20182_().m_7094_());
        target.m_183634_();
        target.m_19877_();
        target.m_146884_(userPos);
        target.f_19812_ = true;
        target.f_19864_ = true;
        entity.m_183634_();
        entity.m_19877_();
        entity.m_20219_(targetPos);
        entity.f_19812_ = true;
        entity.f_19864_ = true;
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123760_, (double)1.0);
        level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123760_, (double)1.0);
        level.m_6263_((Player)null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void vitalShift(ManasSkillInstance instance, LivingEntity entity) {
        LivingEntity target = (LivingEntity)SkillHelper.getTargetingEntity(LivingEntity.class, (LivingEntity)entity, (double)30.0, (double)0.5, (boolean)true, (boolean)true);
        float f = entity.m_217043_().m_188501_();
        float f2 = instance.isMastered(entity) ? 0.5f : 0.25f;
        if (f <= f2 && entity.m_21223_() < target.m_21223_()) {
            entity.m_21153_(Math.min(target.m_21223_(), entity.m_21233_()));
        }
        instance.setCoolDown(30);
    }

    public void absoluteAntithesis(ManasSkillInstance instance, LivingEntity entity) {
        TimerUtils.Timer timer = TimerUtils.getOrCreateTimer("absoluteAntithesisTimer");
        if (!entity.m_21023_((MobEffect)MysticismMobEffects.ANAESTHESIA.get())) {
            timer.start(2400, () -> {
                timer.stop();
                instance.setCoolDown(300);
            });
            entity.m_7292_(new MobEffectInstance((MobEffect)MysticismMobEffects.ANAESTHESIA.get(), 2400, 0, false, false, false));
        } else {
            timer.stop();
            instance.setCoolDown(300);
        }
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }
}

