/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ApolloSkill
extends Skill {
    protected static final UUID ACCELERATION = UUID.fromString("e85d7c3a-fbdc-4e7b-9e3f-2d50b6578425");

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/apollo.png");
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public int getMaxMastery() {
        return 2000;
    }

    public ApolloSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled();
    }

    public double getObtainingEpCost() {
        return 300000.0;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.MUSICIAN.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.MUSICIAN.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public int modes() {
        return 4;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return switch (instance.getMode()) {
                case 1 -> {
                    if (instance.getOrCreateTag().m_128451_("SoulRender") >= 100) {
                        yield 4;
                    }
                    if (this.isMastered((ManasSkillInstance)instance, entity)) {
                        yield 3;
                    }
                    yield 2;
                }
                case 2 -> 1;
                case 3 -> 2;
                case 4 -> 3;
                default -> 0;
            };
        }
        return switch (instance.getMode()) {
            case 1 -> 2;
            case 2 -> {
                if (this.isMastered((ManasSkillInstance)instance, entity)) {
                    yield 3;
                }
                yield 1;
            }
            case 3 -> {
                if (instance.getOrCreateTag().m_128451_("SoulRender") >= 100) {
                    yield 4;
                }
                yield 1;
            }
            default -> 1;
        };
    }

    public String modeLearningId(int mode) {
        if (mode == 4) {
            return "SoulRender";
        }
        return "None";
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.apollo.sonic_blast");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.apollo.sound_wave");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.apollo.mind_requiem");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.apollo.soul_render");
            default -> Component.m_237119_();
        };
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1 -> 50000.0;
            case 2 -> 100000.0;
            case 3 -> 150000.0;
            case 4 -> 300000.0;
            default -> 0.0;
        };
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get(), 200, 2, false, false, false));
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        this.onTick(instance, entity);
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)true);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        entity.m_21195_((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get());
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)false);
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            Level level = entity.m_9236_();
            switch (instance.getMode()) {
                case 1: {
                    this.sonicBlast(instance, entity, level);
                    break;
                }
                case 2: {
                    this.soundWave(instance, entity, level);
                    break;
                }
                case 3: {
                    this.mindRequiem(instance, entity, level);
                    break;
                }
                case 4: {
                    this.soulRender(instance, entity, level);
                }
            }
        }
    }

    private void sonicBlast(ManasSkillInstance instance, LivingEntity entity, Level level) {
        this.addMasteryPoint(instance, entity);
        instance.setCoolDown(1);
        double range = instance.isMastered(entity) ? 16.0 : 12.0;
        Vec3 target = entity.m_20182_().m_82549_(entity.m_20154_().m_82490_(range));
        Vec3 source = entity.m_20182_().m_82520_(0.0, (double)1.6f, 0.0);
        Vec3 offSetToTarget = target.m_82546_(source);
        Vec3 normalizes = offSetToTarget.m_82541_();
        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 5.0f, 1.0f);
        for (int particleIndex = 1; particleIndex < Mth.m_14107_((double)offSetToTarget.m_82553_()); ++particleIndex) {
            Vec3 particlePos = source.m_82549_(normalizes.m_82490_((double)particleIndex));
            ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.SONIC_BLAST.get()), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            AABB aabb = new AABB(new BlockPos(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_)).m_82400_(2.0);
            List livingEntityList = level.m_6443_(LivingEntity.class, aabb, entityData -> !entityData.m_7306_((Entity)entity));
            if (livingEntityList.isEmpty()) continue;
            for (LivingEntity pLivingEntity : livingEntityList) {
                if (RaceHelper.isSpiritualLifeForm((LivingEntity)pLivingEntity)) continue;
                pLivingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 1, false, false, false));
                DamageSource damagesource = TensuraDamageSources.sonicBlast((Entity)entity);
                pLivingEntity.m_6469_((DamageSource)this.sourceWithMP(damagesource, entity, instance), this.isMastered(instance, entity) ? 300.0f : 150.0f);
            }
        }
    }

    private void soundWave(ManasSkillInstance instance, LivingEntity entity, Level level) {
        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 5.0f, 1.0f);
        List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(15.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_());
        if (!list.isEmpty()) {
            this.addMasteryPoint(instance, entity);
            for (LivingEntity target : list) {
                if (RaceHelper.isSpiritualLifeForm((LivingEntity)target)) continue;
                target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 1, false, false, false));
                DamageSource damagesource = TensuraDamageSources.sonicBlast((Entity)entity);
                target.m_6469_((DamageSource)this.sourceWithMP(damagesource, entity, instance), this.isMastered(instance, entity) ? 140.0f : 80.0f);
            }
        }
        instance.setCoolDown(1);
        ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.SOUND_GIANT.get()), entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123747_, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123813_, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
    }

    private void mindRequiem(ManasSkillInstance instance, LivingEntity entity, Level level) {
        CompoundTag tag = instance.getOrCreateTag();
        int learnPoint = tag.m_128451_("SoulRender");
        if (learnPoint < 100) {
            tag.m_128405_("SoulRender", learnPoint + SkillUtils.getEarningLearnPoint((ManasSkillInstance)instance, (LivingEntity)entity, (boolean)true));
            if (tag.m_128451_("SoulRender") >= 100 && entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.mastery", (Object[])new Object[]{this.getModeName(4)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            }
        }
        this.addMasteryPoint(instance, entity);
        instance.setCoolDown(3);
        Vec3 target = entity.m_20182_().m_82549_(entity.m_20154_().m_82490_(10.0));
        Vec3 source = entity.m_20182_().m_82520_(0.0, (double)1.6f, 0.0);
        Vec3 offSetToTarget = target.m_82546_(source);
        Vec3 normalizes = offSetToTarget.m_82541_();
        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 5.0f, 1.0f);
        for (int particleIndex = 1; particleIndex < Mth.m_14107_((double)offSetToTarget.m_82553_()); ++particleIndex) {
            Vec3 particlePos = source.m_82549_(normalizes.m_82490_((double)particleIndex));
            ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.SOUND_REQUIEM.get()), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            AABB aabb = new AABB(new BlockPos(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_)).m_82400_(3.0);
            List livingEntityList = level.m_6443_(LivingEntity.class, aabb, entityData -> !entityData.m_7306_((Entity)entity));
            if (livingEntityList.isEmpty()) continue;
            for (LivingEntity living : livingEntityList) {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 1, false, false, false));
                DamageSource damagesource = TensuraDamageSources.mindRequiem((Entity)entity);
                if (!living.m_6469_((DamageSource)this.sourceWithMP(damagesource, entity, instance), 500.0f)) continue;
                DamageSourceHelper.directSpiritualHurt((LivingEntity)living, (Entity)entity, (float)200.0f);
            }
        }
    }

    private void soulRender(ManasSkillInstance instance, LivingEntity entity, Level level) {
        this.addMasteryPoint(instance, entity);
        instance.setCoolDown(10);
        Vec3 source = entity.m_20182_().m_82520_(0.0, 1.6, 0.0);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 5.0f, 1.0f);
        List targets = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(20.0), e -> !e.m_7306_((Entity)entity) && e.m_6084_());
        for (LivingEntity target : targets) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 1, false, false, false));
            DamageSource damageSource = TensuraDamageSources.mindRequiem((Entity)entity);
            if (!target.m_6469_((DamageSource)this.sourceWithMP(damageSource, entity, instance), 900.0f)) continue;
            DamageSourceHelper.directSpiritualHurt((LivingEntity)target, (Entity)entity, (float)300.0f);
        }
        if (!level.f_46443_) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 360; i += 10) {
                for (int j = -45; j <= 45; j += 15) {
                    double rad = Math.toRadians(i);
                    double pitch = Math.toRadians(j);
                    double x = Math.cos(rad) * Math.cos(pitch);
                    double y = Math.sin(pitch);
                    double z = Math.sin(rad) * Math.cos(pitch);
                    Vec3 dir = new Vec3(x, y, z).m_82541_();
                    Vec3 pos = source.m_82549_(dir.m_82490_(10.0));
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.SOUND_REQUIEM.get()), pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

