/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.registry.sound.MysticismSoundEvents;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.util.damage.MysticismDamageSources;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class AsmodeusSkill
extends Skill {
    private static final ThreadLocal<Boolean> reentrantGuard = ThreadLocal.withInitial(() -> false);

    public AsmodeusSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    @Nullable
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/asmodeus.png");
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity living, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.LUST.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)living);
        if (SkillUtils.hasSkill((Entity)living, (ManasSkill)currentSkill)) {
            return;
        }
        if (living instanceof Player) {
            Player player = (Player)living;
            if (living.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)living).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!living.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.LUST.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.asmodeus.drain");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.asmodeus.invigorate");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.asmodeus.death_blessing");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.asmodeus.memory_end_requiem");
            default -> Component.m_237119_();
        };
    }

    public int getMaxMastery() {
        return 3000;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1 -> 100000.0;
            case 2 -> 50000.0;
            case 3 -> 150000.0;
            case 4 -> 300000.0;
            default -> 0.0;
        };
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 4 : instance.getMode() - 1;
        }
        return instance.getMode() == 4 ? 1 : instance.getMode() + 1;
    }

    public String modeLearningId(int mode) {
        if (mode == 4) {
            return "MemoryEndRequiem";
        }
        return "None";
    }

    public double getObtainingEpCost() {
        return 1000000.0;
    }

    public int modes() {
        return 4;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getMastery() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDamageEntity(ManasSkillInstance instance, LivingEntity entity, LivingHurtEvent event) {
        if (instance.getMode() == 4 && instance.getOrCreateTag().m_128451_("MemoryEndRequiem") >= 100) {
            if (instance.onCoolDown()) {
                return;
            }
            if (reentrantGuard.get().booleanValue() || !DamageSourceHelper.isPhysicalAttack((DamageSource)event.getSource())) {
                return;
            }
            LivingEntity target = event.getEntity();
            reentrantGuard.set(true);
            try {
                this.memory(instance, entity, entity.m_9236_(), target);
            }
            finally {
                reentrantGuard.set(false);
            }
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity living, int heldTicks) {
        List list;
        if (instance.getMode() != 3) {
            return false;
        }
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)living, (ManasSkillInstance)instance)) {
            return false;
        }
        if (heldTicks % 200 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, living);
        }
        living.m_9236_().m_6263_((Player)null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (heldTicks % 10 == 0) {
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> living), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:death_blessing"), living.m_19879_(), 0.0, 1.0, 0.0, true));
        }
        if (!(list = living.m_9236_().m_6443_(LivingEntity.class, living.m_20191_().m_82400_(7.0), e -> !e.m_7306_((Entity)living) && e.m_6084_())).isEmpty() && heldTicks > 0 && heldTicks % 60 == 0) {
            double ownerEP = TensuraEPCapability.getEP((LivingEntity)living);
            for (LivingEntity target : list) {
                double epGain;
                double targetEP;
                double difference;
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) continue;
                }
                if ((difference = (targetEP = TensuraEPCapability.getEP((LivingEntity)target)) / ownerEP) <= 0.75) {
                    if (!target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.deathBless((Entity)living), living, instance), target.m_21233_() * 10.0f)) continue;
                    SkillHelper.gainMP((LivingEntity)living, (double)(targetEP * 0.75), (boolean)false);
                    SkillHelper.gainAP((LivingEntity)living, (double)(targetEP * 0.25), (boolean)false);
                    continue;
                }
                if (!target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.deathBless((Entity)living), living, instance), target.m_21233_() / 2.0f)) continue;
                double d = epGain = difference <= 1.0 ? targetEP * 0.25 : targetEP * 0.05;
                if (target.m_6084_()) {
                    this.reduceStat(target, epGain, living);
                }
                SkillHelper.gainMP((LivingEntity)living, (double)(epGain * 0.75), (boolean)false);
                SkillHelper.gainAP((LivingEntity)living, (double)(epGain * 0.25), (boolean)false);
            }
        } else if (living instanceof Player) {
            Player player = (Player)living;
            int second = 3 + heldTicks / 100 * 3;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.time_held.max", (Object[])new Object[]{heldTicks / 20, second}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
        }
        return true;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        switch (instance.getMode()) {
            case 1: {
                if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                    return;
                }
                this.addMasteryPoint(instance, entity);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)5.0, (boolean)false);
                if (target != null) {
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        if (player.m_150110_().f_35934_) {
                            return;
                        }
                    }
                    if (!this.isMastered(instance, entity)) {
                        SkillHelper.drainEnergy((LivingEntity)target, (LivingEntity)entity, (double)1000.0, (boolean)false);
                        SkillHelper.drainEnergy((LivingEntity)target, (LivingEntity)entity, (double)0.01, (boolean)true);
                    } else {
                        SkillHelper.drainEnergy((LivingEntity)target, (LivingEntity)entity, (double)5000.0, (boolean)false);
                        SkillHelper.drainEnergy((LivingEntity)target, (LivingEntity)entity, (double)0.05, (boolean)true);
                    }
                    instance.setCoolDown(1);
                    level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12053_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)((ParticleOptions)TensuraParticles.YELLOW_LIGHTNING_SPARK.get()));
                    break;
                }
                if (entity.m_21023_((MobEffect)TensuraMobEffects.LUST_DRAIN.get())) break;
                instance.setCoolDown(1);
                entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.LUST_DRAIN.get(), 200, this.isMastered(instance, entity) ? 1 : 0, false, false, false));
                level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12053_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 2: {
                boolean success;
                LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)5.0, (boolean)false);
                if (target != null && entity.m_6144_()) {
                    if (target instanceof Animal) {
                        Animal animal = (Animal)target;
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            if (animal.m_21223_() == animal.m_21233_() && animal.m_146764_() >= 0) {
                                animal.m_146762_(0);
                                animal.m_27595_(player);
                            }
                        }
                    }
                    success = SkillHelper.removePredicateEffect((LivingEntity)target, effect -> true, (double)this.magiculeCost(entity, instance));
                    int cost = instance.isMastered(entity) ? 10 : 30;
                    float lackedHealth = target.m_21233_() - target.m_21223_();
                    double lackedMagicule = SkillHelper.outOfMagiculeStillConsume((LivingEntity)entity, (double)((int)(lackedHealth * (float)cost)));
                    if (lackedMagicule > 0.0) {
                        lackedHealth = (float)((double)lackedHealth - lackedMagicule / (double)cost);
                    }
                    target.m_5634_(lackedHealth);
                    boolean bl = success = success || lackedHealth > 0.0f;
                    if (success) {
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123749_, (double)1.0);
                    }
                } else {
                    success = SkillHelper.removePredicateEffect((LivingEntity)entity, effect -> true, (double)this.magiculeCost(entity, instance));
                    int cost = instance.isMastered(entity) ? 10 : 30;
                    float lackedHealth = entity.m_21233_() - entity.m_21223_();
                    double lackedMagicule = SkillHelper.outOfMagiculeStillConsume((LivingEntity)entity, (double)((int)(lackedHealth * (float)cost)));
                    if (lackedMagicule > 0.0) {
                        lackedHealth = (float)((double)lackedHealth - lackedMagicule / (double)cost);
                    }
                    entity.m_5634_(lackedHealth);
                    boolean bl = success = success || lackedHealth > 0.0f;
                    if (success) {
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123749_, (double)1.0);
                    }
                }
                if (!success) break;
                this.addMasteryPoint(instance, entity);
                instance.setCoolDown(instance.isMastered(entity) ? 5 : 3);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 4: {
                CompoundTag tag = instance.getOrCreateTag();
                int learnPoint = tag.m_128451_("MemoryEndRequiem");
                if (learnPoint >= 100) break;
                if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                    return;
                }
                tag.m_128405_("MemoryEndRequiem", learnPoint + SkillUtils.getEarningLearnPoint((ManasSkillInstance)instance, (LivingEntity)entity, (boolean)true));
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (tag.m_128451_("MemoryEndRequiem") >= 100) {
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(5)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    } else {
                        instance.setCoolDown(10);
                        SkillUtils.learningFailPenalty((LivingEntity)entity);
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(5)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                    }
                    player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                instance.markDirty();
            }
        }
    }

    public void onSubordinateDeath(ManasSkillInstance instance, LivingEntity owner, LivingDeathEvent e) {
        if (instance.isToggled()) {
            LivingEntity target = e.getEntity();
            if (target.getPersistentData().m_128471_("is_display")) {
                if (owner instanceof Player) {
                    Player player = (Player)owner;
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.mephisto.life_domination.message.is_display").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
                return;
            }
            if (owner.m_20280_((Entity)target) > 400.0 && owner instanceof Player) {
                Player player = (Player)owner;
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.asmodeus.angel_of_death.failure", (Object[])new Object[]{target.m_7755_().getString()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
            TensuraEPCapability.getFrom((LivingEntity)target).ifPresent(cap -> {
                double subordinateEP = cap.getEP();
                if (!SkillHelper.outOfMagicule((LivingEntity)owner, (double)(subordinateEP * 0.1))) {
                    target.m_217045_();
                    CompoundTag tags = target.getPersistentData();
                    tags.m_128379_("NO_EP_PLUNDER", true);
                    tags.m_128379_("NO_SKILL_PLUNDER", true);
                    tags.m_128379_("no_loot", true);
                    e.setCanceled(true);
                    owner.f_19853_.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    target.m_21153_((float)((double)target.m_21233_() * 0.2));
                    if (owner instanceof Player) {
                        Player player = (Player)owner;
                        player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.asmodeus.angel_of_death.success", (Object[])new Object[]{target.m_7755_().getString()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
                    }
                }
            });
        }
    }

    private void memory(ManasSkillInstance instance, LivingEntity entity, Level level, LivingEntity target) {
        boolean hasUltimateSkill;
        if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            return;
        }
        SkillStorage targetStorage = SkillAPI.getSkillsFrom((Entity)target);
        if (target instanceof Player) {
            Player player = (Player)target;
            if (player.m_150110_().f_35934_) {
                return;
            }
        }
        if (hasUltimateSkill = targetStorage.getLearnedSkills().stream().map(ManasSkillInstance::getSkill).filter(skill -> skill instanceof Skill).map(skill -> (Skill)skill).anyMatch(skill -> skill.getType() == Skill.SkillType.ULTIMATE)) {
            TensuraEPCapability.getFrom((LivingEntity)entity).ifPresent(cap -> {
                double entityEP = cap.getEP();
                TensuraEPCapability.getFrom((LivingEntity)target).ifPresent(targetCap -> {
                    int burden;
                    int slowness;
                    int weakness;
                    int duration;
                    double drainRatio;
                    float damage;
                    double targetEP = targetCap.getEP();
                    double ratio = targetEP / entityEP;
                    if (ratio <= 1.0) {
                        damage = target.m_21233_();
                        drainRatio = 1.0;
                        duration = 300;
                        weakness = 6;
                        slowness = 6;
                        burden = 6;
                    } else if (ratio <= 1.1) {
                        damage = target.m_21233_() * 0.9f;
                        drainRatio = 0.75;
                        duration = 300;
                        weakness = 6;
                        slowness = 6;
                        burden = 6;
                    } else if (ratio <= 1.2) {
                        damage = target.m_21233_() * 0.8f;
                        drainRatio = 0.5;
                        duration = 280;
                        weakness = 4;
                        slowness = 4;
                        burden = 5;
                    } else if (ratio <= 1.3) {
                        damage = target.m_21233_() * 0.7f;
                        drainRatio = 0.4;
                        duration = 260;
                        weakness = 4;
                        slowness = 4;
                        burden = 4;
                    } else if (ratio <= 1.4) {
                        damage = target.m_21233_() * 0.6f;
                        drainRatio = 0.3;
                        duration = 240;
                        weakness = 4;
                        slowness = 4;
                        burden = 3;
                    } else if (ratio <= 1.5) {
                        damage = target.m_21233_() * 0.5f;
                        drainRatio = 0.2;
                        duration = 220;
                        weakness = 2;
                        slowness = 2;
                        burden = 2;
                    } else {
                        damage = target.m_21233_() * 0.25f;
                        drainRatio = 0.1;
                        duration = 200;
                        weakness = 1;
                        slowness = 1;
                        burden = 1;
                    }
                    if (target.m_6469_((DamageSource)this.sourceWithMP(MysticismDamageSources.lifeReapingSlash((Entity)entity), entity, instance), damage)) {
                        entity.m_5634_(damage);
                        double epToDrain = targetEP * drainRatio;
                        SkillHelper.drainEnergy((LivingEntity)target, (LivingEntity)entity, (double)epToDrain, (boolean)false);
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, duration, weakness - 1, false, false, true));
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, duration, slowness - 1, false, false, true));
                        target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.BURDEN.get(), duration, burden - 1, false, false, true));
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123792_);
                    }
                });
            });
            this.restoreMagicules(target, TensuraEPCapability.getEP((LivingEntity)target));
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)MysticismSoundEvents.LIFE_REAPING_SLASH_HURT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)((ParticleOptions)TensuraParticles.BLACK_LIGHTNING_EFFECT.get()), (double)1.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)((ParticleOptions)TensuraParticles.DARK_RED_LIGHTNING_SPARK.get()), (double)1.0);
        } else {
            target.m_6469_((DamageSource)this.sourceWithMP(MysticismDamageSources.lifeReapingSlash((Entity)entity), entity, instance), target.m_21233_());
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123808_);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123792_);
            SkillHelper.drainEnergy((LivingEntity)target, (LivingEntity)entity, (double)100.0, (boolean)true);
            this.restoreMagicules(target, TensuraEPCapability.getEP((LivingEntity)target));
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)MysticismSoundEvents.LIFE_REAPING_SLASH_KILL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123790_, (double)1.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123746_, (double)1.0);
        }
        reentrantGuard.set(false);
        instance.addMasteryPoint(entity);
        instance.setCoolDown(15);
    }

    private void restoreMagicules(LivingEntity entity, double amount) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            SkillHelper.gainMP((LivingEntity)player, (double)amount, (boolean)false);
        }
    }

    private void reduceStat(LivingEntity target, double amount, LivingEntity attacker) {
        if (target instanceof Player) {
            Player playerTarget = (Player)target;
            TensuraPlayerCapability.getFrom((Player)playerTarget).ifPresent(cap -> {
                cap.setMagicule(cap.getMagicule() - amount * 0.75);
                cap.setAura(cap.getAura() - amount * 0.25);
            });
            TensuraPlayerCapability.sync((Player)playerTarget);
        } else {
            SkillHelper.reduceEP((LivingEntity)target, (LivingEntity)attacker, (double)amount, (boolean)false);
        }
    }
}

