/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.ISpatialStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.intrinsic.AbsorbDissolveSkill;
import com.github.manasmods.tensura.ability.skill.unique.StarvedSkill;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.magic.breath.BreathEntity;
import com.github.manasmods.tensura.menu.container.SpatialStorageContainer;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.TensuraAdvancementsHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.github.manasmods.tensura.world.TensuraGameRules;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.menu.BeelzebubMenuProvide;
import io.github.Memoires.trmysticism.menu.BeelzebubMenuReceive;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeelzebubSkill
extends Skill
implements ISpatialStorage {
    protected static final UUID GUARDIAN = UUID.fromString("57d10fe9-6fb8-45a8-9635-2e30848deb30");

    public BeelzebubSkill() {
        super(Skill.SkillType.ULTIMATE);
        this.addHeldAttributeModifier(Attributes.f_22279_, "8c4fec2d-6913-435e-9bfd-a111b8eadf62", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Nullable
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/beelzebub.png");
    }

    public void addHeldAttributeModifiers(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() == 2) {
            super.addHeldAttributeModifiers(instance, entity);
        }
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled();
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(20.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && living.m_7307_((Entity)entity));
        if (!list.isEmpty()) {
            for (LivingEntity ally : list) {
                ally.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.PROTECTION.get(), 3600, 0, false, false, true), (Entity)entity);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)ally, (ParticleOptions)ParticleTypes.f_175828_, (double)1.0);
            }
        }
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return instance.getMastery() >= 0;
    }

    public double getObtainingEpCost() {
        return 500000.0;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.GOURMET.get(), (TensuraSkill)UniqueSkills.GUARDIAN.get(), (TensuraSkill)ExtraSkills.MULTILAYER_BARRIER.get(), (TensuraSkill)CommonSkills.CORROSION.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.GUARDIAN.get();
        Skill secondPreviousSkill = (Skill)UniqueSkills.GOURMET.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
            List<Skill> skillsToLearn = List.of((Skill)ExtraSkills.SPATIAL_MANIPULATION.get(), (Skill)ExtraSkills.ULTRASPEED_REGENERATION.get(), (Skill)ExtraSkills.GODWOLF_SENSE.get(), (Skill)ExtraSkills.UNIVERSAL_PERCEPTION.get());
            if (entity instanceof Player) {
                Player player = (Player)entity;
                for (Skill skill : skillsToLearn) {
                    if (!player.m_7500_()) {
                        double cost = skill.getObtainingEpCost() * (double)player.f_19853_.m_46469_().m_46215_(TensuraGameRules.MP_SKILL_COST) / 100.0;
                        TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                            cap.setBaseMagicule(cap.getBaseMagicule() + cost, (LivingEntity)player, false);
                            TensuraPlayerCapability.sync((Player)player);
                        });
                    }
                    if (!SkillUtils.learnSkill((LivingEntity)player, (ManasSkill)skill)) continue;
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                }
            }
        }
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                if (storage.getSkill((ManasSkill)secondPreviousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)secondPreviousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{secondPreviousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public int modes() {
        return 7;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 7 : instance.getMode() - 1;
        }
        return instance.getMode() == 7 ? 1 : instance.getMode() + 1;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.beelzebub.predation");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.beelzebub.corrosion");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.beelzebub.stomach");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.beelzebub.isolation");
            case 5 -> Component.m_237115_((String)"trmysticism.skill.mode.beelzebub.provide");
            case 6 -> Component.m_237115_((String)"trmysticism.skill.mode.beelzebub.receive");
            case 7 -> Component.m_237115_((String)"trmysticism.skill.mode.beelzebub.substitution");
            default -> Component.m_237119_();
        };
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 10000.0;
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        this.ironWall(instance, entity, true);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        this.ironWall(instance, entity, false);
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            switch (instance.getMode()) {
                case 1: {
                    this.predationPress(instance, entity);
                    break;
                }
                case 3: {
                    this.openSpatialStorage(entity, instance);
                    break;
                }
                case 4: {
                    this.isolation(instance, entity);
                    break;
                }
                case 5: {
                    this.provide(instance, entity);
                    break;
                }
                case 6: {
                    this.receive(instance, entity);
                    break;
                }
                case 7: {
                    boolean substitution = !instance.getOrCreateTag().m_128471_("Substitution");
                    instance.getOrCreateTag().m_128379_("Substitution", substitution);
                    if (substitution) {
                        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11671_, SoundSource.PLAYERS, 1.0f, 1.1f);
                        break;
                    }
                    entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11665_, SoundSource.PLAYERS, 1.0f, 0.9f);
                }
            }
        }
    }

    @NotNull
    public SpatialStorageContainer getSpatialStorage(ManasSkillInstance instance) {
        SpatialStorageContainer container = new SpatialStorageContainer(256, 1337);
        container.m_7797_(instance.getOrCreateTag().m_128437_("SpatialStorage", 10));
        return container;
    }

    private void ironWall(ManasSkillInstance instance, LivingEntity entity, boolean toggle) {
        Level level = entity.m_9236_();
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        AttributeInstance armor = entity.m_21051_(Attributes.f_22284_);
        if (armor != null && armor.m_22111_(GUARDIAN) != null && !toggle) {
            armor.m_22127_(GUARDIAN);
            AttributeInstance attributeInstance = entity.m_21051_(Attributes.f_22278_);
            if (attributeInstance != null) {
                attributeInstance.m_22127_(GUARDIAN);
            }
            level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11665_, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (toggle) {
            if (armor != null) {
                float amount;
                float f = amount = instance.isMastered(entity) ? 45.0f : 30.0f;
                if (armor.m_22111_(GUARDIAN) != null) {
                    armor.m_22127_(GUARDIAN);
                }
                AttributeModifier modifier = new AttributeModifier(GUARDIAN, "Guardian", (double)amount, AttributeModifier.Operation.ADDITION);
                armor.m_22125_(modifier);
            }
            AttributeInstance knockBack = entity.m_21051_(Attributes.f_22278_);
            AttributeModifier attributemodifier = new AttributeModifier(GUARDIAN, "Guardian", 1.0, AttributeModifier.Operation.ADDITION);
            if (knockBack != null && !knockBack.m_22109_(attributemodifier)) {
                knockBack.m_22125_(attributemodifier);
            }
            level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11671_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void isolation(ManasSkillInstance instance, LivingEntity entity) {
        ItemStack itemStack = entity.m_21205_();
        Level level = entity.m_9236_();
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        if (itemStack.m_41619_()) {
            boolean success;
            LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)3.0, (boolean)false);
            if (target != null) {
                success = TensuraEffectsCapability.getSeverance((LivingEntity)target) > 0.0;
                TensuraEffectsCapability.getFrom((LivingEntity)target).ifPresent(cap -> cap.setSeveranceAmount(0.0));
                Predicate<MobEffect> predicate = effect -> effect.m_19483_() == MobEffectCategory.HARMFUL;
                boolean bl = success = success || SkillHelper.removePredicateEffect((LivingEntity)target, predicate, (double)this.magiculeCost(entity, instance));
                if (success) {
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123749_, (double)2.0);
                }
            } else {
                success = TensuraEffectsCapability.getSeverance((LivingEntity)entity) > 0.0;
                TensuraEffectsCapability.getFrom((LivingEntity)entity).ifPresent(cap -> cap.setSeveranceAmount(0.0));
                Predicate<MobEffect> predicate = effect -> effect.m_19483_() == MobEffectCategory.HARMFUL;
                boolean bl = success = success || SkillHelper.removePredicateEffect((LivingEntity)entity, predicate, (double)this.magiculeCost(entity, instance));
                if (success) {
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123749_, (double)2.0);
                }
            }
            if (success) {
                instance.setCoolDown(instance.isMastered(entity) ? 5 : 3);
                level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        } else {
            for (AbsorbDissolveSkill.Dissolving dissolving : AbsorbDissolveSkill.Dissolving.values()) {
                if (!dissolving.getItem().equals(itemStack.m_41720_())) continue;
                itemStack.m_41774_(1);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    if (itemStack.m_41720_().equals(TensuraMaterialItems.SLIME_IN_A_BUCKET.get())) {
                        TensuraAdvancementsHelper.grant((ServerPlayer)serverPlayer, (ResourceLocation)TensuraAdvancementsHelper.Advancements.TRAITOR);
                    }
                    serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
                }
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                        cap.setMagicule(cap.getMagicule() + (double)(dissolving.getMagicule() * 2));
                        if (cap.getMagicule() > player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get())) {
                            cap.setMagicule(player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get()));
                        }
                    });
                }
                if (dissolving.getHeal() > 0.0f) {
                    entity.m_5634_(dissolving.getHeal());
                }
                level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public void provide(ManasSkillInstance instance, LivingEntity providerEntity) {
        if (!(providerEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)providerEntity;
        LivingEntity targetEntity = this.findValidSubordinateTarget(serverPlayer, 6.0);
        if (targetEntity == null) {
            serverPlayer.m_5661_((Component)Component.m_237113_((String)"No valid subordinate target found."), true);
            return;
        }
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)serverPlayer);
        List<ResourceLocation> preFiltered = storage.getLearnedSkills().stream().filter(inst -> inst.getSkill() instanceof Skill).map(inst -> (Skill)inst.getSkill()).filter(skill -> {
            Skill.SkillType type = skill.getType();
            return type == Skill.SkillType.INTRINSIC || type == Skill.SkillType.COMMON || type == Skill.SkillType.EXTRA;
        }).map(ManasSkill::getRegistryName).filter(Objects::nonNull).toList();
        List<ResourceLocation> skillList = preFiltered.stream().filter(location -> this.canCreateSkill((ResourceLocation)location, serverPlayer, instance)).toList();
        if (skillList.isEmpty()) {
            serverPlayer.m_5661_((Component)Component.m_237113_((String)"No transferable skills available."), true);
            return;
        }
        NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider(BeelzebubMenuProvide::new, (Component)Component.m_237115_((String)"tensura.menu.skill.provide")), buf -> {
            buf.m_130077_(targetEntity.m_20148_());
            buf.m_236828_((Collection)skillList, FriendlyByteBuf::m_130085_);
        });
        serverPlayer.m_6330_(SoundEvents.f_11889_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private LivingEntity findValidSubordinateTarget(ServerPlayer player, double range) {
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 lookVec = player.m_20154_();
        Vec3 targetVec = eyePos.m_82549_(lookVec.m_82490_(range));
        AABB searchBox = new AABB(eyePos, targetVec).m_82400_(0.5);
        UUID playerId = player.m_20148_();
        List potentialTargets = player.f_19853_.m_6443_(LivingEntity.class, searchBox, entity -> {
            if (entity == player || !entity.m_6084_()) {
                return false;
            }
            return TensuraEPCapability.getFrom((LivingEntity)entity).map(cap -> {
                TamableAnimal t;
                if (entity instanceof TamableAnimal && (t = (TamableAnimal)entity).m_21824_()) {
                    return playerId.equals(t.m_21805_());
                }
                return playerId.equals(cap.getPermanentOwner());
            }).orElse(false);
        });
        return potentialTargets.stream().filter(target -> {
            Vec3 mid = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
            Vec3 dir = mid.m_82546_(eyePos).m_82541_();
            return lookVec.m_82526_(dir) > 0.8;
        }).min(Comparator.comparingDouble(arg_0 -> ((ServerPlayer)player).m_20270_(arg_0))).orElse(null);
    }

    public void receive(ManasSkillInstance instance, LivingEntity entity) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)entity;
        ServerLevel level = serverPlayer.m_9236_();
        LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)serverPlayer, (double)5.0, (boolean)false);
        if (target == null || !target.m_6084_()) {
            return;
        }
        if (!SkillHelper.isSubordinate((LivingEntity)serverPlayer, (LivingEntity)target)) {
            return;
        }
        if (target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SKILL_PLUNDER)) {
            return;
        }
        List<ResourceLocation> availableSkills = SkillAPI.getSkillsFrom((Entity)target).getLearnedSkills().stream().filter(inst -> StarvedSkill.canGain((ManasSkill)inst.getSkill())).filter(inst -> !inst.isTemporarySkill()).filter(inst -> inst.getMastery() >= 0).filter(inst -> inst.getSkill() != this).map(inst -> inst.getSkill().getRegistryName()).filter(Objects::nonNull).toList();
        if (availableSkills.isEmpty()) {
            return;
        }
        NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider(BeelzebubMenuReceive::new, (Component)Component.m_237113_((String)"Plunder Skill")), buf -> {
            buf.m_130077_(entity.m_20148_());
            buf.m_236828_((Collection)availableSkills, FriendlyByteBuf::m_130085_);
        });
        serverPlayer.m_6330_(SoundEvents.f_11889_, SoundSource.PLAYERS, 1.0f, 0.85f);
    }

    private boolean canCreateSkill(ResourceLocation location, ServerPlayer serverPlayer, ManasSkillInstance instance) {
        ResourceLocation created;
        ManasSkill skill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(location);
        if (skill == null) {
            return false;
        }
        CompoundTag tag = instance.getTag();
        return tag == null || !tag.m_128441_("created_skill") || !(created = new ResourceLocation(tag.m_128461_("created_skill"))).equals((Object)location);
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        switch (instance.getMode()) {
            case 1: {
                this.predation(instance, entity, heldTicks);
                break;
            }
            case 2: {
                this.corrosion(instance, entity, heldTicks);
            }
        }
        return true;
    }

    public boolean corrosion(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        List list;
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            return false;
        }
        if (heldTicks % 100 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        Level level = entity.m_9236_();
        level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12031_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (heldTicks % 10 == 0) {
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:gluttony_corrosion"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
        }
        if (heldTicks % 10 == 0 && !(list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(5.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity))).isEmpty()) {
            for (LivingEntity target : list) {
                CompoundTag tag;
                if (!target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.corrosion((Entity)entity), entity, instance), 50.0f) || !target.m_21224_()) continue;
                if (!target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SKILL_PLUNDER)) {
                    for (ManasSkillInstance targetInstance : SkillAPI.getSkillsFrom((Entity)target).getLearnedSkills().stream().filter(skillInstance -> StarvedSkill.canGain((ManasSkill)skillInstance.getSkill())).toList()) {
                        if (targetInstance.isTemporarySkill() || targetInstance.getMastery() < 0 || targetInstance.getSkill() == this || !SkillUtils.learnSkill((LivingEntity)entity, (ManasSkill)targetInstance.getSkill(), (int)instance.getRemoveTime()) || !(entity instanceof Player)) continue;
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{targetInstance.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    }
                }
                if ((tag = instance.getOrCreateTag()).m_128441_("predationList")) {
                    String targetID;
                    predationList = (CompoundTag)tag.m_128423_("predationList");
                    if (predationList == null || predationList.m_128441_(targetID = EntityType.m_20613_((EntityType)target.m_6095_()).toString())) continue;
                    predationList.m_128379_(targetID, true);
                } else {
                    predationList = new CompoundTag();
                    predationList.m_128379_(EntityType.m_20613_((EntityType)target.m_6095_()).toString(), true);
                    tag.m_128365_("predationList", (Tag)predationList);
                }
                if (target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_EP_PLUNDER)) continue;
                double EP = Math.min(SkillUtils.getEPGain((LivingEntity)target, (LivingEntity)entity), (Double)TensuraConfig.INSTANCE.skillsConfig.maximumEPSteal.get());
                if (target instanceof Player) {
                    Player playerTarget = (Player)target;
                    if (TensuraGameRules.canEpSteal((Level)target.m_9236_())) {
                        int minEP = TensuraGameRules.getMinEp((Level)level);
                        if (minEP > 0) {
                            EP -= (double)minEP;
                        }
                        if (EP <= 0.0) continue;
                        SkillHelper.gainMaxMP((LivingEntity)entity, (double)(EP * 0.4));
                        SkillHelper.gainMaxAP((LivingEntity)entity, (double)(EP * 0.4));
                        TensuraEPCapability.setSkippingEPDrop((LivingEntity)target, (boolean)true);
                        SkillHelper.gainMP((LivingEntity)entity, (double)(EP * 0.4), (boolean)false);
                        SkillHelper.gainAP((LivingEntity)entity, (double)(EP * 0.4), (boolean)false);
                        TensuraPlayerCapability.getFrom((Player)playerTarget).ifPresent(cap -> {
                            cap.setBaseMagicule((double)minEP / 2.0, (LivingEntity)playerTarget);
                            cap.setBaseAura((double)minEP / 2.0, (LivingEntity)playerTarget);
                        });
                        TensuraPlayerCapability.sync((Player)playerTarget);
                    }
                } else {
                    SkillHelper.gainMaxMP((LivingEntity)entity, (double)(EP * 0.4));
                    SkillHelper.gainMaxAP((LivingEntity)entity, (double)(EP * 0.4));
                    TensuraEPCapability.setSkippingEPDrop((LivingEntity)target, (boolean)true);
                    SkillHelper.gainMP((LivingEntity)entity, (double)(EP * 0.4), (boolean)false);
                    SkillHelper.gainAP((LivingEntity)entity, (double)(EP * 0.4), (boolean)false);
                    SkillHelper.reduceEP((LivingEntity)target, (LivingEntity)entity, (double)1.0, (boolean)true, (boolean)true);
                }
                tag.m_128347_("storedMP", tag.m_128459_("storedMP") + EP * 0.1);
                tag.m_128347_("storedAP", tag.m_128459_("storedAP") + EP * 0.1);
                instance.markDirty();
            }
        }
        return true;
    }

    public void predationPress(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        instance.getOrCreateTag().m_128405_("BreathEntity", 0);
        if (entity.m_6144_() && entity instanceof Player) {
            int newMode;
            Player player = (Player)entity;
            switch (tag.m_128451_("blockMode")) {
                case 1: {
                    newMode = 2;
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.predator.block_mode.blocks", (Object[])new Object[]{this.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                    break;
                }
                case 2: {
                    newMode = 3;
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.predator.block_mode.fluid", (Object[])new Object[]{this.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                    break;
                }
                case 3: {
                    newMode = 4;
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.predator.block_mode.all", (Object[])new Object[]{this.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                    break;
                }
                default: {
                    newMode = 1;
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.predator.block_mode.none", (Object[])new Object[]{this.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                }
            }
            tag.m_128405_("blockMode", newMode);
        }
        instance.markDirty();
    }

    public boolean predation(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (entity.m_6144_()) {
            return false;
        }
        CompoundTag tag = instance.getOrCreateTag();
        if (tag.m_128459_("range") < 3.0) {
            tag.m_128347_("range", 10.0);
        }
        if (heldTicks % 60 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        BreathEntity.spawnPredationMist((EntityType)((EntityType)TensuraEntityTypes.GLUTTONY_MIST.get()), (LivingEntity)entity, (ManasSkillInstance)instance, (double)this.magiculeCost(entity, instance), (float)((float)tag.m_128459_("range")), (int)tag.m_128451_("blockMode"), (boolean)true);
        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return true;
    }
}

