/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.ability.skill.intrinsic.CharmSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.human.CloneEntity;
import com.github.manasmods.tensura.entity.template.TensuraHorseEntity;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.network.PacketDistributor;

public class BelphegorSkill
extends Skill {
    protected static final UUID ACCELERATION = UUID.fromString("3f95575f-c38d-49d9-a095-36d3b27437d9");
    double storedMagicule = 0.0;

    public BelphegorSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/belphegor.png");
    }

    public double getObtainingEpCost() {
        return 1000000.0;
    }

    public int getMaxMastery() {
        return 3000;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public int modes() {
        return 6;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        if (entity.m_21023_((MobEffect)TensuraMobEffects.SLEEP_MODE.get()) && UltimateUtils.insideConfig(instance.getSkillId())) {
            return false;
        }
        if (entity.m_21023_((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get()) && UltimateUtils.insideConfig(instance.getSkillId())) {
            return false;
        }
        return entity.m_21023_((MobEffect)TensuraMobEffects.REST.get()) && UltimateUtils.insideConfig(instance.getSkillId()) || super.canInteractSkill(instance, entity);
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.SLOTH.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.SLOTH.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
            ManasSkillInstance slothInstance = (ManasSkillInstance)storage.getSkill((ManasSkill)previousSkill).get();
            double storedMagicules = slothInstance.getOrCreateTag().m_128459_("storedMagicule");
            instance.getOrCreateTag().m_128347_("storedMagicule", storedMagicules);
        }
        TensuraEPCapability.getFrom((LivingEntity)entity).ifPresent(cap -> {
            if (!cap.isChaos() || !cap.isMajin()) {
                cap.setMajin(true);
            }
        });
        TensuraEPCapability.sync((LivingEntity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        int currentMode = instance.getMode();
        boolean mastered = instance.isMastered(entity);
        if (reverse) {
            return currentMode == 1 ? (mastered ? 6 : 5) : currentMode - 1;
        }
        return currentMode == 5 ? (mastered ? 6 : 1) : (currentMode == 6 ? 1 : currentMode + 1);
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.belphegor.fallen_thanatos");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.belphegor.fallen_hypno");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.belphegor.deprive");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.belphegor.rest");
            case 5 -> Component.m_237115_((String)"trmysticism.skill.mode.belphegor.fallen_catastrophe");
            case 6 -> Component.m_237115_((String)"trmysticism.skill.mode.belphegor.fallen_strike");
            default -> Component.m_237119_();
        };
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1, 2, 3 -> 10000.0;
            case 6 -> 1000000.0;
            default -> 0.0;
        };
    }

    public String modeLearningId(int mode) {
        if (mode == 6) {
            return "fallenStrike";
        }
        return "None";
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)true);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)false);
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMastery() < 0) {
            return false;
        }
        return instance.getMode() != 5 && instance.getMode() != 6;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity entity, LivingHurtEvent event) {
        if (instance.isToggled() && DamageSourceHelper.isPhysicalAttack((DamageSource)event.getSource())) {
            LivingEntity target = event.getEntity();
            double bonus = instance.isMastered(entity) ? target.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()) * 0.2 : (double)0.05f;
            DamageSourceHelper.directSpiritualHurt((LivingEntity)target, (Entity)entity, (float)(100.0f + (float)bonus));
            if (!target.m_6084_()) {
                event.setCanceled(true);
            }
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() != 5 && instance.getMode() != 6) {
            if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                return false;
            }
            Level level = entity.m_9236_();
            switch (instance.getMode()) {
                case 1: {
                    double radius = 10.0;
                    double angleThreshold = 30.0;
                    Vec3 lookVector = entity.m_20154_();
                    List entities = entity.f_19853_.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(radius), e -> e != entity);
                    LivingEntity target = null;
                    double closestDistance = Double.MAX_VALUE;
                    for (LivingEntity livingEntity : entities) {
                        double distance;
                        Vec3 toEntity = new Vec3(livingEntity.m_20185_() - entity.m_20185_(), livingEntity.m_20186_() - entity.m_20186_(), livingEntity.m_20189_() - entity.m_20189_());
                        double dotProduct = lookVector.m_82526_(toEntity = toEntity.m_82541_());
                        double angle = Math.toDegrees(Math.acos(dotProduct));
                        if (!(angle <= angleThreshold) || !((distance = entity.m_20280_((Entity)livingEntity)) < closestDistance)) continue;
                        closestDistance = distance;
                        target = livingEntity;
                    }
                    if (target == null) break;
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        if (player.m_150110_().f_35934_) {
                            return false;
                        }
                    }
                    if (heldTicks % 100 == 0 && heldTicks > 0) {
                        this.addMasteryPoint(instance, entity);
                    }
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12268_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.applyDrowsiness(instance, entity, target, heldTicks);
                    break;
                }
                case 2: {
                    level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (heldTicks % 10 == 0) {
                        TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:fallen_hypno"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
                    }
                    float radius2 = instance.isMastered(entity) ? 30.0f : 20.0f;
                    List list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_((double)radius2), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity));
                    if (list.isEmpty()) break;
                    if (heldTicks % 100 == 0 && heldTicks > 0) {
                        this.addMasteryPoint(instance, entity);
                    }
                    for (LivingEntity target1 : list) {
                        int duration;
                        if (target1 instanceof Player) {
                            Player player = (Player)target1;
                            if (player.m_150110_().f_35934_) continue;
                        }
                        int i = 0;
                        int originalDuration = instance.isMastered(entity) ? 500 : 300;
                        MobEffectInstance drowsiness = target1.m_21124_((MobEffect)MysticismMobEffects.FALLEN_DEPRIVE.get());
                        if (drowsiness != null && heldTicks > 0) {
                            duration = drowsiness.m_19557_() + 2;
                            i = (duration - originalDuration) / 70;
                        } else {
                            duration = originalDuration;
                        }
                        if (target1 instanceof CloneEntity) {
                            CloneEntity clone = (CloneEntity)target1;
                            LivingEntity owner = clone.m_21826_();
                            if (owner == null) continue;
                            SkillHelper.checkThenAddEffectSource((LivingEntity)owner, (Entity)entity, (MobEffect)((MobEffect)MysticismMobEffects.FALLEN_DEPRIVE.get()), (int)duration, (int)i, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                            continue;
                        }
                        SkillHelper.checkThenAddEffectSource((LivingEntity)target1, (Entity)entity, (MobEffect)((MobEffect)MysticismMobEffects.FALLEN_DEPRIVE.get()), (int)duration, (int)i, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                    }
                    break;
                }
                case 3: {
                    Player player;
                    boolean mastered = instance.isMastered(entity);
                    double radius1 = mastered ? 25.0 : 20.0;
                    List entities1 = entity.f_19853_.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(radius1), e -> e != entity);
                    LivingEntity target2 = null;
                    double closestDistance1 = Double.MAX_VALUE;
                    for (LivingEntity livingEntity : entities1) {
                        double distance = entity.m_20280_((Entity)livingEntity);
                        if (!(distance < closestDistance1)) continue;
                        closestDistance1 = distance;
                        target2 = livingEntity;
                    }
                    if (entity instanceof Player && (player = (Player)entity).m_6047_()) {
                        player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.belphegor.stored_magicule", (Object[])new Object[]{this.storedMagicule}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                    }
                    if (target2 == null || heldTicks % 10 != 0) break;
                    if (target2 instanceof Player) {
                        player = (Player)target2;
                        if (player.m_150110_().f_35934_) {
                            return false;
                        }
                    }
                    CompoundTag tag = instance.getOrCreateTag();
                    this.storedMagicule = tag.m_128459_("storedMagicule");
                    if (heldTicks <= 0 || !SkillHelper.drainMP((LivingEntity)target2, (LivingEntity)entity, (double)2000.0, (boolean)false)) break;
                    if (mastered) {
                        SkillHelper.drainMP((LivingEntity)target2, (LivingEntity)entity, (double)0.17, (boolean)true);
                    }
                    this.storedMagicule += 500.0;
                    if (mastered) {
                        TensuraEPCapability.getFrom((LivingEntity)target2).ifPresent(cap -> this.storedMagicule += cap.getEP() * 0.05);
                    }
                    tag.m_128347_("storedMagicule", this.storedMagicule);
                    double bonus = mastered ? target2.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()) * 0.01 : 0.0;
                    DamageSourceHelper.directSpiritualHurt((LivingEntity)target2, (Entity)entity, (float)(20.0f + (float)bonus));
                    level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12053_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (heldTicks % 200 == 0) {
                        this.addMasteryPoint(instance, entity);
                    }
                    if (!target2.m_6084_() || !(TensuraEPCapability.getSpiritualHealth((LivingEntity)target2) > 0.0) || !(TensuraEPCapability.getSpiritualHealth((LivingEntity)target2) < (double)(target2.m_21233_() / 2.0f)) || !CharmSkill.canMindControl((LivingEntity)target2, (Level)level)) break;
                    UUID uuid = entity.m_20148_();
                    LivingEntity finalTarget = target2;
                    TensuraEPCapability.getFrom((LivingEntity)target2).ifPresent(cap -> {
                        if (!Objects.equals(cap.getTemporaryOwner(), uuid)) {
                            cap.setTemporaryOwner(uuid);
                            if (entity instanceof Player) {
                                Player player = (Player)entity;
                                if (finalTarget instanceof TamableAnimal) {
                                    TamableAnimal animal = (TamableAnimal)finalTarget;
                                    animal.m_21828_(player);
                                } else if (finalTarget instanceof TensuraHorseEntity) {
                                    TensuraHorseEntity horse = (TensuraHorseEntity)finalTarget;
                                    horse.m_30637_(player);
                                }
                            }
                            TensuraEPCapability.sync((LivingEntity)finalTarget);
                            entity.m_21011_(InteractionHand.MAIN_HAND, true);
                            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)finalTarget, (ParticleOptions)ParticleTypes.f_123750_);
                            level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 0.5f, 1.0f);
                        }
                    });
                    break;
                }
                case 4: {
                    Player player;
                    if (entity instanceof Player && (player = (Player)entity).m_36341_()) {
                        return false;
                    }
                    entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.REST.get(), 5, 0, false, false, false));
                    if (heldTicks % 20 != 0) break;
                    entity.m_5634_(instance.isMastered(entity) ? 40.0f + entity.m_21233_() * 0.1f : 40.0f);
                    float healSHP = instance.isMastered(entity) ? 40.0f + (float)(entity.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()) * (double)0.1f) : 40.0f;
                    TensuraEPCapability.healSpiritualHealth((LivingEntity)entity, (double)healSHP);
                    if (!(entity instanceof Player)) break;
                    Player player2 = (Player)entity;
                    TensuraPlayerCapability.getFrom((Player)player2).ifPresent(cap -> {
                        double maxMP = player2.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                        if (cap.getMagicule() >= maxMP) {
                            double mana = SkillHelper.mpRegen((LivingEntity)player2, (double)maxMP, (double)5.0);
                            CompoundTag tag = instance.getOrCreateTag();
                            tag.m_128347_("storedMagicule", tag.m_128459_("storedMagicule") + mana);
                            instance.markDirty();
                        }
                    });
                }
            }
            return true;
        }
        return false;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        CompoundTag tag = instance.getOrCreateTag();
        switch (instance.getMode()) {
            case 4: {
                List list;
                Player player;
                if (entity instanceof Player && !(player = (Player)entity).m_36341_()) {
                    return;
                }
                this.storedMagicule = tag.m_128459_("storedMagicule");
                if (entity instanceof Player && (player = (Player)entity).m_6144_()) {
                    player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.belphegor.stored_magicule", (Object[])new Object[]{this.storedMagicule}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                }
                if ((list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(15.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && living.m_7307_((Entity)entity))).isEmpty()) {
                    return;
                }
                if (this.outOfStoredMP(entity, instance, 1000 * list.size())) {
                    return;
                }
                for (LivingEntity ally : list) {
                    ally.m_5634_(100.0f);
                    TensuraEPCapability.healSpiritualHealth((LivingEntity)ally, (double)20.0);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)ally, (ParticleOptions)ParticleTypes.f_123750_, (double)1.0);
                    if (!(ally instanceof Player)) continue;
                    Player player2 = (Player)ally;
                    TensuraPlayerCapability.getFrom((Player)player2).ifPresent(cap -> {
                        if (cap.getMagicule() != player2.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get())) {
                            double newMana = cap.getMagicule() + 2000.0;
                            cap.setMagicule(Math.min(newMana, player2.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get())));
                        }
                        if (cap.getAura() != player2.m_21133_((Attribute)TensuraAttributeRegistry.MAX_AURA.get())) {
                            double newAura = cap.getAura() + 2000.0;
                            cap.setAura(Math.min(newAura, player2.m_21133_((Attribute)TensuraAttributeRegistry.MAX_AURA.get())));
                        }
                    });
                    TensuraPlayerCapability.sync((Player)player2);
                }
                break;
            }
            case 5: {
                double radius = 10.0;
                this.storedMagicule = tag.m_128459_("storedMagicule");
                if (entity instanceof Player) {
                    Player player3 = (Player)entity;
                    this.storedMagicule = player3.m_7500_() ? 1.0E9 : tag.m_128459_("storedMagicule");
                }
                List entities = entity.f_19853_.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(radius), e -> e != entity);
                LivingEntity target = null;
                double closestDistance = Double.MAX_VALUE;
                for (LivingEntity livingEntity : entities) {
                    double distance = entity.m_20280_((Entity)livingEntity);
                    if (!(distance < closestDistance)) continue;
                    closestDistance = distance;
                    target = livingEntity;
                }
                if (!(entity instanceof Player)) break;
                Player player = (Player)entity;
                if (target == null) break;
                if (target instanceof Player) {
                    Player player1 = (Player)target;
                    if (player1.m_150110_().f_35934_) {
                        return;
                    }
                }
                int strength = 0;
                int duration = 0;
                duration = 60;
                strength = 5;
                if (this.storedMagicule > 50000.0 && !entity.m_6047_()) {
                    if (target instanceof CloneEntity) {
                        CloneEntity clone = (CloneEntity)target;
                        LivingEntity owner = clone.m_21826_();
                        if (owner != null) {
                            SkillHelper.checkThenAddEffectSource((LivingEntity)owner, (Entity)entity, (MobEffect)((MobEffect)MysticismMobEffects.FALLEN_DEPRIVE.get()), (int)duration, (int)strength, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                        }
                    } else {
                        SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)MysticismMobEffects.FALLEN_DEPRIVE.get()), (int)duration, (int)strength, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                    }
                    instance.setCoolDown(100);
                    this.storedMagicule -= 50000.0;
                } else if (this.storedMagicule > 25000.0 && entity.m_6047_()) {
                    SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.SLEEP_MODE.get()), (int)duration, (int)strength, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                    this.storedMagicule -= 25000.0;
                    instance.setCoolDown(30);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.belphegor.lack_of_stored_magicule").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                }
                tag.m_128347_("storedMagicule", this.storedMagicule);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11794_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 6: {
                boolean hasUltimateSkill;
                if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                    return;
                }
                LivingEntity target2 = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)8.0, (boolean)false);
                SkillStorage targetStorage = SkillAPI.getSkillsFrom((Entity)target2);
                if (target2 == null || targetStorage == null) break;
                if (target2 instanceof Player) {
                    Player player = (Player)target2;
                    if (player.m_150110_().f_35934_) {
                        return;
                    }
                }
                if (hasUltimateSkill = targetStorage.getLearnedSkills().stream().map(ManasSkillInstance::getSkill).filter(skill -> skill instanceof Skill).map(skill -> (Skill)skill).anyMatch(skill -> skill.getType() == Skill.SkillType.ULTIMATE)) {
                    DamageSourceHelper.directSpiritualHurt((LivingEntity)target2, (Entity)entity, (float)15000.0f, (float)0.0f);
                    if (target2 instanceof CloneEntity) {
                        CloneEntity clone = (CloneEntity)target2;
                        LivingEntity owner = clone.m_21826_();
                        if (owner != null) {
                            SkillHelper.checkThenAddEffectSource((LivingEntity)owner, (Entity)entity, (MobEffect)((MobEffect)MysticismMobEffects.FALLEN_DEPRIVE.get()), (int)300, (int)3, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                        }
                    } else {
                        SkillHelper.checkThenAddEffectSource((LivingEntity)target2, (Entity)entity, (MobEffect)((MobEffect)MysticismMobEffects.FALLEN_DEPRIVE.get()), (int)300, (int)3, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                    }
                    instance.setCoolDown(300);
                    level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target2, (ParticleOptions)ParticleTypes.f_123747_, (double)1.0);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target2, (ParticleOptions)ParticleTypes.f_123765_, (double)1.0);
                    break;
                }
                DamageSourceHelper.directSpiritualHurt((LivingEntity)target2, (Entity)entity, (float)Float.MAX_VALUE, (float)0.0f);
                if (target2 instanceof CloneEntity) {
                    CloneEntity clone = (CloneEntity)target2;
                    LivingEntity owner = clone.m_21826_();
                    if (owner != null) {
                        SkillHelper.checkThenAddEffectSource((LivingEntity)owner, (Entity)entity, (MobEffect)((MobEffect)MysticismMobEffects.FALLEN_DEPRIVE.get()), (int)300, (int)10, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                    }
                } else {
                    SkillHelper.checkThenAddEffectSource((LivingEntity)target2, (Entity)entity, (MobEffect)((MobEffect)MysticismMobEffects.FALLEN_DEPRIVE.get()), (int)300, (int)10, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                }
                instance.setCoolDown(300);
                level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target2, (ParticleOptions)ParticleTypes.f_123747_, (double)1.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target2, (ParticleOptions)ParticleTypes.f_123765_, (double)1.0);
            }
        }
    }

    private boolean outOfStoredMP(LivingEntity entity, ManasSkillInstance skillInstance, double cost) {
        CompoundTag tag = skillInstance.getOrCreateTag();
        double newStored = tag.m_128459_("storedMagicule") - cost;
        if (newStored >= 0.0) {
            tag.m_128347_("storedMagicule", newStored);
            skillInstance.markDirty();
            entity.f_19853_.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return false;
        }
        entity.f_19853_.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    private void applyDrowsiness(ManasSkillInstance instance, LivingEntity entity, LivingEntity target, int heldTicks) {
        int duration;
        int i = 0;
        int originalDuration = instance.isMastered(entity) ? 500 : 300;
        MobEffectInstance drowsiness = target.m_21124_((MobEffect)MysticismMobEffects.FALLEN_DEPRIVE.get());
        if (drowsiness != null && heldTicks > 0) {
            duration = drowsiness.m_19557_() + 2;
            i = (duration - originalDuration) / 70;
        } else {
            duration = originalDuration;
        }
        if (entity instanceof CloneEntity) {
            CloneEntity clone = (CloneEntity)entity;
            LivingEntity owner = clone.m_21826_();
            if (owner != null) {
                SkillHelper.checkThenAddEffectSource((LivingEntity)owner, (Entity)entity, (MobEffect)((MobEffect)MysticismMobEffects.FALLEN_DEPRIVE.get()), (int)duration, (int)i, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
            }
        } else {
            SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)MysticismMobEffects.FALLEN_DEPRIVE.get()), (int)duration, (int)i, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
        }
    }
}

