/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.handlers.InactionHandler;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import io.github.Memoires.trmysticism.registry.skill.UniqueSkills;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BushyastaSkill
extends Skill {
    protected static final UUID ACCELERATION = UUID.fromString("ee3e4b44-3cea-4c2a-b102-a9c94c613219");
    protected static final UUID STASIS_COAT = UUID.fromString("f47ac10b-58cc-4372-a567-0e02b2c3d479");
    protected static final UUID BARRIER_UUID = UUID.fromString("74e58db3-6fd7-4fac-9dfd-cb6fc94bcc22");
    protected static final String BARRIER_NAME = "Multilayer Barrier";

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/bushyasta.png");
    }

    public int getMaxMastery() {
        return 2000;
    }

    public BushyastaSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public double getObtainingEpCost() {
        return 500000.0;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.STAGNATOR.get(), (TensuraSkill)ExtraSkills.MULTILAYER_BARRIER.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, @NotNull LivingEntity entity, @NotNull UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.STAGNATOR.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public boolean canTick(@NotNull ManasSkillInstance instance, @NotNull LivingEntity entity) {
        return true;
    }

    public boolean canBeToggled(ManasSkillInstance instance, @NotNull LivingEntity living) {
        return instance.getMastery() >= 0;
    }

    public void onToggleOn(@NotNull ManasSkillInstance instance, @NotNull LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)true);
        instance.getOrCreateTag().m_128405_("TickCounter", 0);
        instance.markDirty();
    }

    public void onToggleOff(@NotNull ManasSkillInstance instance, @NotNull LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)false);
        this.removeBarrierPoints(entity, instance);
        instance.getOrCreateTag().m_128473_("TickCounter");
        instance.markDirty();
        instance.setCoolDown(5);
    }

    public void onTakenDamage(ManasSkillInstance instance, LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        if (instance.getMode() == 1 && this.hasInaction(entity)) {
            event.setCanceled(true);
        }
    }

    public void onProjectileHit(@NotNull ManasSkillInstance instance, @NotNull LivingEntity entity, @NotNull ProjectileImpactEvent event) {
        if (this.isInSlot(entity)) {
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
            event.setCanceled(true);
        }
    }

    public void onDamageEntity(ManasSkillInstance instance, @NotNull LivingEntity attacker, @NotNull LivingHurtEvent e) {
        DamageSource source;
        if (instance.isToggled() && (source = e.getSource()).m_7640_() == attacker) {
            float damage = 50.0f;
            e.setAmount(e.getAmount() + damage);
        }
    }

    private boolean activatedStasisCoat(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        return instance.isMastered(entity) && instance.isToggled() || tag.m_128471_("StasisCoatActivated");
    }

    public void onTouchEntity(@NotNull ManasSkillInstance instance, @NotNull LivingEntity entity, @NotNull LivingHurtEvent event) {
        CompoundTag tag = instance.getOrCreateTag();
        if (this.activatedStasisCoat(instance, entity) && !instance.onCoolDown()) {
            AttributeModifier stasisModifier;
            LivingEntity target = event.getEntity();
            AttributeInstance health = target.m_21051_(Attributes.f_22276_);
            AttributeInstance shp = target.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
            double amount = (double)event.getAmount() / 2.0;
            if (health != null) {
                stasisModifier = health.m_22111_(STASIS_COAT);
                if (stasisModifier != null) {
                    amount -= stasisModifier.m_22218_();
                }
                AttributeModifier attributemodifier = new AttributeModifier(STASIS_COAT, "Stasis Coat HP", amount * -1.0, AttributeModifier.Operation.ADDITION);
                health.m_22130_(attributemodifier);
                health.m_22125_(attributemodifier);
            }
            if (shp != null) {
                stasisModifier = shp.m_22111_(STASIS_COAT);
                if (stasisModifier != null) {
                    amount -= stasisModifier.m_22218_();
                }
                AttributeModifier attributeModifier = new AttributeModifier(STASIS_COAT, "Stasis Coat SHP", amount * -1.0, AttributeModifier.Operation.ADDITION);
                shp.m_22130_(attributeModifier);
                shp.m_22125_(attributeModifier);
            }
            this.addMasteryPoint(instance, entity);
            instance.setCoolDown(1);
            entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_12052_, SoundSource.AMBIENT, 1.0f, 1.0f);
            if (!instance.isMastered(entity) || !instance.isToggled()) {
                boolean activated = tag.m_128471_("StasisCoatActivated");
                tag.m_128379_("StasisCoatActivated", !activated);
            }
        }
    }

    public void onTick(@NotNull ManasSkillInstance instance, @NotNull LivingEntity entity) {
        CompoundTag tag;
        int tickCounter;
        this.roadToStagnation(instance, entity);
        if (SkillHelper.outOfMagicule((LivingEntity)entity, (double)this.magiculeCost(entity, instance)) && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.lack_magicule.toggled_off", (Object[])new Object[]{instance.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
        }
        if ((tickCounter = (tag = instance.getOrCreateTag()).m_128451_("TickCounter")) == 1) {
            this.incrementBarrierPoints(entity, instance);
            tag.m_128405_("TickCounter", 0);
        } else {
            tag.m_128405_("TickCounter", tickCounter + 1);
        }
        instance.markDirty();
    }

    private void roadToStagnation(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        boolean isMastered = instance.isMastered(entity);
        List closeEntities = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(10.0), target -> target != entity && target.m_6084_() && !SkillHelper.isSubordinate((LivingEntity)entity, (LivingEntity)target));
        List farEntities = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(20.0), target -> target != entity && target.m_6084_() && !SkillHelper.isSubordinate((LivingEntity)entity, (LivingEntity)target));
        this.applyStagnationEffects(closeEntities, isMastered, true);
        this.applyStagnationEffects(farEntities, isMastered, false);
    }

    private void applyStagnationEffects(List<LivingEntity> entities, boolean isMastered, boolean isCloseRange) {
        for (LivingEntity target : entities) {
            if (isMastered) {
                this.applyEffect(target, (MobEffect)TensuraMobEffects.PARALYSIS.get(), isCloseRange ? 3 : 1);
                continue;
            }
            this.applyEffect(target, MobEffects.f_19597_, isCloseRange ? 3 : 1);
        }
    }

    private void applyEffect(LivingEntity target, MobEffect effect, int amplifier) {
        int duration = 100;
        if (!target.m_21023_(effect) || Objects.requireNonNull(target.m_21124_(effect)).m_19557_() < duration / 2) {
            target.m_7292_(new MobEffectInstance(effect, duration, amplifier, false, false, true));
        }
    }

    private boolean hasInaction(LivingEntity entity) {
        return entity.m_21023_((MobEffect)MysticismMobEffects.INACTION.get());
    }

    public double magiculeCost(@NotNull LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1 -> 50000.0;
            case 2 -> 250000.0;
            case 3 -> 500000.0;
            case 4 -> 75000.0;
            default -> 500.0;
        };
    }

    public int modes() {
        return 4;
    }

    public int nextMode(@NotNull LivingEntity entity, @NotNull TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 4 : instance.getMode() - 1;
        }
        return instance.getMode() == 4 ? 1 : instance.getMode() + 1;
    }

    @NotNull
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.bushyasta.inaction");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.bushyasta.stagnate");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.bushyasta.stillness_of_ones_heart");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.bushyasta.stasis_coat");
            default -> Component.m_237119_();
        };
    }

    public boolean onHeld(ManasSkillInstance instance, @NotNull LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 1) {
            if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                return false;
            }
            entity.m_7292_(new MobEffectInstance((MobEffect)MysticismMobEffects.INACTION.get(), 5, 0, false, false, false));
            return true;
        }
        return false;
    }

    public void onRelease(ManasSkillInstance instance, @NotNull LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 1) {
            InactionHandler.giveFlight((Player)entity);
        }
    }

    public void onPressed(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        switch (instance.getMode()) {
            case 1: {
                InactionHandler.storeAndTakeFlight((Player)entity);
                break;
            }
            case 2: {
                this.stagnate(instance, entity);
                break;
            }
            case 3: {
                this.stillHeart(instance, entity);
                break;
            }
            case 4: {
                CompoundTag tag = instance.getOrCreateTag();
                if (entity.m_6144_()) {
                    LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)6.0, (boolean)false);
                    if (target == null || !target.m_6084_()) {
                        target = entity;
                    }
                    BushyastaSkill.removeStasisCoatedHP(target, instance);
                    break;
                }
                boolean activated = tag.m_128471_("StasisCoatActivated");
                tag.m_128379_("StasisCoatActivated", !activated);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), activated ? SoundEvents.f_11824_ : SoundEvents.f_11767_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public void applyStagnateEffect(LivingEntity entity, int duration) {
        MobEffectInstance effect = new MobEffectInstance((MobEffect)MysticismMobEffects.STAGNATE.get(), duration, 0, false, false);
        entity.m_7292_(effect);
    }

    private void stagnate(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        boolean isSneaking = entity.m_6144_();
        List list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(10.0), target -> target != entity && target.m_6084_() && !SkillHelper.isSubordinate((LivingEntity)entity, (LivingEntity)target));
        if (!list.isEmpty()) {
            this.addMasteryPoint(instance, entity);
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
            for (LivingEntity target2 : list) {
                if (isSneaking) {
                    if (!target2.m_21023_((MobEffect)MysticismMobEffects.STAGNATE.get())) continue;
                    target2.m_21195_((MobEffect)MysticismMobEffects.STAGNATE.get());
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target2, (ParticleOptions)ParticleTypes.f_175829_);
                    continue;
                }
                if (target2.m_21023_((MobEffect)MysticismMobEffects.STAGNATE.get())) continue;
                this.applyStagnateEffect(target2, 1200);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target2, (ParticleOptions)ParticleTypes.f_175821_);
            }
        }
    }

    private void stillHeart(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        List targets = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(25.0), target -> target != entity && target.m_6084_() && !SkillHelper.isSubordinate((LivingEntity)entity, (LivingEntity)target));
        if (!targets.isEmpty()) {
            this.addMasteryPoint(instance, entity);
            for (LivingEntity target2 : targets) {
                boolean isSpiritual = RaceHelper.isSpiritualLifeForm((LivingEntity)target2);
                AttributeInstance SHP = target2.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
                assert (SHP != null);
                double damage = SHP.m_22135_();
                boolean hasNull = SkillUtils.isSkillToggled((Entity)target2, (ManasSkill)((ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_NULLIFICATION.get()));
                if (isSpiritual && !instance.isMastered(entity)) continue;
                if (hasNull) {
                    DamageSourceHelper.directSpiritualHurt((LivingEntity)target2, (Entity)entity, (float)((float)damage), (float)0.9f);
                } else {
                    DamageSourceHelper.directSpiritualHurt((LivingEntity)target2, (Entity)entity, (float)((float)damage));
                }
                instance.setCoolDown(instance.isMastered(entity) ? 30 : 60);
            }
        }
    }

    public static void removeStasisCoatedHP(LivingEntity entity, @Nullable ManasSkillInstance instance) {
        AttributeInstance health = entity.m_21051_(Attributes.f_22276_);
        AttributeInstance shp = entity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
        if (health != null && health.m_22111_(STASIS_COAT) != null) {
            health.m_22127_(STASIS_COAT);
        }
        if (shp != null && shp.m_22111_(STASIS_COAT) != null) {
            shp.m_22127_(STASIS_COAT);
        }
        if (instance != null) {
            instance.setCoolDown(1);
        }
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123749_);
    }

    private void incrementBarrierPoints(LivingEntity entity, ManasSkillInstance instance) {
        AttributeInstance barrierAttribute = entity.m_21051_((Attribute)TensuraAttributeRegistry.BARRIER.get());
        if (barrierAttribute == null) {
            return;
        }
        double currentBarrier = 0.0;
        AttributeModifier currentModifier = barrierAttribute.m_22111_(BARRIER_UUID);
        if (currentModifier != null) {
            currentBarrier = currentModifier.m_22218_();
        }
        double newBarrier = currentBarrier + 1.0;
        if (currentModifier != null) {
            barrierAttribute.m_22120_(BARRIER_UUID);
        }
        barrierAttribute.m_22125_(new AttributeModifier(BARRIER_UUID, BARRIER_NAME, newBarrier, AttributeModifier.Operation.ADDITION));
        instance.markDirty();
    }

    private void removeBarrierPoints(LivingEntity entity, ManasSkillInstance instance) {
        AttributeInstance barrierAttribute = entity.m_21051_((Attribute)TensuraAttributeRegistry.BARRIER.get());
        if (barrierAttribute == null) {
            return;
        }
        AttributeModifier currentModifier = barrierAttribute.m_22111_(BARRIER_UUID);
        if (currentModifier != null) {
            barrierAttribute.m_22120_(BARRIER_UUID);
            instance.markDirty();
        }
    }
}

