/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.google.common.collect.ImmutableList;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import org.jetbrains.annotations.NotNull;

public class GalileoSkill
extends Skill {
    public static final ImmutableList<MobEffect> VISION;
    private static boolean dangerDetection;
    private static boolean treasureDetection;
    protected static final UUID ACCELERATION;
    protected static final UUID ACCELERATION2;
    protected static final UUID DIMENSIONAL;

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/galileo.png");
    }

    public GalileoSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.OBSERVER.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.OBSERVER.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return instance.getMastery() >= 0;
    }

    public double getObtainingEpCost() {
        return 200000.0;
    }

    public int modes() {
        return 4;
    }

    public int nextMode(@NotNull LivingEntity entity, @NotNull TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 4 : instance.getMode() - 1;
        }
        return instance.getMode() == 4 ? 1 : instance.getMode() + 1;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.galileo.multidimensional_barrier");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.galileo.eye_of_the_allfather");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.galileo.enhanced_danger_detection");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.galileo.enhanced_treasure_detection");
            default -> Component.m_237119_();
        };
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        if (instance.getMode() == 2) {
            return 50000.0;
        }
        return 0.0;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled();
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)true);
        if (instance.isMastered(entity)) {
            ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION2, (boolean)true);
        }
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        int level;
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)false);
        if (instance.isMastered(entity)) {
            ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION2, (boolean)false);
        }
        if (entity.m_21023_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get()) && (level = Objects.requireNonNull(entity.m_21124_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get())).m_19564_()) == 3) {
            entity.m_21195_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get());
        }
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        double dodgeChance;
        if (event.isCanceled()) {
            return;
        }
        if (!this.isInSlot(event.getEntity())) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.m_19378_() || damageSource.m_19387_()) {
            return;
        }
        Entity entity = damageSource.m_7640_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        double d = dodgeChance = instance.isMastered(entity2) ? 1.0 : 0.8;
        if (SkillUtils.canNegateDodge((LivingEntity)entity2, (DamageSource)damageSource)) {
            dodgeChance = 0.25;
        }
        if (entity2.m_217043_().m_188500_() >= dodgeChance) {
            return;
        }
        entity2.m_9236_().m_6263_(null, entity2.m_20185_(), entity2.m_20186_(), entity2.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
        event.setCanceled(true);
    }

    public void onProjectileHit(ManasSkillInstance instance, LivingEntity entity, ProjectileImpactEvent event) {
        if (!this.isInSlot(entity)) {
            return;
        }
        if (SkillUtils.isProjectileAlwaysHit((Projectile)event.getProjectile())) {
            return;
        }
        if (event.getProjectile() instanceof ThrowableProjectile || event.getProjectile() instanceof AbstractArrow) {
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
            event.setCanceled(true);
        }
    }

    public void onTakenDamage(ManasSkillInstance instance, LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        if (!GalileoSkill.hasFaultField(entity)) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (!(damageSource.m_19390_() || DamageSourceHelper.isSpiritual((DamageSource)damageSource) || DamageSourceHelper.isSpatialDamage((DamageSource)damageSource) || SkillUtils.haveSeveranceAttack((DamageSource)damageSource, (LivingEntity)entity))) {
            float damageCanceled = (int)event.getAmount();
            double lackedMagicule = SkillHelper.outOfMagiculeStillConsume((LivingEntity)entity, (double)(damageCanceled * 50.0f));
            if (lackedMagicule > 0.0) {
                damageCanceled = (float)((double)damageCanceled - lackedMagicule / 50.0);
                event.setAmount(event.getAmount() - damageCanceled);
            } else {
                event.setCanceled(true);
            }
        }
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getOrCreateTag().m_128471_("DangerDetection")) {
            entity.m_7292_(new MobEffectInstance((MobEffect)MysticismMobEffects.ENHANCED_DANGER_DETECTION.get(), 200, 0, false, false, false));
        }
        if (instance.getOrCreateTag().m_128471_("TreasureDetection")) {
            entity.m_7292_(new MobEffectInstance((MobEffect)MysticismMobEffects.TREASURE_DETECTION.get(), 200, 0, false, false, false));
        }
        entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get(), 200, 4, false, false, false));
    }

    @NotNull
    public List<MobEffect> getImmuneEffects(ManasSkillInstance instance, LivingEntity entity) {
        return !TensuraSkillCapability.isSkillInSlot((LivingEntity)entity, (ManasSkill)instance.getSkill()) ? new ArrayList() : VISION;
    }

    public void onBeingTargeted(ManasSkillInstance instance, LivingEntity target, LivingChangeTargetEvent event) {
        if (SkillUtils.noInteractiveMode((LivingEntity)target)) {
            return;
        }
        if (!instance.isToggled()) {
            return;
        }
        if (!(target instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)target;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        if (mob.m_5448_() == null || !target.m_7306_((Entity)mob.m_5448_())) {
            this.sendSound(player, (LivingEntity)mob);
        }
    }

    private void sendSound(ServerPlayer user, LivingEntity target) {
        Vec3 eyeVec = user.m_146892_();
        Vec3 soundPos = eyeVec.m_82549_(target.m_146892_().m_82546_(eyeVec).m_82541_().m_82490_(5.0));
        user.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(SoundEvents.f_11699_, SoundSource.HOSTILE, soundPos.m_7096_(), eyeVec.m_7098_(), soundPos.m_7094_(), 1.0f, 1.0f, user.m_217043_().m_188505_()));
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            return false;
        }
        if (heldTicks % 60 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        if (instance.getMode() == 2) {
            String currentEffect;
            CompoundTag tag = instance.getTag();
            String string = currentEffect = tag != null ? tag.m_128461_("effect") : "";
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.galileo.eye_of_the_allfather.current_effect", (Object[])new Object[]{currentEffect}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
            }
            if (!currentEffect.isEmpty() && heldTicks % 20 == 0) {
                MobEffectInstance effectInstance;
                int effectLevel = tag.m_128451_("effectLevel");
                if (heldTicks % 100 == 0) {
                    tag.m_128405_("effectLevel", ++effectLevel);
                }
                if ((effectInstance = this.getEffectInstance(currentEffect, effectLevel)) != null) {
                    LivingEntity target;
                    LivingEntity livingEntity = target = instance.isMastered(entity) ? (LivingEntity)SkillHelper.getTargetingEntity(LivingEntity.class, (LivingEntity)entity, (double)30.0, (double)0.0, (boolean)true) : (LivingEntity)SkillHelper.getTargetingEntity(LivingEntity.class, (LivingEntity)entity, (double)15.0, (double)0.0, (boolean)true);
                    if (target != null) {
                        String newTargetUUID;
                        for (ManasSkillInstance skillInstance : SkillAPI.getSkillsFrom((Entity)target).getLearnedSkills()) {
                            if (!skillInstance.getSkill().equals(ResistanceSkills.PARALYSIS_RESISTANCE.get()) && !skillInstance.getSkill().equals(ResistanceSkills.ABNORMAL_CONDITION_RESISTANCE.get()) && !skillInstance.getSkill().equals(ResistanceSkills.PARALYSIS_NULLIFICATION.get()) && !skillInstance.getSkill().equals(ResistanceSkills.ABNORMAL_CONDITION_NULLIFICATION.get()) || !skillInstance.isToggled()) continue;
                            skillInstance.setToggled(false);
                            skillInstance.onToggleOff(target);
                        }
                        String currentTargetUUID = tag.m_128461_("currentTarget");
                        if (!currentTargetUUID.equals(newTargetUUID = target.m_20148_().toString())) {
                            tag.m_128405_("effectLevel", 0);
                            tag.m_128359_("currentTarget", newTargetUUID);
                        }
                        target.m_7292_(effectInstance);
                    } else {
                        tag.m_128359_("currentTarget", "");
                    }
                }
            }
            return true;
        }
        return true;
    }

    public void onScroll(ManasSkillInstance instance, LivingEntity living, double delta) {
        if (instance.getMode() == 2) {
            CompoundTag tag = instance.getOrCreateTag();
            tag.m_128405_("effectLevel", 0);
            List<String> effects = Arrays.asList("Blindness", "Paralysis", "Petrification", "Burden", "Darkness");
            int currentIndex = tag.m_128451_("effectIndex");
            int newIndex = currentIndex + (int)delta;
            if (newIndex >= effects.size()) {
                newIndex = 0;
            } else if (newIndex < 0) {
                newIndex = effects.size() - 1;
            }
            if (currentIndex != newIndex) {
                tag.m_128405_("effectIndex", newIndex);
                tag.m_128359_("effect", effects.get(newIndex));
                instance.markDirty();
            }
        }
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 2) {
            CompoundTag tag = instance.getTag();
            tag.m_128405_("effectLevel", 0);
        }
    }

    private MobEffectInstance getEffectInstance(String effectName, int effectLevel) {
        return switch (effectName) {
            case "Blindness" -> new MobEffectInstance(MobEffects.f_19610_, 600, effectLevel, false, true, true);
            case "Paralysis" -> new MobEffectInstance((MobEffect)TensuraMobEffects.PARALYSIS.get(), 600, effectLevel + 2, false, true, true);
            case "Petrification" -> new MobEffectInstance((MobEffect)TensuraMobEffects.PETRIFICATION.get(), 600, effectLevel - 1, false, true, true);
            case "Burden" -> new MobEffectInstance((MobEffect)TensuraMobEffects.BURDEN.get(), 600, effectLevel - 1, false, true, true);
            case "Darkness" -> new MobEffectInstance(MobEffects.f_216964_, 600, effectLevel - 1, false, true, true);
            default -> null;
        };
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() == 1) {
            this.activateMultidimensionalBarrier(instance, entity);
        } else if (instance.getMode() == 3) {
            dangerDetection = !dangerDetection;
            instance.getOrCreateTag().m_128379_("DangerDetection", dangerDetection);
            if (!dangerDetection) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.galileo.enhanced_danger_detection.toggle", (Object[])new Object[]{"Off"}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                }
                entity.m_21195_((MobEffect)MysticismMobEffects.ENHANCED_DANGER_DETECTION.get());
            } else {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.galileo.enhanced_danger_detection.toggle", (Object[])new Object[]{"On"}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                }
                entity.m_7292_(new MobEffectInstance((MobEffect)MysticismMobEffects.ENHANCED_DANGER_DETECTION.get(), 200, 0, false, false, false));
            }
        } else if (instance.getMode() == 4) {
            treasureDetection = !treasureDetection;
            instance.getOrCreateTag().m_128379_("TreasureDetection", treasureDetection);
            if (!treasureDetection) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.galileo.enhanced_treasure_detection.toggle", (Object[])new Object[]{"Off"}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                }
                entity.m_21195_((MobEffect)MysticismMobEffects.TREASURE_DETECTION.get());
            } else {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.galileo.enhanced_treasure_detection.toggle", (Object[])new Object[]{"On"}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                }
                entity.m_7292_(new MobEffectInstance((MobEffect)MysticismMobEffects.TREASURE_DETECTION.get(), 200, 0, false, false, false));
            }
        }
    }

    public static boolean hasFaultField(LivingEntity entity) {
        AttributeInstance attributeInstance = entity.m_21051_((Attribute)TensuraAttributeRegistry.BARRIER.get());
        if (attributeInstance == null) {
            return false;
        }
        return attributeInstance.m_22111_(UUID.fromString("505423cb-f5a3-4283-ad6a-562553ee14a6")) != null;
    }

    private void activateMultidimensionalBarrier(ManasSkillInstance instance, LivingEntity entity) {
        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            AttributeInstance attributeInstance = Objects.requireNonNull(entity.m_21051_((Attribute)TensuraAttributeRegistry.BARRIER.get()));
            if (attributeInstance.m_22111_(DIMENSIONAL) != null) {
                attributeInstance.m_22127_(DIMENSIONAL);
                entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12347_, SoundSource.PLAYERS, 1.0f, 1.0f);
                instance.setCoolDown(10);
            } else {
                this.addMasteryPoint(instance, entity);
                double barrierPoints = instance.isMastered(entity) ? (double)entity.m_21223_() * 4.5 : (double)entity.m_21223_() * 3.0;
                attributeInstance.m_22125_(new AttributeModifier(DIMENSIONAL, "Multidimensional Barrier", barrierPoints, AttributeModifier.Operation.ADDITION));
                entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    static {
        ACCELERATION = UUID.fromString("9cc54e77-84f6-4323-8439-423a193cec1e");
        ACCELERATION2 = UUID.fromString("9cc54e73-84f6-4323-8439-423a193cec1e");
        DIMENSIONAL = UUID.fromString("505423cb-f5a3-4283-ad6a-562553ee14a6");
        VISION = ImmutableList.of((Object)MobEffects.f_19610_, (Object)MobEffects.f_19604_, (Object)MobEffects.f_216964_);
    }
}

