/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.beam.BeamProjectile;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.sound.TensuraSoundEvents;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import io.github.Memoires.trmysticism.api.IWeaponStorageUlt;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.entity.skill.GateEntity;
import io.github.Memoires.trmysticism.entity.skill.TerritoryEntity;
import io.github.Memoires.trmysticism.menu.container.WeaponStorageContainer;
import io.github.Memoires.trmysticism.registry.entity.MysticismEntityTypes;
import io.github.Memoires.trmysticism.registry.items.MysticismWeaponItems;
import io.github.Memoires.trmysticism.registry.skill.UniqueSkills;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GilgameshSkill
extends Skill
implements IWeaponStorageUlt {
    private static final Map<UUID, List<GateEntity>> GATE_MAP = new HashMap<UUID, List<GateEntity>>();

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.GATEKEEPER.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Player player;
        Skill previousSkill = (Skill)UniqueSkills.GATEKEEPER.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player && (player = (Player)entity).m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                int currentUltimates = cap.getCurrentUltimates();
                cap.setCurrentUltimates(currentUltimates + 1);
            });
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
            return;
        }
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return;
        }
        if (instance.getMastery() >= 0 && !instance.isTemporarySkill() && entity instanceof Player) {
            player = (Player)entity;
            if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                storage.forgetSkill((ManasSkill)previousSkill);
            }
            player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
        }
    }

    public GilgameshSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public int modes() {
        return 7;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.gatekeeper.enkidu");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.gatekeeper.kings_storehouse");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.gatekeeper.gate_of_babylon");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.gilgamesh.enuma_elish");
            case 5 -> Component.m_237115_((String)"trmysticism.skill.mode.gilgamesh.territory");
            case 6 -> Component.m_237115_((String)"trmysticism.skill.mode.gilgamesh.ea");
            case 7 -> Component.m_237115_((String)"trmysticism.skill.mode.gilgamesh.axe");
            default -> Component.m_237119_();
        };
    }

    public double getObtainingEpCost() {
        return 750000.0;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/gilgamesh.png");
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1 -> 50000.0;
            case 4 -> 100000.0;
            case 5 -> 1000000.0;
            case 6 -> 1000000.0;
            case 7 -> 1000000.0;
            default -> 0.0;
        };
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        return this.canTick(instance, entity);
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        int time = tag.m_128451_("activatedTimes");
        if (time % 6 == 0) {
            this.addMasteryPoint(instance, entity);
        }
        tag.m_128405_("activatedTimes", time + 1);
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 7 : instance.getMode() - 1;
        }
        return instance.getMode() == 7 ? 1 : instance.getMode() + 1;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() == 1) {
            LivingEntity target = (LivingEntity)SkillHelper.getTargetingEntity(LivingEntity.class, (LivingEntity)entity, (double)30.0, (double)0.2, (boolean)false, (boolean)true);
            if (!SkillHelper.outOfMagicule((LivingEntity)entity, (double)this.magiculeCost(entity, instance))) {
                if (target == null) {
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.not_targeted").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                    instance.setCoolDown(10);
                    return;
                }
                if (target.m_21023_((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get())) {
                    target.m_21195_((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get());
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123747_, (double)1.0);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123749_, (double)1.0);
                } else {
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        if (player.m_150110_().f_35934_) {
                            return;
                        }
                    }
                    if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                        return;
                    }
                    instance.addMasteryPoint(entity);
                    instance.setCoolDown(20);
                    int duration = this.isMastered(instance, entity) ? 9600 : 4800;
                    SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get()), (int)duration, (int)0, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                    DamageSourceHelper.markHurt((LivingEntity)target, (Entity)entity);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123747_, (double)1.0);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123813_, (double)1.0);
                    entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        } else if (instance.getMode() == 2) {
            this.openWeaponStorage(entity, instance);
        } else if (instance.getMode() == 3) {
            int mastery = instance.getMastery();
            int cooldown = mastery >= 1000 ? 3 : (mastery >= 500 ? 4 : 5);
            instance.setCoolDown(cooldown);
        } else if (instance.getMode() == 6) {
            if (SkillHelper.outOfMagicule((LivingEntity)entity, (double)this.magiculeCost(entity, instance))) {
                return;
            }
            if (!instance.getOrCreateTag().m_128471_("eaCreated")) {
                ItemStack mainHand = entity.m_21205_();
                ItemStack eaStack = new ItemStack((ItemLike)MysticismWeaponItems.EA.get());
                if (entity.m_21033_(EquipmentSlot.MAINHAND)) {
                    return;
                }
                entity.m_21008_(InteractionHand.MAIN_HAND, eaStack);
                instance.getOrCreateTag().m_128379_("eaCreated", true);
            } else if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.ea_already_created").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                instance.setCoolDown(instance.isMastered((LivingEntity)player) ? 15 : 30);
            }
        } else if (instance.getMode() == 7) {
            if (SkillHelper.outOfMagicule((LivingEntity)entity, (double)this.magiculeCost(entity, instance))) {
                return;
            }
            if (!instance.getOrCreateTag().m_128471_("axeCreated")) {
                ItemStack mainHand = entity.m_21205_();
                ItemStack eaStack = new ItemStack((ItemLike)MysticismWeaponItems.AXE.get());
                if (entity.m_21033_(EquipmentSlot.MAINHAND)) {
                    return;
                }
                entity.m_21008_(InteractionHand.MAIN_HAND, eaStack);
                instance.getOrCreateTag().m_128379_("axeCreated", true);
            } else if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.axe_already_created").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                instance.setCoolDown(instance.isMastered((LivingEntity)player) ? 15 : 30);
            }
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        int mastery;
        double cost;
        if (instance.getMode() == 3 && !SkillHelper.outOfMagicule((LivingEntity)entity, (double)(cost = (mastery = instance.getMastery()) >= 2000 ? 12500.0 : (mastery >= 1500 ? 1000.0 : (mastery >= 600 ? 7500.0 : (mastery >= 300 ? 5000.0 : 2500.0)))))) {
            boolean surround;
            if (heldTicks % 20 == 0) {
                Vec3 targetPos = this.getGateTarget(entity);
                boolean surround2 = entity.m_6144_();
                LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)30.0, (boolean)true, (boolean)true);
                this.spawnGates(entity, targetPos, surround2, instance, target);
            }
            Vec3 targetPos = (surround = entity.m_6144_()) ? this.getGateTarget(entity) : entity.m_146892_().m_82549_(entity.m_20154_().m_82490_(30.0));
            List<GateEntity> gates = GATE_MAP.get(entity.m_20148_());
            if (gates != null && !surround) {
                Iterator<GateEntity> iter = gates.iterator();
                while (iter.hasNext()) {
                    GateEntity gate = iter.next();
                    if (!gate.m_6084_()) {
                        iter.remove();
                        continue;
                    }
                    Vec3 toTarget = targetPos.m_82546_(gate.m_20182_()).m_82541_();
                    float yaw = (float)(Math.atan2(toTarget.f_82479_, toTarget.f_82481_) * 57.29577951308232);
                    float pitch = (float)(-Math.asin(toTarget.f_82480_) * 57.29577951308232);
                    gate.m_146922_(yaw);
                    gate.m_146926_(pitch);
                    gate.f_19859_ = yaw;
                    gate.f_19860_ = pitch;
                }
            }
        }
        if (instance.getMode() == 4 && entity instanceof Player) {
            Player player = (Player)entity;
            if (GilgameshSkill.isHoldingEa(player, (Item)MysticismWeaponItems.EA.get())) {
                if (heldTicks % 100 == 0 && heldTicks > 0) {
                    this.addMasteryPoint(instance, entity);
                }
                double cost2 = this.magiculeCost(entity, instance);
                this.spawnEnumaElish(player, instance, cost2);
                entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 0.8f, 0.5f);
            } else {
                player.m_5661_((Component)Component.m_237113_((String)"You are missing something.").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
        if (instance.getMode() == 5) {
            Level level = entity.m_9236_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (heldTicks < 100 && heldTicks % 20 == 0) {
                    level.m_5594_(null, entity.m_20183_(), (SoundEvent)TensuraSoundEvents.MC_WHISPER1.get(), SoundSource.PLAYERS, 0.4f, 1.5f + (float)heldTicks / 100.0f);
                }
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (heldTicks < 100) {
                        for (int i = 0; i < 5; ++i) {
                            double angle = Math.PI * 2 * (double)i / 5.0 + (double)heldTicks / 10.0;
                            double radius = 0.5 + (double)heldTicks / 100.0;
                            double offsetX = Math.cos(angle) * radius;
                            double offsetZ = Math.sin(angle) * radius;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.YELLOW_LIGHTNING_SPARK.get()), entity.m_20185_() + offsetX, entity.m_20186_() + 1.0, entity.m_20189_() + offsetZ, 1, 0.01, 0.01, 0.01, 0.001);
                        }
                    }
                }
                if (heldTicks == 100) {
                    BlockHitResult pos;
                    BlockPos blockPos;
                    if (SkillHelper.outOfMagicule((LivingEntity)entity, (double)this.magiculeCost(entity, instance))) {
                        return false;
                    }
                    if (instance.getOrCreateTag().m_128471_("territoryCreated")) {
                        player.m_5661_((Component)Component.m_237115_((String)"trmysticism.territory_already_created").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                        instance.setCoolDown(instance.isMastered((LivingEntity)player) ? 15 : 30);
                    }
                    if (level.m_8055_((blockPos = (pos = SkillHelper.getPlayerPOVHitResult((Level)level, (Entity)player, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)3.0)).m_82425_()).m_7495_()).m_60767_().m_76333_()) {
                        instance.addMasteryPoint(entity);
                        TerritoryEntity territory = new TerritoryEntity((EntityType<? extends TensuraTamableEntity>)((EntityType)MysticismEntityTypes.TERRITORY.get()), level);
                        territory.m_7678_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 1.0, (double)blockPos.m_123343_() + 0.5, entity.m_146908_(), 0.0f);
                        territory.m_21828_(player);
                        territory.m_6518_((ServerLevelAccessor)level, level.m_6436_(territory.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                        territory.m_21391_((Entity)entity, 0.0f, 0.0f);
                        level.m_7967_((Entity)territory);
                        instance.getOrCreateTag().m_128379_("territoryCreated", true);
                        level.m_5594_(null, blockPos, SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)territory, (ParticleOptions)ParticleTypes.f_123747_, (double)2.0);
                        instance.setCoolDown(instance.isMastered((LivingEntity)player) ? 15 : 30);
                    }
                }
            }
        }
        return true;
    }

    private Vec3 getGateTarget(LivingEntity entity) {
        int distance = 30;
        LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)distance, (boolean)false, (boolean)true);
        if (target != null) {
            return target.m_146892_();
        }
        BlockHitResult result = SkillHelper.getPlayerPOVHitResult((Level)entity.f_19853_, (Entity)entity, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)distance);
        return result.m_82450_().m_82520_(0.0, 0.5, 0.0);
    }

    private void spawnGates(LivingEntity entity, Vec3 center, boolean surround, ManasSkillInstance instance, @Nullable LivingEntity target) {
        Level level = entity.f_19853_;
        int count = GilgameshSkill.getCount(surround, instance);
        double radius = 3.0;
        Vec3 playerPos = entity.m_146892_().m_82492_(0.0, 0.5, 0.0);
        Vec3 lookDir = entity.m_20154_().m_82541_();
        Vec3 right = lookDir.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        Vec3 backward = lookDir.m_82490_(-1.0);
        Vec3 lineCenter = playerPos.m_82549_(backward.m_82490_(2.0));
        Vec3 rightOffset = right.m_82490_(3.0);
        Vec3 lineStart = lineCenter.m_82546_(rightOffset.m_82490_((double)(count - 1) / 2.0));
        instance.addMasteryPoint(entity);
        for (int i = 0; i < count; ++i) {
            float pitch;
            float yaw;
            Vec3 spawnPos;
            if (surround) {
                double angle = Math.PI * 2 * (double)i / (double)count;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                spawnPos = center.m_82520_(xOffset, 1.0, zOffset);
            } else {
                spawnPos = lineStart.m_82549_(rightOffset.m_82490_((double)i));
            }
            if (surround) {
                Vec3 toCenter = center.m_82546_(spawnPos).m_82541_();
                yaw = (float)(Mth.m_14136_((double)(-toCenter.f_82479_), (double)(-toCenter.f_82481_)) * 57.29577951308232);
                pitch = (float)(-Mth.m_14136_((double)toCenter.f_82480_, (double)1.0) * 57.29577951308232);
            } else {
                yaw = (float)(Mth.m_14136_((double)(-lookDir.f_82479_), (double)(-lookDir.f_82481_)) * 57.29577951308232);
                pitch = (float)(-Mth.m_14136_((double)lookDir.f_82480_, (double)1.0) * 57.29577951308232);
            }
            GateEntity gate = new GateEntity((EntityType<? extends Entity>)((EntityType)MysticismEntityTypes.GATE.get()), level);
            if (surround) {
                gate.setSurround(true);
                if (target != null) {
                    gate.setTarget(target);
                }
            }
            gate.setSkill(instance);
            gate.m_146884_(spawnPos);
            gate.m_146922_(yaw);
            gate.m_146926_(pitch);
            gate.f_19859_ = yaw;
            gate.f_19860_ = pitch;
            gate.setOwner(entity);
            gate.setSkillInstance(instance);
            level.m_7967_((Entity)gate);
            GATE_MAP.computeIfAbsent(entity.m_20148_(), k -> new ArrayList()).add(gate);
        }
    }

    private static int getCount(boolean surround, ManasSkillInstance instance) {
        int mastery = instance.getMastery();
        int count = mastery >= 2000 ? 10 : (mastery >= 1500 ? 9 : (mastery >= 1000 ? 8 : (mastery >= 750 ? 7 : (mastery >= 300 ? 6 : 5))));
        if (surround) {
            count += 2;
        }
        return count;
    }

    private void spawnEnumaElish(Player player, ManasSkillInstance instance, double cost) {
        BeamProjectile.spawnLastingBeam((EntityType)((EntityType)MysticismEntityTypes.ENUMA_ELISH.get()), (float)2000.0f, (float)2.5f, (LivingEntity)player, (ManasSkillInstance)instance, (double)cost, (double)cost, (int)0);
    }

    public static float getWeaponBaseDamage(List<ItemStack> weapons) {
        float totalDamage = 0.0f;
        for (ItemStack weapon : weapons) {
            Item item = weapon.m_41720_();
            if (item instanceof SwordItem) {
                SwordItem sword = (SwordItem)item;
                float damage = sword.m_43299_();
                totalDamage += damage;
                continue;
            }
            Item damage = weapon.m_41720_();
            if (!(damage instanceof TieredItem)) continue;
            TieredItem tiered = (TieredItem)damage;
            float damage2 = tiered.m_43314_().m_6631_();
            totalDamage += damage2;
        }
        float divisor = Math.max((float)weapons.size() / 5.0f, 1.5f);
        float finalDamage = totalDamage / divisor;
        return finalDamage;
    }

    @Override
    @NotNull
    public WeaponStorageContainer getWeaponStorage(ManasSkillInstance instance, LivingEntity entity) {
        int size = 20;
        WeaponStorageContainer container = new WeaponStorageContainer(size, 5);
        container.m_7797_(instance.getOrCreateTag().m_128437_("SpatialStorage", 10));
        return container;
    }

    public static boolean isHoldingEa(Player player, Item itemA) {
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        return mainHand.m_41720_() == itemA || offHand.m_41720_() == itemA;
    }
}

