/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.ability.skill.unique.ReaperSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.human.CloneEntity;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.github.manasmods.tensura.world.TensuraGameRules;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;

public class HadesSkill
extends Skill {
    protected static final UUID ACCELERATION = UUID.fromString("69c29349-c142-43da-83b4-f7e488291304");
    public static final String RECON = "70f7adad-681e-4b6d-80d9-a29edaff18b1";
    public static final UUID REAPER = UUID.fromString("70f7adad-681e-4b6d-80d9-a29edaff18b1");

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/hades.png");
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled();
    }

    public double getObtainingEpCost() {
        return 600000.0;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.REAPER.get(), (TensuraSkill)CommonSkills.POISON.get(), (TensuraSkill)CommonSkills.CORROSION.get(), (TensuraSkill)CommonSkills.PARALYSIS.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.REAPER.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 4 : instance.getMode() - 1;
        }
        return instance.getMode() == 4 ? 1 : instance.getMode() + 1;
    }

    public int getMaxMastery() {
        return 2000;
    }

    public HadesSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    private boolean dodgeChance(ManasSkillInstance instance, LivingEntity entity) {
        float chance = entity.m_217043_().m_188501_();
        if (instance.isMastered(entity)) {
            return (double)chance < 1.0;
        }
        return (double)chance < 0.75;
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        LivingEntity entity;
        DamageSource damageSource;
        if (!(event.isCanceled() || !instance.getOrCreateTag().m_128471_("ReconMode") || (damageSource = event.getSource()).m_19378_() || damageSource.m_7640_() == null || damageSource.m_7640_() != damageSource.m_7639_() || damageSource.m_19387_() || this.dodgeChance(instance, entity = event.getEntity()))) {
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
            event.setCanceled(true);
            if (SkillUtils.canNegateDodge((LivingEntity)entity, (DamageSource)damageSource)) {
                event.setCanceled(false);
            }
        }
    }

    public void onProjectileHit(ManasSkillInstance instance, LivingEntity entity, ProjectileImpactEvent event) {
        if (instance.getOrCreateTag().m_128471_("ReconMode") && !SkillUtils.isProjectileAlwaysHit((Projectile)event.getProjectile()) && !this.dodgeChance(instance, entity)) {
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
            event.setCanceled(true);
        }
    }

    public int modes() {
        return 4;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.hades.recon_mode");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.hades.attack_mode");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.hades.infinite_eater");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.hades.fear_of_insanity");
            default -> Component.m_237119_();
        };
    }

    public void onTouchEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        CompoundTag tag;
        int time;
        if (!this.isInSlot(attacker) || e.getSource().m_7640_() != attacker || !DamageSourceHelper.isPhysicalAttack((DamageSource)e.getSource())) {
            return;
        }
        Level level = attacker.m_9236_();
        LivingEntity target = e.getEntity();
        int mastery = instance.getMastery();
        HadesSkill.toggleSpecificResistances(target);
        level.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12031_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Map effectsMap = target.m_21221_();
        if (mastery >= 0) {
            this.addEffect(target, effectsMap, (MobEffect)TensuraMobEffects.FATAL_POISON.get(), 200, 9);
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.POISON_BUBBLE.get()), target.m_20182_().f_82479_, target.m_20182_().f_82480_ + (double)target.m_20206_() / 2.0, target.m_20182_().f_82481_, 20, 0.08, 0.08, 0.08, 0.15);
        }
        if (mastery >= 334) {
            this.addEffect(target, effectsMap, (MobEffect)TensuraMobEffects.PARALYSIS.get(), 200, 5);
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.PARALYSING_BUBBLE.get()), target.m_20182_().f_82479_, target.m_20182_().f_82480_ + (double)target.m_20206_() / 2.0, target.m_20182_().f_82481_, 20, 0.08, 0.08, 0.08, 0.15);
        }
        if (mastery >= 667) {
            this.addEffect(target, effectsMap, (MobEffect)TensuraMobEffects.CORROSION.get(), 200, 7);
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.ACID_BUBBLE.get()), target.m_20182_().f_82479_, target.m_20182_().f_82480_ + (double)target.m_20206_() / 2.0, target.m_20182_().f_82481_, 20, 0.08, 0.08, 0.08, 0.15);
        }
        if (mastery >= 1000) {
            this.addEffect(target, effectsMap, (MobEffect)TensuraMobEffects.BURDEN.get(), 200, 4);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123806_, target.m_20182_().f_82479_, target.m_20182_().f_82480_ + (double)target.m_20206_() / 2.0, target.m_20182_().f_82481_, 20, 0.08, 0.08, 0.08, 0.15);
        }
        if (mastery >= 1500) {
            this.addEffect(target, effectsMap, (MobEffect)TensuraMobEffects.FRAGILITY.get(), 200, 4);
        }
        if (instance.isMastered(attacker)) {
            this.addEffect(target, effectsMap, (MobEffect)MysticismMobEffects.MARKED_FOR_DEATH.get(), 200, 0);
        }
        if ((time = (tag = instance.getOrCreateTag()).m_128451_("activatedTimes")) % 10 == 0) {
            this.addMasteryPoint(instance, attacker);
        }
        tag.m_128405_("activatedTimes", time + 1);
    }

    private static int toggleSpecificResistances(LivingEntity player) {
        int toggledCount = 0;
        for (ManasSkillInstance instance : SkillAPI.getSkillsFrom((Entity)player).getLearnedSkills()) {
            if (!instance.getSkill().equals(ResistanceSkills.CORROSION_RESISTANCE.get()) && !instance.getSkill().equals(ResistanceSkills.POISON_RESISTANCE.get()) && !instance.getSkill().equals(ResistanceSkills.PARALYSIS_RESISTANCE.get()) && !instance.getSkill().equals(ResistanceSkills.ABNORMAL_CONDITION_RESISTANCE.get()) && !instance.getSkill().equals(ResistanceSkills.CORROSION_NULLIFICATION.get()) && !instance.getSkill().equals(ResistanceSkills.POISON_NULLIFICATION.get()) && !instance.getSkill().equals(ResistanceSkills.PARALYSIS_NULLIFICATION.get()) && !instance.getSkill().equals(ResistanceSkills.ABNORMAL_CONDITION_NULLIFICATION.get()) || !instance.isToggled()) continue;
            instance.setToggled(false);
            instance.onToggleOff(player);
            ++toggledCount;
        }
        return toggledCount;
    }

    private void addEffect(LivingEntity target, Map<MobEffect, MobEffectInstance> activeEffects, MobEffect effect, int duration, int level) {
        MobEffectInstance instance = activeEffects.get(effect);
        MobEffectInstance newInstance = new MobEffectInstance(effect, duration, level);
        MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Added(target, instance, newInstance, (Entity)target));
        if (instance == null) {
            activeEffects.put(newInstance.m_19544_(), newInstance);
            newInstance.m_19544_().m_6385_(target, target.m_21204_(), newInstance.m_19564_());
            target.f_20948_ = true;
        } else if (instance.m_19558_(newInstance)) {
            effect.m_6386_(target, target.m_21204_(), instance.m_19564_());
            effect.m_6385_(target, target.m_21204_(), instance.m_19564_());
            target.f_20948_ = true;
        }
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)true);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)false);
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.isToggled()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get(), 200, 1, false, false, false));
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.HEAT_SENSE.get(), 200, 0, false, false, false));
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get(), 200, 0, false, false, false));
        }
    }

    private boolean cannotUseAttack(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getOrCreateTag().m_128471_("ReconMode")) {
            return true;
        }
        AttributeInstance recon = entity.m_21051_((Attribute)TensuraAttributeRegistry.SIZE.get());
        return recon != null && recon.m_22111_(REAPER) != null;
    }

    public void onDeath(ManasSkillInstance instance, LivingDeathEvent event) {
        if (!event.isCanceled()) {
            LivingEntity entity = event.getEntity();
            AttributeInstance recon = entity.m_21051_((Attribute)TensuraAttributeRegistry.SIZE.get());
            AttributeInstance aura = entity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_AURA.get());
            AttributeInstance magicule = entity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
            if (recon != null && recon.m_22111_(REAPER) != null) {
                recon.m_22127_(REAPER);
                if (aura != null) {
                    aura.m_22120_(REAPER);
                }
                if (magicule != null) {
                    magicule.m_22120_(REAPER);
                }
                this.updateCurrentEP(entity, 2.0f);
            }
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity living, int heldTicks) {
        if (instance.getMode() == 2) {
            int clones;
            if (this.cannotUseAttack(instance, living)) {
                return false;
            }
            CompoundTag tag = instance.getTag();
            int n = clones = tag != null ? tag.m_128451_("clones") : 10;
            if (living instanceof Player) {
                Player player = (Player)living;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.output_number", (Object[])new Object[]{clones}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
            }
            return true;
        }
        if (instance.getMode() == 4) {
            Level level = living.m_9236_();
            level.m_6263_((Player)null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (heldTicks % 10 == 0) {
                TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> living), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:fallen_hypno"), living.m_19879_(), 0.0, 1.0, 0.0, true));
            }
            float radius = instance.isMastered(living) ? 10.0f : 5.0f;
            List list = level.m_6443_(LivingEntity.class, living.m_20191_().m_82400_((double)radius), entity -> entity != living && entity.m_6084_() && !entity.m_7307_((Entity)living));
            if (!list.isEmpty()) {
                if (heldTicks % 100 == 0 && heldTicks > 0) {
                    this.addMasteryPoint(instance, living);
                }
                for (LivingEntity target : list) {
                    int duration;
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        if (player.m_150110_().f_35934_) continue;
                    }
                    MobEffectInstance fear = target.m_21124_((MobEffect)TensuraMobEffects.FEAR.get());
                    MobEffectInstance weakness = target.m_21124_(MobEffects.f_19613_);
                    MobEffectInstance insanity = target.m_21124_((MobEffect)TensuraMobEffects.INSANITY.get());
                    int n = duration = instance.isMastered(living) ? 400 : 200;
                    if (fear == null || weakness == null || insanity == null) {
                        target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.FEAR.get(), duration, 9, false, false));
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, duration, 4, false, false));
                        target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.INSANITY.get(), duration, 4, false, false));
                        continue;
                    }
                    int currentDuration = fear.m_19557_();
                    if (heldTicks % 20 != 0) continue;
                    target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.FEAR.get(), currentDuration + 20, 0, false, false));
                    target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.INSANITY.get(), currentDuration + 20, 0, false, false));
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, currentDuration + 20, 0, false, false));
                }
            }
            return true;
        }
        return false;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 2) {
            if (SkillUtils.isSkillToggled((Entity)entity, (ManasSkill)((ManasSkill)UniqueSkills.REAPER.get()))) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.mode.need_toggle_off", (Object[])new Object[]{((ReaperSkill)UniqueSkills.REAPER.get()).getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                }
                return;
            }
            if (instance.getOrCreateTag().m_128471_("ReconMode")) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.mode.need_toggle_off", (Object[])new Object[]{this.getModeName(1)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                }
            } else {
                Level level = entity.m_9236_();
                AttributeInstance recon = entity.m_21051_((Attribute)TensuraAttributeRegistry.SIZE.get());
                AttributeInstance aura = entity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_AURA.get());
                AttributeInstance magicule = entity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                if (recon != null && recon.m_22111_(REAPER) != null) {
                    recon.m_22127_(REAPER);
                    instance.setCoolDown(10);
                    if (aura != null) {
                        aura.m_22120_(REAPER);
                    }
                    if (magicule != null) {
                        magicule.m_22120_(REAPER);
                    }
                    this.updateCurrentEP(entity, 2.0f);
                    level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
                } else if (recon != null && this.isHeld(entity)) {
                    this.addMasteryPoint(instance, entity);
                    CompoundTag tag = instance.getTag();
                    if (tag == null || tag.m_128451_("clones") == 0) {
                        this.summonClones(entity, level, 10);
                    } else {
                        this.summonClones(entity, level, tag.m_128451_("clones"));
                    }
                    float size = 0.5f;
                    float sizeMultiplier = RaceHelper.getSizeMultiplier((LivingEntity)entity);
                    size = (float)(Math.max((double)(size * sizeMultiplier), (Double)TensuraConfig.INSTANCE.attributeConfig.minimumSize.get()) / (double)sizeMultiplier);
                    AttributeModifier reaper = new AttributeModifier(REAPER, "ReaperRecon", (double)(size - 1.0f), AttributeModifier.Operation.MULTIPLY_TOTAL);
                    recon.m_22125_(reaper);
                    if (aura != null) {
                        aura.m_22125_(reaper);
                    }
                    if (magicule != null) {
                        magicule.m_22125_(reaper);
                    }
                    this.updateCurrentEP(entity, 0.5f);
                }
            }
        }
    }

    public void onScroll(ManasSkillInstance instance, LivingEntity entity, double delta) {
        if (instance.getMode() == 2 && this.isHeld(entity)) {
            CompoundTag tag = instance.getOrCreateTag();
            int newScale = tag.m_128451_("clones") + (int)delta;
            if (newScale > 10) {
                newScale = 1;
            } else if (newScale < 1) {
                newScale = 10;
            }
            if (tag.m_128451_("clones") != newScale) {
                tag.m_128405_("clones", newScale);
                instance.markDirty();
            }
        }
    }

    private void summonClones(LivingEntity entity, Level level, int number) {
        level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123765_, (double)1.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123765_, (double)2.0);
        double EP = TensuraEPCapability.getEP((LivingEntity)entity) * 0.5 / (double)number;
        float size = switch (number) {
            case 1 -> 0.5f;
            case 2 -> 0.48f;
            case 3 -> 0.45f;
            case 4 -> 0.42f;
            case 5 -> 0.4f;
            case 6 -> 0.38f;
            case 7 -> 0.36f;
            case 8 -> 0.34f;
            case 9 -> 0.32f;
            default -> 0.3f;
        };
        float sizeMultiplier = RaceHelper.getSizeMultiplier((LivingEntity)entity);
        size = (float)(Math.max((double)(size * sizeMultiplier), (Double)TensuraConfig.INSTANCE.attributeConfig.minimumSize.get()) / (double)sizeMultiplier);
        EntityType type = entity.m_6144_() ? (EntityType)TensuraEntityTypes.CLONE_SLIM.get() : (EntityType)TensuraEntityTypes.CLONE_DEFAULT.get();
        for (int i = 0; i < number; ++i) {
            CloneEntity clone = new CloneEntity(type, level);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                clone.m_21828_(player);
            }
            clone.setSkill((ManasSkill)this);
            clone.copyStatsAndSkills(entity, true);
            clone.setHeight(clone.getHeight() * size);
            clone.setWidth(clone.getWidth() * size);
            TensuraEPCapability.setLivingEP((LivingEntity)clone, (double)Math.round(EP));
            clone.m_146884_(entity.m_20182_());
            level.m_7967_((Entity)clone);
        }
    }

    private void updateCurrentEP(LivingEntity entity, float multiplier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                cap.setMagicule(cap.getMagicule() * (double)multiplier);
                cap.setAura(cap.getAura() * (double)multiplier);
                TensuraPlayerCapability.sync((Player)player);
            });
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        switch (instance.getMode()) {
            case 1: {
                if (!SkillUtils.isSkillToggled((Entity)entity, (ManasSkill)((ManasSkill)UniqueSkills.REAPER.get()))) {
                    if (tag.m_128471_("ReconMode")) {
                        AttributeInstance recon = entity.m_21051_((Attribute)TensuraAttributeRegistry.SIZE.get());
                        if (recon != null && recon.m_22111_(REAPER) != null) {
                            AttributeInstance magicule;
                            recon.m_22127_(REAPER);
                            AttributeInstance aura = entity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_AURA.get());
                            if (aura != null) {
                                aura.m_22120_(REAPER);
                            }
                            if ((magicule = entity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get())) != null) {
                                magicule.m_22120_(REAPER);
                            }
                        }
                        entity.m_21195_((MobEffect)TensuraMobEffects.REAPER_RECON.get());
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123765_, (double)1.0);
                        tag.m_128379_("ReconMode", false);
                        break;
                    }
                    tag.m_128379_("ReconMode", true);
                    int level = instance.isMastered(entity) ? 2 : 1;
                    entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.REAPER_RECON.get(), 240, level, false, false, false));
                    break;
                }
                if (!(entity instanceof Player)) break;
                Player player = (Player)entity;
                String message = instance.getOrCreateTag().m_128471_("ReconMode") ? "tensura.skill.mode.need_toggle_off" : "tensura.ability.activation_failed";
                player.m_5661_((Component)Component.m_237110_((String)message, (Object[])new Object[]{this.getModeName(1)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                break;
            }
            case 3: {
                Level level = entity.m_9236_();
                if (this.cannotUseAttack(instance, entity)) {
                    if (!(entity instanceof Player)) break;
                    Player player = (Player)entity;
                    String message = instance.getOrCreateTag().m_128471_("ReconMode") ? "tensura.skill.mode.need_toggle_off" : "tensura.ability.activation_failed";
                    player.m_5661_((Component)Component.m_237110_((String)message, (Object[])new Object[]{this.getModeName(1)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                    break;
                }
                LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)6.0, (boolean)false);
                if (target != null && target.m_6084_()) {
                    double targetEP;
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        if (player.m_150110_().f_35934_) {
                            return;
                        }
                    }
                    if ((targetEP = TensuraEPCapability.getEP((LivingEntity)target)) > TensuraEPCapability.getEP((LivingEntity)entity)) {
                        if (!(entity instanceof Player)) break;
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.ep_not_meet").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                        break;
                    }
                    if (SkillHelper.outOfMagicule((LivingEntity)entity, (double)targetEP) || !target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.infiniteEater((Entity)entity), entity, instance), target.m_21233_() * 10.0f)) break;
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    this.addMasteryPoint(instance, entity);
                    instance.setCoolDown(instance.isMastered(entity) ? 5 : 10);
                    level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123765_, (double)1.0);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123808_, (double)2.0);
                    if (tag.m_128441_("eatenList")) {
                        eatenList = (CompoundTag)tag.m_128423_("eatenList");
                        if (eatenList == null) {
                            return;
                        }
                        String targetID = EntityType.m_20613_((EntityType)target.m_6095_()).toString();
                        if (eatenList.m_128441_(targetID)) {
                            return;
                        }
                        eatenList.m_128379_(targetID, true);
                        instance.markDirty();
                    } else {
                        eatenList = new CompoundTag();
                        eatenList.m_128379_(EntityType.m_20613_((EntityType)target.m_6095_()).toString(), true);
                        tag.m_128365_("eatenList", (Tag)eatenList);
                        instance.markDirty();
                    }
                    if (target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_EP_PLUNDER)) {
                        return;
                    }
                    double amountToMax = 0.5;
                    double EP = Math.min(SkillUtils.getEPGain((LivingEntity)target, (LivingEntity)entity), (Double)TensuraConfig.INSTANCE.skillsConfig.maximumEPSteal.get() / amountToMax);
                    if (target instanceof Player) {
                        Player playerTarget = (Player)target;
                        if (!TensuraGameRules.canEpSteal((Level)target.m_9236_())) break;
                        int minEP = TensuraGameRules.getMinEp((Level)target.m_9236_());
                        if (minEP > 0) {
                            EP -= (double)minEP;
                        }
                        if (EP <= 0.0) {
                            return;
                        }
                        SkillHelper.gainMaxMP((LivingEntity)entity, (double)(EP * amountToMax));
                        TensuraEPCapability.setSkippingEPDrop((LivingEntity)target, (boolean)true);
                        double finalEP = EP;
                        TensuraPlayerCapability.getFrom((Player)playerTarget).ifPresent(cap -> {
                            cap.setBaseMagicule(cap.getBaseMagicule() - finalEP / 2.0, (LivingEntity)playerTarget);
                            cap.setBaseAura(cap.getBaseAura() - finalEP / 2.0, (LivingEntity)playerTarget);
                        });
                        TensuraPlayerCapability.sync((Player)playerTarget);
                        break;
                    }
                    SkillHelper.gainMaxMP((LivingEntity)entity, (double)(EP * amountToMax));
                    SkillHelper.reduceEP((LivingEntity)target, (LivingEntity)entity, (double)1.0, (boolean)true, (boolean)true);
                    TensuraEPCapability.setSkippingEPDrop((LivingEntity)target, (boolean)true);
                    break;
                }
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.not_targeted").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
                level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
                instance.setCoolDown(instance.isMastered(entity) ? 5 : 10);
            }
        }
    }
}

