/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.magic.misc.FusionistLandmineEntity;
import com.github.manasmods.tensura.entity.magic.skill.FusionistProjectile;
import com.github.manasmods.tensura.event.SkillGriefEvent;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.world.TensuraGameRules;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.Event;

public class IgnisSkill
extends Skill {
    public IgnisSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/ignis.png");
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public int getMaxMastery() {
        return 2000;
    }

    public String modeLearningId(int mode) {
        return mode == 5 ? "BitesTheDust" : "None";
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getOrCreateTag().m_128471_("bombSet") || instance.getOrCreateTag().m_128471_("bombPrimed");
    }

    public double getObtainingEpCost() {
        return 750000.0;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.FUSIONIST.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.FUSIONIST.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public int modes() {
        return 5;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 5 : instance.getMode() - 1;
        }
        return instance.getMode() == 5 ? 1 : instance.getMode() + 1;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 4 -> 10000.0;
            default -> 30000.0;
        };
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.ignis.disassemble");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.ignis.stone");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.ignis.fuse");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.ignis.explosion_dash");
            case 5 -> Component.m_237115_((String)"trmysticism.skill.mode.ignis.bites_the_dust");
            default -> Component.m_237119_();
        };
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            Level level = entity.m_9236_();
            CompoundTag tag = instance.getOrCreateTag();
            switch (instance.getMode()) {
                case 1: {
                    BlockHitResult result;
                    BlockPos pos;
                    BlockState state;
                    if (entity.m_6144_()) {
                        BlockItem item;
                        ItemStack stack = entity.m_21205_();
                        if (stack.m_41619_()) {
                            if (entity instanceof Player) {
                                Player player = (Player)entity;
                                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.fusionist.matter_amount", (Object[])new Object[]{tag.m_128451_("matters")}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                            }
                            return;
                        }
                        Item itemStack = stack.m_41720_();
                        if (itemStack instanceof BlockItem && !(item = (BlockItem)itemStack).m_40614_().m_49966_().m_204336_(TensuraTags.Blocks.SKILL_UNBREAKABLE)) {
                            int stackSize = stack.m_41613_();
                            stack.m_41774_(stackSize);
                            entity.m_21011_(InteractionHand.MAIN_HAND, true);
                            tag.m_128405_("matters", tag.m_128451_("matters") + stackSize * 2);
                            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            instance.markDirty();
                            return;
                        }
                    }
                    if ((state = level.m_8055_(pos = (result = SkillHelper.getPlayerPOVHitResult((Level)level, (Entity)entity, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)5.0)).m_82425_())).m_60795_() || state.m_204336_(TensuraTags.Blocks.SKILL_UNBREAKABLE) || !TensuraGameRules.canSkillGrief((Level)level) || !state.canEntityDestroy((BlockGetter)level, pos, (Entity)entity)) {
                        return;
                    }
                    int blocksDisassembled = 0;
                    for (int dx = -1; dx <= 1; ++dx) {
                        for (int dy = -1; dy <= 1; ++dy) {
                            for (int dz = -1; dz <= 1; ++dz) {
                                SkillGriefEvent.Pre preGrief;
                                BlockPos targetPos = pos.m_7918_(dx, dy, dz);
                                BlockState targetState = level.m_8055_(targetPos);
                                if (targetState.m_60795_() || targetState.m_204336_(TensuraTags.Blocks.SKILL_UNBREAKABLE) || !targetState.canEntityDestroy((BlockGetter)level, targetPos, (Entity)entity) || MinecraftForge.EVENT_BUS.post((Event)(preGrief = new SkillGriefEvent.Pre((Entity)entity, instance, targetPos)))) continue;
                                level.m_46953_(targetPos, false, (Entity)entity);
                                ++blocksDisassembled;
                            }
                        }
                    }
                    if (blocksDisassembled > 0) {
                        tag.m_128405_("matters", tag.m_128451_("matters") + blocksDisassembled);
                    }
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    instance.markDirty();
                    MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post((Entity)entity, instance, pos));
                    break;
                }
                case 2: {
                    Player player;
                    if (tag.m_128451_("matters") < 3) {
                        Player player2;
                        if (entity instanceof Player && !(player2 = (Player)entity).m_7500_()) {
                            player2.m_5661_((Component)Component.m_237115_((String)"tensura.skill.fusionist.out_of_matter").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                        }
                        return;
                    }
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    FusionistProjectile sphere = new FusionistProjectile(level, entity);
                    sphere.setSpeed(3.0f);
                    sphere.setExplosionRadius(18.0f);
                    sphere.setMpCost(this.magiculeCost(entity, instance));
                    sphere.setSkill(instance);
                    sphere.setPosAndShoot(entity);
                    level.m_7967_((Entity)sphere);
                    if (entity instanceof Player && !(player = (Player)entity).m_7500_()) {
                        tag.m_128405_("matters", tag.m_128451_("matters") - 3);
                    }
                    this.addMasteryPoint(instance, entity);
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case 3: {
                    Player player;
                    AABB aabb;
                    List list;
                    if (tag.m_128441_("mineY") && !(list = level.m_6443_(FusionistLandmineEntity.class, aabb = new AABB(new BlockPos(tag.m_128459_("mineX"), tag.m_128459_("mineY"), tag.m_128459_("mineZ"))).m_82400_(0.5), entityData -> entityData.getOwner() == entity)).isEmpty()) {
                        for (FusionistLandmineEntity mine : list) {
                            double y = TensuraGameRules.canSkillGrief((Level)level) ? mine.m_20186_() : mine.m_20186_() + 1.0;
                            mine.trigger(mine.m_20185_(), y, mine.m_20189_());
                        }
                        tag.m_128473_("mineX");
                        tag.m_128473_("mineY");
                        tag.m_128473_("mineZ");
                        this.addMasteryPoint(instance, entity);
                        entity.m_21011_(InteractionHand.MAIN_HAND, true);
                        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11837_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        return;
                    }
                    if (!(tag.m_128451_("matters") >= 15 || entity instanceof Player && (player = (Player)entity).m_7500_())) {
                        if (entity instanceof Player) {
                            Player playerOutOfMatter = (Player)entity;
                            playerOutOfMatter.m_5661_((Component)Component.m_237115_((String)"tensura.skill.fusionist.out_of_matter").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                        }
                        return;
                    }
                    BlockHitResult result = SkillHelper.getPlayerPOVHitResult((Level)level, (Entity)entity, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)5.0);
                    BlockPos pos = result.m_82425_();
                    if (level.m_8055_(pos).m_60795_()) {
                        return;
                    }
                    FusionistLandmineEntity landmine = new FusionistLandmineEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, entity);
                    landmine.setRadius(120);
                    level.m_7967_((Entity)landmine);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    tag.m_128347_("mineX", landmine.m_20185_());
                    tag.m_128347_("mineY", landmine.m_20186_());
                    tag.m_128347_("mineZ", landmine.m_20189_());
                    if (entity instanceof Player && !(player = (Player)entity).m_7500_()) {
                        tag.m_128405_("matters", tag.m_128451_("matters") - 15);
                    }
                    instance.markDirty();
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11837_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case 5: {
                    LivingEntity target;
                    Player player;
                    int learnPoint = tag.m_128451_("BitesTheDust");
                    if (learnPoint < 100) {
                        tag.m_128405_("BitesTheDust", learnPoint + SkillUtils.getEarningLearnPoint((ManasSkillInstance)instance, (LivingEntity)entity, (boolean)true));
                        if (entity instanceof Player) {
                            Player player3 = (Player)entity;
                            if (tag.m_128451_("BitesTheDust") >= 100) {
                                player3.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(5)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                            } else {
                                SkillUtils.learningFailPenalty((LivingEntity)entity);
                                instance.setCoolDown(10);
                                player3.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(5)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                            }
                            player3.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                        instance.markDirty();
                        return;
                    }
                    if (!instance.isMastered(entity) ? tag.m_128451_("matters") < 2000 : tag.m_128451_("matters") < 1000 && (!(entity instanceof Player) || !(player = (Player)entity).m_7500_())) {
                        if (entity instanceof Player) {
                            Player playerOutOfMatter = (Player)entity;
                            playerOutOfMatter.m_5661_((Component)Component.m_237115_((String)"tensura.skill.fusionist.out_of_matter").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                        }
                        return;
                    }
                    tag.m_128405_("power", tag.m_128451_("matters"));
                    if (entity instanceof Player && !(player = (Player)entity).m_7500_()) {
                        tag.m_128405_("matters", 0);
                    }
                    if (entity.m_6144_()) {
                        if (tag.m_128471_("bombPrimed") || tag.m_128471_("bombSet")) {
                            if (entity instanceof Player) {
                                player = (Player)entity;
                                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.ignis.bites_the_dust.disarmed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                            }
                            tag.m_128473_("bombPrimed");
                            tag.m_128473_("bombPrimedTimer");
                            tag.m_128473_("bombSet");
                            tag.m_128473_("bombSetTimer");
                            tag.m_128473_("targetUUID");
                            return;
                        }
                        if (entity instanceof Player) {
                            player = (Player)entity;
                            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.ignis.bites_the_dust.no_bomb").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                        }
                    }
                    if (tag.m_128471_("bombPrimed")) {
                        target = this.findTargetByUUID(tag.m_128342_("targetUUID"), level);
                        if (target != null) {
                            Explosion.BlockInteraction interaction = TensuraGameRules.canSkillGrief((Level)level) ? Explosion.BlockInteraction.BREAK : Explosion.BlockInteraction.NONE;
                            SkillGriefEvent.Pre preGrief = new SkillGriefEvent.Pre((Entity)entity, instance, target.m_20183_());
                            if (!MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                                level.m_46511_((Entity)entity, target.m_20185_(), target.m_20186_(), target.m_20189_(), this.calculateExplosionPower(tag.m_128451_("power")), interaction);
                                MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post((Entity)entity, instance, target.m_20183_()));
                            }
                        }
                        tag.m_128379_("bombPrimed", false);
                        tag.m_128473_("bombPrimed");
                        tag.m_128473_("bombPrimedTimer");
                        tag.m_128473_("bombSet");
                        tag.m_128473_("bombSetTimer");
                        tag.m_128473_("targetUUID");
                        return;
                    }
                    target = (LivingEntity)SkillHelper.getTargetingEntity(LivingEntity.class, (LivingEntity)entity, (double)10.0, (double)0.0, (boolean)true);
                    if (target == null && !tag.m_128471_("bombPrimed")) {
                        if (entity instanceof Player) {
                            Player player4 = (Player)entity;
                            player4.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.ignis.bites_the_dust.no_target").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                        }
                        return;
                    }
                    if (entity instanceof Player) {
                        Player player5 = (Player)entity;
                        player5.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.ignis.bites_the_dust.bomb_set", (Object[])new Object[]{target.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                        player5.m_216990_(SoundEvents.f_11837_);
                    }
                    tag.m_128379_("bombSet", true);
                    tag.m_128405_("bombSetTimer", 1200);
                    tag.m_128362_("targetUUID", target.m_20148_());
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                }
            }
        }
    }

    public void onDeath(ManasSkillInstance instance, LivingDeathEvent event) {
        if ((instance.getOrCreateTag().m_128471_("bombSet") || instance.getOrCreateTag().m_128471_("bombPrimed")) && event.getEntity().m_21224_()) {
            instance.getOrCreateTag().m_128379_("bombPrimed", false);
            instance.getOrCreateTag().m_128379_("bombSet", false);
        }
    }

    public void onTick(ManasSkillInstance instance, LivingEntity living) {
        Player playerTarget;
        Player player;
        LivingEntity target;
        CompoundTag tag = instance.getOrCreateTag();
        Level level = living.m_9236_();
        if (tag.m_128471_("bombSet")) {
            int setTimer = tag.m_128451_("bombSetTimer");
            if (setTimer > 0) {
                tag.m_128405_("bombSetTimer", setTimer - 100);
                if (living instanceof Player) {
                    Player player2 = (Player)living;
                    player2.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.ignis.bites_the_dust.bomb_timer", (Object[])new Object[]{setTimer / 20}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                }
                if (setTimer == 300) {
                    target = this.findTargetByUUID(tag.m_128342_("targetUUID"), level);
                    if (target == null) {
                        tag.m_128379_("bombSet", false);
                        return;
                    }
                    level.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_11837_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (living instanceof Player) {
                        player = (Player)living;
                        player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.ignis.bites_the_dust.target_warned", (Object[])new Object[]{target.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                    }
                    if (target instanceof Player) {
                        playerTarget = (Player)target;
                        for (int i = 0; i < 3; ++i) {
                            level.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                        playerTarget.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.ignis.bites_the_dust.bomb_warning").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    } else if (target instanceof Mob) {
                        Mob mob = (Mob)target;
                        mob.m_6710_(living);
                    } else if (target.m_7307_((Entity)living) && !target.m_7306_((Entity)living)) {
                        SkillHelper.setAggressive((LivingEntity)target);
                    }
                }
            } else {
                target = this.findTargetByUUID(tag.m_128342_("targetUUID"), level);
                if (target == null) {
                    tag.m_128379_("bombSet", false);
                    return;
                }
                if (target instanceof Player) {
                    playerTarget = (Player)target;
                    playerTarget.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.ignis.bites_the_dust.bomb_primed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
                if (living instanceof Player) {
                    player = (Player)living;
                    player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.ignis.bites_the_dust.bomb_priming", (Object[])new Object[]{target.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
                tag.m_128379_("bombPrimed", true);
                tag.m_128379_("bombSet", false);
                tag.m_128405_("bombPrimedTimer", 2400);
                tag.m_128473_("bombSetTimer");
            }
        }
        if (tag.m_128471_("bombPrimed")) {
            int primedTimer = tag.m_128451_("bombPrimedTimer");
            if (primedTimer > 0) {
                tag.m_128405_("bombPrimedTimer", primedTimer - 100);
                target = this.findTargetByUUID(tag.m_128342_("targetUUID"), level);
                if (living instanceof Player) {
                    player = (Player)living;
                    player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.ignis.bites_the_dust.bomb_timer", (Object[])new Object[]{primedTimer / 20}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                }
                if (target instanceof Player) {
                    playerTarget = (Player)target;
                    playerTarget.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.ignis.bites_the_dust.bomb_timer", (Object[])new Object[]{primedTimer / 20}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                }
            } else {
                target = this.findTargetByUUID(tag.m_128342_("targetUUID"), level);
                if (living instanceof Player) {
                    player = (Player)living;
                    player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.ignis.bites_the_dust.bomb_timer", (Object[])new Object[]{tag.m_128451_("bombPrimedTimer") / 20}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                }
                if (target != null) {
                    Explosion.BlockInteraction interaction = TensuraGameRules.canSkillGrief((Level)level) ? Explosion.BlockInteraction.BREAK : Explosion.BlockInteraction.NONE;
                    SkillGriefEvent.Pre preGrief = new SkillGriefEvent.Pre((Entity)living, instance, target.m_20183_());
                    if (!MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                        level.m_46511_((Entity)living, target.m_20185_(), target.m_20186_(), target.m_20189_(), Math.min(this.calculateExplosionPower(tag.m_128451_("power")), 10.0f), interaction);
                        MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post((Entity)living, instance, target.m_20183_()));
                    }
                }
                tag.m_128379_("bombPrimed", false);
                tag.m_128473_("bombPrimed");
                tag.m_128473_("bombPrimedTimer");
                tag.m_128473_("bombSet");
                tag.m_128473_("bombSetTimer");
                tag.m_128473_("targetUUID");
            }
        }
    }

    private LivingEntity findTargetByUUID(UUID targetUUID, Level level) {
        Entity target = ((ServerLevel)level).m_8791_(targetUUID);
        return target instanceof LivingEntity ? (LivingEntity)target : null;
    }

    private float calculateExplosionPower(int power) {
        return (float)power / 10.0f;
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity living, int heldTicks) {
        if (instance.getMode() == 4) {
            int explosionScale;
            CompoundTag tag = instance.getTag();
            int n = explosionScale = tag != null ? tag.m_128451_("explosionScale") : 10;
            if (living instanceof Player) {
                Player player = (Player)living;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.output_number", (Object[])new Object[]{explosionScale}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
            }
            return true;
        }
        return false;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 4 && this.isHeld(entity)) {
            Player player;
            CompoundTag tag = instance.getOrCreateTag();
            int scale = tag.m_128451_("explosionScale");
            if (!(tag.m_128451_("matters") >= scale || entity instanceof Player && (player = (Player)entity).m_7500_())) {
                if (entity instanceof Player) {
                    Player playerOutOfMatter = (Player)entity;
                    playerOutOfMatter.m_5661_((Component)Component.m_237115_((String)"tensura.skill.fusionist.out_of_matter").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                }
                return;
            }
            if (entity instanceof Player && !(player = (Player)entity).m_7500_()) {
                tag.m_128405_("matters", tag.m_128451_("matters") - scale);
            }
            int push = scale * 3;
            if (entity.m_20202_() != null) {
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity.m_20202_(), (ParticleOptions)ParticleTypes.f_123812_, (double)0.5);
                entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                SkillHelper.riptidePushVehicle((Entity)entity.m_20202_(), (LivingEntity)entity, (float)push);
                entity.m_20202_().f_19864_ = true;
                entity.m_20202_().f_19812_ = true;
            } else {
                SkillHelper.riptidePush((LivingEntity)entity, (float)push);
                entity.f_19864_ = true;
                entity.f_19812_ = true;
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123812_, (double)1.0);
                entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (!instance.isMastered(entity)) {
                instance.setCoolDown(3);
            } else {
                instance.setCoolDown(1);
            }
        }
    }

    public void onScroll(ManasSkillInstance instance, LivingEntity living, double delta) {
        if (instance.getMode() == 4) {
            CompoundTag tag = instance.getOrCreateTag();
            int newScale = tag.m_128451_("explosionScale") + (int)delta;
            if (newScale > 10) {
                newScale = 1;
            } else if (newScale < 1) {
                newScale = 10;
            }
            if (tag.m_128451_("explosionScale") != newScale) {
                tag.m_128405_("explosionScale", newScale);
                instance.markDirty();
            }
        }
    }
}

