/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.HakiSkill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import com.google.common.collect.ImmutableList;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import io.github.Memoires.trmysticism.registry.skill.UniqueSkills;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class InvictusSkill
extends Skill {
    public static final ImmutableList<MobEffect> UNBREAKABLE_WILL = ImmutableList.of((Object)((MobEffect)TensuraMobEffects.INSANITY.get()), (Object)((MobEffect)TensuraMobEffects.MIND_CONTROL.get()), (Object)((MobEffect)TensuraMobEffects.FEAR.get()));

    public InvictusSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/invictus.png");
    }

    public int getMaxMastery() {
        return 2000;
    }

    public double getObtainingEpCost() {
        return 750000.0;
    }

    public int getMasteryOnEPAcquirement(@NotNull Player entity) {
        return 0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.VICTORIOUS_HARBINGER.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, @NotNull LivingEntity entity, @NotNull UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.VICTORIOUS_HARBINGER.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom(player).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!player.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public double magiculeCost(@NotNull LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1 -> 50000.0;
            case 2 -> 30000.0;
            case 3 -> 75000.0;
            case 4 -> 150000.0;
            case 5 -> 500000.0;
            default -> 0.0;
        };
    }

    public int modes() {
        return 5;
    }

    public int nextMode(@NotNull LivingEntity entity, @NotNull TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return switch (instance.getMode()) {
                case 1 -> this.isMastered((ManasSkillInstance)instance, entity) ? 5 : 4;
                case 2 -> 1;
                case 3 -> 2;
                case 4 -> 3;
                case 5 -> 4;
                default -> 0;
            };
        }
        return switch (instance.getMode()) {
            case 1 -> 2;
            case 2 -> 3;
            case 3 -> 4;
            case 4 -> this.isMastered((ManasSkillInstance)instance, entity) ? 5 : 1;
            default -> 1;
        };
    }

    @NotNull
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.invictus.kaisers_dominion");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.invictus.relentless_echo");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.invictus.invincible_victory");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.invictus.conquest");
            case 5 -> Component.m_237115_((String)"trmysticism.skill.mode.invictus.glorious_verdict");
            default -> Component.m_237119_();
        };
    }

    public double getAttributeModifierAmplifier(ManasSkillInstance instance, @NotNull LivingEntity entity, AttributeModifier modifier) {
        return modifier.m_22218_() * (instance.isMastered(entity) ? 0.9473684210526315 : 1.0);
    }

    public void addHeldAttributeModifiers(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        if (instance.getMode() == 1) {
            super.addHeldAttributeModifiers(instance, entity);
        }
    }

    public static void clearDeathTypes(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        if (tag.m_128441_("deaths")) {
            tag.m_128473_("deaths");
            instance.markDirty();
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 2.0f, 1.0f);
        }
    }

    private boolean checkDeathType(ManasSkillInstance instance, DamageSource source) {
        ListTag deaths;
        CompoundTag tag = instance.getOrCreateTag();
        if (tag.m_128441_("deaths") && (deaths = (ListTag)tag.m_128423_("deaths")) != null) {
            for (Tag value : deaths) {
                CompoundTag target;
                if (!(value instanceof CompoundTag) || !(target = (CompoundTag)value).m_128441_(source.m_19385_())) continue;
                return true;
            }
        }
        return false;
    }

    public void onDeath(@NotNull ManasSkillInstance instance, LivingDeathEvent event) {
        DamageSource source;
        CompoundTag tag = instance.getOrCreateTag();
        if (!event.isCanceled() && (source = event.getSource()) != DamageSource.f_19317_) {
            TensuraDamageSource damageSource;
            if (source instanceof TensuraDamageSource && (damageSource = (TensuraDamageSource)source).getIgnoreBarrier() >= 3.0f) {
                return;
            }
            LivingEntity entity = event.getEntity();
            if (!entity.m_6084_()) {
                if (source.m_7639_() != null) {
                    if (source.m_7639_() == entity) {
                        return;
                    }
                    if (source.m_7639_() == SkillHelper.getSubordinateOwner((LivingEntity)entity)) {
                        return;
                    }
                }
                if (!this.checkDeathType(instance, source)) {
                    this.addMasteryPoint(instance, entity);
                    entity.m_21153_(Math.max(entity.m_21223_(), entity.m_21233_()));
                    entity.f_19802_ = Math.max(80, entity.f_19802_);
                    Predicate<MobEffect> predicate = effect -> effect.m_19483_() == MobEffectCategory.HARMFUL;
                    SkillHelper.removePredicateEffect((LivingEntity)entity, predicate);
                    TensuraEffectsCapability.resetEverything((LivingEntity)entity, (boolean)false, (boolean)false);
                    TensuraEPCapability.getFrom((LivingEntity)entity).ifPresent(cap -> {
                        if (cap.getEP() <= 0.0) {
                            cap.setEP(entity, 100.0, false);
                        } else if (cap.getCurrentEP() <= 0.0) {
                            cap.setCurrentEP(entity, cap.getEP() * 0.5);
                        }
                        double SHP = entity.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
                        if (cap.getSpiritualHealth() < SHP * 0.5) {
                            cap.setSpiritualHealth(SHP * 0.5);
                        }
                    });
                    TensuraEPCapability.sync((LivingEntity)entity);
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                            float multiplier = instance.isMastered(entity) ? 0.75f : 0.5f;
                            cap.setMagicule(Math.max(cap.getMagicule(), player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get()) * (double)multiplier));
                            cap.setAura(Math.max(cap.getAura(), player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_AURA.get()) * (double)multiplier));
                            TensuraPlayerCapability.sync((Player)player);
                        });
                    }
                    this.addDeathType(instance, source);
                    event.setCanceled(true);
                    if (tag.m_128471_("DeathTimer")) {
                        return;
                    }
                    tag.m_128379_("DeathTimer", true);
                    tag.m_128405_("DeathTimerTicks", 0);
                    entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123767_, (double)1.0);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123767_, (double)2.0);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123747_, (double)1.0);
                }
            }
        }
    }

    private void addDeathType(ManasSkillInstance instance, DamageSource source) {
        CompoundTag tag = instance.getOrCreateTag();
        if (!tag.m_128441_("deaths")) {
            ListTag deaths = new ListTag();
            CompoundTag death = new CompoundTag();
            death.m_128379_(source.m_19385_(), true);
            deaths.add((Object)death);
            tag.m_128365_("deaths", (Tag)deaths);
        } else {
            ListTag deaths = (ListTag)tag.m_128423_("deaths");
            if (deaths == null) {
                return;
            }
            CompoundTag death = new CompoundTag();
            death.m_128379_(source.m_19385_(), true);
            deaths.add((Object)death);
            tag.m_128365_("deaths", (Tag)deaths);
        }
        instance.markDirty();
    }

    public void onDamageEntity(@NotNull ManasSkillInstance instance, @NotNull LivingEntity attacker, @NotNull LivingHurtEvent e) {
        if (!this.isInSlot(attacker)) {
            return;
        }
        LivingEntity target = e.getEntity();
        if (RaceHelper.isSpiritual((LivingEntity)target)) {
            float extraDamage = e.getAmount() * 0.3f;
            e.setAmount(e.getAmount() + extraDamage);
        }
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public boolean canTick(@NotNull ManasSkillInstance instance, @NotNull LivingEntity entity) {
        return instance.getOrCreateTag().m_128471_("DeathTimer");
    }

    public void onTick(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        int ticks = tag.m_128451_("DeathTimerTicks");
        tag.m_128405_("DeathTimerTicks", ++ticks);
        if (ticks >= 120) {
            InvictusSkill.clearDeathTypes(instance, entity);
            tag.m_128379_("DeathTimer", false);
            tag.m_128473_("DeathTimerTicks");
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.invictus.rebirth_ready").m_130940_(ChatFormatting.GREEN), false);
            }
        }
        instance.markDirty();
    }

    public boolean canBeToggled(ManasSkillInstance instance, @NotNull LivingEntity living) {
        return instance.getMastery() >= 0;
    }

    public void onToggleOn(@NotNull ManasSkillInstance instance, @NotNull LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)UUID.fromString("77f0dd81-8ebe-45e2-a237-5eb13a956b3a"), (boolean)true);
    }

    public boolean onHeld(@NotNull ManasSkillInstance instance, @NotNull LivingEntity entity, int heldTicks) {
        if (instance.getMode() != 1) {
            return false;
        }
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            return false;
        }
        if (heldTicks % 100 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        this.applyKaisersDominionEffects(instance, entity, heldTicks);
        return true;
    }

    public void onToggleOff(@NotNull ManasSkillInstance instance, @NotNull LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)UUID.fromString("77f0dd81-8ebe-45e2-a237-5eb13a956b3a"), (boolean)false);
    }

    public void onPressed(@NotNull ManasSkillInstance instance, @NotNull LivingEntity entity) {
        Level level = entity.m_9236_();
        switch (instance.getMode()) {
            case 1: {
                SkillHelper.removePredicateEffect((LivingEntity)entity, effect -> !effect.m_19486_() || effect.m_8093_());
                break;
            }
            case 2: {
                this.relentlessEcho(instance, entity);
                ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.SOUND_GIANT.get()), entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123747_, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123813_, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215769_, SoundSource.PLAYERS, 1.0f, 1.0f);
                instance.setCoolDown(instance.isMastered(entity) ? 45 : 60);
                break;
            }
            case 5: {
                double attackerEP;
                if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                    return;
                }
                LivingEntity target2 = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)20.0, (boolean)true, (boolean)true);
                if (target2 == null) {
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.not_targeted").m_130940_(ChatFormatting.GOLD), false);
                    }
                    return;
                }
                double targetEP = InvictusSkill.getEP(target2);
                double drainPercent = targetEP <= 0.25 * (attackerEP = TensuraPlayerCapability.getBaseEP((Player)((Player)entity))) ? 0.3 : 0.15;
                SkillHelper.reduceEP((LivingEntity)target2, (LivingEntity)entity, (double)drainPercent, (boolean)true);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12053_, SoundSource.PLAYERS, 1.0f, 1.0f);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target2, (ParticleOptions)((ParticleOptions)TensuraParticles.YELLOW_LIGHTNING_SPARK.get()));
                instance.setCoolDown(20);
                break;
            }
            case 3: {
                if (entity.m_21023_((MobEffect)MysticismMobEffects.INVINCIBLE_VICTORY.get())) {
                    return;
                }
                if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                    return;
                }
                entity.m_7292_(new MobEffectInstance((MobEffect)MysticismMobEffects.INVINCIBLE_VICTORY.get(), 600));
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12471_, SoundSource.PLAYERS, 1.0f, 0.0f);
                instance.setCoolDown(45);
                break;
            }
            case 4: {
                if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                    return;
                }
                Vec3 lookVec = entity.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_();
                Vec3 origin = entity.m_20182_();
                double radius = 5.0;
                double radiusSq = radius * radius;
                List targets = entity.f_19853_.m_6443_(LivingEntity.class, entity.m_20191_().m_82377_(radius + 1.0, 2.0, radius + 1.0), target -> {
                    if (!target.m_6084_() || target == entity || target.m_7307_((Entity)entity)) {
                        return false;
                    }
                    double yDiff = Math.abs(target.m_20186_() - entity.m_20186_());
                    if (yDiff > 1.5) {
                        return false;
                    }
                    Vec3 toTarget = target.m_20182_().m_82546_(origin).m_82542_(1.0, 0.0, 1.0);
                    if (toTarget.m_82556_() > radiusSq) {
                        return false;
                    }
                    double angle = Math.toDegrees(Math.atan2(toTarget.f_82481_, toTarget.f_82479_) - Math.atan2(lookVec.f_82481_, lookVec.f_82479_));
                    return (angle = (angle + 360.0) % 360.0) >= 270.0 || angle <= 90.0;
                });
                for (LivingEntity target3 : targets) {
                    float damage = (float)((double)(target3.m_21233_() / 2.0f) + entity.m_21133_(Attributes.f_22281_));
                    TensuraDamageSource damageSource = DamageSourceHelper.turnTensura((DamageSource)DamageSource.m_19370_((LivingEntity)entity)).setIgnoreResistance(2.0f).setSkill(instance).setMpCost(50000.0);
                    AttributeInstance attribute = target3.m_21051_((Attribute)TensuraAttributeRegistry.BARRIER.get());
                    if (attribute != null) {
                        attribute.m_22132_();
                    }
                    target3.m_6469_((DamageSource)damageSource, damage);
                }
                instance.setCoolDown(300);
                entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 0.75f);
                for (int i = -90; i <= 90; i += 10) {
                    double radians = Math.toRadians(i);
                    double offsetX = Math.cos(radians) * radius;
                    double offsetZ = Math.sin(radians) * radius;
                    double yaw = Math.atan2(lookVec.f_82481_, lookVec.f_82479_);
                    double rotatedX = offsetX * Math.cos(yaw) - offsetZ * Math.sin(yaw);
                    double rotatedZ = offsetX * Math.sin(yaw) + offsetZ * Math.cos(yaw);
                    Vec3 particlePos = origin.m_82520_(rotatedX, 1.0, rotatedZ);
                    TensuraParticleHelper.spawnServerParticles((Level)entity.f_19853_, (ParticleOptions)ParticleTypes.f_123766_, (double)particlePos.f_82479_, (double)particlePos.f_82480_, (double)particlePos.f_82481_, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
                }
                break;
            }
        }
    }

    private void kaisersDominionFear(@NotNull ManasSkillInstance instance, @NotNull LivingEntity entity, int heldTicks) {
        List enemy;
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (heldTicks % 2 == 0) {
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:demon_lord_haki"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
        }
        if (!(enemy = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(10.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity))).isEmpty()) {
            double scale = instance.getTag() == null ? 0.0 : instance.getTag().m_128459_("scale");
            double multiplier = scale == 0.0 ? 1.0 : Math.min(scale, 1.0);
            double ownerEP = TensuraEPCapability.getEP((LivingEntity)entity) * multiplier;
            for (LivingEntity target : enemy) {
                double targetEP;
                double difference;
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) continue;
                }
                if ((difference = ownerEP / (targetEP = TensuraEPCapability.getEP((LivingEntity)target))) <= 2.0) continue;
                int fearLevel = (int)(difference * 0.5 - 1.0);
                fearLevel = Math.min(fearLevel, (Integer)TensuraConfig.INSTANCE.mobEffectConfig.maxFear.get());
                SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.FEAR.get()), (int)200, (int)fearLevel);
                HakiSkill.hakiPush((LivingEntity)target, (LivingEntity)entity, (int)fearLevel);
            }
        }
    }

    private void kaisersDominionHeal(@NotNull LivingEntity entity) {
        List ally = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(10.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && living.m_7307_((Entity)entity));
        if (!ally.isEmpty()) {
            for (LivingEntity target : ally) {
                SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)MysticismMobEffects.KAISERS_DOMINION_HEAL.get()), (int)200, (int)0);
                SkillHelper.removePredicateEffect((LivingEntity)target, effect -> !effect.m_19486_() || effect.m_8093_());
            }
        }
    }

    private void relentlessEcho(@NotNull ManasSkillInstance instance, @NotNull LivingEntity entity) {
        int duration = instance.isMastered(entity) ? 30 : 15;
        int strength = 2;
        List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(instance.isMastered(entity) ? 20.0 : 10.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity));
        if (!list.isEmpty()) {
            for (LivingEntity target : list) {
                SkillHelper.addEffectWithSource((LivingEntity)target, (LivingEntity)entity, (MobEffect)MobEffects.f_19597_, (int)(duration * 20), (int)strength);
                SkillHelper.addEffectWithSource((LivingEntity)target, (LivingEntity)entity, (MobEffect)((MobEffect)TensuraMobEffects.FRAGILITY.get()), (int)(duration * 20), (int)strength);
                SkillHelper.addEffectWithSource((LivingEntity)target, (LivingEntity)entity, (MobEffect)MobEffects.f_19613_, (int)(duration * 20), (int)strength);
                SkillHelper.addEffectWithSource((LivingEntity)target, (LivingEntity)entity, (MobEffect)((MobEffect)TensuraMobEffects.BURDEN.get()), (int)(duration * 20), (int)strength);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)((ParticleOptions)TensuraParticles.BOG_BUBBLE.get()));
            }
        }
    }

    private void applyKaisersDominionEffects(@NotNull ManasSkillInstance instance, @NotNull LivingEntity entity, int heldTicks) {
        this.kaisersDominionFear(instance, entity, heldTicks);
        this.kaisersDominionHeal(entity);
    }

    public void onScroll(ManasSkillInstance instance, @NotNull LivingEntity entity, double delta) {
        if (instance.getMode() == 1) {
            HakiSkill.changeEPUsed((ManasSkillInstance)instance, (LivingEntity)entity, (double)delta);
        }
    }

    public void onRelease(ManasSkillInstance instance, @NotNull LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 1 && this.isHeld(entity)) {
            instance.setCoolDown(30);
        }
    }

    public static double getEP(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return TensuraPlayerCapability.getBaseEP((Player)player);
        }
        return TensuraEPCapability.getEP((LivingEntity)entity);
    }

    @NotNull
    public List<MobEffect> getImmuneEffects(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        return SkillUtils.hasSkill((Entity)entity, (ManasSkill)instance.getSkill()) ? new ArrayList() : UNBREAKABLE_WILL;
    }
}

