/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.menu.SkillCreatorMenu;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.network.NetworkHooks;

public class LuciferSkill
extends Skill {
    protected static final UUID ACCELERATION = UUID.fromString("46c9b896-1ab3-49bd-8d7c-34a9f3c96618");

    public LuciferSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public double getObtainingEpCost() {
        return 1000000.0;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.PRIDE.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.PRIDE.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public int getMaxMastery() {
        return 2000;
    }

    public int modes() {
        return 3;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.lucifer.akasha");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.great_sage.analytical_appraisal");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.lucifer.arroganz");
            default -> Component.m_237119_();
        };
    }

    protected boolean canActivateInRaceLimit(ManasSkillInstance instance) {
        return instance.getMode() == 2;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 3 : instance.getMode() - 1;
        }
        return instance.getMode() == 3 ? 1 : instance.getMode() + 1;
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        if (!event.isCanceled()) {
            ManasSkillInstance targetInstance;
            TensuraDamageSource source;
            DamageSource damageSource;
            LivingEntity entity = event.getEntity();
            if (!(instance.onCoolDown() || !this.isInSlot(entity) || (damageSource = event.getSource()).m_19378_() || damageSource.m_7639_() != null && damageSource.m_7639_().m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SKILL_PLUNDER) || !(damageSource instanceof TensuraDamageSource) || (double)(source = (TensuraDamageSource)damageSource).getIgnoreBarrier() >= 1.75 || (targetInstance = source.getSkill()) == null || targetInstance.isTemporarySkill() || targetInstance.getSkill() == this)) {
                Entity var8 = source.m_7639_();
                if (var8 instanceof Player) {
                    Player player = (Player)var8;
                    if (player.m_150110_().f_35934_) {
                        return;
                    }
                }
                ManasSkill skill = targetInstance.getSkill();
                int chance = this.copyChance(entity, instance, skill);
                if (entity.m_217043_().m_188503_(100) >= chance) {
                    if (!SkillUtils.hasSkill((Entity)entity, (ManasSkill)skill)) {
                        this.addMasteryPoint(instance, entity);
                    }
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237115_((String)"tensura.ability.activation_failed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                    }
                } else if (SkillUtils.learnSkill((LivingEntity)entity, (ManasSkill)skill, (int)instance.getRemoveTime())) {
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{targetInstance.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                        TensuraSkillCapability.getFrom((Player)player).ifPresent(cap -> {
                            Optional optional = SkillAPI.getSkillsFrom((Entity)player).getSkill(skill);
                            if (!optional.isEmpty()) {
                                if (cap.getSkillInSlot(0) == null) {
                                    cap.setInstanceInSlot((ManasSkillInstance)optional.get(), 0);
                                } else if (cap.getSkillInSlot(1) == null) {
                                    cap.setInstanceInSlot((ManasSkillInstance)optional.get(), 1);
                                } else if (cap.getSkillInSlot(2) == null) {
                                    cap.setInstanceInSlot((ManasSkillInstance)optional.get(), 2);
                                }
                                TensuraSkillCapability.sync((Player)player);
                            }
                        });
                    }
                    if (skill instanceof TensuraSkill) {
                        TensuraSkill tensuraSkill = (TensuraSkill)skill;
                        double mastery = tensuraSkill.getObtainingEpCost() / 10000.0;
                        this.addMasteryPoint(instance, entity, (int)(mastery + (double)SkillUtils.getBonusMasteryPoint((ManasSkillInstance)instance, (LivingEntity)entity, (int)((int)mastery))));
                        instance.setCoolDown(300);
                    } else {
                        this.addMasteryPoint(instance, entity);
                    }
                    entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215778_, SoundSource.PLAYERS, 2.0f, 1.0f);
                }
            }
        }
    }

    private int copyChance(LivingEntity owner, ManasSkillInstance pride, ManasSkill targetSkill) {
        if (this.cantCopy(targetSkill)) {
            return 0;
        }
        return 100;
    }

    private boolean cantCopy(ManasSkill manasSkill) {
        Skill skill;
        if (manasSkill instanceof SpiritualMagic) {
            return true;
        }
        if (manasSkill instanceof Skill && (skill = (Skill)manasSkill).getType().equals((Object)Skill.SkillType.ULTIMATE)) {
            boolean var10000 = true;
            return var10000;
        }
        boolean var10000 = false;
        return var10000;
    }

    public static boolean uniqueCheck(ManasSkill manasSkill) {
        if (manasSkill instanceof Skill) {
            Skill skill = (Skill)manasSkill;
            return skill.getType().equals((Object)Skill.SkillType.UNIQUE);
        }
        return false;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingHurtEvent e) {
        if (instance.isToggled()) {
            e.setAmount(e.getAmount() * 1.5f);
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            switch (instance.getMode()) {
                case 1: {
                    this.akasha(instance, entity);
                    break;
                }
                case 2: {
                    this.analyticalAppraisal(instance, entity);
                    break;
                }
                case 3: {
                    this.arroganz(instance, entity);
                }
            }
        }
    }

    public void analyticalAppraisal(ManasSkillInstance instance, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            TensuraSkillCapability.getFrom((Player)player).ifPresent(cap -> {
                if (player.m_6047_()) {
                    int level = cap.getAnalysisMode();
                    switch (level) {
                        case 1: {
                            cap.setAnalysisMode(2);
                            player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.analytical.analyzing_mode.block").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                            break;
                        }
                        case 2: {
                            cap.setAnalysisMode(0);
                            player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.analytical.analyzing_mode.both").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                            break;
                        }
                        default: {
                            cap.setAnalysisMode(1);
                            player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.analytical.analyzing_mode.entity").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                        }
                    }
                    player.m_6330_(SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TensuraSkillCapability.sync((Player)player);
                } else {
                    int level = 2;
                    if (cap.getAnalysisLevel() != level) {
                        cap.setAnalysisLevel(level);
                        cap.setAnalysisDistance(instance.isMastered(entity) ? 30 : 20);
                        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    } else {
                        cap.setAnalysisLevel(0);
                        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    TensuraSkillCapability.sync((Player)player);
                }
            });
        }
    }

    public void arroganz(ManasSkillInstance instance, LivingEntity entity) {
        block6: {
            List<ManasSkillInstance> collection;
            LivingEntity target;
            block7: {
                target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)10.0, (boolean)false);
                if (target == null || !target.m_6084_()) break block6;
                if (!(target instanceof Player)) break block7;
                Player player = (Player)target;
                if (player.m_150110_().f_35934_) break block6;
            }
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            ServerLevel level = (ServerLevel)entity.m_9236_();
            int chance = 100;
            boolean failed = true;
            if (entity.m_217043_().m_188503_(100) <= chance && !(collection = SkillAPI.getSkillsFrom((Entity)target).getLearnedSkills().stream().filter(skillInstance -> !this.cantCopy(skillInstance.getSkill())).toList()).isEmpty()) {
                int cooldown;
                this.addMasteryPoint(instance, entity);
                ManasSkillInstance chosenSkillInstance = collection.get(target.m_217043_().m_188503_(collection.size()));
                ManasSkill skill = chosenSkillInstance.getSkill();
                int n = cooldown = LuciferSkill.uniqueCheck(skill) ? 600 : 300;
                if (SkillUtils.learnSkill((LivingEntity)entity, (ManasSkill)skill, (int)instance.getRemoveTime())) {
                    instance.setCoolDown(cooldown);
                    failed = false;
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    }
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    public void akasha(ManasSkillInstance instance, LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            List<ResourceLocation> list = ((List)TensuraConfig.INSTANCE.skillsConfig.skillCreatorSkills.get()).stream().map(skill -> new ResourceLocation(skill.toString())).filter(location -> this.canCreateSkill((ResourceLocation)location, serverPlayer, instance)).toList();
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider(SkillCreatorMenu::new, (Component)Component.m_237119_()), buf -> buf.m_236828_((Collection)list, FriendlyByteBuf::m_130085_));
            serverPlayer.m_6330_(SoundEvents.f_11889_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private boolean canCreateSkill(ResourceLocation location, ServerPlayer serverPlayer, ManasSkillInstance instance) {
        ResourceLocation created;
        ManasSkill skill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(location);
        if (skill == null) {
            return false;
        }
        Optional optional = SkillAPI.getSkillsFrom((Entity)serverPlayer).getSkill(skill);
        if (instance.isMastered((LivingEntity)serverPlayer)) {
            return optional.map(ManasSkillInstance::isTemporarySkill).orElse(true);
        }
        CompoundTag tag = instance.getTag();
        if (tag != null && tag.m_128441_("created_skill") && (created = new ResourceLocation(tag.m_128461_("created_skill"))).equals((Object)location)) {
            return false;
        }
        return optional.isEmpty();
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        if (!UltimateUtils.insideConfig(instance.getSkillId())) {
            return false;
        }
        return instance.getMastery() >= 0;
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)true);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)false);
    }
}

