/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.DirewolfEntity;
import com.github.manasmods.tensura.entity.SissieEntity;
import com.github.manasmods.tensura.entity.multipart.EvilCentipedeBody;
import com.github.manasmods.tensura.entity.multipart.TempestSerpentBody;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraHorseEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.world.TensuraGameRules;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.entity.skill.LingeringSoulEntity;
import io.github.Memoires.trmysticism.handlers.MephistoHandler;
import io.github.Memoires.trmysticism.registry.dimensions.MysticismDimensions;
import io.github.Memoires.trmysticism.registry.skill.ExtraSkills;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.util.damage.MysticismDamageSources;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.jetbrains.annotations.Nullable;

public class MephistoSkill
extends Skill {
    protected static final UUID ACCELERATION = UUID.fromString("d9c8b7a3-47f0-4a27-95eb-6fbf62f638d7");

    @Nullable
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/mephisto.png");
    }

    public MephistoSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public int getMaxMastery() {
        return 2000;
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UltimateSkills.SEPHIROT.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity entity, LivingHurtEvent event) {
        if (event.getEntity().m_21224_() || event.getEntity().m_21223_() - event.getAmount() <= 0.0f) {
            if (event.getEntity() instanceof Player) {
                instance.decreaseCoolDown(600);
            } else {
                instance.decreaseCoolDown(30);
            }
        }
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled();
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)true);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)false);
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isMastered(entity) && instance.getMode() == 2 || instance.getMode() == 3 && entity.m_6144_() && instance.getOrCreateTag().m_128471_("InFantasyWorld") || instance.getMode() == 4 && entity.m_6144_();
    }

    public void onTick(ManasSkillInstance instance, LivingEntity living) {
        if (this.isInSlot(living) && living instanceof Player) {
            Player player = (Player)living;
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                long lastDamageTime;
                CompoundTag tag = player.getPersistentData();
                long currentTime = player.f_19853_.m_46467_();
                if (currentTime - (lastDamageTime = tag.m_128454_("NoDamageTimer")) >= 300L) {
                    double maxMP = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                    double currentMP = cap.getMagicule();
                    double mpGain = maxMP * 0.05;
                    cap.setMagicule(Math.min(currentMP + mpGain, maxMP));
                }
            });
            TensuraPlayerCapability.sync((Player)player);
        }
        if (instance.isToggled()) {
            living.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get(), 200, 1, false, false, false));
            living.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.HEAT_SENSE.get(), 200, 0, false, false, false));
            living.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get(), 200, 0, false, false, false));
        }
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
        }
        if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
            Player player;
            Skill lightAndHeat = (Skill)ExtraSkills.WATER_AND_THUNDER_DOMINATION.get();
            if (entity instanceof Player && !(player = (Player)entity).m_7500_()) {
                double cost = lightAndHeat.getObtainingEpCost() * (double)player.f_19853_.m_46469_().m_46215_(TensuraGameRules.MP_SKILL_COST) / 100.0;
                TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                    cap.setBaseMagicule(cap.getBaseMagicule() + cost, (LivingEntity)player, false);
                    TensuraPlayerCapability.sync((Player)player);
                });
            }
            if (SkillUtils.learnSkill((LivingEntity)entity, (ManasSkill)lightAndHeat) && entity instanceof Player) {
                player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{lightAndHeat.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            }
        }
        Skill previousSkill = (Skill)UltimateSkills.SEPHIROT.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public int modes() {
        return 4;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return switch (instance.getMode()) {
                case 1 -> {
                    if (instance.getOrCreateTag().m_128451_("DreamEnd") >= 100) {
                        yield 4;
                    }
                    yield 3;
                }
                case 2 -> 1;
                case 3 -> 2;
                case 4 -> 3;
                default -> 0;
            };
        }
        return switch (instance.getMode()) {
            case 1 -> 2;
            case 2 -> 3;
            case 3 -> {
                if (instance.getOrCreateTag().m_128451_("DreamEnd") >= 100) {
                    yield 4;
                }
                yield 1;
            }
            default -> 1;
        };
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.mephisto.checkpoint");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.mephisto.life_domination");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.mephisto.fantasy_world");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.mephisto.dream_end");
            default -> Component.m_237119_();
        };
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        DamageSource damageSource;
        LivingEntity entity;
        if (!this.isInSlot(event.getEntity())) {
            return;
        }
        if (!event.isCanceled() && this.isInSlot(entity = event.getEntity()) && !(damageSource = event.getSource()).m_19378_() && !(entity.m_217043_().m_188501_() > (instance.isMastered(entity) ? 0.7f : 0.4f))) {
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
            event.setCanceled(true);
            if (SkillUtils.canNegateDodge((LivingEntity)entity, (DamageSource)damageSource)) {
                event.setCanceled(false);
            }
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            switch (instance.getMode()) {
                case 1: {
                    this.dream(instance, entity);
                    instance.addMasteryPoint(entity);
                    break;
                }
                case 2: {
                    LingeringSoulEntity soul = (LingeringSoulEntity)SkillHelper.getTargetingEntity(LingeringSoulEntity.class, (LivingEntity)entity, (double)20.0, (double)0.0, (boolean)true);
                    if (soul == null || !soul.m_6084_() || !soul.hasOriginalMobData()) {
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.sephirot.life_domination.no_valid_soul").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                        }
                        return;
                    }
                    this.reviveSubordinate(instance, soul, (Player)entity);
                    instance.addMasteryPoint(entity);
                    break;
                }
                case 3: {
                    int learnPoint = tag.m_128451_("DreamEnd");
                    if (learnPoint < 100) {
                        tag.m_128405_("DreamEnd", learnPoint + SkillUtils.getEarningLearnPoint((ManasSkillInstance)instance, (LivingEntity)entity, (boolean)true));
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            if (tag.m_128451_("DreamEnd") >= 100) {
                                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(4)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                            } else {
                                SkillUtils.learningFailPenalty((LivingEntity)entity);
                                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(4)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                            }
                            player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                    }
                    if (entity.m_6144_() && instance.getOrCreateTag().m_128471_("InFantasyWorld")) {
                        this.handleExit((Player)entity, instance);
                    } else {
                        ResourceKey<Level> dimension = MysticismDimensions.FANTASY_WORLD;
                        ServerLevel serverLevel = Objects.requireNonNull(entity.m_20194_()).m_129880_(dimension);
                        assert (serverLevel != null);
                        MephistoHandler.loadFantasyWorldStructures(serverLevel);
                        this.enterFantasyWorld((Player)entity, instance);
                    }
                    instance.addMasteryPoint(entity);
                    break;
                }
                case 4: {
                    LivingEntity target = (LivingEntity)SkillHelper.getTargetingEntity(LivingEntity.class, (LivingEntity)entity, (double)5.0, (double)0.0, (boolean)true);
                    if (!(entity instanceof Player)) break;
                    Player player = (Player)entity;
                    UUID uuid = entity.m_20148_();
                    if (entity.m_6144_()) {
                        Level level = entity.m_9236_();
                        if (target == null || !target.getPersistentData().m_128441_("IsMarkedByMephisto")) break;
                        target.getPersistentData().m_128473_("IsMarkedByMephisto");
                        player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.mephisto.dream_end.removed_mark").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE)), false);
                        if (target instanceof Player) {
                            Player playerTarget = (Player)target;
                            playerTarget.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.mephisto.dream_end.mark_removed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE)), false);
                        }
                        TensuraEPCapability.getFrom((LivingEntity)target).ifPresent(cap -> {
                            boolean success = false;
                            if (Objects.equals(cap.getTemporaryOwner(), uuid)) {
                                cap.setTemporaryOwner((UUID)null);
                                target.m_21195_((MobEffect)TensuraMobEffects.MIND_CONTROL.get());
                                success = true;
                                UUID owner = cap.getPermanentOwner();
                                if (target instanceof TensuraTamableEntity) {
                                    TensuraTamableEntity tamable = (TensuraTamableEntity)target;
                                    tamable.resetOwner(owner);
                                } else if (target instanceof TensuraHorseEntity) {
                                    TensuraHorseEntity horse = (TensuraHorseEntity)target;
                                    horse.resetOwner(owner);
                                } else if (target instanceof TamableAnimal) {
                                    TamableAnimal animal = (TamableAnimal)target;
                                    animal.m_21816_(owner);
                                    if (owner == null) {
                                        animal.m_7105_(false);
                                    }
                                }
                            }
                            if (cap.isTargetNeutral(uuid)) {
                                cap.removeNeutralTarget(uuid);
                                success = true;
                            }
                            if (success) {
                                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                                TensuraEPCapability.sync((LivingEntity)target);
                                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123792_);
                                level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12052_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            }
                        });
                        return;
                    }
                    if (target == null) {
                        ServerLevel serverLevel = (ServerLevel)player.m_9236_();
                        MinecraftServer server = serverLevel.m_7654_();
                        int entityCount = 0;
                        block6: for (ServerLevel level : server.m_129785_()) {
                            for (Entity entityInWorld : level.m_8583_()) {
                                LivingEntity livingEntity;
                                CompoundTag entityData;
                                if (!(entityInWorld instanceof LivingEntity) || !(entityData = (livingEntity = (LivingEntity)entityInWorld).getPersistentData()).m_128441_("IsMarkedByMephisto")) continue;
                                double cost = 1000.0;
                                if (!SkillHelper.outOfMagicule((LivingEntity)player, (double)cost)) {
                                    DamageSource damageSource = MysticismDamageSources.dreamEater((Entity)entity);
                                    livingEntity.m_6469_((DamageSource)this.sourceWithMP(damageSource, entity, instance), Float.MAX_VALUE);
                                    ++entityCount;
                                    entityData.m_128473_("IsMarkedByMephisto");
                                    continue;
                                }
                                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.mephisto.dream_end.insufficient_magicule").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                                continue block6;
                            }
                        }
                        if (entityCount > 0) {
                            int additionalSeconds = entityCount * 60;
                            player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.mephisto.dream_end.all_marks_triggered", (Object[])new Object[]{entityCount}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_RED)), false);
                            instance.setCoolDown(60 + additionalSeconds);
                            break;
                        }
                        player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.mephisto.dream_end.no_marks_triggered").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                        break;
                    }
                    Level level = entity.m_9236_();
                    CompoundTag targetData = target.getPersistentData();
                    targetData.m_128379_("IsMarkedByMephisto", true);
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.mephisto.dream_end.added_mark").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE)), false);
                    if (target instanceof Player) {
                        Player playerTarget = (Player)target;
                        playerTarget.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.mephisto.dream_end.mark_added").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_RED)), false);
                        break;
                    }
                    TensuraEPCapability.getFrom((LivingEntity)target).ifPresent(cap -> {
                        boolean success = false;
                        if (Objects.equals(cap.getTemporaryOwner(), uuid)) {
                            cap.setTemporaryOwner((UUID)null);
                            target.m_21195_((MobEffect)TensuraMobEffects.MIND_CONTROL.get());
                            success = true;
                            UUID owner = cap.getPermanentOwner();
                            if (target instanceof TensuraTamableEntity) {
                                TensuraTamableEntity tamable = (TensuraTamableEntity)target;
                                tamable.resetOwner(owner);
                            } else if (target instanceof TensuraHorseEntity) {
                                TensuraHorseEntity horse = (TensuraHorseEntity)target;
                                horse.resetOwner(owner);
                            } else if (target instanceof TamableAnimal) {
                                TamableAnimal animal = (TamableAnimal)target;
                                animal.m_21816_(owner);
                                if (owner == null) {
                                    animal.m_7105_(false);
                                }
                            }
                        }
                        if (cap.isTargetNeutral(uuid)) {
                            cap.removeNeutralTarget(uuid);
                            success = true;
                        }
                        if (success) {
                            entity.m_21011_(InteractionHand.MAIN_HAND, true);
                            TensuraEPCapability.sync((LivingEntity)target);
                            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123792_);
                            level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12052_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                    });
                }
            }
        }
    }

    public String modeLearningId(int mode) {
        return mode == 4 ? "DreamEnd" : "None";
    }

    private void dream(ManasSkillInstance instance, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CompoundTag tag = instance.getOrCreateTag();
            if (tag.m_128471_("Dream")) {
                if (player.m_6144_()) {
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.dream.cancel").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE)), false);
                    tag.m_128379_("Dream", false);
                } else {
                    ArrayList<Object> stats = this.readStatsFromTag(tag);
                    this.restoreStats(player, stats);
                    BlockPos position = this.readLocationFromTag(tag);
                    ResourceKey<Level> dimension = this.readLevelFromTag(tag);
                    if (!player.f_19853_.m_46472_().equals(dimension)) {
                        ServerLevel targetLevel = player.m_20194_().m_129880_(dimension);
                        if (targetLevel != null && !dimension.equals(MysticismDimensions.FANTASY_WORLD)) {
                            if (entity.m_21023_((MobEffect)TensuraMobEffects.SPATIAL_BLOCKADE.get())) {
                                entity.m_21195_((MobEffect)TensuraMobEffects.SPATIAL_BLOCKADE.get());
                            }
                            SkillHelper.moveAcrossDimensionTo((Entity)entity, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), (float)1.0f, (float)1.0f, (ServerLevel)targetLevel);
                        } else {
                            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.mephisto.checkpoint_bad_dimension").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                        }
                    } else {
                        player.m_6021_((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_());
                    }
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.dream.restore").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE)), false);
                    instance.setCoolDown(300);
                    tag.m_128379_("Dream", false);
                }
            } else {
                ArrayList<Object> stats = this.createDream(instance, entity);
                this.writeStatsToTag(tag, stats, player);
                tag.m_128379_("Dream", true);
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.dream.create").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.LIGHT_PURPLE)), false);
            }
        }
    }

    public void onDeath(ManasSkillInstance instance, LivingDeathEvent event) {
        CompoundTag tag = instance.getOrCreateTag();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (SkillUtils.hasSkill((Entity)event.getSource().m_7639_(), (ManasSkill)((ManasSkill)UltimateSkills.SUSANOO.get()))) {
                return;
            }
            if (instance.getOrCreateTag().m_128471_("InFantasyWorld")) {
                player.m_5496_(SoundEvents.f_12513_, 2.0f, 1.0f);
                event.setCanceled(true);
                if (event.getEntity() instanceof Player) {
                    player.m_21153_(player.m_21233_());
                    TensuraEPCapability.setSpiritualHealth((LivingEntity)event.getEntity(), (double)TensuraEPCapability.getSpiritualHealth((LivingEntity)event.getEntity()));
                    event.getEntity().m_21219_();
                }
                return;
            }
            if (tag.m_128471_("Dream")) {
                event.setCanceled(true);
                event.getEntity().m_21219_();
                event.getEntity().f_19802_ = 60;
                ArrayList<Object> stats = this.readStatsFromTag(tag);
                this.restoreStats(player, stats);
                BlockPos position = this.readLocationFromTag(tag);
                ResourceKey<Level> dimension = this.readLevelFromTag(tag);
                if (!player.f_19853_.m_46472_().equals(dimension)) {
                    ServerLevel targetLevel = player.m_20194_().m_129880_(dimension);
                    if (targetLevel != null && !targetLevel.equals(MysticismDimensions.FANTASY_WORLD)) {
                        if (event.getEntity().m_21023_((MobEffect)TensuraMobEffects.SPATIAL_BLOCKADE.get())) {
                            event.getEntity().m_21195_((MobEffect)TensuraMobEffects.SPATIAL_BLOCKADE.get());
                        }
                        SkillHelper.moveAcrossDimensionTo((Entity)event.getEntity(), (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), (float)1.0f, (float)1.0f, (ServerLevel)targetLevel);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.mephisto.checkpoint_bad_dimension").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                } else {
                    player.m_6021_((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_());
                }
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.dream.death").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE)), false);
                instance.setCoolDown(600);
                tag.m_128379_("Dream", false);
            }
        }
    }

    private ArrayList<Object> createDream(ManasSkillInstance instance, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float currentHealth = player.m_21223_();
            double currentMP = TensuraPlayerCapability.getMagicule((Player)player);
            double currentAP = TensuraPlayerCapability.getAura((Player)player);
            double currentSHP = TensuraEPCapability.getSpiritualHealth((LivingEntity)player);
            ArrayList<Object> stats = new ArrayList<Object>();
            stats.add(Float.valueOf(currentHealth));
            stats.add(currentMP);
            stats.add(currentAP);
            stats.add(currentSHP);
            return stats;
        }
        return new ArrayList<Object>();
    }

    private void restoreStats(Player player, ArrayList<Object> stats) {
        if (stats.size() == 4) {
            float health = ((Float)stats.get(0)).floatValue();
            double mp = (Double)stats.get(1);
            double ap = (Double)stats.get(2);
            double shp = (Double)stats.get(3);
            player.m_21153_(health);
            TensuraPlayerCapability.setMagicule((Player)player, (double)mp);
            TensuraPlayerCapability.setAura((Player)player, (double)ap);
            TensuraEPCapability.setSpiritualHealth((LivingEntity)player, (double)shp);
        } else {
            System.out.println("Invalid stats list!");
        }
    }

    private void writeStatsToTag(CompoundTag tag, ArrayList<Object> stats, Player player) {
        tag.m_128350_("Health", ((Float)stats.get(0)).floatValue());
        tag.m_128347_("MP", ((Double)stats.get(1)).doubleValue());
        tag.m_128347_("AP", ((Double)stats.get(2)).doubleValue());
        tag.m_128347_("SHP", ((Double)stats.get(3)).doubleValue());
        tag.m_128347_("PosX", player.m_20185_());
        tag.m_128347_("PosY", player.m_20186_());
        tag.m_128347_("PosZ", player.m_20189_());
        tag.m_128359_("Level", player.f_19853_.m_46472_().m_135782_().toString());
    }

    private void writeLocationToTag(CompoundTag tag, Player player) {
        tag.m_128347_("PosX", player.m_20185_());
        tag.m_128347_("PosY", player.m_20186_());
        tag.m_128347_("PosZ", player.m_20189_());
        tag.m_128359_("Level", player.f_19853_.m_46472_().m_135782_().toString());
    }

    private ArrayList<Object> readStatsFromTag(CompoundTag tag) {
        ArrayList<Object> stats = new ArrayList<Object>();
        stats.add(Float.valueOf(tag.m_128457_("Health")));
        stats.add(tag.m_128459_("MP"));
        stats.add(tag.m_128459_("AP"));
        stats.add(tag.m_128459_("SHP"));
        return stats;
    }

    private BlockPos readLocationFromTag(CompoundTag tag) {
        double x = tag.m_128459_("PosX");
        double y = tag.m_128459_("PosY");
        double z = tag.m_128459_("PosZ");
        return new BlockPos(x, y, z);
    }

    private ResourceKey<Level> readLevelFromTag(CompoundTag tag) {
        String levelName = tag.m_128461_("Level");
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(levelName));
    }

    public void onSubordinateDeath(ManasSkillInstance instance, LivingEntity owner, LivingDeathEvent e) {
        if (!instance.isToggled()) {
            return;
        }
        LivingEntity originalEntity = e.getEntity();
        if (!(originalEntity instanceof Mob) || originalEntity.m_20270_((Entity)owner) > 30.0f || originalEntity.m_6095_().equals(TensuraEntityTypes.CLONE_DEFAULT) || originalEntity.m_6095_().equals(TensuraEntityTypes.CLONE_SLIM)) {
            return;
        }
        Level level = owner.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            try {
                LingeringSoulEntity soul = new LingeringSoulEntity(level, originalEntity.m_20183_());
                soul.setOriginalMobData(originalEntity);
                soul.m_20084_(UUID.randomUUID());
                if (!serverLevel.m_7967_((Entity)soul)) {
                    throw new RuntimeException("Failed to add LingeringSoulEntity to the server");
                }
                if (owner instanceof Player) {
                    Player player = (Player)owner;
                    player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.sephirot.life_domination.lingering_soul_spawned", (Object[])new Object[]{originalEntity.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE)), false);
                }
            }
            catch (Exception ex) {
                System.err.println("Error spawning LingeringSoulEntity: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    private void reviveSubordinate(ManasSkillInstance instance, LingeringSoulEntity soul, Player owner) {
        if (soul == null || !soul.m_6084_()) {
            return;
        }
        if (!soul.hasOriginalMobData()) {
            return;
        }
        Level level = soul.m_9236_();
        CompoundTag mobData = soul.getOriginalMobData();
        if (!mobData.m_128441_("id")) {
            owner.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.sephirot.life_domination.invalid_data").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            return;
        }
        LivingEntity dummyEntity = (LivingEntity)EntityType.m_20645_((CompoundTag)mobData, (Level)level, entity -> entity);
        if (dummyEntity == null) {
            return;
        }
        double magiculeCost = TensuraEPCapability.getEP((LivingEntity)dummyEntity);
        double currentMagicule = TensuraPlayerCapability.getMagicule((Player)owner);
        if (currentMagicule < magiculeCost) {
            owner.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.sephirot.life_domination.not_enough_magicule").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            return;
        }
        TensuraPlayerCapability.setMagicule((Player)owner, (double)(currentMagicule - magiculeCost));
        TensuraPlayerCapability.sync((Player)owner);
        LivingEntity revivedEntity = (LivingEntity)EntityType.m_20645_((CompoundTag)mobData, (Level)level, entity -> entity);
        if (revivedEntity != null) {
            if (revivedEntity.getPersistentData().m_128471_("is_display")) {
                owner.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.mephisto.life_domination.message.is_display").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                return;
            }
            CompoundTag tags = revivedEntity.getPersistentData();
            tags.m_128379_("NO_EP_PLUNDER", true);
            tags.m_128379_("NO_SKILL_PLUNDER", true);
            tags.m_128379_("no_loot", true);
            revivedEntity.m_21153_(revivedEntity.m_21233_() / 10.0f);
            revivedEntity.m_21219_();
            revivedEntity.f_19853_.m_6269_(null, (Entity)revivedEntity, SoundEvents.f_12513_, SoundSource.PLAYERS, 2.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)revivedEntity, (ParticleOptions)ParticleTypes.f_123767_, (double)2.0);
            revivedEntity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 1));
            revivedEntity.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 200, 3));
            this.clearInventory(revivedEntity);
            level.m_7967_((Entity)revivedEntity);
            if (!instance.isMastered((LivingEntity)owner)) {
                instance.setCoolDown(20);
            }
            if (!level.m_5776_()) {
                soul.m_146870_();
            }
            owner.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.sephirot.life_domination.subordinate_revived", (Object[])new Object[]{revivedEntity.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
        } else {
            System.out.println("Failed to revive entity from mobData: " + mobData);
        }
    }

    private void clearInventory(LivingEntity revivedEntity) {
        if (revivedEntity instanceof HumanoidNPCEntity) {
            HumanoidNPCEntity humanoidNPCEntity = (HumanoidNPCEntity)revivedEntity;
            humanoidNPCEntity.inventory.m_6211_();
        } else if (revivedEntity instanceof DirewolfEntity) {
            DirewolfEntity direwolf = (DirewolfEntity)revivedEntity;
            direwolf.inventory.m_6211_();
        } else if (revivedEntity instanceof SissieEntity) {
            SissieEntity sissie = (SissieEntity)revivedEntity;
            sissie.inventory.m_6211_();
        } else if (revivedEntity instanceof EvilCentipedeBody) {
            EvilCentipedeBody evilCentipede = (EvilCentipedeBody)revivedEntity;
            evilCentipede.inventory.m_6211_();
        } else if (revivedEntity instanceof TempestSerpentBody) {
            TempestSerpentBody tempestSerpent = (TempestSerpentBody)revivedEntity;
            tempestSerpent.inventory.m_6211_();
        } else if (revivedEntity instanceof SissieEntity) {
            SissieEntity sissie = (SissieEntity)revivedEntity;
            sissie.inventory.m_6211_();
        }
        revivedEntity.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_41852_, 100));
        revivedEntity.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.f_41852_, 100));
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            revivedEntity.m_8061_(slot, ItemStack.f_41583_);
        }
    }

    private void enterFantasyWorld(Player player, ManasSkillInstance instance) {
        ServerLevel currentLevel = (ServerLevel)player.m_9236_();
        ServerLevel fantasyWorld = currentLevel.m_7654_().m_129880_(MysticismDimensions.FANTASY_WORLD);
        if (fantasyWorld == null) {
            player.m_5661_((Component)Component.m_237115_((String)"error.dimension.not_found"), false);
            return;
        }
        this.writeLocationToTag(instance.getOrCreateTag(), player);
        CompoundTag originalPositions = new CompoundTag();
        List nearbyEntities = instance.isMastered((LivingEntity)player) ? currentLevel.m_6443_(Entity.class, player.m_20191_().m_82400_(20.0), e -> e instanceof LivingEntity) : currentLevel.m_6443_(Entity.class, player.m_20191_().m_82400_(10.0), e -> e instanceof LivingEntity);
        nearbyEntities.remove(player);
        for (Entity entity : nearbyEntities) {
            LivingEntity living;
            CompoundTag entityData = entity.getPersistentData();
            entityData.m_128379_("InsideFantasyWorld", true);
            entityData.m_128347_("x", entity.m_20185_());
            entityData.m_128347_("y", entity.m_20186_());
            entityData.m_128347_("z", entity.m_20189_());
            entityData.m_128359_("dimension", currentLevel.m_46472_().m_135782_().toString());
            originalPositions.m_128365_(entity.m_20148_().toString(), (Tag)entityData);
            if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_((MobEffect)TensuraMobEffects.SPATIAL_BLOCKADE.get())) {
                living.m_21195_((MobEffect)TensuraMobEffects.SPATIAL_BLOCKADE.get());
            }
            SkillHelper.moveAcrossDimensionTo((Entity)entity, (double)53.0, (double)-17.0, (double)25.0, (float)1.0f, (float)1.0f, (ServerLevel)fantasyWorld);
        }
        if (player.m_21023_((MobEffect)TensuraMobEffects.SPATIAL_BLOCKADE.get())) {
            player.m_21195_((MobEffect)TensuraMobEffects.SPATIAL_BLOCKADE.get());
        }
        SkillHelper.moveAcrossDimensionTo((Entity)player, (double)53.0, (double)-17.0, (double)25.0, (float)1.0f, (float)1.0f, (ServerLevel)fantasyWorld);
        instance.getOrCreateTag().m_128365_("OriginalPositions", (Tag)originalPositions);
        instance.getOrCreateTag().m_128379_("InFantasyWorld", true);
        if (!instance.isMastered((LivingEntity)player)) {
            instance.setCoolDown(1800);
        } else {
            instance.setCoolDown(900);
        }
    }

    private void handleExit(Player player, ManasSkillInstance instance) {
        ServerLevel currentLevel = (ServerLevel)player.m_9236_();
        if (!instance.getOrCreateTag().m_128471_("InFantasyWorld")) {
            return;
        }
        CompoundTag tag = instance.getOrCreateTag();
        BlockPos playerPosition = this.readLocationFromTag(tag);
        ResourceKey playerDimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tag.m_128461_("Level")));
        if (!player.f_19853_.m_46472_().equals((Object)playerDimension)) {
            ServerLevel targetLevel = player.m_20194_().m_129880_(playerDimension);
            if (targetLevel != null) {
                if (player.m_21023_((MobEffect)TensuraMobEffects.SPATIAL_BLOCKADE.get())) {
                    player.m_21195_((MobEffect)TensuraMobEffects.SPATIAL_BLOCKADE.get());
                }
                SkillHelper.moveAcrossDimensionTo((Entity)player, (double)playerPosition.m_123341_(), (double)playerPosition.m_123342_(), (double)playerPosition.m_123343_(), (float)1.0f, (float)1.0f, (ServerLevel)targetLevel);
            }
        } else {
            player.m_6021_((double)playerPosition.m_123341_(), (double)playerPosition.m_123342_(), (double)playerPosition.m_123343_());
        }
        CompoundTag positionsTag = tag.m_128469_("OriginalPositions");
        for (String entityKey : positionsTag.m_128431_()) {
            UUID entityUUID = UUID.fromString(entityKey);
            Entity entity = currentLevel.m_8791_(entityUUID);
            if (entity == null) continue;
            CompoundTag entityData = positionsTag.m_128469_(entityKey);
            BlockPos position = new BlockPos(entityData.m_128459_("x"), entityData.m_128459_("y"), entityData.m_128459_("z"));
            ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(entityData.m_128461_("dimension")));
            if (!entity.f_19853_.m_46472_().equals((Object)dimension)) {
                LivingEntity living;
                ServerLevel targetLevel = player.m_20194_().m_129880_(dimension);
                if (targetLevel == null) continue;
                if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_((MobEffect)TensuraMobEffects.SPATIAL_BLOCKADE.get())) {
                    living.m_21195_((MobEffect)TensuraMobEffects.SPATIAL_BLOCKADE.get());
                }
                SkillHelper.moveAcrossDimensionTo((Entity)entity, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), (float)1.0f, (float)1.0f, (ServerLevel)targetLevel);
                continue;
            }
            entity.m_6034_((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_());
        }
        tag.m_128473_("OriginalPositions");
        tag.m_128473_("InsideFantasyWorld");
        tag.m_128473_("PosX");
        tag.m_128473_("PosY");
        tag.m_128473_("PosZ");
        tag.m_128473_("Level");
        tag.m_128473_("InFantasyWorld");
        tag.m_128379_("InFantasyWorld", false);
    }
}

