/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.human.CloneEntity;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import io.github.Memoires.trmysticism.registry.skill.UniqueSkills;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.util.damage.MysticismDamageSources;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import org.jetbrains.annotations.Nullable;

public class PernidaSkill
extends Skill {
    public PernidaSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    @Nullable
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/pernida.png");
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.COMPULSOR.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public int modes() {
        return 4;
    }

    public double getObtainingEpCost() {
        return 300000.0;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.compulsor.organic_distortion");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.compulsor.anatomy_manipulation");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.pernida.adaptive_replication");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.compulsor.clone_removal");
            default -> Component.m_237119_();
        };
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 4 : instance.getMode() - 1;
        }
        return instance.getMode() == 4 ? 1 : instance.getMode() + 1;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getMastery() >= 0;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 100000.0;
    }

    public int getMaxMastery() {
        return 2000;
    }

    public void onDeath(ManasSkillInstance instance, LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (instance.getOrCreateTag().m_128451_("reconstructionCooldown") == 0) {
            event.setCanceled(true);
            event.getEntity().m_21153_(event.getEntity().m_21233_());
            instance.getOrCreateTag().m_128405_("reconstructionCooldown", 24);
        }
        if ((livingEntity = event.getEntity()) instanceof CloneEntity) {
            SkillStorage ownerStorage;
            Optional compulsorInstance;
            CloneEntity clone = (CloneEntity)livingEntity;
            LivingEntity owner = null;
            double minZ = clone.f_19853_.m_6857_().m_61956_();
            double maxZ = clone.f_19853_.m_6857_().m_61958_();
            double minX = clone.f_19853_.m_6857_().m_61955_();
            double maxX = clone.f_19853_.m_6857_().m_61957_();
            double minY = clone.f_19853_.m_141937_();
            double maxY = clone.f_19853_.m_151558_();
            List world_entities = clone.f_19853_.m_45976_(LivingEntity.class, new AABB(minZ, minX, minY, maxZ, maxX, maxY));
            for (LivingEntity entity : world_entities) {
                if (!instance.getOrCreateTag().m_128441_("ClonedFrom") || !instance.getOrCreateTag().m_128342_("ClonedFrom").equals(entity.m_20148_())) continue;
                System.out.println(entity);
                owner = entity;
            }
            if (owner != null && (compulsorInstance = (ownerStorage = SkillAPI.getSkillsFrom(owner)).getSkill((ManasSkill)UltimateSkills.PERNIDA.get())).isPresent()) {
                ManasSkillInstance instanceVal = (ManasSkillInstance)compulsorInstance.get();
                int newCloneCount = instanceVal.getOrCreateTag().m_128451_("CloneCount") - 1;
                instanceVal.getOrCreateTag().m_128405_("CloneCount", Math.max(newCloneCount, 0));
            }
        }
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity living, UnlockSkillEvent event) {
        Player player;
        Skill previousSkill = (Skill)UniqueSkills.COMPULSOR.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)living);
        if (SkillUtils.hasSkill((Entity)living, (ManasSkill)currentSkill)) {
            return;
        }
        if (living instanceof Player) {
            player = (Player)living;
            CompoundTag skillTag = instance.getOrCreateTag();
            if (!skillTag.m_128441_("OriginalOwner")) {
                skillTag.m_128362_("OriginalOwner", player.m_20148_());
                instance.markDirty();
            }
            skillTag.m_128405_("CloneCount", 0);
            skillTag.m_128405_("maxClones", 5);
        }
        if (living instanceof Player) {
            player = (Player)living;
            if (living.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)living).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!living.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        LivingEntity user = event.getEntity();
        if (this.isInSlot(event.getEntity())) {
            float remainingHealth = user.m_21223_() - event.getAmount();
            DamageSource source = event.getSource();
            if (!source.m_19378_() && (double)remainingHealth <= (double)user.m_21233_() * 0.5 && !event.getSource().m_19384_()) {
                if (instance.getOrCreateTag().m_128451_("CloneCount") < instance.getOrCreateTag().m_128451_("maxClones")) {
                    instance.getOrCreateTag().m_128405_("CloneCount", instance.getOrCreateTag().m_128451_("CloneCount") + 1);
                    System.out.println(instance.getOrCreateTag());
                    EntityType type = (EntityType)TensuraEntityTypes.CLONE_DEFAULT.get();
                    CloneEntity clone = new CloneEntity(type, user.f_19853_);
                    UUID originalOwnerUUID = instance.getOrCreateTag().m_128342_("OriginalOwner");
                    Player originalOwner = user.f_19853_.m_46003_(originalOwnerUUID);
                    if (originalOwner != null) {
                        clone.m_21828_(originalOwner);
                    }
                    clone.setSkill((ManasSkill)this);
                    clone.copyStatsAndSkills(user, true);
                    ManasSkillInstance cloneInstance = SkillUtils.getSkillOrNull((Entity)clone, (ManasSkill)((ManasSkill)UltimateSkills.PERNIDA.get()));
                    if (cloneInstance != null) {
                        System.out.println(user);
                        if (user instanceof CloneEntity) {
                            if (instance.getOrCreateTag().m_128471_("isCloneClone")) {
                                cloneInstance.getOrCreateTag().m_128405_("maxClones", 0);
                                cloneInstance.getOrCreateTag().m_128362_("ClonedFrom", user.m_20148_());
                            } else {
                                cloneInstance.getOrCreateTag().m_128379_("isCloneClone", true);
                                cloneInstance.getOrCreateTag().m_128405_("maxClones", 1);
                                cloneInstance.getOrCreateTag().m_128362_("ClonedFrom", user.m_20148_());
                            }
                        } else {
                            cloneInstance.getOrCreateTag().m_128405_("maxClones", 3);
                        }
                        cloneInstance.getOrCreateTag().m_128405_("CloneCount", 0);
                        cloneInstance.getOrCreateTag().m_128362_("ClonedFrom", user.m_20148_());
                    }
                    AttributeInstance cloneMovementSpeed = clone.m_21051_(Attributes.f_22279_);
                    AttributeInstance userMovementSpeed = user.m_21051_(Attributes.f_22279_);
                    if (cloneMovementSpeed != null && userMovementSpeed != null) {
                        cloneMovementSpeed.m_22100_(userMovementSpeed.m_22115_() / 10.0);
                    }
                    clone.setHeight(clone.getHeight());
                    clone.setWidth(clone.getWidth());
                    TensuraEPCapability.setLivingEP((LivingEntity)clone, (double)Math.round(TensuraEPCapability.getEP((LivingEntity)user) / 5.0));
                    clone.m_6034_(user.m_20185_() + (Math.random() - 0.5) * 2.0, user.m_20186_(), user.m_20189_() + (Math.random() - 0.5) * 2.0);
                    clone.m_21153_(clone.m_21233_());
                    user.f_19853_.m_7967_((Entity)clone);
                    SkillHelper.setWander((LivingEntity)clone);
                } else if (user instanceof Player) {
                    Player player = (Player)user;
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.compulsor.clone_limit").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
            }
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            if (instance.isToggled()) {
                SkillStorage playerStorage = SkillAPI.getSkillsFrom((Entity)player);
                Collection playerStorageLearnedSkills = playerStorage.getLearnedSkills();
                List resistSkills = playerStorageLearnedSkills.stream().filter(skillInstance -> skillInstance.getSkill() instanceof ResistSkill).collect(Collectors.toList());
                for (ManasSkillInstance resistance : resistSkills) {
                    ManasSkill manasSkill = resistance.getSkill();
                    if (!(manasSkill instanceof ResistSkill)) continue;
                    ResistSkill resistSkill = (ResistSkill)manasSkill;
                    if (resistance.getMastery() < 0) {
                        resistSkill.addMasteryPoint(resistance, user);
                    }
                    if (!resistSkill.isMastered(resistance, user)) continue;
                    resistSkill.evolveToNullification(resistance, user);
                }
            }
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity living, int heldTicks) {
        if (instance.getMode() == 2) {
            float size;
            CompoundTag tag = instance.getTag();
            float f = size = tag != null ? tag.m_128457_("size") : 5.0f;
            if (living instanceof Player) {
                Player player = (Player)living;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.output_number", (Object[])new Object[]{Float.valueOf(size / 5.0f)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
            }
            return true;
        }
        if (instance.getMode() == 4) {
            CompoundTag targetTag;
            LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)living, (double)10.0, (boolean)true, (boolean)true);
            if (target instanceof CloneEntity && (targetTag = target.getPersistentData()).m_128441_("ClonedFrom") && targetTag.m_128342_("ClonedFrom") == living.m_20148_()) {
                target.m_6469_(TensuraDamageSources.noEnergySource((Entity)target), target.m_21233_() * 1.0f);
            }
            return true;
        }
        return false;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)10.0, (boolean)true, (boolean)true);
        if (instance.getMode() == 1) {
            if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                if (target != null) {
                    Vec3 particlePos = target.m_20318_(0.0f);
                    target.m_7292_(new MobEffectInstance((MobEffect)MysticismMobEffects.DISTORTED.get(), 200, 2, false, false, false));
                    TensuraParticleHelper.addServerParticlesAroundPos((RandomSource)target.m_217043_(), (Level)target.f_19853_, (Vec3)particlePos, (ParticleOptions)ParticleTypes.f_123766_, (double)3.0);
                    DamageSource distorted = MysticismDamageSources.distorted((Entity)entity);
                    target.m_6469_(distorted, 500.0f);
                    target.f_19853_.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12053_, SoundSource.PLAYERS, 2.0f, 1.0f);
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        player.m_5496_(SoundEvents.f_11871_, 2.0f, 1.0f);
                        player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.compulsor.organic_distortion.being_compromised").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                    instance.setCoolDown(20);
                    this.addMasteryPoint(instance, entity);
                } else {
                    instance.setCoolDown(10);
                }
            }
        } else if (instance.getMode() == 3) {
            if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                Random random = new Random();
                List<ManasSkillInstance> targetSkills = SkillAPI.getSkillsFrom((Entity)target).getLearnedSkills().stream().filter(skill -> {
                    if (!skill.isTemporarySkill() && skill.getMastery() >= 0) {
                        ManasSkill manasSkill = skill.getSkill();
                        if (!(manasSkill instanceof Skill)) {
                            return false;
                        }
                        Skill newSkill = (Skill)manasSkill;
                        return newSkill.getType().equals((Object)Skill.SkillType.COMMON) || newSkill.getType().equals((Object)Skill.SkillType.EXTRA) || newSkill.getType().equals((Object)Skill.SkillType.INTRINSIC) || newSkill.getType().equals((Object)Skill.SkillType.UNIQUE);
                    }
                    return false;
                }).toList();
                ManasSkillInstance copieInstance = targetSkills.get(random.nextInt(0, targetSkills.size()));
                ManasSkill manasSkill = copieInstance.getSkill();
                if (manasSkill instanceof Skill) {
                    Skill skill2 = (Skill)manasSkill;
                    if (skill2.getType().equals((Object)Skill.SkillType.UNIQUE)) {
                        SkillUtils.learnSkill((LivingEntity)entity, (ManasSkill)skill2, (int)-2);
                    } else {
                        SkillUtils.learnSkill((LivingEntity)entity, (ManasSkill)skill2);
                    }
                }
                instance.setCoolDown(90);
                instance.addMasteryPoint(entity);
            }
        } else if (instance.getMode() == 4) {
            CompoundTag tag = instance.getTag();
            CloneEntity clone = (CloneEntity)SkillHelper.getTargetingEntity(CloneEntity.class, (LivingEntity)entity, (double)50.0, (double)0.2, (boolean)false);
            if (clone != null && clone.m_6084_() && clone.getSkill() == this && entity.m_6144_() && !clone.m_6107_()) {
                clone.m_6469_(TensuraDamageSources.noEnergySource((Entity)entity).m_19381_(), clone.m_21233_());
                entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public void onScroll(ManasSkillInstance instance, LivingEntity entity, double delta) {
        if (instance.getMode() == 2 && this.isHeld(entity)) {
            float currentScale;
            float newScale;
            CompoundTag tag = instance.getOrCreateTag();
            tag.m_128405_("ActivatedTimes", tag.m_128451_("ActivatedTimes") + 1);
            if (tag.m_128451_("ActivatedTimes") % 10 == 0) {
                this.addMasteryPoint(instance, entity);
            }
            if ((newScale = (currentScale = tag.m_128457_("size")) + (float)((int)delta)) > 5.0f) {
                newScale = 1.0f;
            } else if (newScale < 1.0f) {
                newScale = 5.0f;
            }
            if (currentScale != newScale) {
                tag.m_128350_("size", newScale);
                instance.markDirty();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    this.adjustPlayerSize(player, newScale);
                    player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12053_, SoundSource.PLAYERS, 2.0f, 1.0f);
                }
            }
        }
    }

    private void adjustPlayerSize(Player player, float scale) {
        AttributeInstance sizeAttribute = player.m_21051_((Attribute)TensuraAttributeRegistry.SIZE.get());
        if (sizeAttribute != null) {
            double newSizeValue = (double)scale / 5.0;
            sizeAttribute.m_22100_(newSizeValue);
        }
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getOrCreateTag().m_128451_("reconstructionCooldown") > 0;
    }

    public void onTick(ManasSkillInstance instance, LivingEntity living) {
        instance.getOrCreateTag().m_128405_("reconstructionCooldown", instance.getOrCreateTag().m_128451_("reconstructionCooldown") - 1);
        if (instance.isToggled() && !living.m_21023_((MobEffect)MysticismMobEffects.INCOMBAT.get())) {
            if (instance.getOrCreateTag().m_128451_("10secondDelay") == 2) {
                instance.getOrCreateTag().m_128405_("10secondDelay", 1);
                float newHP = (float)((double)living.m_21223_() + (double)living.m_21233_() * 0.02);
                living.m_21153_(newHP);
                if (living instanceof Player) {
                    Player player = (Player)living;
                    float newMP = (float)(TensuraPlayerCapability.getMagicule((Player)player) + TensuraPlayerCapability.getBaseMagicule((Player)player) * 0.01);
                    TensuraPlayerCapability.setMagicule((Player)player, (double)newMP);
                }
            }
            instance.getOrCreateTag().m_128405_("10secondDelay", instance.getOrCreateTag().m_128451_("10secondDelay") + 1);
        }
    }
}

