/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.manascore.attribute.ManasCoreAttributes;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.ITensuraPlayerCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.handler.CapabilityHandler;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class SandalphonSkill
extends Skill {
    private static final String SANDALPHON = "0c350729-5d6a-453b-b5c5-b0eee93d1531";

    public SandalphonSkill() {
        super(Skill.SkillType.ULTIMATE);
        this.addHeldAttributeModifier(Attributes.f_22281_, SANDALPHON, 50.0, AttributeModifier.Operation.ADDITION);
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public int getMaxMastery() {
        return 3000;
    }

    public double getObtainingEpCost() {
        return 550000.0;
    }

    public static int getSoulPoints(Player player) {
        ITensuraPlayerCapability capability = (ITensuraPlayerCapability)CapabilityHandler.getCapability((Entity)player, (Capability)TensuraPlayerCapability.CAPABILITY);
        return capability == null ? 0 : capability.getSoulPoints();
    }

    public static boolean isHeroEgg(Player player) {
        ITensuraPlayerCapability capability = (ITensuraPlayerCapability)CapabilityHandler.getCapability((Entity)player, (Capability)TensuraPlayerCapability.CAPABILITY);
        return capability == null ? false : capability.isHeroEgg();
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.MURDERER.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.MURDERER.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/sandalphon.png");
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1 -> 1000.0;
            case 2 -> 10000.0;
            case 3 -> 20000.0;
            case 4 -> 15000.0;
            case 5 -> 15000.0;
            case 6 -> 250000.0;
            default -> 0.0;
        };
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public int modes() {
        return 6;
    }

    public String modeLearningId(int mode) {
        return switch (mode) {
            case 6 -> "judgement";
            default -> "None";
        };
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        int currentMode = instance.getMode();
        boolean mastered = instance.isMastered(entity);
        if (reverse) {
            return currentMode == 1 ? (mastered ? 6 : 5) : currentMode - 1;
        }
        return currentMode == 5 ? (mastered ? 6 : 1) : (currentMode == 6 ? 1 : currentMode + 1);
    }

    public Component getModeName(int mode) {
        switch (mode) {
            case 1: {
                return Component.m_237115_((String)"trmysticism.skill.mode.sandalphon.assassination");
            }
            case 2: {
                return Component.m_237115_((String)"trmysticism.skill.mode.sandalphon.dispel");
            }
            case 3: {
                return Component.m_237115_((String)"trmysticism.skill.mode.sandalphon.eraser");
            }
            case 4: {
                return Component.m_237115_((String)"trmysticism.skill.mode.sandalphon.necrosis");
            }
            case 5: {
                return Component.m_237115_((String)"trmysticism.skill.mode.sandalphon.remove");
            }
            case 6: {
                return Component.m_237115_((String)"trmysticism.skill.mode.sandalphon.judgement");
            }
        }
        return Component.m_237113_((String)"");
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        if (!event.isCanceled()) {
            DamageSource damageSource;
            LivingEntity entity = event.getEntity();
            if (instance.isToggled() && !(damageSource = event.getSource()).m_19378_() && !damageSource.m_19387_() && damageSource.m_7640_() != null && damageSource.m_7640_() == damageSource.m_7639_() && !(entity.m_217043_().m_188501_() > 0.5f)) {
                entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
                event.setCanceled(true);
                if (SkillUtils.canNegateDodge((LivingEntity)entity, (DamageSource)damageSource)) {
                    event.setCanceled(false);
                }
            }
        }
    }

    public void onProjectileHit(ManasSkillInstance instance, LivingEntity entity, ProjectileImpactEvent event) {
        if (instance.isToggled() && !SkillUtils.isProjectileAlwaysHit((Projectile)event.getProjectile()) && !(entity.m_217043_().m_188501_() > 0.5f)) {
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
            event.setCanceled(true);
        }
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        if (instance.isToggled()) {
            LivingEntity entity;
            DamageSource source = e.getSource();
            if (source.m_7640_() == attacker && DamageSourceHelper.isPhysicalAttack((DamageSource)source) && (double)attacker.m_217043_().m_188501_() <= 1.0 && !SkillUtils.canNegateCritChance((Entity)(entity = e.getEntity()))) {
                double critical = attacker.m_21133_((Attribute)ManasCoreAttributes.CRIT_MULTIPLIER.get());
                e.setAmount((float)((double)e.getAmount() * critical));
                entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12313_, attacker.m_5720_(), 1.0f, 1.0f);
                Level var9 = attacker.m_9236_();
                if (var9 instanceof ServerLevel) {
                    ServerLevel level = (ServerLevel)var9;
                    level.m_7726_().m_8394_((Entity)attacker, (Packet)new ClientboundAnimatePacket((Entity)entity, 4));
                }
            }
            if (DamageSourceHelper.isPhysicalAttack((DamageSource)e.getSource())) {
                LivingEntity target = e.getEntity();
                double bonus = instance.isMastered(attacker) ? target.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()) * 0.01 : 0.0;
                DamageSourceHelper.directSpiritualHurt((LivingEntity)target, (Entity)attacker, (float)(15.0f + (float)bonus));
                if (!target.m_6084_()) {
                    e.setCanceled(true);
                }
            }
        }
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getMode() == 1;
    }

    public double getAttributeModifierAmplifier(ManasSkillInstance instance, LivingEntity entity, AttributeModifier modifier) {
        return modifier.m_22218_() * (double)(instance.isMastered(entity) ? 13 : 6);
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 1) {
            if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                return false;
            }
            if (heldTicks % 100 == 0 && heldTicks > 0) {
                this.addMasteryPoint(instance, entity);
            }
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_CONCEALMENT.get(), 5, 4, false, false, false));
            return true;
        }
        return false;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            switch (instance.getMode()) {
                case 2: {
                    if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                        return;
                    }
                    float radius = instance.isMastered(entity) ? 30.0f : 20.0f;
                    List list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_((double)radius), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity));
                    if (list.isEmpty()) break;
                    instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
                    this.addMasteryPoint(instance, entity);
                    for (LivingEntity target1 : list) {
                        if (target1 instanceof Player) {
                            Player player = (Player)target1;
                            if (player.m_150110_().f_35934_) continue;
                        }
                        int duration = instance.isMastered(entity) ? 500 : 200;
                        SkillHelper.checkThenAddEffectSource((LivingEntity)target1, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get()), (int)duration, (int)1, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                        entity.m_21011_(InteractionHand.MAIN_HAND, true);
                        entity.m_21219_();
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target1, (ParticleOptions)ParticleTypes.f_123762_, (double)1.0);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target1, (ParticleOptions)ParticleTypes.f_123808_, (double)1.0);
                        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    break;
                }
                case 3: {
                    if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                        return;
                    }
                    LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)20.0, (boolean)false);
                    double ownerEP = TensuraEPCapability.getEP((LivingEntity)entity);
                    double targetEP = TensuraEPCapability.getEP((LivingEntity)target);
                    if (target == null) {
                        return;
                    }
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        if (player.m_150110_().f_35934_) {
                            return;
                        }
                        if (TensuraSkillCapability.isSkillInSlot((LivingEntity)player, (ManasSkill)((ManasSkill)UltimateSkills.URIEL.get()))) {
                            return;
                        }
                    }
                    if (target == null) break;
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    double distance = entity.m_20270_((Entity)target);
                    double minDistance = 3.0;
                    double maxDistance = 20.0;
                    double successChance = distance <= minDistance ? 1.0 : (distance >= maxDistance ? 0.2 : 0.2 + 0.8 * (maxDistance - distance) / (maxDistance - minDistance));
                    double MP = TensuraEPCapability.getEP((LivingEntity)target);
                    if (Math.random() <= successChance) {
                        DamageSourceHelper.markHurt((LivingEntity)target, (Entity)entity);
                        MP = targetEP <= ownerEP * 0.1 ? (MP *= 2.0) : (targetEP <= ownerEP * 0.25 ? (MP *= 0.5) : (targetEP <= ownerEP * 0.5 ? (MP *= 0.25) : (MP *= 0.1)));
                        instance.setCoolDown(instance.isMastered(entity) ? 10 : 20);
                        this.addMasteryPoint(instance, entity);
                        SkillHelper.reduceEP((LivingEntity)target, (LivingEntity)entity, (double)MP, (boolean)false);
                        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123747_, (double)1.0);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123808_, (double)1.0);
                        break;
                    }
                    entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case 4: {
                    int duration;
                    if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                        return;
                    }
                    LivingEntity target2 = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)20.0, (boolean)false);
                    if (target2 == null) {
                        return;
                    }
                    if (target2 instanceof Player) {
                        Player player = (Player)target2;
                        if (player.m_150110_().f_35934_) {
                            return;
                        }
                        if (TensuraSkillCapability.isSkillInSlot((LivingEntity)player, (ManasSkill)((ManasSkill)UltimateSkills.URIEL.get()))) {
                            return;
                        }
                    }
                    if (target2 == null) break;
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    double distance = entity.m_20270_((Entity)target2);
                    double minDistance = 3.0;
                    double maxDistance = 20.0;
                    double successChance = distance <= minDistance ? 1.0 : (distance >= maxDistance ? 0.2 : 0.2 + 0.8 * (maxDistance - distance) / (maxDistance - minDistance));
                    int n = duration = instance.isMastered(entity) ? 500 : 350;
                    if (Math.random() <= successChance) {
                        SkillHelper.checkThenAddEffectSource((LivingEntity)target2, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get()), (int)duration, (int)1, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                        instance.setCoolDown(instance.isMastered(entity) ? 20 : 30);
                        this.addMasteryPoint(instance, entity);
                        SkillHelper.checkThenAddEffectSource((LivingEntity)target2, (Entity)entity, (MobEffect)((MobEffect)MysticismMobEffects.NECROSIS.get()), (int)duration, (int)1, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215675_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target2, (ParticleOptions)ParticleTypes.f_175828_, (double)1.0);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target2, (ParticleOptions)ParticleTypes.f_123808_, (double)1.0);
                        break;
                    }
                    entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case 5: {
                    if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                        return;
                    }
                    LivingEntity target3 = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)20.0, (boolean)false);
                    if (target3 == null) {
                        return;
                    }
                    if (target3 instanceof Player) {
                        Player player = (Player)target3;
                        if (player.m_150110_().f_35934_) {
                            return;
                        }
                        if (TensuraSkillCapability.isSkillInSlot((LivingEntity)player, (ManasSkill)((ManasSkill)UltimateSkills.URIEL.get()))) {
                            return;
                        }
                    }
                    if (target3 == null) break;
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    double distance = entity.m_20270_((Entity)target3);
                    double minDistance = 3.0;
                    double maxDistance = 20.0;
                    double successChance = distance <= minDistance ? 1.0 : (distance >= maxDistance ? 0.2 : 0.2 + 0.8 * (maxDistance - distance) / (maxDistance - minDistance));
                    if (!(Math.random() <= successChance)) break;
                    AttributeInstance attribute = target3.m_21051_((Attribute)TensuraAttributeRegistry.BARRIER.get());
                    if (attribute != null) {
                        attribute.m_22132_();
                    }
                    this.addMasteryPoint(instance, entity);
                    entity.m_9236_().m_5594_((Player)null, entity.m_20183_(), SoundEvents.f_11983_, SoundSource.AMBIENT, 1.0f, 1.0f);
                    break;
                }
                case 6: {
                    CompoundTag tag = instance.getOrCreateTag();
                    int learnPoint = tag.m_128451_("judgement");
                    if (learnPoint < 100) {
                        tag.m_128405_("judgement", learnPoint + SkillUtils.getEarningLearnPoint((ManasSkillInstance)instance, (LivingEntity)entity, (boolean)true));
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            if (tag.m_128451_("judgement") >= 100) {
                                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(6)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                            } else {
                                instance.setCoolDown(10);
                                SkillUtils.learningFailPenalty((LivingEntity)entity);
                                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(6)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                            }
                            player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                        instance.markDirty();
                        break;
                    }
                    if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                        return;
                    }
                    LivingEntity target4 = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)100.0, (boolean)false);
                    double ownerEP1 = TensuraEPCapability.getEP((LivingEntity)entity);
                    double targetEP1 = TensuraEPCapability.getEP((LivingEntity)target4);
                    if (target4 == null) {
                        return;
                    }
                    if (target4 instanceof Player) {
                        Player player = (Player)target4;
                        if (player.m_150110_().f_35934_) {
                            return;
                        }
                        if (TensuraSkillCapability.isSkillInSlot((LivingEntity)player, (ManasSkill)((ManasSkill)UltimateSkills.URIEL.get()))) {
                            return;
                        }
                    }
                    if (target4 == null) break;
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    DamageSourceHelper.markHurt((LivingEntity)target4, (Entity)entity);
                    this.addMasteryPoint(instance, entity);
                    AttributeInstance attribute = target4.m_21051_((Attribute)TensuraAttributeRegistry.BARRIER.get());
                    if (attribute != null) {
                        attribute.m_22132_();
                    }
                    int duration = instance.isMastered(entity) ? 240 : 120;
                    SkillHelper.checkThenAddEffectSource((LivingEntity)target4, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get()), (int)duration, (int)1, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                    SkillHelper.checkThenAddEffectSource((LivingEntity)target4, (Entity)entity, (MobEffect)((MobEffect)MysticismMobEffects.NECROSIS.get()), (int)duration, (int)1, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                    double MP = TensuraEPCapability.getEP((LivingEntity)target4);
                    MP = targetEP1 <= ownerEP1 * 0.1 ? (MP *= 2.0) : (targetEP1 <= ownerEP1 * 0.25 ? (MP *= 0.9) : (targetEP1 <= ownerEP1 * 0.5 ? (MP *= 0.85) : (MP *= 0.75)));
                    instance.setCoolDown(1200);
                    SkillHelper.reduceEP((LivingEntity)target4, (LivingEntity)entity, (double)MP, (boolean)false);
                    DamageSourceHelper.directSpiritualHurt((LivingEntity)target4, (Entity)entity, (float)1000.0f);
                    target4.m_6469_(TensuraDamageSource.f_19318_, 750.0f);
                }
            }
        }
    }
}

