/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.HakiSkill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.human.CloneEntity;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.world.TensuraGameRules;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.registry.sound.MysticismSoundEvents;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.util.damage.MysticismDamageSources;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.network.PacketDistributor;

public class SarielSkill
extends Skill {
    private static final ThreadLocal<Boolean> reentrantGuard = ThreadLocal.withInitial(() -> false);
    protected static final UUID ACCELERATION = UUID.fromString("e676df49-75b6-4c95-8373-c5c2426538b8");

    public SarielSkill() {
        super(Skill.SkillType.ULTIMATE);
        this.addHeldAttributeModifier(Attributes.f_22279_, "7f69b484-8a28-467a-91c3-fc1986fa4d29", -0.95f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/sariel.png");
    }

    public double getAttributeModifierAmplifier(ManasSkillInstance instance, LivingEntity entity, AttributeModifier modifier) {
        return modifier.m_22218_() * (instance.isMastered(entity) ? 0.9473684210526315 : 1.0);
    }

    public void addHeldAttributeModifiers(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() == 1) {
            super.addHeldAttributeModifiers(instance, entity);
        }
    }

    public int getMaxMastery() {
        return 3000;
    }

    public double getObtainingEpCost() {
        return 1000000.0;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.UNYIELDING.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.UNYIELDING.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return instance.getMastery() >= 0;
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)true);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)false);
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.sariel.sacred_haki");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.sariel.backup");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.sariel.return");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.sariel.fortitude");
            default -> Component.m_237119_();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDamageEntity(ManasSkillInstance instance, LivingEntity entity, LivingHurtEvent event) {
        if (instance.getMode() == 4 && instance.getOrCreateTag().m_128451_("Fortitude") >= 100) {
            if (instance.onCoolDown()) {
                return;
            }
            if (reentrantGuard.get().booleanValue() || !DamageSourceHelper.isPhysicalAttack((DamageSource)event.getSource())) {
                return;
            }
            reentrantGuard.set(true);
            LivingEntity target = event.getEntity();
            try {
                SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance);
                this.fortitude(instance, entity, entity.m_9236_(), target);
            }
            finally {
                reentrantGuard.set(false);
            }
        }
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            default -> 0.0;
            case 1 -> 10000.0;
            case 4 -> 300000.0;
        };
    }

    public int modes() {
        return 4;
    }

    public String modeLearningId(int mode) {
        if (mode == 4) {
            return "Fortitude";
        }
        return "None";
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 4 : instance.getMode() - 1;
        }
        return instance.getMode() == 4 ? 1 : instance.getMode() + 1;
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        List list;
        if (instance.getMode() != 1) {
            return false;
        }
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            return false;
        }
        if (heldTicks % 60 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215778_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (heldTicks % 2 == 0) {
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:sacred_haki"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
        }
        if (!(list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(15.0), entityData -> !entityData.m_7306_((Entity)entity) && entityData.m_6084_() && !entity.m_7307_((Entity)entityData))).isEmpty()) {
            double scale = instance.getTag() == null ? 0.0 : instance.getTag().m_128459_("scale");
            double multiplier = scale == 0.0 ? 1.0 : Math.min(scale, 1.0);
            double ownerEP = TensuraEPCapability.getEP((LivingEntity)entity) * multiplier;
            for (LivingEntity target : list) {
                double targetEP;
                double difference;
                if (target.m_7307_((Entity)entity)) {
                    Predicate<MobEffect> predicate;
                    boolean success;
                    boolean bl = success = target.m_21223_() < target.m_21233_();
                    if (heldTicks % 100 == 0 && heldTicks > 0) {
                        target.m_5634_(1200.0f);
                    }
                    if (!(success = SkillHelper.removePredicateEffect((LivingEntity)entity, predicate = effect -> effect.m_19483_() == MobEffectCategory.HARMFUL) || success)) continue;
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123750_, (double)1.0);
                    continue;
                }
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) continue;
                }
                if ((difference = ownerEP / (targetEP = TensuraEPCapability.getEP((LivingEntity)target))) <= 2.0) continue;
                int fearLevel = (int)(difference * 0.5 - 1.0);
                fearLevel = Math.min(fearLevel, (Integer)TensuraConfig.INSTANCE.mobEffectConfig.maxFear.get());
                SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.FEAR.get()), (int)200, (int)fearLevel);
                HakiSkill.hakiPush((LivingEntity)target, (LivingEntity)entity, (int)fearLevel);
            }
            return true;
        }
        return true;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 1 && this.isHeld(entity)) {
            instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
        }
    }

    public void onScroll(ManasSkillInstance instance, LivingEntity entity, double delta) {
        if (instance.getMode() == 1) {
            HakiSkill.changeEPUsed((ManasSkillInstance)instance, (LivingEntity)entity, (double)delta);
        }
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        List list;
        CompoundTag tag = instance.getOrCreateTag();
        Level level = entity.m_9236_();
        if (this.isInSlot(entity) && !entity.m_21023_((MobEffect)TensuraMobEffects.HAKI_COAT.get())) {
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.HAKI_COAT.get(), 240, 0, false, false, false));
        }
        if (!(list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(30.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && living.m_7307_((Entity)entity))).isEmpty()) {
            int effectLevel = instance.isMastered(entity) ? 1 : 0;
            for (LivingEntity target2 : list) {
                if (SkillHelper.isSubordinate((LivingEntity)target2, (LivingEntity)entity)) {
                    return;
                }
                target2.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.INSPIRATION.get(), 240, effectLevel, false, false, false), (Entity)entity);
            }
        }
        if (instance.isMastered(entity) && level instanceof ServerLevel) {
            Object uuid;
            Entity backup;
            ServerLevel serverLevel = (ServerLevel)level;
            if (tag.m_128441_("Backup") && (backup = SkillHelper.getEntityFromUUID((ServerLevel)serverLevel, (UUID)(uuid = tag.m_128342_("Backup")), clonex -> clonex instanceof CloneEntity)) instanceof CloneEntity) {
                ((CloneEntity)backup).m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.ALLY_BOOST.get(), 200, 0, false, false, false));
            }
        }
        Collection<LivingEntity> allies = this.getAlliesInRange(entity, 15.0);
        for (LivingEntity ally : allies) {
            this.applyEffects(ally, instance, entity);
        }
        Collection uuidList = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(30.0), target -> this.isNamed(entity, (LivingEntity)target)).stream().map(Entity::m_20149_).collect(Collectors.toList());
        if (tag.m_128441_("UnyieldingList")) {
            CompoundTag unyieldingList = (CompoundTag)tag.m_128423_("UnyieldingList");
            if (list == null) {
                return;
            }
            List<String> keyList = List.copyOf(unyieldingList.m_128431_());
            if (!keyList.isEmpty()) {
                for (String key : keyList) {
                    if (uuidList.contains(key)) {
                        unyieldingList.m_128405_(key, unyieldingList.m_128451_(key) + (instance.isMastered(entity) ? 4 : 3));
                        uuidList.remove(key);
                        continue;
                    }
                    int newPoint = Math.max(unyieldingList.m_128451_(key) - 1, 0);
                    unyieldingList.m_128405_(key, newPoint);
                    if (newPoint != 0) continue;
                    list.remove(key);
                    unyieldingList.m_128473_(key);
                }
            }
            if (!uuidList.isEmpty()) {
                for (String key : uuidList) {
                    unyieldingList.m_128405_(key, Math.min(unyieldingList.m_128451_(key) + 30, 1800));
                }
            }
            instance.markDirty();
        } else if (!uuidList.isEmpty()) {
            for (String uuid : uuidList) {
                CompoundTag unyieldingList = new CompoundTag();
                unyieldingList.m_128405_(uuid, 1);
                tag.m_128365_("UnyieldingList", (Tag)unyieldingList);
            }
            instance.markDirty();
        }
    }

    private Collection<LivingEntity> getAlliesInRange(LivingEntity entity, double radius) {
        return new ArrayList<LivingEntity>(entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(radius), target -> entity.m_7307_((Entity)entity)));
    }

    private void applyEffects(LivingEntity ally, ManasSkillInstance instance, LivingEntity entity) {
        boolean mastered = instance.isMastered(entity);
        if (!ally.m_21023_((MobEffect)TensuraMobEffects.INSPIRATION.get())) {
            ally.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.INSPIRATION.get(), 120, mastered ? 1 : 0, false, false, false));
        }
        if (!ally.m_21023_((MobEffect)TensuraMobEffects.ALLY_BOOST.get())) {
            ally.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.ALLY_BOOST.get(), 120, mastered ? 1 : 0, false, false, false));
        }
    }

    private boolean isNamed(LivingEntity owner, LivingEntity entity) {
        UUID permanentOwner = TensuraEPCapability.getPermanentOwner((LivingEntity)entity);
        if (permanentOwner == null) {
            return false;
        }
        if (!Objects.equals(permanentOwner, owner.m_20148_())) {
            return false;
        }
        if (TensuraEPCapability.getName((LivingEntity)entity) == null) {
            return false;
        }
        return !entity.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_EP_PLUNDER);
    }

    private int getUnyieldingPoint(ManasSkillInstance instance, LivingEntity target) {
        CompoundTag tag = instance.getOrCreateTag();
        if (!tag.m_128441_("UnyieldingList")) {
            return 0;
        }
        CompoundTag list = (CompoundTag)tag.m_128423_("UnyieldingList");
        return list == null ? 0 : list.m_128451_(target.m_20149_());
    }

    private void removeUnyielding(ManasSkillInstance instance, LivingEntity target) {
        CompoundTag tag = instance.getOrCreateTag();
        if (tag.m_128441_("UnyieldingList")) {
            CompoundTag list = (CompoundTag)tag.m_128423_("UnyieldingList");
            if (list == null) {
                return;
            }
            list.m_128473_(target.m_20149_());
        }
        instance.markDirty();
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag;
        int learnPoint;
        if (instance.getMode() == 2) {
            Level var4 = entity.m_9236_();
            if (var4 instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)var4;
                CompoundTag tag2 = instance.getOrCreateTag();
                double maxMP = entity.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                if (!tag2.m_128441_("Backup")) {
                    if (instance.isMastered(entity)) {
                        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (double)(maxMP * 0.1))) {
                            this.spawnBackup(instance, entity, false);
                        }
                    } else if (!SkillHelper.outOfMagicule((LivingEntity)entity, (double)(maxMP * 0.05))) {
                        this.spawnBackup(instance, entity, false);
                    }
                    instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
                } else {
                    UUID uuid = tag2.m_128342_("Backup");
                    Entity var9 = SkillHelper.getEntityFromUUID((ServerLevel)level, (UUID)uuid, clone -> clone instanceof CloneEntity);
                    if (var9 instanceof CloneEntity) {
                        CloneEntity backup = (CloneEntity)var9;
                        if (entity.m_6144_()) {
                            if (entity instanceof Player) {
                                Player player = (Player)entity;
                                player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.mode.unyielding.backup_remove").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                            }
                            backup.remove();
                        } else if (backup.m_9236_() != entity.m_9236_() && !instance.isMastered(entity)) {
                            if (entity instanceof Player) {
                                Player player = (Player)entity;
                                player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.mode.unyielding.backup_different_dimension").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                            }
                        } else if (backup.m_6084_()) {
                            instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
                            level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            CloneEntity body = this.spawnBackup(instance, entity, true);
                            body.m_7311_(entity.m_20094_());
                            SkillHelper.moveAcrossDimensionTo((Entity)entity, (Entity)backup);
                            backup.copyEquipmentsOntoOwner(entity, true);
                            CloneEntity.copyEffects((LivingEntity)backup, (LivingEntity)entity);
                            entity.m_21153_(backup.m_21223_());
                            backup.remove();
                        }
                    } else if (!SkillHelper.outOfMagicule((LivingEntity)entity, (double)(maxMP * 0.1))) {
                        this.spawnBackup(instance, entity, false);
                        instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
                    }
                }
            }
        } else if (instance.getMode() == 3) {
            LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)6.0, (boolean)false);
            if (target != null && target.m_7307_((Entity)entity) && entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.mode.unyielding.check_point", (Object[])new Object[]{target.m_7755_(), this.getUnyieldingPoint(instance, target)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA)), true);
            }
        } else if (instance.getMode() == 4 && (learnPoint = (tag = instance.getOrCreateTag()).m_128451_("Fortitude")) < 100) {
            if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                return;
            }
            tag.m_128405_("Fortitude", learnPoint + SkillUtils.getEarningLearnPoint((ManasSkillInstance)instance, (LivingEntity)entity, (boolean)true));
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (tag.m_128451_("Fortitude") >= 100) {
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(4)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                } else {
                    instance.setCoolDown(10);
                    SkillUtils.learningFailPenalty((LivingEntity)entity);
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(4)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                }
                player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            instance.markDirty();
        }
    }

    private CloneEntity spawnBackup(ManasSkillInstance instance, LivingEntity entity, boolean copyEquipment) {
        Level level = entity.m_9236_();
        CompoundTag tag = instance.getOrCreateTag();
        double EP = TensuraEPCapability.getEP((LivingEntity)entity);
        EntityType type = entity.m_6144_() ? (EntityType)TensuraEntityTypes.CLONE_SLIM.get() : (EntityType)TensuraEntityTypes.CLONE_DEFAULT.get();
        CloneEntity clone = new CloneEntity(type, level);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            clone.m_21828_(player);
        }
        clone.setSkill((ManasSkill)this);
        if (instance.isMastered(entity)) {
            SkillHelper.setAggressive((LivingEntity)clone);
        } else {
            clone.setImmobile(true);
        }
        clone.setChunkLoader(true);
        clone.m_21153_(entity.m_21223_());
        if (copyEquipment) {
            clone.copyEquipments(entity);
        }
        clone.copyStatsAndSkills(entity, CloneEntity.CopySkill.NONE, true);
        CloneEntity.copyEffects((LivingEntity)entity, (LivingEntity)clone);
        TensuraEPCapability.setLivingEP((LivingEntity)clone, (double)EP);
        clone.m_146884_(entity.m_20182_());
        clone.loadChunkHandler();
        CloneEntity.copyRotation((LivingEntity)entity, (LivingEntity)clone);
        level.m_7967_((Entity)clone);
        tag.m_128362_("Backup", clone.m_20148_());
        instance.markDirty();
        return clone;
    }

    public void onDeath(ManasSkillInstance instance, LivingDeathEvent event) {
        Level level;
        LivingEntity entity;
        if (!event.isCanceled() && !(entity = event.getEntity()).m_6084_() && !(entity instanceof CloneEntity) && (level = entity.m_9236_()) instanceof ServerLevel) {
            UUID uuid;
            Entity var8;
            ServerLevel serverLevel = (ServerLevel)level;
            CompoundTag tag = instance.getOrCreateTag();
            if (tag.m_128441_("Backup") && (var8 = SkillHelper.getEntityFromUUID((ServerLevel)serverLevel, (UUID)(uuid = tag.m_128342_("Backup")), clonex -> clonex instanceof CloneEntity)) instanceof CloneEntity) {
                CloneEntity backup = (CloneEntity)var8;
                this.addMasteryPoint(instance, entity);
                serverLevel.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                entity.f_19802_ = 60;
                entity.m_21153_(backup.m_21223_());
                entity.m_7311_(backup.m_20094_());
                event.setCanceled(true);
                TensuraEffectsCapability.resetEverything((LivingEntity)entity, (boolean)false, (boolean)false);
                CloneEntity clone = this.spawnBackup(instance, entity, true);
                CloneEntity.copyEffects((LivingEntity)entity, (LivingEntity)clone);
                boolean keepInv = serverLevel.m_46469_().m_46207_(GameRules.f_46133_);
                if (!keepInv) {
                    clone.m_6667_(event.getSource());
                    clone.remove();
                }
                SkillHelper.moveAcrossDimensionTo((Entity)entity, (Entity)backup);
                backup.copyEquipmentsOntoOwner(entity, true);
                CloneEntity.copyEffects((LivingEntity)backup, (LivingEntity)entity);
                backup.remove();
                if (keepInv && (clone = (CloneEntity)SkillHelper.moveAcrossDimensionTo((Entity)clone, (Entity)entity)) != null) {
                    clone.remove();
                }
            }
        }
    }

    private void fortitude(ManasSkillInstance instance, LivingEntity entity, Level level, LivingEntity target) {
        boolean hasUltimateSkill;
        if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            return;
        }
        SkillStorage targetStorage = SkillAPI.getSkillsFrom((Entity)target);
        if (target instanceof Player) {
            Player player = (Player)target;
            if (player.m_150110_().f_35934_) {
                return;
            }
        }
        if (hasUltimateSkill = targetStorage.getLearnedSkills().stream().map(ManasSkillInstance::getSkill).filter(skill -> skill instanceof Skill).map(skill -> (Skill)skill).anyMatch(skill -> skill.getType() == Skill.SkillType.ULTIMATE)) {
            TensuraEPCapability.getFrom((LivingEntity)entity).ifPresent(cap -> {
                double entityEP = cap.getEP();
                TensuraEPCapability.getFrom((LivingEntity)target).ifPresent(targetCap -> {
                    int burden;
                    int slowness;
                    int weakness;
                    int duration;
                    float damage;
                    double targetEP = targetCap.getEP();
                    double ratio = targetEP / entityEP;
                    if (ratio <= 1.0) {
                        damage = target.m_21233_();
                        duration = 300;
                        weakness = 6;
                        slowness = 6;
                        burden = 6;
                    } else if (ratio <= 1.1) {
                        damage = target.m_21233_() * 0.9f;
                        duration = 300;
                        weakness = 6;
                        slowness = 6;
                        burden = 6;
                    } else if (ratio <= 1.2) {
                        damage = target.m_21233_() * 0.8f;
                        duration = 280;
                        weakness = 4;
                        slowness = 4;
                        burden = 5;
                    } else if (ratio <= 1.3) {
                        damage = target.m_21233_() * 0.7f;
                        duration = 260;
                        weakness = 4;
                        slowness = 4;
                        burden = 4;
                    } else if (ratio <= 1.4) {
                        damage = target.m_21233_() * 0.6f;
                        duration = 240;
                        weakness = 4;
                        slowness = 4;
                        burden = 3;
                    } else if (ratio <= 1.5) {
                        damage = target.m_21233_() * 0.5f;
                        duration = 220;
                        weakness = 2;
                        slowness = 2;
                        burden = 2;
                    } else {
                        damage = target.m_21233_() * 0.25f;
                        duration = 200;
                        weakness = 1;
                        slowness = 1;
                        burden = 1;
                    }
                    if (target.m_6469_((DamageSource)this.sourceWithMP(MysticismDamageSources.lifeReapingSlash((Entity)entity), entity, instance), damage)) {
                        entity.m_5634_(damage);
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, duration, weakness - 1, false, false, true));
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, duration, slowness - 1, false, false, true));
                        target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.BURDEN.get(), duration, burden - 1, false, false, true));
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123792_);
                    }
                });
            });
            SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.ANTI_SKILL.get()), (int)10, (int)1, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)MysticismSoundEvents.LIFE_REAPING_SLASH_HURT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)((ParticleOptions)TensuraParticles.BLACK_LIGHTNING_EFFECT.get()), (double)1.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)((ParticleOptions)TensuraParticles.DARK_RED_LIGHTNING_SPARK.get()), (double)1.0);
        } else {
            target.m_6469_((DamageSource)this.sourceWithMP(MysticismDamageSources.lifeReapingSlash((Entity)entity), entity, instance), target.m_21233_());
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123808_);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123792_);
            SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.ANTI_SKILL.get()), (int)30, (int)1, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)MysticismSoundEvents.LIFE_REAPING_SLASH_KILL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123790_, (double)1.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123746_, (double)1.0);
        }
        reentrantGuard.set(false);
        instance.addMasteryPoint(entity);
        instance.setCoolDown(15);
    }

    public void onSubordinateDeath(ManasSkillInstance instance, LivingEntity owner, LivingDeathEvent e) {
        block3: {
            List<ManasSkillInstance> list;
            int unyieldingPoint;
            LivingEntity entity;
            block4: {
                entity = e.getEntity();
                if (e.getSource().m_7639_() == owner || !this.isNamed(owner, entity)) break block3;
                unyieldingPoint = Math.min(this.getUnyieldingPoint(instance, entity) / 120, 15);
                int epCalcUnyieldingPoint = Math.min(unyieldingPoint, 10);
                this.removeUnyielding(instance, entity);
                if (unyieldingPoint < 1) break block3;
                this.addMasteryPoint(instance, entity, unyieldingPoint);
                TensuraEPCapability.getFrom((LivingEntity)entity).ifPresent(cap -> {
                    boolean canGainMax;
                    double epGain = Math.min(cap.getEP() * 0.1 * (double)epCalcUnyieldingPoint, (Double)TensuraConfig.INSTANCE.skillsConfig.maximumEPSteal.get());
                    SkillHelper.gainMP((LivingEntity)owner, (double)(epGain / 2.0), (boolean)false);
                    SkillHelper.gainAP((LivingEntity)owner, (double)(epGain / 2.0), (boolean)false);
                    if (owner instanceof Player) {
                        Player player = (Player)owner;
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.ep.acquire_fallen", (Object[])new Object[]{epGain, entity.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                        player.m_6330_(SoundEvents.f_12275_, SoundSource.PLAYERS, 0.5f, 1.0f);
                    }
                    boolean bl = canGainMax = !(entity instanceof Player) || TensuraGameRules.canEpSteal((Level)entity.m_9236_());
                    if (canGainMax) {
                        SkillHelper.gainMaxMP((LivingEntity)owner, (double)(epGain / 2.0));
                        SkillHelper.gainMaxAP((LivingEntity)owner, (double)(epGain / 2.0));
                        cap.setEP(entity, cap.getEP() - epGain);
                        cap.setSkipEPDrop(true);
                    }
                });
                if (entity.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SKILL_PLUNDER)) break block3;
                if (entity instanceof Player && !entity.m_9236_().m_6106_().m_5466_()) break block4;
                List<ManasSkillInstance> list2 = List.copyOf(SkillAPI.getSkillsFrom((Entity)entity).getLearnedSkills());
                if (list2.isEmpty()) break block3;
                for (ManasSkillInstance targetInstance : list2) {
                    if (!this.canGainSkill(targetInstance, unyieldingPoint) || !SkillUtils.learnSkill((LivingEntity)owner, (ManasSkill)targetInstance.getSkill(), (int)instance.getRemoveTime())) continue;
                    SkillAPI.getSkillsFrom((Entity)entity).forgetSkill(targetInstance.getSkill());
                    if (!(owner instanceof Player)) continue;
                    Player player = (Player)owner;
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_fallen", (Object[])new Object[]{targetInstance.getSkill().getName(), entity.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    player.m_6330_(SoundEvents.f_12275_, SoundSource.PLAYERS, 0.5f, 1.0f);
                }
                break block3;
            }
            if (entity instanceof Player && !entity.m_9236_().m_6106_().m_5466_() && !(list = List.copyOf(SkillAPI.getSkillsFrom((Entity)entity).getLearnedSkills().stream().filter(skillInstance -> {
                ManasSkill skill = skillInstance.getSkill();
                if (skill instanceof Skill) {
                    Skill s = (Skill)skill;
                    Skill.SkillType type = s.getType();
                    if (type == Skill.SkillType.INTRINSIC || type == Skill.SkillType.COMMON || type == Skill.SkillType.EXTRA) {
                        return true;
                    }
                    if (type == Skill.SkillType.RESISTANCE && skill instanceof ResistSkill) {
                        ResistSkill resist = (ResistSkill)skill;
                        return resist.getResistType() == ResistSkill.ResistType.RESISTANCE;
                    }
                }
                return false;
            }).toList())).isEmpty()) {
                for (ManasSkillInstance targetInstance : list) {
                    if (!this.canGainSkill(targetInstance, unyieldingPoint) || !SkillUtils.learnSkill((LivingEntity)owner, (ManasSkill)targetInstance.getSkill(), (int)instance.getRemoveTime()) || !(owner instanceof Player)) continue;
                    Player player = (Player)owner;
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_fallen", (Object[])new Object[]{targetInstance.getSkill().getName(), entity.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    player.m_6330_(SoundEvents.f_12275_, SoundSource.PLAYERS, 0.5f, 1.0f);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canGainSkill(ManasSkillInstance targetInstance, int point) {
        if (targetInstance.getSkill() == this) {
            return false;
        }
        if (targetInstance.isTemporarySkill()) return false;
        if (targetInstance.getMastery() < 0) return false;
        ManasSkill manasSkill = targetInstance.getSkill();
        if (!(manasSkill instanceof Skill)) return true;
        Skill skill = (Skill)manasSkill;
        if (skill.getType().equals((Object)Skill.SkillType.UNIQUE)) {
            if (point < 5) return false;
            return true;
        }
        if (!skill.getType().equals((Object)Skill.SkillType.ULTIMATE)) return false;
        if (point < 15) return false;
        return true;
    }
}

