/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.unique.WrathSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.google.common.collect.ImmutableList;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class SatanaelSkill
extends Skill {
    public static final ImmutableList<MobEffect> POISONING = ImmutableList.of((Object)((MobEffect)TensuraMobEffects.MAGICULE_POISON.get()));

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/satanael.png");
    }

    public int getMaxMastery() {
        return 3000;
    }

    public SatanaelSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public double getObtainingEpCost() {
        return 1000000.0;
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        if (entity.m_21023_((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get())) {
            return true;
        }
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.WRATH.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.WRATH.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return instance.isMastered(living);
    }

    public int modes() {
        return 3;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 3 : instance.getMode() - 1;
        }
        return instance.getMode() == 3 ? 1 : instance.getMode() + 1;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.satanael.breeder");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.satanael.enrage");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.satanael.stampede");
            default -> Component.m_237119_();
        };
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 2 -> 5000.0;
            case 3 -> 500000.0;
            default -> 0.0;
        };
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled();
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        this.breederReactor(instance, player);
        TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:wrath_boost"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        if (this.isInSlot(attacker) && attacker.m_21023_((MobEffect)TensuraMobEffects.RAMPAGE.get()) && this.isDamagePhysical(e.getSource(), attacker)) {
            EquipmentSlot[] slots;
            LivingEntity target = e.getEntity();
            int durabilityBreak = (int)Math.max(1.0f, e.getAmount() / 4.0f) * 2;
            if (instance.isMastered(attacker)) {
                durabilityBreak *= 2;
            }
            for (EquipmentSlot slot : slots = EquipmentSlot.values()) {
                ItemStack slotStack;
                if (slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) && !target.m_6844_(slot).canPerformAction(ToolActions.SHIELD_BLOCK) || !(slotStack = target.m_6844_(slot)).m_41619_() && slotStack.m_41784_().m_128459_("EP") >= 1000000.0) continue;
                slotStack.m_41622_(durabilityBreak, target, living -> living.m_21166_(slot));
            }
        }
    }

    private boolean isDamagePhysical(DamageSource source, LivingEntity attacker) {
        return source.m_7639_() == attacker && DamageSourceHelper.isPhysicalAttack((DamageSource)source);
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        switch (instance.getMode()) {
            case 1: {
                if (instance.isToggled() && instance.isMastered(entity)) {
                    return false;
                }
                if (!(entity instanceof Player)) {
                    return false;
                }
                Player player = (Player)entity;
                if (heldTicks % 100 == 0 && heldTicks > 0) {
                    this.breederReactor(instance, player);
                }
                if (heldTicks % 100 == 0 && heldTicks > 0) {
                    this.addMasteryPoint(instance, entity);
                }
                if (heldTicks % 10 == 0) {
                    TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:wrath_boost"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
                }
                player.m_6330_(SoundEvents.f_215771_, SoundSource.PLAYERS, 2.0f, 1.0f);
                return true;
            }
            case 2: {
                if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                    return false;
                }
                Level level = entity.m_9236_();
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215777_, SoundSource.PLAYERS, 10.0f, 1.0f);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123792_, (double)2.0);
                List list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(14.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity));
                if (!list.isEmpty()) {
                    if (heldTicks % 200 == 0 && heldTicks > 0) {
                        this.addMasteryPoint(instance, entity);
                    }
                    for (LivingEntity target : list) {
                        int duration;
                        if (SkillUtils.isSkillToggled((Entity)target, (ManasSkill)((ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_NULLIFICATION.get())) && entity.m_217043_().m_188503_(2) != 1) continue;
                        int effectLevel = 0;
                        MobEffectInstance rampage = target.m_21124_((MobEffect)TensuraMobEffects.RAMPAGE.get());
                        if (rampage != null && heldTicks > 0) {
                            duration = rampage.m_19557_() + 2;
                            effectLevel = (duration - 400) / 200;
                        } else {
                            duration = 400;
                        }
                        target.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.RAMPAGE.get(), duration, effectLevel, false, false, false), (Entity)entity);
                        if (heldTicks % 10 != 0) continue;
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123792_, (double)2.0);
                    }
                }
                return true;
            }
            case 3: {
                if (!instance.isToggled()) {
                    if (!(entity instanceof Player)) {
                        return false;
                    }
                    Player player = (Player)entity;
                    if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                        return false;
                    }
                    int amplifier = 9;
                    Level level = entity.m_9236_();
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215777_, SoundSource.PLAYERS, 10.0f, 1.0f);
                    MobEffectInstance effectInstance = player.m_21124_((MobEffect)TensuraMobEffects.RAMPAGE.get());
                    if (effectInstance != null) {
                        amplifier = effectInstance.m_19564_() + 10;
                    }
                    SkillHelper.addEffectWithSource((LivingEntity)player, (LivingEntity)player, (MobEffect)((MobEffect)TensuraMobEffects.RAMPAGE.get()), (int)12000, (int)amplifier, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                    if (!instance.isMastered((LivingEntity)player)) {
                        instance.setCoolDown(1200);
                        break;
                    }
                    instance.setCoolDown(600);
                    break;
                }
                if (!(entity instanceof Player)) break;
                Player player = (Player)entity;
                String message = instance.isToggled() ? "tensura.skill.mode.need_toggle_off" : "tensura.ability.activation_failed";
                player.m_5661_((Component)Component.m_237115_((String)message).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
        }
        return false;
    }

    private void breederReactor(ManasSkillInstance instance, Player player) {
        if (((WrathSkill)UniqueSkills.WRATH.get()).isHeld((LivingEntity)player)) {
            return;
        }
        TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
            double rampageChance;
            double maxMP = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
            double mpGain = maxMP * 0.05;
            cap.setMagicule(cap.getMagicule() + mpGain);
            double d = rampageChance = cap.getMagicule() > maxMP ? 0.2 : 0.1;
            if (instance.isMastered((LivingEntity)player)) {
                rampageChance *= 1.5;
            }
            if ((double)player.m_217043_().m_188501_() < rampageChance) {
                MobEffectInstance effectInstance = player.m_21124_((MobEffect)TensuraMobEffects.RAMPAGE.get());
                int level = 0;
                if (effectInstance != null) {
                    level = effectInstance.m_19564_() + 1;
                }
                SkillHelper.addEffectWithSource((LivingEntity)player, (LivingEntity)player, (MobEffect)((MobEffect)TensuraMobEffects.RAMPAGE.get()), (int)1200, (int)level, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
            }
        });
        TensuraPlayerCapability.sync((Player)player);
    }

    public void onRespawn(ManasSkillInstance instance, PlayerEvent.PlayerRespawnEvent event) {
        if (instance.isToggled()) {
            instance.setToggled(false);
        }
    }

    @NotNull
    public List<MobEffect> getImmuneEffects(ManasSkillInstance instance, LivingEntity entity) {
        return POISONING;
    }
}

