/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.DirewolfEntity;
import com.github.manasmods.tensura.entity.SissieEntity;
import com.github.manasmods.tensura.entity.multipart.EvilCentipedeBody;
import com.github.manasmods.tensura.entity.multipart.TempestSerpentBody;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.variant.DirewolfVariant;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.entity.skill.LingeringSoulEntity;
import io.github.Memoires.trmysticism.registry.dimensions.MysticismDimensions;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import io.github.Memoires.trmysticism.registry.skill.UniqueSkills;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.util.damage.MysticismDamageSources;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class SephirotSkill
extends Skill {
    @Nullable
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/sephirot.png");
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public SephirotSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public double getObtainingEpCost() {
        return 250000.0;
    }

    public int getMaxMastery() {
        return 2000;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity entity, LivingHurtEvent event) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (storage.getSkill((ManasSkill)UltimateSkills.MEPHISTO.get()).isPresent()) {
            return;
        }
        if ((event.getEntity().m_21224_() || event.getEntity().m_21223_() - event.getAmount() <= 0.0f) && event.getEntity().m_21023_((MobEffect)TensuraMobEffects.DROWSINESS.get())) {
            if (event.getEntity() instanceof Player) {
                instance.decreaseCoolDown(60);
            } else {
                instance.decreaseCoolDown(10);
            }
        }
    }

    public void onTick(ManasSkillInstance instance, LivingEntity living) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)living);
        if (storage.getSkill((ManasSkill)UltimateSkills.MEPHISTO.get()).isPresent()) {
            return;
        }
        if (this.isInSlot(living) && living instanceof Player) {
            Player player = (Player)living;
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                long lastDamageTime;
                CompoundTag tag = player.getPersistentData();
                long currentTime = player.f_19853_.m_46467_();
                if (currentTime - (lastDamageTime = tag.m_128454_("NoDamageTimer")) >= 300L) {
                    double maxMP = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                    double currentMP = cap.getMagicule();
                    double mpGain = maxMP * 0.03;
                    cap.setMagicule(Math.min(currentMP + mpGain, maxMP));
                }
            });
            TensuraPlayerCapability.sync((Player)player);
        }
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        DamageSource damageSource;
        LivingEntity entity;
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)event.getEntity());
        if (storage.getSkill((ManasSkill)UltimateSkills.MEPHISTO.get()).isPresent()) {
            return;
        }
        if (!this.isInSlot(event.getEntity())) {
            return;
        }
        if (!event.isCanceled() && this.isInSlot(entity = event.getEntity()) && !(damageSource = event.getSource()).m_19378_() && !(entity.m_217043_().m_188501_() > (instance.isMastered(entity) ? 0.4f : 0.2f))) {
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
            event.setCanceled(true);
            if (SkillUtils.canNegateDodge((LivingEntity)entity, (DamageSource)damageSource)) {
                event.setCanceled(false);
            }
        }
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 2 -> 50.0;
            case 3 -> 100.0;
            case 4 -> 0.0;
            default -> 1000.0;
        };
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.sephirot.checkpoint");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.sephirot.hypnosis");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.sephirot.dream_eater");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.sephirot.life_domination");
            case 5 -> Component.m_237115_((String)"trmysticism.skill.mode.sephirot.restore_life");
            default -> Component.m_237119_();
        };
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.DREAMER.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.DREAMER.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public int modes() {
        return 5;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 5 : instance.getMode() - 1;
        }
        return instance.getMode() == 5 ? 1 : instance.getMode() + 1;
    }

    public String modeLearningId(int mode) {
        return mode == 5 ? "RestoreLife" : "None";
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            switch (instance.getMode()) {
                case 1: {
                    this.dream(instance, entity);
                    break;
                }
                case 4: {
                    SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
                    if (this.haveUpgrade(storage, entity)) {
                        return;
                    }
                    LingeringSoulEntity soul = (LingeringSoulEntity)SkillHelper.getTargetingEntity(LingeringSoulEntity.class, (LivingEntity)entity, (double)20.0, (double)0.0, (boolean)true);
                    if (soul == null || !soul.m_6084_() || !soul.hasOriginalMobData()) {
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.sephirot.life_domination.no_valid_soul").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                        }
                        return;
                    }
                    this.reviveSubordinate(instance, soul, (Player)entity);
                    this.addMasteryPoint(instance, entity, 3);
                    break;
                }
                case 5: {
                    int learnPoint = tag.m_128451_("RestoreLife");
                    if (learnPoint < 100) {
                        tag.m_128405_("RestoreLife", learnPoint + SkillUtils.getEarningLearnPoint((ManasSkillInstance)instance, (LivingEntity)entity, (boolean)true));
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            if (tag.m_128451_("RestoreLife") >= 100) {
                                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(5)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                            } else {
                                instance.setCoolDown(10);
                                SkillUtils.learningFailPenalty((LivingEntity)entity);
                                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(5)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                            }
                            player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                        instance.markDirty();
                    }
                    if (!(entity instanceof Player)) {
                        return;
                    }
                    Player player = (Player)entity;
                    LivingEntity target = (LivingEntity)SkillHelper.getTargetingEntity(LivingEntity.class, (LivingEntity)player, (double)20.0, (double)0.0, (boolean)false);
                    if (TensuraEPCapability.getPermanentOwner((LivingEntity)target) != entity.m_20148_()) {
                        return;
                    }
                    if (entity.m_6144_()) {
                        if (target.getPersistentData().m_128471_("HasSephirotEvolved")) {
                            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.sephirot.evolve.mob_already_evolved").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), false);
                            return;
                        }
                        this.evolveSubordinate(target, (Player)entity);
                        instance.addMasteryPoint(entity);
                        break;
                    }
                    this.harvestFestivalSubordinate(target, (Player)entity);
                }
            }
        }
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMastery() < 0) {
            return false;
        }
        CompoundTag tag = instance.getOrCreateTag();
        return instance.getMode() == 2 || instance.getMode() == 3 || instance.getMode() == 5 && tag.m_128451_("RestoreLife") >= 100;
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity living, int heldTicks) {
        if (instance.getMode() != 1) {
            if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)living, (ManasSkillInstance)instance)) {
                return false;
            }
            Level level = living.m_9236_();
            switch (instance.getMode()) {
                case 2: {
                    level.m_6263_((Player)null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (heldTicks % 10 == 0) {
                        TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> living), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:fallen_hypno"), living.m_19879_(), 0.0, 1.0, 0.0, true));
                    }
                    float radius = instance.isMastered(living) ? 10.0f : 5.0f;
                    List list = level.m_6443_(LivingEntity.class, living.m_20191_().m_82400_((double)radius), entity -> entity != living && entity.m_6084_() && !entity.m_7307_((Entity)living));
                    if (heldTicks % 100 == 0 && heldTicks > 0) {
                        this.addMasteryPoint(instance, living);
                    }
                    if (list.isEmpty()) break;
                    for (LivingEntity target : list) {
                        int duration;
                        if (target instanceof Player) {
                            Player player = (Player)target;
                            if (player.m_150110_().f_35934_) continue;
                        }
                        MobEffectInstance drowsiness = target.m_21124_((MobEffect)TensuraMobEffects.DROWSINESS.get());
                        int n = duration = instance.isMastered(living) ? 400 : 200;
                        if (drowsiness == null) {
                            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.DROWSINESS.get(), duration, 0, false, false));
                            continue;
                        }
                        int currentDuration = drowsiness.m_19557_();
                        if (heldTicks % 20 != 0) continue;
                        target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.DROWSINESS.get(), currentDuration + 20, 0, false, false));
                    }
                    break;
                }
                case 3: {
                    CompoundTag tag = instance.getOrCreateTag();
                    int second = tag.m_128451_("heldSeconds");
                    LivingEntity target = (LivingEntity)SkillHelper.getTargetingEntity(LivingEntity.class, (LivingEntity)living, (double)30.0, (double)0.5, (boolean)true, (boolean)true);
                    if (target != null && target.m_21023_((MobEffect)TensuraMobEffects.DROWSINESS.get())) {
                        if (tag.m_128441_("target") && !Objects.equals(tag.m_128342_("target"), target.m_20148_())) break;
                        if (heldTicks % 100 == 0 && heldTicks > 0) {
                            this.addMasteryPoint(instance, living);
                        }
                        int controlling = 5;
                        if (heldTicks % 20 == 0) {
                            tag.m_128405_("heldSeconds", second + 1);
                        }
                        if (living instanceof Player) {
                            Player player = (Player)living;
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.time_held.max", (Object[])new Object[]{second, controlling}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
                            player.m_6330_(SoundEvents.f_11867_, SoundSource.PLAYERS, 0.2f, 1.0f);
                        }
                        if (second < controlling) break;
                        DamageSource damageSource = MysticismDamageSources.dreamEater((Entity)living);
                        target.m_6469_((DamageSource)this.sourceWithMP(damageSource, living, instance), 50.0f);
                        DamageSourceHelper.directSpiritualHurt((LivingEntity)target, (Entity)living, (float)50.0f);
                        tag.m_128405_("heldSeconds", 0);
                        instance.decreaseCoolDown(30);
                        instance.addMasteryPoint(living);
                        break;
                    }
                    tag.m_128405_("heldSeconds", Math.max(0, second - 1));
                    if (tag.m_128451_("heldSeconds") <= 0) {
                        tag.m_128473_("target");
                    }
                    if (!(living instanceof Player)) break;
                    Player player = (Player)living;
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.time_held", (Object[])new Object[]{second}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
                }
            }
            return true;
        }
        return false;
    }

    private void dream(ManasSkillInstance instance, LivingEntity entity) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (this.haveUpgrade(storage, entity)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CompoundTag tag = instance.getOrCreateTag();
            if (tag.m_128471_("Dream")) {
                if (player.m_6144_()) {
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.dream.cancel").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE)), false);
                    tag.m_128379_("Dream", false);
                } else {
                    ArrayList<Object> stats = this.readStatsFromTag(tag);
                    this.restoreStats(player, stats);
                    BlockPos position = this.readLocationFromTag(tag);
                    ResourceKey<Level> dimension = this.readLevelFromTag(tag);
                    if (!player.f_19853_.m_46472_().equals(dimension)) {
                        ServerLevel targetLevel = player.m_20194_().m_129880_(dimension);
                        if (targetLevel != null && !targetLevel.m_46472_().equals(MysticismDimensions.FANTASY_WORLD)) {
                            SkillHelper.moveAcrossDimensionTo((Entity)entity, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), (float)1.0f, (float)1.0f, (ServerLevel)targetLevel);
                        } else {
                            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.mephisto.checkpoint_bad_dimension").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                        }
                    } else {
                        player.m_6021_((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_());
                    }
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.dream.restore").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE)), false);
                    instance.setCoolDown(600);
                    tag.m_128379_("Dream", false);
                }
            } else {
                ArrayList<Object> stats = this.createDream(instance, entity);
                this.writeStatsToTag(tag, stats, player);
                tag.m_128379_("Dream", true);
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.dream.create").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.LIGHT_PURPLE)), false);
            }
        }
    }

    public void onDeath(ManasSkillInstance instance, LivingDeathEvent event) {
        CompoundTag tag = instance.getOrCreateTag();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (SkillUtils.hasSkill((Entity)event.getSource().m_7639_(), (ManasSkill)((ManasSkill)UltimateSkills.SUSANOO.get()))) {
                return;
            }
            if (tag.m_128471_("Dream")) {
                event.setCanceled(true);
                event.getEntity().m_21219_();
                event.getEntity().f_19802_ = 60;
                ArrayList<Object> stats = this.readStatsFromTag(tag);
                this.restoreStats(player, stats);
                BlockPos position = this.readLocationFromTag(tag);
                ResourceKey<Level> dimension = this.readLevelFromTag(tag);
                if (!player.f_19853_.m_46472_().equals(dimension)) {
                    ServerLevel targetLevel = player.m_20194_().m_129880_(dimension);
                    if (targetLevel != null && !targetLevel.m_46472_().equals(MysticismDimensions.FANTASY_WORLD)) {
                        SkillHelper.moveAcrossDimensionTo((Entity)event.getEntity(), (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), (float)1.0f, (float)1.0f, (ServerLevel)targetLevel);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.mephisto.checkpoint_bad_dimension").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                } else {
                    player.m_6021_((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_());
                }
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.dream.death").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE)), false);
                instance.setCoolDown(1200);
                tag.m_128379_("Dream", false);
            }
        }
    }

    private ArrayList<Object> createDream(ManasSkillInstance instance, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float currentHealth = player.m_21223_();
            double currentMP = TensuraPlayerCapability.getMagicule((Player)player);
            double currentAP = TensuraPlayerCapability.getAura((Player)player);
            double currentSHP = TensuraEPCapability.getSpiritualHealth((LivingEntity)player);
            ArrayList<Object> stats = new ArrayList<Object>();
            stats.add(Float.valueOf(currentHealth));
            stats.add(currentMP);
            stats.add(currentAP);
            stats.add(currentSHP);
            return stats;
        }
        return new ArrayList<Object>();
    }

    private void restoreStats(Player player, ArrayList<Object> stats) {
        if (stats.size() == 4) {
            float health = ((Float)stats.get(0)).floatValue();
            double mp = (Double)stats.get(1);
            double ap = (Double)stats.get(2);
            double shp = (Double)stats.get(3);
            player.m_21153_(health);
            TensuraPlayerCapability.setMagicule((Player)player, (double)mp);
            TensuraPlayerCapability.setAura((Player)player, (double)ap);
            TensuraEPCapability.setSpiritualHealth((LivingEntity)player, (double)shp);
        } else {
            System.out.println("Invalid stats list!");
        }
    }

    private void writeStatsToTag(CompoundTag tag, ArrayList<Object> stats, Player player) {
        tag.m_128350_("Health", ((Float)stats.get(0)).floatValue());
        tag.m_128347_("MP", ((Double)stats.get(1)).doubleValue());
        tag.m_128347_("AP", ((Double)stats.get(2)).doubleValue());
        tag.m_128347_("SHP", ((Double)stats.get(3)).doubleValue());
        tag.m_128347_("PosX", player.m_20185_());
        tag.m_128347_("PosY", player.m_20186_());
        tag.m_128347_("PosZ", player.m_20189_());
        tag.m_128359_("Level", player.f_19853_.m_46472_().m_135782_().toString());
    }

    private ArrayList<Object> readStatsFromTag(CompoundTag tag) {
        ArrayList<Object> stats = new ArrayList<Object>();
        stats.add(Float.valueOf(tag.m_128457_("Health")));
        stats.add(tag.m_128459_("MP"));
        stats.add(tag.m_128459_("AP"));
        stats.add(tag.m_128459_("SHP"));
        return stats;
    }

    private BlockPos readLocationFromTag(CompoundTag tag) {
        double x = tag.m_128459_("PosX");
        double y = tag.m_128459_("PosY");
        double z = tag.m_128459_("PosZ");
        return new BlockPos(x, y, z);
    }

    private ResourceKey<Level> readLevelFromTag(CompoundTag tag) {
        String levelName = tag.m_128461_("Level");
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(levelName));
    }

    public void onSubordinateDeath(ManasSkillInstance instance, LivingEntity owner, LivingDeathEvent e) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)owner);
        if (storage.getSkill((ManasSkill)UltimateSkills.MEPHISTO.get()).isPresent()) {
            return;
        }
        if (!instance.isToggled()) {
            return;
        }
        LivingEntity originalEntity = e.getEntity();
        if (!(originalEntity instanceof Mob) || originalEntity.m_20270_((Entity)owner) > 30.0f || originalEntity.m_6095_().equals(TensuraEntityTypes.CLONE_DEFAULT) || originalEntity.m_6095_().equals(TensuraEntityTypes.CLONE_SLIM)) {
            return;
        }
        Level level = owner.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            try {
                LingeringSoulEntity soul = new LingeringSoulEntity(level, originalEntity.m_20183_());
                soul.setOriginalMobData(originalEntity);
                soul.m_20084_(UUID.randomUUID());
                if (!serverLevel.m_7967_((Entity)soul)) {
                    throw new RuntimeException("Failed to add LingeringSoulEntity to the server");
                }
                if (owner instanceof Player) {
                    Player player = (Player)owner;
                    player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.sephirot.life_domination.lingering_soul_spawned", (Object[])new Object[]{originalEntity.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE)), false);
                }
            }
            catch (Exception ex) {
                System.err.println("Error spawning LingeringSoulEntity: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    private void reviveSubordinate(ManasSkillInstance instance, LingeringSoulEntity soul, Player owner) {
        if (soul == null || !soul.m_6084_()) {
            return;
        }
        if (!soul.hasOriginalMobData()) {
            System.out.println("LingeringSoulEntity has no original mob data.");
            return;
        }
        Level level = soul.m_9236_();
        CompoundTag mobData = soul.getOriginalMobData();
        if (!mobData.m_128441_("id")) {
            System.out.println("Missing 'id' in mobData: " + mobData);
            owner.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.sephirot.life_domination.invalid_data").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            return;
        }
        LivingEntity dummyEntity = (LivingEntity)EntityType.m_20645_((CompoundTag)mobData, (Level)level, entity -> entity);
        if (dummyEntity == null) {
            System.out.println("Failed to load dummy entity for EP calculation.");
            return;
        }
        double magiculeCost = TensuraEPCapability.getEP((LivingEntity)dummyEntity);
        double currentMagicule = TensuraPlayerCapability.getMagicule((Player)owner);
        if (currentMagicule < magiculeCost) {
            owner.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.sephirot.life_domination.not_enough_magicule").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            return;
        }
        TensuraPlayerCapability.setMagicule((Player)owner, (double)(currentMagicule - magiculeCost));
        TensuraPlayerCapability.sync((Player)owner);
        LivingEntity revivedEntity = (LivingEntity)EntityType.m_20645_((CompoundTag)mobData, (Level)level, entity -> entity);
        if (revivedEntity != null) {
            if (revivedEntity.getPersistentData().m_128471_("is_display")) {
                owner.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.mephisto.life_domination.message.is_display").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                return;
            }
            CompoundTag tags = revivedEntity.getPersistentData();
            tags.m_128379_("NO_EP_PLUNDER", true);
            tags.m_128379_("NO_SKILL_PLUNDER", true);
            tags.m_128379_("no_loot", true);
            revivedEntity.m_21153_(revivedEntity.m_21233_() / 10.0f);
            revivedEntity.m_21219_();
            level.m_5594_(null, revivedEntity.m_20183_(), SoundEvents.f_12513_, SoundSource.NEUTRAL, 2.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)revivedEntity, (ParticleOptions)ParticleTypes.f_123767_, (double)2.0);
            revivedEntity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 1));
            revivedEntity.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 200, 3));
            this.clearInventory(revivedEntity);
            level.m_7967_((Entity)revivedEntity);
            if (instance.isMastered((LivingEntity)owner)) {
                instance.setCoolDown(20);
            } else {
                instance.setCoolDown(60);
            }
            if (!level.m_5776_()) {
                soul.m_146870_();
            }
            owner.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.sephirot.life_domination.subordinate_revived", (Object[])new Object[]{revivedEntity.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
        } else {
            System.out.println("Failed to revive entity from mobData: " + mobData);
        }
    }

    private void clearInventory(LivingEntity revivedEntity) {
        if (revivedEntity instanceof HumanoidNPCEntity) {
            HumanoidNPCEntity humanoidNPCEntity = (HumanoidNPCEntity)revivedEntity;
            humanoidNPCEntity.inventory.m_6211_();
        } else if (revivedEntity instanceof DirewolfEntity) {
            DirewolfEntity direwolf = (DirewolfEntity)revivedEntity;
            direwolf.inventory.m_6211_();
        } else if (revivedEntity instanceof SissieEntity) {
            SissieEntity sissie = (SissieEntity)revivedEntity;
            sissie.inventory.m_6211_();
        } else if (revivedEntity instanceof EvilCentipedeBody) {
            EvilCentipedeBody evilCentipede = (EvilCentipedeBody)revivedEntity;
            evilCentipede.inventory.m_6211_();
        } else if (revivedEntity instanceof TempestSerpentBody) {
            TempestSerpentBody tempestSerpent = (TempestSerpentBody)revivedEntity;
            tempestSerpent.inventory.m_6211_();
        } else if (revivedEntity instanceof SissieEntity) {
            SissieEntity sissie = (SissieEntity)revivedEntity;
            sissie.inventory.m_6211_();
        }
        revivedEntity.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_41852_, 100));
        revivedEntity.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.f_41852_, 100));
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            revivedEntity.m_8061_(slot, ItemStack.f_41583_);
        }
    }

    private void evolveSubordinate(LivingEntity target, Player owner) {
        TensuraPlayerCapability.getFrom((Player)owner).ifPresent(ownerCap -> {
            int evolutionCost;
            int ownerSoulPoints = ownerCap.getSoulPoints();
            int n = evolutionCost = target instanceof Player ? 2000000 : 1000000;
            if (ownerSoulPoints < evolutionCost) {
                owner.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.sephirot.evolve.not_enough_souls", (Object[])new Object[]{evolutionCost / 1000}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                return;
            }
            if (target instanceof Player) {
                Player player = (Player)target;
                TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                    Race nextRace = cap.getTrackedEvolution();
                    if (nextRace == null) {
                        nextRace = cap.getRace().getDefaultEvolution(player);
                    }
                    if (nextRace != null) {
                        ownerCap.setSoulPoints(ownerSoulPoints - evolutionCost);
                        TensuraPlayerCapability.sync((Player)owner);
                        owner.m_9236_().m_6263_((Player)null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), SoundEvents.f_11887_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        cap.setRace((LivingEntity)player, nextRace, true);
                        TensuraPlayerCapability.sync((Player)player);
                        player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12496_, SoundSource.PLAYERS, 2.0f, 1.0f);
                        owner.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.sephirot.evolve.player_success", (Object[])new Object[]{player.m_7755_(), nextRace.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
                        player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.sephirot.evolve.self_evolved", (Object[])new Object[]{nextRace.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
                    } else {
                        owner.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.sephirot.evolve.no_evolution").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                });
            } else {
                DirewolfEntity direwolf;
                if (target instanceof DirewolfEntity && (direwolf = (DirewolfEntity)target).getVariant().getId() == 14) {
                    direwolf.setVariant(DirewolfVariant.TEMPEST_STAR_WOLF);
                    direwolf.setSize(direwolf.getSize() + 0.5f);
                    direwolf.setMaxSize(direwolf.getMaxSize() + 0.5f);
                    SkillStorage storage = SkillAPI.getSkillsFrom((Entity)direwolf);
                    storage.learnSkill((ManasSkill)ExtraSkills.BLACK_LIGHTNING.get());
                    ManasSkillInstance instance = new ManasSkillInstance((ManasSkill)ExtraSkills.ULTRA_INSTINCT.get());
                    instance.setToggled(true);
                    storage.learnSkill(instance);
                }
                TensuraEPCapability.getFrom((LivingEntity)target).ifPresent(cap -> {
                    CompoundTag mobData = target.getPersistentData();
                    if (mobData.m_128471_("HasSephirotEvolved")) {
                        owner.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.sephirot.evolve.mob_already_evolved").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                        return;
                    }
                    ownerCap.setSoulPoints(ownerSoulPoints - evolutionCost);
                    TensuraPlayerCapability.sync((Player)owner);
                    owner.m_9236_().m_6263_((Player)null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), SoundEvents.f_11887_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    double currentEP = TensuraEPCapability.getEP((LivingEntity)target);
                    TensuraEPCapability.setLivingEP((LivingEntity)target, (double)(currentEP * 1.5));
                    mobData.m_128379_("HasSephirotEvolved", true);
                    target.m_9236_().m_6263_((Player)null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12496_, SoundSource.NEUTRAL, 2.0f, 1.0f);
                    owner.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.sephirot.evolve.mob_success", (Object[])new Object[]{target.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
                });
            }
        });
    }

    private void harvestFestivalSubordinate(LivingEntity target, Player owner) {
        if (target instanceof Player) {
            if (TensuraPlayerCapability.isTrueDemonLord((Player)((Player)target))) {
                owner.m_5661_((Component)Component.m_237115_((String)"tensura.evolve.demon_lord.already").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                return;
            }
            if (TensuraPlayerCapability.isTrueHero((LivingEntity)target)) {
                owner.m_5661_((Component)Component.m_237115_((String)"tensura.evolve.demon_lord.hero").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                return;
            }
            TensuraPlayerCapability.getFrom((Player)owner).ifPresent(ownerCap -> {
                int harvestFestivalCost;
                int ownerSoulPoints = ownerCap.getSoulPoints();
                if (ownerSoulPoints < (harvestFestivalCost = 20000000)) {
                    owner.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.sephirot.evolve.not_enough_souls", (Object[])new Object[]{harvestFestivalCost / 1000}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    return;
                }
                TensuraPlayerCapability.getFrom((Player)((Player)target)).ifPresent(cap -> {
                    if (!cap.isDemonLordSeed()) {
                        owner.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.sephirot.evolve.target_not_seed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    } else {
                        ownerCap.setSoulPoints(ownerCap.getSoulPoints() - harvestFestivalCost);
                        RaceHelper.awakening((Player)((Player)target), (boolean)false);
                    }
                });
            });
        }
    }

    private boolean haveUpgrade(SkillStorage storage, LivingEntity entity) {
        if (storage.getSkill((ManasSkill)UltimateSkills.MEPHISTO.get()).isPresent()) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.dreamer_line.have_upgrade").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
            return true;
        }
        return false;
    }
}

