/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.manascore.attribute.ManasCoreAttributes;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.google.common.collect.ImmutableList;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import io.github.Memoires.trmysticism.util.TimerUtils;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.jetbrains.annotations.NotNull;

public class SusanooSkill
extends Skill {
    public static final ImmutableList<MobEffect> SPACE_TIME;
    public static final UUID SUSANOO;
    protected static final UUID ACCELERATION;
    protected static final UUID COUNTERING;

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/susanoo.png");
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public int getMaxMastery() {
        return 2000;
    }

    public SusanooSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public int getMasteryOnEPAcquirement(@NotNull Player entity) {
        return 0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().f_46443_) {
            return false;
        }
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)this)) {
            return false;
        }
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.COOK.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, @NotNull LivingEntity entity, @NotNull UnlockSkillEvent event) {
        if (entity.m_9236_().f_46443_) {
            return;
        }
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)((Skill)instance.getSkill()))) {
            return;
        }
        Skill previousSkill = (Skill)UniqueSkills.COOK.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom(player).ifPresent(cap -> cap.setCurrentUltimates(cap.getCurrentUltimates() + 1));
            }
            if (player.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE) && !player.m_7500_() && instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                storage.getSkill((ManasSkill)previousSkill).ifPresent(s -> storage.forgetSkill((ManasSkill)previousSkill));
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public int modes() {
        return 2;
    }

    public double getObtainingEpCost() {
        return 750000.0;
    }

    public boolean canBeToggled(@NotNull ManasSkillInstance instance, @NotNull LivingEntity living) {
        return true;
    }

    @NotNull
    public String modeLearningId(int mode) {
        return mode == 1 ? "TrueChaoticFate" : "None";
    }

    public boolean canTick(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        return instance.isToggled();
    }

    @NotNull
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.susanoo.true_chaotic_fate");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.susanoo.counter");
            default -> Component.m_237119_();
        };
    }

    public int nextMode(@NotNull LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    public void onBeingDamaged(ManasSkillInstance instance, @NotNull LivingAttackEvent event) {
        if (instance.getOrCreateTag().m_128471_("CounterActive")) {
            event.setCanceled(true);
            LivingEntity attacker = (LivingEntity)event.getSource().m_7639_();
            if (attacker instanceof Player) {
                Player attackerPlayer = (Player)attacker;
                attackerPlayer.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.susanoo.counter.countered").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
            if (attacker != null) {
                AttributeInstance attackSpeedAttribute;
                attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_11665_, SoundSource.PLAYERS, 0.5f, 0.5f);
                AttributeInstance counteringAttackSpeed = event.getEntity().m_21051_(Attributes.f_22279_);
                AttributeInstance counteringAttackDamage = event.getEntity().m_21051_(Attributes.f_22281_);
                if (counteringAttackSpeed != null && counteringAttackDamage != null) {
                    counteringAttackSpeed.m_22127_(COUNTERING);
                    counteringAttackDamage.m_22127_(COUNTERING);
                }
                if ((attackSpeedAttribute = attacker.m_21051_(Attributes.f_22283_)) != null) {
                    UUID counteringModifier = UUID.fromString("64eebda2-96d2-4f89-92d1-37b3d6bbf48e");
                    attackSpeedAttribute.m_22125_(new AttributeModifier(counteringModifier, "Being Countered Atk Speed", -1000.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
                    attackSpeedAttribute.m_22120_(counteringModifier);
                    TimerUtils.Timer timer = TimerUtils.getOrCreateTimer("SusanooCounter");
                    if (!instance.isMastered(event.getEntity())) {
                        timer.start(100, () -> {
                            attackSpeedAttribute.m_22120_(counteringModifier);
                            timer.stop();
                            timer.reset();
                        });
                    } else {
                        timer.start(200, () -> {
                            attackSpeedAttribute.m_22120_(counteringModifier);
                            timer.stop();
                            timer.reset();
                        });
                    }
                    instance.getOrCreateTag().m_128379_("CounterActive", false);
                }
            }
        }
    }

    public void onToggleOn(@NotNull ManasSkillInstance skillInstance, @NotNull LivingEntity entity) {
        this.onToggle(skillInstance, entity, true);
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)skillInstance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)true);
    }

    private void onToggle(ManasSkillInstance instance, LivingEntity entity, boolean on) {
        if (on) {
            AttributeModifier critMultiplierModifier;
            AttributeInstance critMultiplier;
            AttributeModifier critChanceModifier;
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            AttributeInstance critChance = entity.m_21051_((Attribute)ManasCoreAttributes.CRIT_CHANCE.get());
            if (critChance != null && !critChance.m_22109_(critChanceModifier = new AttributeModifier(SUSANOO, "Susano'o", 100.0, AttributeModifier.Operation.ADDITION))) {
                critChance.m_22125_(critChanceModifier);
            }
            if ((critMultiplier = entity.m_21051_((Attribute)ManasCoreAttributes.CRIT_MULTIPLIER.get())) != null && !critMultiplier.m_22109_(critMultiplierModifier = new AttributeModifier(SUSANOO, "Susano'o", instance.isMastered(entity) ? 1.0 : 0.5, AttributeModifier.Operation.ADDITION))) {
                critMultiplier.m_22125_(critMultiplierModifier);
            }
        } else {
            AttributeInstance critMultiplier;
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 0.5f, 0.5f);
            AttributeInstance critChance = entity.m_21051_((Attribute)ManasCoreAttributes.CRIT_CHANCE.get());
            if (critChance != null) {
                critChance.m_22127_(SUSANOO);
            }
            if ((critMultiplier = entity.m_21051_((Attribute)ManasCoreAttributes.CRIT_MULTIPLIER.get())) != null) {
                critMultiplier.m_22127_(SUSANOO);
            }
        }
    }

    public void onTick(@NotNull ManasSkillInstance instance, @NotNull LivingEntity entity) {
        if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.lack_magicule.toggled_off", (Object[])new Object[]{instance.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
            instance.setToggled(false);
        } else {
            CompoundTag tag = instance.getOrCreateTag();
            int time = tag.m_128451_("activatedTimes");
            if (time % 6 == 0) {
                this.addMasteryPoint(instance, entity);
            }
            tag.m_128405_("activatedTimes", time + 1);
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get(), 200, 1, false, false, false));
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.HEAT_SENSE.get(), 200, 0, false, false, false));
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get(), 200, 0, false, false, false));
        }
    }

    public void onToggleOff(@NotNull ManasSkillInstance skillInstance, LivingEntity entity) {
        int level;
        if (entity.m_21023_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get()) && (level = Objects.requireNonNull(entity.m_21124_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get())).m_19564_()) == 1) {
            entity.m_21195_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get());
        }
        entity.m_21195_((MobEffect)TensuraMobEffects.HEAT_SENSE.get());
        entity.m_21195_((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get());
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)skillInstance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)false);
        this.onToggle(skillInstance, entity, false);
    }

    public void onDamageEntity(ManasSkillInstance instance, @NotNull LivingEntity entity, @NotNull LivingHurtEvent e) {
        LivingEntity target;
        if (instance.isToggled() && !(TensuraEPCapability.getEP((LivingEntity)(target = e.getEntity())) > TensuraEPCapability.getEP((LivingEntity)entity) * 2.0)) {
            AttributeInstance attribute = target.m_21051_((Attribute)TensuraAttributeRegistry.BARRIER.get());
            if (attribute != null) {
                attribute.m_22132_();
            }
            entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_11983_, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
    }

    public void onTouchEntity(ManasSkillInstance instance, @NotNull LivingEntity entity, @NotNull LivingHurtEvent event) {
        LivingEntity target;
        AttributeInstance health;
        CompoundTag tag = instance.getOrCreateTag();
        if (this.activatedChaoticFate(instance) && !instance.onCoolDown() && (health = (target = event.getEntity()).m_21051_(Attributes.f_22276_)) != null) {
            double amount = event.getAmount();
            AttributeModifier chefModifier = health.m_22111_(SUSANOO);
            if (chefModifier != null) {
                amount -= chefModifier.m_22218_();
            }
            AttributeModifier attributemodifier = new AttributeModifier(SUSANOO, "Susanoo", amount * -1.0, AttributeModifier.Operation.ADDITION);
            health.m_22130_(attributemodifier);
            health.m_22125_(attributemodifier);
            if (!instance.isMastered(entity)) {
                tag.m_128379_("TrueChaoticFateActivated", false);
            }
            this.addMasteryPoint(instance, entity);
            instance.setCoolDown(1);
            entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_12052_, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
    }

    public void onPressed(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        if (instance.getMode() == 1) {
            CompoundTag tag = instance.getOrCreateTag();
            int learnPoint = tag.m_128451_("TrueChaoticFate");
            if (learnPoint < 100) {
                tag.m_128405_("TrueChaoticFate", learnPoint + SkillUtils.getEarningLearnPoint((ManasSkillInstance)instance, (LivingEntity)entity, (boolean)true));
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (tag.m_128451_("TrueChaoticFate") >= 100) {
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(1)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    } else {
                        instance.setCoolDown(10);
                        SkillUtils.learningFailPenalty((LivingEntity)entity);
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(1)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                    }
                    player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else if (entity.m_6144_()) {
                AttributeInstance health;
                LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)6.0, (boolean)false);
                if (target == null || !target.m_6084_()) {
                    target = entity;
                }
                if ((health = target.m_21051_(Attributes.f_22276_)) == null) {
                    return;
                }
                if (health.m_22111_(SUSANOO) != null) {
                    health.m_22127_(SUSANOO);
                    instance.setCoolDown(1);
                    entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123749_);
                }
            } else {
                boolean activated = tag.m_128471_("TrueChaoticFateActivated");
                tag.m_128379_("TrueChaoticFateActivated", !activated);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), activated ? SoundEvents.f_11824_ : SoundEvents.f_11767_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        } else {
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11671_, SoundSource.PLAYERS, 0.5f, 0.5f);
            TimerUtils.Timer timer = TimerUtils.getOrCreateTimer("Susano'o");
            CompoundTag tag = instance.getOrCreateTag();
            boolean active = true;
            tag.m_128379_("CounterActive", active);
            AttributeInstance counteringAtkSpeed = entity.m_21051_(Attributes.f_22279_);
            AttributeModifier counteringAtkSpeedModifier = new AttributeModifier(COUNTERING, "Countering", -1000.0, AttributeModifier.Operation.ADDITION);
            if (counteringAtkSpeed != null && !counteringAtkSpeed.m_22109_(counteringAtkSpeedModifier)) {
                counteringAtkSpeed.m_22125_(counteringAtkSpeedModifier);
            }
            AttributeInstance counteringAtkDamage = entity.m_21051_(Attributes.f_22281_);
            AttributeModifier counteringAtkDamageModifier = new AttributeModifier(COUNTERING, "Countering", -1000.0, AttributeModifier.Operation.ADDITION);
            if (counteringAtkDamage != null && !counteringAtkDamage.m_22109_(counteringAtkDamageModifier)) {
                counteringAtkDamage.m_22125_(counteringAtkDamageModifier);
            }
            timer.start(60, () -> {
                tag.m_128379_("CounterActive", !active);
                if (counteringAtkSpeed != null) {
                    counteringAtkSpeed.m_22127_(COUNTERING);
                }
                if (counteringAtkDamage != null) {
                    counteringAtkDamage.m_22127_(COUNTERING);
                }
                timer.stop();
                timer.reset();
            });
            instance.setCoolDown(20);
            instance.addMasteryPoint(entity);
        }
    }

    private boolean activatedChaoticFate(ManasSkillInstance instance) {
        CompoundTag tag = instance.getOrCreateTag();
        if (tag.m_128451_("TrueChaoticFate") < 100) {
            return false;
        }
        return tag.m_128471_("TrueChaoticFateActivated");
    }

    @NotNull
    public List<MobEffect> getImmuneEffects(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        return !instance.isToggled() ? new ArrayList() : SPACE_TIME;
    }

    static {
        SUSANOO = UUID.fromString("7c4a2f42-c3ba-4d5f-9bda-5c912b3b8abc");
        ACCELERATION = UUID.fromString("9cc54e77-84f6-4323-8439-423a193cec1e");
        COUNTERING = UUID.fromString("7439ab52-812e-4f4b-8e0f-79d0f3de4b4c");
        SPACE_TIME = ImmutableList.of((Object)((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get()), (Object)((MobEffect)TensuraMobEffects.BURDEN.get()), (Object)MobEffects.f_19597_, (Object)MobEffects.f_19599_, (Object)((MobEffect)TensuraMobEffects.OPPRESSION.get()), (Object)((MobEffect)MysticismMobEffects.TIMESTOP.get()));
    }
}

