/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.manascore.attribute.ManasCoreAttributes;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.battlewill.Battewill;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.battlewill.MeleeArts;
import com.github.manasmods.tensura.registry.battlewill.UtilityArts;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class TakemikazuchiSkill
extends Skill {
    protected static final UUID ACCELERATION = UUID.fromString("3f2504e0-4f89-11d3-9a0c-0305e82c3301");
    protected static final UUID ATTACK_SPEED = UUID.fromString("0363b77e-9322-4f4c-9736-87339c7f8fc2");

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/takemikazuchi.png");
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public int getMaxMastery() {
        return 2000;
    }

    public TakemikazuchiSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return instance.getMastery() >= 0;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public void onTick(ManasSkillInstance instance, LivingEntity living) {
        if (this.isInSlot(living) && living instanceof Player) {
            Player player = (Player)living;
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                double maxAP = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_AURA.get());
                double currentAP = cap.getAura();
                double auraGain = maxAP * 0.01;
                cap.setAura(Math.min(currentAP + auraGain, maxAP));
            });
            TensuraPlayerCapability.sync((Player)player);
        }
    }

    public double auraCost(LivingEntity entity, ManasSkillInstance instance) {
        return 100000.0;
    }

    public double getObtainingEpCost() {
        return 300000.0;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.MARTIAL_MASTER.get(), (TensuraSkill)UtilityArts.BATTLEWILL.get(), (TensuraSkill)MeleeArts.OGRE_SWORD_GUILLOTINE.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.MARTIAL_MASTER.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        DamageSource damageSource;
        LivingEntity entity;
        if (!(event.isCanceled() || !this.isInSlot(entity = event.getEntity()) || (damageSource = event.getSource()).m_19378_() || damageSource.m_19387_() || damageSource.m_7640_() == null || damageSource.m_7640_() != damageSource.m_7639_() || entity.m_217043_().m_188501_() > 0.25f)) {
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
            event.setCanceled(true);
            if (SkillUtils.canNegateDodge((LivingEntity)entity, (DamageSource)damageSource)) {
                event.setCanceled(false);
            }
        }
    }

    public void onProjectileHit(ManasSkillInstance instance, LivingEntity entity, ProjectileImpactEvent event) {
        if (this.isInSlot(entity) && !SkillUtils.isProjectileAlwaysHit((Projectile)event.getProjectile())) {
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
            event.setCanceled(true);
        }
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        DamageSource source;
        if (instance.isToggled() && !SkillUtils.isSkillToggled((Entity)attacker, (ManasSkill)((ManasSkill)UniqueSkills.MARTIAL_MASTER.get())) && (source = e.getSource()).m_7640_() == attacker) {
            TensuraDamageSource damageSource;
            if (source instanceof TensuraDamageSource && (damageSource = (TensuraDamageSource)source).getSkill() != null && damageSource.getSkill().getSkill() instanceof Battewill) {
                if (!instance.isMastered(e.getEntity())) {
                    e.setAmount(e.getAmount() * 5.0f);
                } else {
                    e.setAmount(e.getAmount() * 10.0f);
                }
                return;
            }
            if (DamageSourceHelper.isPhysicalAttack((DamageSource)source)) {
                if (!instance.isMastered(attacker)) {
                    e.setAmount((float)((double)e.getAmount() * 4.0));
                } else {
                    e.setAmount((float)((double)e.getAmount() * 9.0));
                }
            }
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if ((entity.m_20096_() || entity.m_20072_()) && !SkillHelper.outOfAura((LivingEntity)entity, (ManasSkillInstance)instance)) {
            this.addMasteryPoint(instance, entity);
            Level level = entity.m_9236_();
            int range = instance.isMastered(entity) ? 25 : 20;
            BlockHitResult result = SkillHelper.getPlayerPOVHitResult((Level)level, (Entity)entity, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)range);
            BlockPos resultPos = result.m_82425_().m_121945_(result.m_82434_());
            Vec3 vec3 = SkillHelper.getFloorPos((BlockPos)resultPos);
            if (!level.m_8055_(resultPos).m_60767_().m_76336_()) {
                vec3 = SkillHelper.getFloorPos((BlockPos)resultPos.m_7494_());
            }
            if (level.m_8055_(resultPos).m_60713_((Block)TensuraBlocks.LABYRINTH_BARRIER_BLOCK.get())) {
                level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else if (!entity.m_9236_().m_6857_().m_61937_(new BlockPos(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_()))) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.teleport.out_border").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
            } else {
                Vec3 source = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
                Vec3 offSetToTarget = vec3.m_82546_(source);
                for (int particleIndex = 1; particleIndex < Mth.m_14107_((double)offSetToTarget.m_82553_()); ++particleIndex) {
                    Vec3 particlePos = source.m_82549_(offSetToTarget.m_82541_().m_82490_((double)particleIndex));
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123796_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                    TensuraParticleHelper.addServerParticlesAroundPos((RandomSource)entity.m_217043_(), (Level)level, (Vec3)particlePos, (ParticleOptions)ParticleTypes.f_123766_, (double)3.0);
                    TensuraParticleHelper.addServerParticlesAroundPos((RandomSource)entity.m_217043_(), (Level)level, (Vec3)particlePos, (ParticleOptions)ParticleTypes.f_123766_, (double)2.0);
                    AABB aabb = new AABB(new BlockPos(particlePos)).m_82400_(Math.max(entity.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get()), 2.0));
                    List livingEntityList = level.m_6443_(LivingEntity.class, aabb, targetx -> !targetx.m_7306_((Entity)entity) && !targetx.m_7307_((Entity)entity));
                    if (livingEntityList.isEmpty()) continue;
                    float bonus = instance.isMastered(entity) ? 300.0f : 75.0f;
                    float amount = (float)(entity.m_21133_(Attributes.f_22281_) * entity.m_21133_((Attribute)ManasCoreAttributes.CRIT_MULTIPLIER.get()));
                    for (LivingEntity target : livingEntityList) {
                        int multiplier;
                        int n = multiplier = instance.isMastered(entity) ? 10 : 5;
                        if (!target.m_6469_((DamageSource)this.sourceWithMP(DamageSource.m_19370_((LivingEntity)entity), entity, instance), (amount + bonus) * (float)multiplier)) continue;
                        ItemStack stack = entity.m_21205_();
                        stack.m_41720_().m_7579_(stack, target, entity);
                        entity.m_9236_().m_6263_((Player)null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12313_, entity.m_5720_(), 1.0f, 1.0f);
                        if (!(level instanceof ServerLevel)) continue;
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_7726_().m_8394_((Entity)entity, (Packet)new ClientboundAnimatePacket((Entity)entity, 4));
                    }
                }
                entity.m_183634_();
                entity.m_19877_();
                entity.m_20219_(vec3);
                entity.f_19812_ = true;
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)true);
        this.onToggle(instance, entity, ATTACK_SPEED, true);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)false);
        this.onToggle(instance, entity, ATTACK_SPEED, false);
    }

    private void onToggle(ManasSkillInstance instance, LivingEntity entity, UUID uuid, boolean on) {
        if (on) {
            AttributeModifier attackSpeedModifier;
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            AttributeInstance attackSpeed = entity.m_21051_(Attributes.f_22283_);
            if (attackSpeed != null && !attackSpeed.m_22109_(attackSpeedModifier = new AttributeModifier(uuid, "Takemikazuchi", 2.0, AttributeModifier.Operation.ADDITION))) {
                attackSpeed.m_22125_(attackSpeedModifier);
            }
        } else {
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 0.5f, 0.5f);
            AttributeInstance attackSpeed = entity.m_21051_(Attributes.f_22283_);
            if (attackSpeed != null) {
                attackSpeed.m_22127_(ATTACK_SPEED);
            }
        }
    }
}

