/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.manascore.attribute.ManasCoreAttributes;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.human.CloneEntity;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.world.TensuraGameRules;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class TsukuyomiSkill
extends Skill {
    public static final UUID TSUKUYOMI = UUID.fromString("ff1ba7e1-9b9a-4580-8f6f-c5db93f93651");
    protected static final UUID ACCELERATION = UUID.fromString("8f08f72d-014b-4b4b-8560-987a0375959d");

    public TsukuyomiSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public int getMaxMastery() {
        return 2000;
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/tsukuyomi.png");
    }

    public double getObtainingEpCost() {
        return 300000.0;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.SHADOW_STRIKER.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
            Player player;
            Player player2;
            Player player3;
            Skill multilayer = (Skill)ExtraSkills.MULTILAYER_BARRIER.get();
            if (entity instanceof Player && !(player3 = (Player)entity).m_7500_()) {
                double cost = multilayer.getObtainingEpCost() * (double)player3.f_19853_.m_46469_().m_46215_(TensuraGameRules.MP_SKILL_COST) / 100.0;
                TensuraPlayerCapability.getFrom((Player)player3).ifPresent(cap -> {
                    cap.setBaseMagicule(cap.getBaseMagicule() + cost, (LivingEntity)player3, false);
                    TensuraPlayerCapability.sync((Player)player3);
                });
            }
            if (SkillUtils.learnSkill((LivingEntity)entity, (ManasSkill)multilayer) && entity instanceof Player) {
                player3 = (Player)entity;
                player3.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{multilayer.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            }
            Skill spatialManipulation = (Skill)ExtraSkills.SPATIAL_MANIPULATION.get();
            if (entity instanceof Player && !(player2 = (Player)entity).m_7500_()) {
                double cost = spatialManipulation.getObtainingEpCost() * (double)player2.f_19853_.m_46469_().m_46215_(TensuraGameRules.MP_SKILL_COST) / 100.0;
                TensuraPlayerCapability.getFrom((Player)player2).ifPresent(cap -> {
                    cap.setBaseMagicule(cap.getBaseMagicule() + cost, (LivingEntity)player2, false);
                    TensuraPlayerCapability.sync((Player)player2);
                });
            }
            if (SkillUtils.learnSkill((LivingEntity)entity, (ManasSkill)spatialManipulation) && entity instanceof Player) {
                Player player4 = (Player)entity;
                player4.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{spatialManipulation.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            }
            Skill spiritualNull = (Skill)ResistanceSkills.SPIRITUAL_ATTACK_NULLIFICATION.get();
            if (entity instanceof Player && !(player = (Player)entity).m_7500_()) {
                double cost = spiritualNull.getObtainingEpCost() * (double)player.f_19853_.m_46469_().m_46215_(TensuraGameRules.MP_SKILL_COST) / 100.0;
                TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                    cap.setBaseMagicule(cap.getBaseMagicule() + cost, (LivingEntity)player, false);
                    TensuraPlayerCapability.sync((Player)player);
                });
            }
            if (SkillUtils.learnSkill((LivingEntity)entity, (ManasSkill)spiritualNull) && entity instanceof Player) {
                Player player5 = (Player)entity;
                player5.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{spiritualNull.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            }
        }
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.SHADOW_STRIKER.get(), (TensuraSkill)ExtraSkills.BODY_DOUBLE.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public int modes() {
        return 4;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 4 : instance.getMode() - 1;
        }
        return instance.getMode() == 4 ? 1 : instance.getMode() + 1;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 2 -> 350000.0;
            case 3 -> 0.0;
            case 4 -> 75000.0;
            default -> 50000.0;
        };
    }

    public double auraCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 3 -> 100000.0;
            default -> 0.0;
        };
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled();
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.tsukuyomi.eye_of_the_moon");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.tsukuyomi.insta_kill");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.tsukuyomi.lightspeed_acceleration");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.tsukuyomi.parallel_existence");
            default -> Component.m_237119_();
        };
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            switch (instance.getMode()) {
                case 1: {
                    this.eyeOfTheMoon(instance, entity);
                    break;
                }
                case 3: {
                    this.ultraspeedAction(instance, entity);
                }
            }
        }
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMastery() < 0) {
            return false;
        }
        return instance.getMode() == 1 || instance.getMode() == 3;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return instance.getMastery() >= 0;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        DamageSource source;
        if (this.isInSlot(attacker) && instance.getMode() == 2 && !instance.onCoolDown() && (source = e.getSource()).m_7639_() == attacker && DamageSourceHelper.isPhysicalAttack((DamageSource)source) && !SkillHelper.outOfMagicule((LivingEntity)attacker, (ManasSkillInstance)instance)) {
            LivingEntity living = e.getEntity();
            float targetMaxSHP = (float)living.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
            if (!instance.isMastered(attacker) && SkillUtils.hasSkill((Entity)living, (ManasSkill)((ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_NULLIFICATION.get()))) {
                DamageSourceHelper.directSpiritualHurt((LivingEntity)living, (Entity)attacker, (float)(10000.0f + targetMaxSHP * 0.25f));
            } else if (SkillUtils.hasSkill((Entity)living, (ManasSkill)((ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_RESISTANCE.get()))) {
                DamageSourceHelper.directSpiritualHurt((LivingEntity)living, (Entity)attacker, (float)(5000.0f + targetMaxSHP * 0.5f));
            } else {
                DamageSourceHelper.directSpiritualHurt((LivingEntity)living, (Entity)attacker, (float)Float.MAX_VALUE);
            }
            instance.setCoolDown(instance.isMastered(living) ? 5 : 10);
            if (!living.m_6084_()) {
                e.setCanceled(true);
            }
        }
        if (instance.isToggled() && DamageSourceHelper.isSpatialDamage((DamageSource)e.getSource())) {
            e.setAmount(e.getAmount() * 2.0f);
        }
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)true);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)false);
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.isToggled()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get(), 200, 1, false, false, false));
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.HEAT_SENSE.get(), 200, 0, false, false, false));
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get(), 200, 0, false, false, false));
        }
    }

    private void ultraspeedAction(ManasSkillInstance instance, LivingEntity entity) {
        if ((entity.m_20096_() || entity.m_20072_()) && !SkillHelper.outOfAura((LivingEntity)entity, (ManasSkillInstance)instance)) {
            this.addMasteryPoint(instance, entity);
            Level level = entity.m_9236_();
            int range = instance.isMastered(entity) ? 25 : 20;
            BlockHitResult result = SkillHelper.getPlayerPOVHitResult((Level)level, (Entity)entity, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)range);
            BlockPos resultPos = result.m_82425_().m_121945_(result.m_82434_());
            Vec3 vec3 = SkillHelper.getFloorPos((BlockPos)resultPos);
            if (!level.m_8055_(resultPos).m_60767_().m_76336_()) {
                vec3 = SkillHelper.getFloorPos((BlockPos)resultPos.m_7494_());
            }
            if (level.m_8055_(resultPos).m_60713_((Block)TensuraBlocks.LABYRINTH_BARRIER_BLOCK.get())) {
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else if (!entity.m_9236_().m_6857_().m_61937_(new BlockPos(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_()))) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.teleport.out_border").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
            } else {
                Vec3 source = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
                Vec3 offSetToTarget = vec3.m_82546_(source);
                for (int particleIndex = 1; particleIndex < Mth.m_14107_((double)offSetToTarget.m_82553_()); ++particleIndex) {
                    Vec3 particlePos = source.m_82549_(offSetToTarget.m_82541_().m_82490_((double)particleIndex));
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123796_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                    TensuraParticleHelper.addServerParticlesAroundPos((RandomSource)entity.m_217043_(), (Level)level, (Vec3)particlePos, (ParticleOptions)ParticleTypes.f_123766_, (double)3.0);
                    TensuraParticleHelper.addServerParticlesAroundPos((RandomSource)entity.m_217043_(), (Level)level, (Vec3)particlePos, (ParticleOptions)ParticleTypes.f_123766_, (double)2.0);
                    AABB aabb = new AABB(new BlockPos(particlePos)).m_82400_(Math.max(entity.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get()), 2.0));
                    List livingEntityList = level.m_6443_(LivingEntity.class, aabb, targetx -> !targetx.m_7306_((Entity)entity) && !targetx.m_7307_((Entity)entity));
                    if (livingEntityList.isEmpty()) continue;
                    float bonus = instance.isMastered(entity) ? 300.0f : 75.0f;
                    float amount = (float)(entity.m_21133_(Attributes.f_22281_) * entity.m_21133_((Attribute)ManasCoreAttributes.CRIT_MULTIPLIER.get()));
                    for (LivingEntity target : livingEntityList) {
                        float targetMaxSHP = (float)target.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
                        if (!target.m_6469_((DamageSource)this.sourceWithMP(DamageSource.m_19370_((LivingEntity)entity), entity, instance), amount + bonus)) continue;
                        if (!instance.isMastered(entity)) {
                            DamageSourceHelper.directSpiritualHurt((LivingEntity)target, (Entity)entity, (float)(targetMaxSHP * 0.5f));
                        } else if (SkillUtils.hasSkill((Entity)target, (ManasSkill)((ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_NULLIFICATION.get()))) {
                            if (entity.m_217043_().m_188501_() > 0.25f) {
                                DamageSourceHelper.directSpiritualHurt((LivingEntity)target, (Entity)entity, (float)Float.MAX_VALUE);
                            } else {
                                DamageSourceHelper.directSpiritualHurt((LivingEntity)target, (Entity)entity, (float)(targetMaxSHP * 0.5f));
                            }
                        } else if (SkillUtils.hasSkill((Entity)target, (ManasSkill)((ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_RESISTANCE.get()))) {
                            if (entity.m_217043_().m_188501_() > 0.5f) {
                                DamageSourceHelper.directSpiritualHurt((LivingEntity)target, (Entity)entity, (float)Float.MAX_VALUE);
                            } else {
                                DamageSourceHelper.directSpiritualHurt((LivingEntity)target, (Entity)entity, (float)(targetMaxSHP * 0.5f));
                            }
                        } else {
                            DamageSourceHelper.directSpiritualHurt((LivingEntity)target, (Entity)entity, (float)Float.MAX_VALUE);
                        }
                        ItemStack stack = entity.m_21205_();
                        stack.m_41720_().m_7579_(stack, target, entity);
                        entity.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12313_, entity.m_5720_(), 1.0f, 1.0f);
                        if (!(level instanceof ServerLevel)) continue;
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_7726_().m_8394_((Entity)entity, (Packet)new ClientboundAnimatePacket((Entity)entity, 4));
                    }
                }
                entity.m_183634_();
                entity.m_19877_();
                entity.m_20219_(vec3);
                entity.f_19812_ = true;
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public void eyeOfTheMoon(ManasSkillInstance instance, LivingEntity entity) {
        if (!entity.m_21023_((MobEffect)TensuraMobEffects.SHADOW_STEP.get())) {
            if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                return;
            }
            this.addMasteryPoint(instance, entity);
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.SHADOW_STEP.get(), 6000, 0, false, false, false));
        } else {
            entity.m_21195_((MobEffect)TensuraMobEffects.SHADOW_STEP.get());
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 0.5f);
        }
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 4 && this.isHeld(entity)) {
            Level level = entity.m_9236_();
            AttributeInstance recon = entity.m_21051_((Attribute)TensuraAttributeRegistry.SIZE.get());
            if (recon != null && recon.m_22111_(TSUKUYOMI) != null) {
                recon.m_22127_(TSUKUYOMI);
                instance.setCoolDown(10);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                this.addMasteryPoint(instance, entity);
                CompoundTag tag = instance.getTag();
                if (tag == null) {
                    this.summonClones(entity, level, 5);
                } else {
                    this.summonClones(entity, level, tag.m_128451_("clones"));
                }
                AttributeModifier tsukuyomi = new AttributeModifier(TSUKUYOMI, "TsukuyomiClonesEffect", 0.0, AttributeModifier.Operation.ADDITION);
                if (recon != null && recon.m_22111_(TSUKUYOMI) == null) {
                    recon.m_22125_(tsukuyomi);
                }
            }
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        int clones;
        if (instance.getMode() != 4) {
            return false;
        }
        CompoundTag tag = instance.getTag();
        int n = clones = tag != null ? tag.m_128451_("clones") : 5;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.output_number", (Object[])new Object[]{clones}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
        }
        return true;
    }

    public void onScroll(ManasSkillInstance instance, LivingEntity entity, double delta) {
        if (instance.getMode() == 4) {
            CompoundTag tag = instance.getOrCreateTag();
            int newScale = tag.m_128451_("clones") + (int)delta;
            if (newScale > 5) {
                newScale = 1;
            } else if (newScale < 1) {
                newScale = 5;
            }
            if (tag.m_128451_("clones") != newScale) {
                tag.m_128405_("clones", newScale);
                instance.markDirty();
            }
        }
    }

    public void onDeath(ManasSkillInstance instance, LivingDeathEvent event) {
        LivingEntity entity;
        AttributeInstance recon;
        if (!event.isCanceled() && (recon = (entity = event.getEntity()).m_21051_((Attribute)TensuraAttributeRegistry.SIZE.get())) != null && recon.m_22111_(TSUKUYOMI) != null) {
            recon.m_22127_(TSUKUYOMI);
        }
    }

    private void summonClones(LivingEntity entity, Level level, int number) {
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123765_, (double)1.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123765_, (double)2.0);
        double EP = TensuraEPCapability.getEP((LivingEntity)entity) * 0.5 / (double)number;
        EntityType type = entity.m_6144_() ? (EntityType)TensuraEntityTypes.CLONE_SLIM.get() : (EntityType)TensuraEntityTypes.CLONE_DEFAULT.get();
        for (int i = 0; i < number; ++i) {
            CloneEntity clone = new CloneEntity(type, level);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                clone.m_21828_(player);
            }
            clone.setSkill((ManasSkill)this);
            clone.copyStatsAndSkills(entity, false);
            TensuraEPCapability.setLivingEP((LivingEntity)clone, (double)Math.round(EP));
            clone.m_146884_(entity.m_20182_());
            clone.copySize(entity);
            level.m_7967_((Entity)clone);
        }
    }
}

