/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.ISpatialStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.entity.magic.projectile.SeveranceCutterProjectile;
import com.github.manasmods.tensura.event.SkillGriefEvent;
import com.github.manasmods.tensura.menu.container.SpatialStorageContainer;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.github.manasmods.tensura.world.TensuraGameRules;
import com.google.common.collect.ImmutableList;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class UrielSkill
extends Skill
implements ISpatialStorage {
    public static final ImmutableList<MobEffect> ABSOLUTE_GUARD;
    protected static final UUID UNIVERSAL_BARRIER;

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/uriel.png");
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public UrielSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public double getObtainingEpCost() {
        return 1000000.0;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.INFINITY_PRISON.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.INFINITY_PRISON.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public int modes() {
        return 6;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1 -> 100000.0;
            case 3 -> 5.0;
            case 5 -> 20000.0;
            case 6 -> 100000.0;
            case 7 -> 250000.0;
            case 8 -> 2000000.0;
            case 9 -> 200000.0;
            default -> 0.0;
        };
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        int currentMode = instance.getMode();
        boolean mastered = instance.isMastered(entity);
        if (reverse) {
            return currentMode == 1 ? 9 : currentMode - 1;
        }
        if (currentMode == 6) {
            return mastered ? 7 : 9;
        }
        if (currentMode == 8 && !mastered) {
            return 9;
        }
        return currentMode == 9 ? 1 : currentMode + 1;
    }

    public Component getModeName(int mode) {
        switch (mode) {
            case 1: {
                return Component.m_237115_((String)"trmysticism.skill.mode.uriel.infinity_prison");
            }
            case 2: {
                return Component.m_237115_((String)"trmysticism.skill.mode.uriel.imaginary_space");
            }
            case 3: {
                return Component.m_237115_((String)"trmysticism.skill.mode.uriel.law_manipulation");
            }
            case 4: {
                return Component.m_237115_((String)"trmysticism.skill.mode.uriel.gravity_manipulation");
            }
            case 5: {
                return Component.m_237115_((String)"trmysticism.skill.mode.uriel.universal_barrier");
            }
            case 6: {
                return Component.m_237115_((String)"trmysticism.skill.mode.uriel.absolute_severance");
            }
            case 7: {
                return Component.m_237115_((String)"trmysticism.skill.mode.uriel.fatal_imprison");
            }
            case 8: {
                return Component.m_237115_((String)"trmysticism.skill.mode.uriel.nova_break");
            }
            case 9: {
                return Component.m_237115_((String)"trmysticism.skill.mode.uriel.insulated_prison");
            }
        }
        return Component.m_237113_((String)"");
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        LivingEntity entity;
        Player player;
        Entity attacker = event.getSource().m_7639_();
        if (attacker instanceof Player && TensuraSkillCapability.isSkillInSlot((LivingEntity)(player = (Player)attacker), (ManasSkill)((ManasSkill)UltimateSkills.SUSANOO.get()))) {
            return;
        }
        if (!event.isCanceled() && this.isInSlot(entity = event.getEntity())) {
            DamageSource damageSource = event.getSource();
            if (DamageSourceHelper.isSpiritual((DamageSource)damageSource)) {
                event.setCanceled(true);
                return;
            }
            if (!damageSource.m_19378_()) {
                Entity sourceEntity;
                if (damageSource instanceof TensuraDamageSource) {
                    TensuraDamageSource tensuraDamageSource = (TensuraDamageSource)damageSource;
                }
                if ((sourceEntity = damageSource.m_7639_()) instanceof LivingEntity) {
                    LivingEntity source = (LivingEntity)sourceEntity;
                    if (TensuraEPCapability.getEP((LivingEntity)source) >= TensuraEPCapability.getEP((LivingEntity)entity) * 8.0) {
                        return;
                    }
                    if (entity instanceof Player) {
                        Player player1 = (Player)entity;
                        double cost = event.getAmount() * 0.8f;
                        if (TensuraPlayerCapability.getMagicule((Player)player1) < cost) {
                            return;
                        }
                        TensuraPlayerCapability.decreaseMagicule((Player)player1, (double)cost);
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (instance.isToggled()) {
            if (DamageSourceHelper.isGravityDamage((DamageSource)e.getSource())) {
                e.setAmount(e.getAmount() * 4.0f);
            }
            if (DamageSourceHelper.isSpatialDamage((DamageSource)e.getSource())) {
                e.setAmount(e.getAmount() * 8.0f);
            }
        }
    }

    public int getMaxMastery() {
        return 3000;
    }

    public void onTakenDamage(ManasSkillInstance instance, LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource damageSource = event.getSource();
        if (this.isInSlot(entity) && !damageSource.m_19378_()) {
            float damageCanceled = (int)event.getAmount();
            double lackedMagicule = SkillHelper.outOfMagiculeStillConsume((LivingEntity)entity, (double)(damageCanceled * 50.0f));
            if (lackedMagicule > 0.0) {
                damageCanceled = (float)((double)damageCanceled - lackedMagicule / 50.0);
                event.setAmount(event.getAmount() - damageCanceled);
            } else {
                event.setCanceled(true);
            }
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            switch (instance.getMode()) {
                case 1: {
                    LivingEntity target = (LivingEntity)SkillHelper.getTargetingEntity(LivingEntity.class, (LivingEntity)entity, (double)30.0, (double)0.2, (boolean)false, (boolean)true);
                    if (target == null) {
                        return;
                    }
                    if (target.m_21023_((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get())) {
                        target.m_21195_((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get());
                        entity.m_21011_(InteractionHand.MAIN_HAND, true);
                        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123762_, (double)1.0);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123810_, (double)1.0);
                        break;
                    }
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        if (player.m_150110_().f_35934_) {
                            return;
                        }
                    }
                    if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                        return;
                    }
                    instance.addMasteryPoint(entity);
                    instance.setCoolDown(instance.isMastered(entity) ? 5 : 10);
                    int duration = instance.isMastered(entity) ? 20000 : 12000;
                    SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get()), (int)duration, (int)1, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                    DamageSourceHelper.markHurt((LivingEntity)target, (Entity)entity);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123762_, (double)1.0);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123808_, (double)1.0);
                    entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case 2: {
                    this.openSpatialStorage(entity, instance);
                    break;
                }
                case 3: {
                    this.breakBlock(entity, instance);
                    break;
                }
                case 4: {
                    Player player;
                    if (!(entity instanceof Player) || (player = (Player)entity).m_7500_() || player.m_5833_() || SkillHelper.outOfMagicule((LivingEntity)player, (ManasSkillInstance)instance)) break;
                    if (player.m_150110_().f_35935_) {
                        player.m_150110_().f_35935_ = false;
                        player.m_150110_().f_35936_ = false;
                    } else {
                        this.addMasteryPoint(instance, entity);
                        player.m_150110_().f_35935_ = true;
                        player.m_150110_().f_35936_ = true;
                    }
                    player.m_6885_();
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case 5: {
                    if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) break;
                    AttributeInstance attributeInstance = Objects.requireNonNull(entity.m_21051_((Attribute)TensuraAttributeRegistry.BARRIER.get()));
                    if (attributeInstance.m_22111_(UNIVERSAL_BARRIER) != null) {
                        attributeInstance.m_22127_(UNIVERSAL_BARRIER);
                        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11738_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        break;
                    }
                    this.addMasteryPoint(instance, entity);
                    instance.setCoolDown(10);
                    double barrierPoints = (double)entity.m_21233_() * (double)(instance.isMastered(entity) ? 8.0f : 4.0f);
                    attributeInstance.m_22125_(new AttributeModifier(UNIVERSAL_BARRIER, "Universal Barrier", barrierPoints, AttributeModifier.Operation.ADDITION));
                    entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11736_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case 6: {
                    if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                        return;
                    }
                    SeveranceCutterProjectile spaceCutter = new SeveranceCutterProjectile(entity.m_9236_(), entity);
                    spaceCutter.setSpeed(2.5f);
                    spaceCutter.setDamage(this.isMastered(instance, entity) ? 1400.0f : 700.0f);
                    spaceCutter.setSize(this.isMastered(instance, entity) ? 10.0f : 8.0f);
                    spaceCutter.setMpCost(this.magiculeCost(entity, instance));
                    spaceCutter.setSkill(instance);
                    spaceCutter.m_20242_(true);
                    spaceCutter.setPosAndShoot(entity);
                    spaceCutter.setPosDirection(entity, TensuraProjectile.PositionDirection.MIDDLE);
                    entity.m_9236_().m_7967_((Entity)spaceCutter);
                    instance.addMasteryPoint(entity);
                    instance.setCoolDown(this.isMastered(instance, entity) ? 3 : 5);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    entity.m_21011_(InteractionHand.OFF_HAND, true);
                    entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case 7: {
                    if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                        return;
                    }
                    float radius = instance.isMastered(entity) ? 30.0f : 20.0f;
                    List list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_((double)radius), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity));
                    if (list.isEmpty()) break;
                    instance.setCoolDown(instance.isMastered(entity) ? 20 : 40);
                    this.addMasteryPoint(instance, entity);
                    for (LivingEntity target1 : list) {
                        if (target1 instanceof Player) {
                            Player player = (Player)target1;
                            if (player.m_150110_().f_35934_) continue;
                        }
                        int duration = instance.isMastered(entity) ? 20000 : 12000;
                        SkillHelper.checkThenAddEffectSource((LivingEntity)target1, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get()), (int)duration, (int)1, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                        DamageSourceHelper.markHurt((LivingEntity)target1, (Entity)entity);
                        entity.m_21011_(InteractionHand.MAIN_HAND, true);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target1, (ParticleOptions)ParticleTypes.f_123762_, (double)1.0);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target1, (ParticleOptions)ParticleTypes.f_123808_, (double)1.0);
                        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    break;
                }
                case 8: {
                    if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                        return;
                    }
                    LivingEntity target2 = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)8.0, (boolean)false);
                    if (target2 == null) {
                        return;
                    }
                    if (target2 instanceof Player) {
                        Player player = (Player)target2;
                        if (player.m_150110_().f_35934_) {
                            return;
                        }
                    }
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    target2.m_6469_(TensuraDamageSources.holyDamage((Entity)entity), 5000.0f);
                    DamageSourceHelper.directSpiritualHurt((LivingEntity)target2, (Entity)entity, (float)3000.0f, (float)0.0f);
                    instance.setCoolDown(200);
                    level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target2, (ParticleOptions)ParticleTypes.f_123747_, (double)1.0);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target2, (ParticleOptions)ParticleTypes.f_123765_, (double)1.0);
                    break;
                }
                case 9: {
                    if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                        return;
                    }
                    float radius1 = instance.isMastered(entity) ? 30.0f : 20.0f;
                    List list1 = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_((double)radius1), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity));
                    if (list1.isEmpty()) break;
                    instance.setCoolDown(instance.isMastered(entity) ? 20 : 40);
                    this.addMasteryPoint(instance, entity);
                    for (LivingEntity target1 : list1) {
                        if (target1 instanceof Player) {
                            Player player = (Player)target1;
                            if (player.m_150110_().f_35934_) continue;
                        }
                        int duration = instance.isMastered(entity) ? 1200 : 600;
                        SkillHelper.checkThenAddEffectSource((LivingEntity)target1, (Entity)entity, (MobEffect)((MobEffect)MysticismMobEffects.INSULATED_IMPRISONMENT.get()), (int)duration, (int)0, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                        SkillHelper.checkThenAddEffectSource((LivingEntity)target1, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.SPATIAL_BLOCKADE.get()), (int)duration, (int)1, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                        SkillHelper.checkThenAddEffectSource((LivingEntity)target1, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get()), (int)duration, (int)1, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                        SkillHelper.checkThenAddEffectSource((LivingEntity)target1, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.FRAGILITY.get()), (int)duration, (int)1, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                        DamageSourceHelper.markHurt((LivingEntity)target1, (Entity)entity);
                        entity.m_21011_(InteractionHand.MAIN_HAND, true);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target1, (ParticleOptions)ParticleTypes.f_123762_, (double)1.0);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target1, (ParticleOptions)ParticleTypes.f_123808_, (double)1.0);
                        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    break;
                }
            }
        }
    }

    @NotNull
    public SpatialStorageContainer getSpatialStorage(ManasSkillInstance instance) {
        SpatialStorageContainer container = new SpatialStorageContainer(135, 999);
        container.m_7797_(instance.getOrCreateTag().m_128437_("SpatialStorage", 10));
        return container;
    }

    private void breakBlock(LivingEntity entity, ManasSkillInstance instance) {
        Level level = entity.m_9236_();
        if (TensuraGameRules.canSkillGrief((Level)level) && entity instanceof Player) {
            BlockHitResult result;
            Player player = (Player)entity;
            if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance) && (result = SkillHelper.getPlayerPOVHitResult((Level)level, (Entity)player, (ClipContext.Fluid)ClipContext.Fluid.NONE, (ClipContext.Block)ClipContext.Block.OUTLINE, (double)30.0)).m_6662_() == HitResult.Type.BLOCK) {
                BlockPos pos = result.m_82425_();
                BlockState state = level.m_8055_(pos);
                if (state.m_204336_(TensuraTags.Blocks.SKILL_UNOBTAINABLE)) {
                    return;
                }
                if (state.m_60800_((BlockGetter)level, pos) <= -1.0f) {
                    return;
                }
                SkillGriefEvent.Pre preGrief = new SkillGriefEvent.Pre((Entity)entity, instance, pos);
                if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                    return;
                }
                state.m_60734_().m_5707_(level, pos, state, player);
                if (!(state.m_60734_() instanceof DoublePlantBlock || state.m_60734_() instanceof DoorBlock || state.m_60734_() instanceof BannerBlock || state.m_60734_() instanceof BedBlock || state.m_60734_() instanceof PistonHeadBlock)) {
                    ShulkerBoxBlockEntity shulker;
                    BlockEntity blockEntity = level.m_7702_(pos);
                    if (blockEntity instanceof ShulkerBoxBlockEntity && !(shulker = (ShulkerBoxBlockEntity)blockEntity).m_7983_()) {
                        level.m_46953_(pos, !player.m_7500_(), (Entity)player);
                        return;
                    }
                    ItemStack stack = new ItemStack((ItemLike)state.m_60734_());
                    if (!player.m_36356_(stack)) {
                        player.m_36176_(stack, false);
                    }
                    level.m_46953_(pos, false, (Entity)player);
                } else {
                    level.m_46953_(pos, true, (Entity)player);
                }
                MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post((Entity)entity, instance, pos));
                for (ItemEntity item : player.f_19853_.m_45976_(ItemEntity.class, AABB.m_165882_((Vec3)Vec3.m_82512_((Vec3i)pos), (double)2.0, (double)2.0, (double)2.0))) {
                    if (player.m_36356_(item.m_32055_())) {
                        item.m_146870_();
                        continue;
                    }
                    item.m_32052_(player.m_20148_());
                }
                player.m_21011_(InteractionHand.MAIN_HAND, true);
                level.m_5594_(player, pos, SoundEvents.f_12018_, SoundSource.PLAYERS, 0.5f, 1.0f);
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10, 0.08, 0.08, 0.08, 0.1);
            }
        }
    }

    @NotNull
    public List<MobEffect> getImmuneEffects(ManasSkillInstance instance, LivingEntity entity) {
        return !instance.isToggled() ? new ArrayList() : ABSOLUTE_GUARD;
    }

    static {
        UNIVERSAL_BARRIER = UUID.fromString("67a4e74c-777e-4c0c-bb14-9a247fdc1959");
        ABSOLUTE_GUARD = ImmutableList.of((Object)((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get()), (Object)((MobEffect)TensuraMobEffects.DISINTEGRATING.get()), (Object)((MobEffect)TensuraMobEffects.SEVERANCE_BLADE.get()), (Object)((MobEffect)TensuraMobEffects.BLACK_BURN.get()), (Object)((MobEffect)TensuraMobEffects.ANTI_SKILL.get()));
    }
}

