/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.effect.template.Concealment;
import com.github.manasmods.tensura.entity.human.CloneEntity;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.world.TensuraGameRules;
import com.google.common.collect.ImmutableList;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.menu.VicMenu;
import io.github.Memoires.trmysticism.registry.dimensions.MysticismDimensions;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import io.github.Memoires.trmysticism.registry.skill.UniqueSkills;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VicielSkill
extends Skill
implements Concealment {
    public static final ImmutableList<MobEffect> DARKNESS_MASTERY;
    public static boolean isPaste;
    protected static final UUID MOVEMENT_SPEED_BOOST;
    protected static final UUID ATTACK_DAMAGE_BOOST;
    private static final double SPEED_BOOST = 0.2;
    private static final double ATTACK_BOOST = 2.0;

    public VicielSkill() {
        super(Skill.SkillType.ULTIMATE);
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public boolean canBeSlotted(ManasSkillInstance instance) {
        return UltimateUtils.insideConfig(instance.getSkillId());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    @Nullable
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/viciel.png");
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.HIDDEN_RULER.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.HIDDEN_RULER.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public double getObtainingEpCost() {
        return 666666.0;
    }

    public int getMaxMastery() {
        return 2000;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 3 -> 100000.0;
            case 4 -> 50000.0;
            case 5 -> 150000.0;
            default -> 0.0;
        };
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getMastery() >= 0;
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(30.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && living.m_7307_((Entity)entity));
        if (!list.isEmpty()) {
            int level = instance.isMastered(entity) ? 1 : 0;
            for (LivingEntity target : list) {
                if (SkillHelper.isSubordinate((LivingEntity)target, (LivingEntity)entity)) {
                    return;
                }
                target.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.INSPIRATION.get(), 240, level, false, false, false), (Entity)entity);
            }
        }
        boolean isNight = entity.f_19853_.m_46462_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if ((isNight || this.isDarkEnough(player)) && TensuraSkillCapability.isSkillInSlot((LivingEntity)entity, (ManasSkill)((ManasSkill)UltimateSkills.VICIEL.get()))) {
                VicielSkill.applyBuffs(player);
            } else {
                VicielSkill.removeBuffs(player);
            }
        }
        if (instance.isToggled()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_CONCEALMENT.get(), 240, 3, false, false, false));
        }
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            MinecraftServer server = player.m_20194_();
            PlayerList playerList = player.m_20194_().m_6846_();
            ClientboundPlayerInfoPacket packet = new ClientboundPlayerInfoPacket(ClientboundPlayerInfoPacket.Action.REMOVE_PLAYER, new ServerPlayer[]{player});
            MutableComponent leaveMessage = Component.m_237110_((String)"multiplayer.player.left", (Object[])new Object[]{player.m_5446_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
            for (ServerPlayer target : playerList.m_11314_()) {
                MobEffectInstance effect = target.m_21124_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get());
                if (server.m_129944_(target.m_36316_()) >= 2 && (effect == null || effect.m_19564_() <= 3)) continue;
                target.f_8906_.m_9829_((Packet)packet);
                target.m_213846_((Component)leaveMessage);
            }
        }
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            MinecraftServer server = player.m_20194_();
            PlayerList playerList = player.m_20194_().m_6846_();
            ClientboundPlayerInfoPacket packet = new ClientboundPlayerInfoPacket(ClientboundPlayerInfoPacket.Action.ADD_PLAYER, new ServerPlayer[]{player});
            MutableComponent joinMessage = Component.m_237110_((String)"multiplayer.player.joined", (Object[])new Object[]{player.m_5446_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
            for (ServerPlayer target : playerList.m_11314_()) {
                MobEffectInstance effect = target.m_21124_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get());
                if (server.m_129944_(target.m_36316_()) >= 2 && (effect == null || effect.m_19564_() <= 3)) continue;
                target.f_8906_.m_9829_((Packet)packet);
                target.m_213846_((Component)joinMessage);
            }
        }
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.viciel.true_copy");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.viciel.true_paste");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.viciel.darkness_conscription");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.viciel.shadow_jump");
            case 5 -> Component.m_237115_((String)"trmysticism.skill.mode.viciel.petrichor_stained_destiny");
            default -> Component.m_237119_();
        };
    }

    public int modes() {
        return 5;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 5 : instance.getMode() - 1;
        }
        return instance.getMode() == 5 ? 1 : instance.getMode() + 1;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        if (instance.getMode() == 1) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                LivingEntity target = (LivingEntity)SkillHelper.getTargetingEntity(LivingEntity.class, (LivingEntity)entity, (double)5.0, (double)0.2, (boolean)false, (boolean)true);
                if (entity.m_6144_()) {
                    List playerSkills = SkillAPI.getSkillsFrom((Entity)serverPlayer).getLearnedSkills().stream().toList();
                    ArrayList<ResourceLocation> copiedSkills = new ArrayList<ResourceLocation>();
                    for (Object skillInstance2 : playerSkills) {
                        if (!skillInstance2.getOrCreateTag().m_128471_("vicSkill")) continue;
                        copiedSkills.add(skillInstance2.getSkillId());
                    }
                    if (!copiedSkills.isEmpty()) {
                        if (entity instanceof Player) {
                            player = (Player)entity;
                            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.viciel.collection_header").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), false);
                            for (ResourceLocation skill : copiedSkills) {
                                String translationKey = skill.m_135827_() + ".skill." + skill.m_135815_();
                                String skillName = I18n.m_118938_((String)translationKey, (Object[])new Object[0]);
                                if (skillName.equals(translationKey)) {
                                    skillName = skill.m_135815_();
                                }
                                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.hidden_ruler.collection", (Object[])new Object[]{skillName}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), false);
                            }
                        }
                    } else if (entity instanceof Player) {
                        player = (Player)entity;
                        player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.hidden_ruler.collection_empty").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                    return;
                }
                if (target != null) {
                    if (target instanceof CloneEntity) {
                        serverPlayer.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.viciel.clone").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                        return;
                    }
                    isPaste = false;
                    List<ResourceLocation> dynamicSkillList = SkillAPI.getSkillsFrom((Entity)target).getLearnedSkills().stream().filter(skillInstance -> {
                        ManasSkill patt16587$temp = skillInstance.getSkill();
                        if (patt16587$temp instanceof Skill) {
                            Skill skill = (Skill)patt16587$temp;
                            return skill.getType() != Skill.SkillType.ULTIMATE;
                        }
                        return true;
                    }).filter(skillInstance -> skillInstance.getMastery() >= 0).filter(skillInstance -> !skillInstance.isTemporarySkill()).sorted(Comparator.comparing(skillInstance -> {
                        ManasSkill patt17698$temp = skillInstance.getSkill();
                        if (patt17698$temp instanceof Skill) {
                            Skill skill = (Skill)patt17698$temp;
                            return skill.getType().ordinal();
                        }
                        return Integer.MAX_VALUE;
                    })).map(skillInstance -> skillInstance.getSkill().getRegistryName()).toList();
                    NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider(VicMenu::new, (Component)Component.m_237119_()), buf -> {
                        buf.m_130077_(target.m_20148_());
                        buf.writeBoolean(isPaste);
                        buf.m_236828_((Collection)dynamicSkillList, FriendlyByteBuf::m_130085_);
                    });
                    serverPlayer.m_6330_(SoundEvents.f_11889_, SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    serverPlayer.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.viciel.no_target").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
            }
        } else if (instance.getMode() == 2) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                isPaste = true;
                LivingEntity target = (LivingEntity)SkillHelper.getTargetingEntity(LivingEntity.class, (LivingEntity)entity, (double)5.0, (double)0.2, (boolean)false, (boolean)true);
                if (target != null) {
                    if (target instanceof CloneEntity) {
                        serverPlayer.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.viciel.clone").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                        return;
                    }
                    List playerSkills = SkillAPI.getSkillsFrom((Entity)serverPlayer).getLearnedSkills().stream().toList();
                    ArrayList<ResourceLocation> copiedSkills = new ArrayList<ResourceLocation>();
                    for (ManasSkillInstance skillInstance3 : playerSkills) {
                        if (!skillInstance3.getOrCreateTag().m_128471_("vicSkill")) continue;
                        copiedSkills.add(skillInstance3.getSkillId());
                    }
                    NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider(VicMenu::new, (Component)Component.m_237119_()), buf -> {
                        buf.m_130077_(target.m_20148_());
                        buf.writeBoolean(isPaste);
                        buf.m_236828_((Collection)copiedSkills, FriendlyByteBuf::m_130085_);
                    });
                } else {
                    serverPlayer.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.viciel.no_target").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
            }
        } else if (instance.getMode() == 3) {
            Player player;
            Level level = entity.m_9236_();
            if (entity instanceof Player && this.isDarkEnough(player = (Player)entity)) {
                int chance;
                int n = chance = instance.isMastered(entity) ? 100 : 50;
                if (player.m_150110_().f_35937_) {
                    chance = 100;
                }
                if (entity.m_217043_().m_188503_(100) <= chance) {
                    LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)10.0, (boolean)false);
                    if (target != null && target instanceof TamableAnimal) {
                        if (!VicielSkill.isMindControlFailed((LivingEntity)player, target, level)) {
                            TensuraEPCapability.getFrom((LivingEntity)target).ifPresent(cap -> {
                                cap.setPermanentOwner(player.m_20148_());
                                TensuraEPCapability.sync((LivingEntity)target);
                            });
                            TamableAnimal tamableAnimal = (TamableAnimal)target;
                            tamableAnimal.m_21828_(player);
                            tamableAnimal.m_21573_().m_26573_();
                            tamableAnimal.m_6710_((LivingEntity)null);
                            tamableAnimal.m_21839_(false);
                            tamableAnimal.f_19853_.m_7605_((Entity)tamableAnimal, (byte)7);
                            TensuraParticleHelper.spawnServerParticles((Level)tamableAnimal.f_19853_, (ParticleOptions)((ParticleOptions)TensuraParticles.DARK_RED_LIGHTNING_SPARK.get()), (double)tamableAnimal.m_20185_(), (double)tamableAnimal.m_20186_(), (double)tamableAnimal.m_20189_(), (int)55, (double)0.08, (double)0.08, (double)0.08, (double)0.5, (boolean)true);
                            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_144242_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                        instance.addMasteryPoint(entity);
                        instance.setCoolDown(120);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"tensura.ability.activation_failed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    instance.setCoolDown(60);
                }
            }
        } else if (instance.getMode() == 4) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (this.isDarkEnough(player)) {
                    if (player.m_6144_()) {
                        LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)player, (double)15.0, (boolean)false, (boolean)true);
                        if (target != null) {
                            tag.m_128362_("TargetUUID", target.m_20148_());
                            this.writeTargetsLocToTag(tag, target);
                            tag.m_128379_("blockMarker", false);
                            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.viciel.target_marker").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), false);
                            TensuraParticleHelper.spawnServerParticles((Level)target.f_19853_, (ParticleOptions)((ParticleOptions)TensuraParticles.DARK_RED_LIGHTNING_SPARK.get()), (double)target.m_20185_(), (double)target.m_20186_(), (double)target.m_20189_(), (int)55, (double)0.08, (double)0.08, (double)0.08, (double)0.5, (boolean)true);
                            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_144242_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        } else {
                            tag.m_128379_("blockMarker", true);
                            this.writeLocationToTag(tag, player);
                            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.viciel.block_marker").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), false);
                            TensuraParticleHelper.spawnServerParticles((Level)player.f_19853_, (ParticleOptions)((ParticleOptions)TensuraParticles.DARK_RED_LIGHTNING_SPARK.get()), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (int)55, (double)0.08, (double)0.08, (double)0.08, (double)0.5, (boolean)true);
                            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_144242_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                        tag.m_128379_("savedShadowPosition", true);
                    } else if (!tag.m_128471_("blockMarker")) {
                        UUID targetUUID = tag.m_128342_("TargetUUID");
                        ServerLevel targetLevel = null;
                        LivingEntity livingEntity = null;
                        for (ServerLevel level : player.m_20194_().m_129785_()) {
                            livingEntity = (LivingEntity)level.m_8791_(targetUUID);
                            if (livingEntity == null) continue;
                            targetLevel = level;
                            break;
                        }
                        if (livingEntity == null || targetLevel == null) {
                            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.viciel.target_missing").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                            return;
                        }
                        String targetDimension = livingEntity.f_19853_.m_46472_().m_135782_().toString();
                        ChunkPos chunkPos = new ChunkPos(new BlockPos(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_()));
                        targetLevel.m_7726_().m_8387_(TicketType.f_9448_, chunkPos, 2, (Object)player.m_19879_());
                        if (livingEntity == null) {
                            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.viciel.target_missing").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                            targetLevel.m_7726_().m_8438_(TicketType.f_9448_, chunkPos, 2, (Object)player.m_19879_());
                            return;
                        }
                        if (!player.f_19853_.m_46472_().equals((Object)targetDimension)) {
                            if (targetLevel.m_46472_().equals(MysticismDimensions.FANTASY_WORLD)) {
                                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.mephisto.checkpoint_bad_dimension").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                            } else {
                                SkillHelper.moveAcrossDimensionTo((Entity)player, (double)livingEntity.m_20185_(), (double)livingEntity.m_20186_(), (double)livingEntity.m_20189_(), (float)1.0f, (float)1.0f, (ServerLevel)targetLevel);
                            }
                        } else {
                            player.m_6021_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
                        }
                        targetLevel.m_7726_().m_8438_(TicketType.f_9448_, chunkPos, 2, (Object)player.m_19879_());
                        TensuraParticleHelper.spawnServerParticles((Level)player.f_19853_, (ParticleOptions)((ParticleOptions)TensuraParticles.DARK_RED_LIGHTNING_SPARK.get()), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (int)55, (double)0.08, (double)0.08, (double)0.08, (double)0.5, (boolean)true);
                        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_144242_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        instance.addMasteryPoint(entity);
                        instance.setCoolDown(30);
                    } else {
                        BlockPos position = this.readLocationFromTag(tag);
                        ResourceKey<Level> dimension = this.readLevelFromTag(tag);
                        if (!player.f_19853_.m_46472_().equals(dimension)) {
                            ServerLevel targetLevel = player.m_20194_().m_129880_(dimension);
                            if (targetLevel != null && !targetLevel.m_46472_().equals(MysticismDimensions.FANTASY_WORLD)) {
                                SkillHelper.moveAcrossDimensionTo((Entity)entity, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), (float)1.0f, (float)1.0f, (ServerLevel)targetLevel);
                            } else {
                                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.mephisto.checkpoint_bad_dimension").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                            }
                        } else {
                            player.m_6021_((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_());
                        }
                        TensuraParticleHelper.spawnServerParticles((Level)player.f_19853_, (ParticleOptions)((ParticleOptions)TensuraParticles.DARK_RED_LIGHTNING_SPARK.get()), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (int)55, (double)0.08, (double)0.08, (double)0.08, (double)0.5, (boolean)true);
                        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_144242_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        instance.addMasteryPoint(entity);
                        instance.setCoolDown(30);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.viciel.light").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
            }
        } else if (instance.getMode() == 5) {
            List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(30.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && living.m_7307_((Entity)entity));
            for (LivingEntity subordinate : list) {
                int strengthLevel = instance.isMastered(entity) ? 9 : 4;
                int speedLevel = instance.isMastered(entity) ? 1 : 0;
                int duration = instance.isMastered(entity) ? 6000 : 2400;
                this.applyBuff(subordinate, strengthLevel, speedLevel, duration);
                if (entity.m_6047_()) {
                    subordinate.m_6021_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                }
                instance.setCoolDown(180);
                TensuraParticleHelper.spawnServerParticles((Level)subordinate.f_19853_, (ParticleOptions)((ParticleOptions)TensuraParticles.DARK_RED_LIGHTNING_SPARK.get()), (double)subordinate.m_20185_(), (double)subordinate.m_20186_(), (double)subordinate.m_20189_(), (int)55, (double)0.08, (double)0.08, (double)0.08, (double)0.5, (boolean)true);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_144242_, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.addMasteryPoint(instance, entity);
            }
        }
    }

    @NotNull
    public List<MobEffect> getImmuneEffects(ManasSkillInstance instance, LivingEntity entity) {
        return !SkillUtils.hasSkill((Entity)entity, (ManasSkill)this) ? new ArrayList() : DARKNESS_MASTERY;
    }

    private boolean canCopySkill(ResourceLocation location, ServerPlayer serverPlayer, ManasSkillInstance instance) {
        ManasSkill skill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(location);
        if (skill == null) {
            return false;
        }
        Optional optional = SkillAPI.getSkillsFrom((Entity)serverPlayer).getSkill(skill);
        return optional.isEmpty();
    }

    public static boolean isMindControlFailed(LivingEntity user, LivingEntity target, Level level) {
        boolean failed;
        boolean bl = failed = !VicielSkill.canMindControl(target, level);
        if (!failed && SkillUtils.isSkillToggled((Entity)target, (ManasSkill)((ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_NULLIFICATION.get()))) {
            failed = true;
        }
        if (failed && user instanceof Player) {
            Player player = (Player)user;
            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.hidden_ruler.recruitment.fail").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
        }
        return failed;
    }

    public static boolean canMindControl(LivingEntity target, Level level) {
        return VicielSkill.canMindControl(target, level, false);
    }

    public static boolean canMindControl(LivingEntity target, Level level, boolean ignorePlayerGamerule) {
        if (target instanceof Player) {
            Player player = (Player)target;
            if (!ignorePlayerGamerule && TensuraGameRules.noPlayerMindControl((Level)level)) {
                return false;
            }
            if (player.m_150110_().f_35934_) {
                return false;
            }
        }
        return !target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_MIND_CONTROL);
    }

    private void writeLocationToTag(CompoundTag tag, Player player) {
        tag.m_128347_("PosX", player.m_20185_());
        tag.m_128347_("PosY", player.m_20186_());
        tag.m_128347_("PosZ", player.m_20189_());
        tag.m_128359_("Level", player.f_19853_.m_46472_().m_135782_().toString());
    }

    private void writeTargetsLocToTag(CompoundTag tag, LivingEntity target) {
        tag.m_128362_("TargetUUID", target.m_20148_());
    }

    private BlockPos readLocationFromTag(CompoundTag tag) {
        double x = tag.m_128459_("PosX");
        double y = tag.m_128459_("PosY");
        double z = tag.m_128459_("PosZ");
        return new BlockPos(x, y, z);
    }

    private ResourceKey<Level> readLevelFromTag(CompoundTag tag) {
        String levelName = tag.m_128461_("Level");
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(levelName));
    }

    public boolean isDarkEnough(Player player) {
        if (player == null || player.f_19853_ == null) {
            return false;
        }
        Level level = player.f_19853_;
        BlockPos pos = player.m_20183_();
        int actualLight = level.m_46803_(pos);
        return actualLight < 5;
    }

    private void applyBuff(LivingEntity entity, int strength, int speed, int duration) {
        SkillHelper.checkThenAddEffectSource((LivingEntity)entity, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.STRENGTHEN.get()), (int)duration, (int)strength, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
        SkillHelper.checkThenAddEffectSource((LivingEntity)entity, (Entity)entity, (MobEffect)MobEffects.f_19596_, (int)duration, (int)strength, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
    }

    private static void applyBuffs(Player player) {
        AttributeInstance attackDamageAttribute;
        AttributeInstance speedAttribute = player.m_21051_(Attributes.f_22279_);
        if (speedAttribute != null) {
            speedAttribute.m_22120_(MOVEMENT_SPEED_BOOST);
            speedAttribute.m_22125_(new AttributeModifier(MOVEMENT_SPEED_BOOST, "Shadow Dominance Speed Boost", 0.2, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if ((attackDamageAttribute = player.m_21051_(Attributes.f_22281_)) != null) {
            attackDamageAttribute.m_22120_(ATTACK_DAMAGE_BOOST);
            attackDamageAttribute.m_22125_(new AttributeModifier(ATTACK_DAMAGE_BOOST, "Shadow Dominance Attack Boost", 2.0, AttributeModifier.Operation.ADDITION));
        }
    }

    private static void removeBuffs(Player player) {
        AttributeInstance attackDamageAttribute;
        AttributeInstance speedAttribute = player.m_21051_(Attributes.f_22279_);
        if (speedAttribute != null) {
            speedAttribute.m_22120_(MOVEMENT_SPEED_BOOST);
        }
        if ((attackDamageAttribute = player.m_21051_(Attributes.f_22281_)) != null) {
            attackDamageAttribute.m_22120_(ATTACK_DAMAGE_BOOST);
        }
    }

    static {
        MOVEMENT_SPEED_BOOST = UUID.fromString("c1f39652-2936-4f20-bce6-a07e7f80665d");
        ATTACK_DAMAGE_BOOST = UUID.fromString("da32460c-82d9-43d1-8ec5-f81e0dd45192");
        DARKNESS_MASTERY = ImmutableList.of((Object)((MobEffect)TensuraMobEffects.TRUE_BLINDNESS.get()), (Object)MobEffects.f_19610_, (Object)MobEffects.f_216964_);
    }
}

