/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.ultimate;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.entity.human.CloneEntity;
import com.github.manasmods.tensura.event.NamingEvent;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.ClientboundMainScreenOpenPacket;
import com.github.manasmods.tensura.network.play2server.RequestNamingGUIPacket;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.TensuraAdvancementsHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class XezbethSkill
extends Skill {
    private static boolean deception;
    protected static final String FAKE = "2956bb6b-57c3-4a2a-a03b-cde6d6988c27";

    @Nullable
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/ultimate/xezbeth.png");
    }

    public XezbethSkill() {
        super(Skill.SkillType.ULTIMATE);
        this.addHeldAttributeModifier(Attributes.f_22279_, FAKE, -0.4f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    public double getObtainingEpCost() {
        return 300000.0;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
            AtomicInteger soulQuality = new AtomicInteger();
            AtomicInteger currentUltimates = new AtomicInteger();
            MysticismPlayerCapability.getFrom(entity).ifPresent(cap -> {
                soulQuality.set(cap.getSoulQuality());
                currentUltimates.set(cap.getCurrentUltimates());
            });
            if (currentUltimates.get() >= soulQuality.get()) {
                return false;
            }
        }
        if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
            return false;
        }
        if (!UltimateUtils.obtainableUltimates(this.createDefaultInstance().getSkillId())) {
            return false;
        }
        List<TensuraSkill> requiredSkills = List.of((TensuraSkill)UniqueSkills.FALSIFIER.get());
        return UltimateUtils.ultimateEvolution(entity, requiredSkills);
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        Skill previousSkill = (Skill)UniqueSkills.FALSIFIER.get();
        Skill currentSkill = (Skill)instance.getSkill();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)currentSkill)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                MysticismPlayerCapability.getFrom((Player)entity).ifPresent(cap -> {
                    int currentUltimates = cap.getCurrentUltimates();
                    cap.setCurrentUltimates(currentUltimates + 1);
                });
            }
            if (!entity.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) {
                return;
            }
            if (player.m_7500_()) {
                return;
            }
            if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
                if (storage.getSkill((ManasSkill)previousSkill).isPresent()) {
                    storage.forgetSkill((ManasSkill)previousSkill);
                }
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{previousSkill.getName(), currentSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
    }

    public int modes() {
        return 5;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 5 : instance.getMode() - 1;
        }
        return instance.getMode() == 5 ? 1 : instance.getMode() + 1;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.xezbeth.deception");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.falsifier.illusion");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.falsifier.fake_death");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.xezbeth.disguise");
            case 5 -> Component.m_237115_((String)"trmysticism.skill.mode.xezbeth.display");
            default -> Component.m_237119_();
        };
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1 -> 10000.0;
            case 3 -> 100000.0;
            case 4 -> 125000.0;
            case 5 -> 150000.0;
            default -> 0.0;
        };
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        return entity.m_21023_((MobEffect)TensuraMobEffects.FALSIFIER.get());
    }

    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        return UltimateUtils.insideConfig(instance.getSkillId()) && super.canInteractSkill(instance, entity);
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        if (!entity.m_21023_((MobEffect)TensuraMobEffects.HEAT_SENSE.get()) && !entity.m_21023_((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get())) {
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.HEAT_SENSE.get(), 200, 0, false, false, false));
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get(), 200, 0, false, false, false));
        }
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)UUID.fromString(FAKE), (boolean)true);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        entity.m_21195_((MobEffect)TensuraMobEffects.HEAT_SENSE.get());
        entity.m_21195_((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get());
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)UUID.fromString(FAKE), (boolean)false);
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity entity, LivingHurtEvent event) {
        LivingEntity target = event.getEntity();
        float remainingHealth = target.m_21223_() - event.getAmount();
        if (target instanceof Player || target.m_21224_()) {
            return;
        }
        if (target.getPersistentData().m_128471_("is_display")) {
            return;
        }
        if (remainingHealth <= 0.0f && !instance.getOrCreateTag().m_128471_("disguise")) {
            CompoundTag tag = instance.getOrCreateTag();
            Entity entity2 = Objects.requireNonNull(event.getSource().m_7639_());
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                tag.m_128359_("prison_of_lies_player", player.m_36316_().getId().toString());
                SkillStorage playerSkills = SkillAPI.getSkillsFrom((Entity)player);
                CompoundTag skill_list = new CompoundTag();
                SkillAPI.getSkillsFrom((Entity)target).getLearnedSkills().forEach(skill -> {
                    Skill skill1;
                    ManasSkill patt10787$temp;
                    if (skill.getMastery() >= 0 && (patt10787$temp = skill.getSkill()) instanceof Skill && (skill1 = (Skill)patt10787$temp).getType() != Skill.SkillType.RESISTANCE) {
                        CompoundTag skillTag = skill.toNBT();
                        Optional playerSkill = playerSkills.getSkill(skill.getSkill());
                        if (playerSkill.isPresent() && ((ManasSkillInstance)playerSkill.get()).getMastery() >= 0) {
                            skillTag.m_128379_("xezbethAlreadyHas", true);
                        }
                        skill_list.m_128365_(skill.toString(), (Tag)skillTag);
                    }
                });
                tag.m_128359_("prison_of_lies", String.valueOf(EntityType.m_20613_((EntityType)target.m_6095_())));
                tag.m_128365_("prison_of_lies_nbt", (Tag)target.serializeNBT());
                tag.m_128365_("prison_of_lies_skills", (Tag)skill_list);
            }
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        switch (instance.getMode()) {
            case 1: {
                deception = !deception;
                instance.getOrCreateTag().m_128379_("deception", deception);
                if (!deception) {
                    if (!(entity instanceof Player)) break;
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.xezbeth.deception.toggle", (Object[])new Object[]{"Off"}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                    break;
                }
                if (!(entity instanceof Player)) break;
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.xezbeth.deception.toggle", (Object[])new Object[]{"On"}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                break;
            }
            case 2: {
                if (!(entity instanceof ServerPlayer)) {
                    return;
                }
                ServerPlayer player = (ServerPlayer)entity;
                TensuraNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundMainScreenOpenPacket(9, player.m_19879_()));
                player.m_6330_(SoundEvents.f_11889_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            default: {
                break;
            }
            case 4: {
                if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) break;
                if (!instance.getOrCreateTag().m_128471_("disguise")) {
                    CompoundTag tag = instance.getOrCreateTag();
                    if (!EntityType.m_20632_((String)tag.m_128461_("prison_of_lies")).isPresent()) break;
                    EntityType type = (EntityType)EntityType.m_20632_((String)tag.m_128461_("prison_of_lies")).get();
                    if (type.equals(EntityType.f_20532_)) {
                        entity.m_6593_(entity.f_19853_.m_46003_(UUID.fromString(tag.m_128461_("prison_of_lies_player"))).m_7755_());
                        String skin = tag.m_128461_("prison_of_lies_skin");
                        if (entity instanceof AbstractClientPlayer) {
                            AbstractClientPlayer clientPlayer = (AbstractClientPlayer)entity;
                            String oldSkin = ((ResourceLocation)clientPlayer.m_108558_().f_105299_.get(MinecraftProfileTexture.Type.SKIN)).toString();
                            tag.m_128359_("prison_of_lies_skin", oldSkin);
                            clientPlayer.m_108558_().f_105299_.replace(MinecraftProfileTexture.Type.SKIN, new ResourceLocation(oldSkin), new ResourceLocation(skin));
                        }
                    }
                    SkillAPI.getSkillsFrom((Entity)entity).getLearnedSkills().forEach(skill -> {
                        skill.setCoolDown(1);
                        skill.getOrCreateTag().m_128379_("disguise_skill", false);
                    });
                    tag.m_128469_("prison_of_lies_skills").m_128431_().forEach(Skill2 -> {
                        CompoundTag skillTag = tag.m_128469_("prison_of_lies_skills").m_128469_(Skill2);
                        if (ManasSkillInstance.fromNBT((CompoundTag)tag.m_128469_("prison_of_lies_skills").m_128469_(Skill2)).getMastery() >= 0 || !ManasSkillInstance.fromNBT((CompoundTag)tag.m_128469_("prison_of_lies_skills").m_128469_(Skill2)).isMastered(entity)) {
                            if (!skillTag.m_128471_("xezbethAlreadyHas")) {
                                SkillUtils.learnSkill((LivingEntity)entity, (ManasSkill)ManasSkillInstance.fromNBT((CompoundTag)tag.m_128469_("prison_of_lies_skills").m_128469_(Skill2)).getSkill(), (int)-2);
                            }
                            SkillUtils.getSkillOrNull((Entity)entity, (ManasSkill)ManasSkillInstance.fromNBT((CompoundTag)tag.m_128469_("prison_of_lies_skills").m_128469_(Skill2)).getSkill()).getOrCreateTag().m_128379_("disguise_skill", true);
                        }
                        if (entity instanceof Player) {
                            Player player1 = (Player)entity;
                            if (!skillTag.m_128471_("xezbethAlreadyHas")) {
                                player1.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.success_drain", (Object[])new Object[]{ManasSkillInstance.fromNBT((CompoundTag)tag.m_128469_("prison_of_lies_skills").m_128469_(Skill2)).getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
                            }
                        }
                    });
                    tag.m_128379_("disguise_skill", true);
                    tag.m_128379_("disguise", true);
                    if (!(entity instanceof Player)) break;
                    Player player1 = (Player)entity;
                    player1.m_5661_((Component)Component.m_237115_((String)"trmysticism.xezbeth.disguise_active").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE)), false);
                    break;
                }
                CompoundTag tag = instance.getOrCreateTag();
                tag.m_128469_("prison_of_lies_skills").m_128431_().forEach(Skill2 -> {
                    CompoundTag skillTag = tag.m_128469_("prison_of_lies_skills").m_128469_(Skill2);
                    if (!(ManasSkillInstance.fromNBT((CompoundTag)tag.m_128469_("prison_of_lies_skills").m_128469_(Skill2)).getMastery() < 0 && ManasSkillInstance.fromNBT((CompoundTag)tag.m_128469_("prison_of_lies_skills").m_128469_(Skill2)).isMastered(entity) || skillTag.m_128471_("xezbethAlreadyHas"))) {
                        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
                        storage.forgetSkill(ManasSkillInstance.fromNBT((CompoundTag)tag.m_128469_("prison_of_lies_skills").m_128469_(Skill2)));
                    }
                    if (entity instanceof Player) {
                        Player player1 = (Player)entity;
                        if (!skillTag.m_128471_("xezbethAlreadyHas")) {
                            player1.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.remove", (Object[])new Object[]{ManasSkillInstance.fromNBT((CompoundTag)tag.m_128469_("prison_of_lies_skills").m_128469_(Skill2)).getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                        }
                    }
                });
                tag.m_128379_("disguise", false);
                if (!(entity instanceof Player)) break;
                Player player1 = (Player)entity;
                player1.m_5661_((Component)Component.m_237115_((String)"trmysticism.xezbeth.disguise_disabled").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.LIGHT_PURPLE)), false);
                break;
            }
            case 5: {
                if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) break;
                CompoundTag tag = instance.getOrCreateTag();
                if (!tag.m_128471_("has_display")) {
                    if (tag.m_128461_("prison_of_lies").isEmpty() || !EntityType.m_20632_((String)tag.m_128461_("prison_of_lies")).isPresent()) break;
                    EntityType type = (EntityType)EntityType.m_20632_((String)tag.m_128461_("prison_of_lies")).get();
                    if (type.equals(EntityType.f_20532_)) {
                        if (tag.m_128461_("prison_of_lies_player").isEmpty()) break;
                        Player player1 = entity.f_19853_.m_46003_(UUID.fromString(tag.m_128461_("prison_of_lies_player")));
                        LivingEntity clone = this.tameEntity((LivingEntity)player1, entity);
                        CompoundTag tags = clone.getPersistentData();
                        tags.m_128379_("NO_EP_PLUNDER", true);
                        tags.m_128379_("NO_SKILL_PLUNDER", true);
                        tags.m_128379_("no_loot", true);
                        tags.m_128379_("is_display", true);
                        tags.m_128362_("ownerID", entity.m_20148_());
                        tag.m_128359_("prison_of_lies_player", "");
                        tag.m_128359_("prison_of_lies", "");
                        tag.m_128379_("has_display", true);
                        TensuraEPCapability.setLivingEP((LivingEntity)clone, (double)0.0);
                        TensuraEPCapability.setCurrentLivingEP((LivingEntity)clone, (double)0.0);
                        TensuraEPCapability.sync((LivingEntity)clone);
                        break;
                    }
                    Level level = entity.f_19853_;
                    Entity entity12 = type.m_20615_(level);
                    Vec3 lookVec = entity.m_20299_(1.0f);
                    entity12.m_146884_(lookVec);
                    CompoundTag tags = entity12.getPersistentData();
                    tags.m_128379_("NO_EP_PLUNDER", true);
                    tags.m_128379_("NO_SKILL_PLUNDER", true);
                    tags.m_128379_("no_loot", true);
                    tags.m_128379_("is_display", true);
                    tags.m_128362_("ownerID", entity.m_20148_());
                    level.m_7967_(entity12);
                    entity12.m_20240_(tag.m_128469_("prison_of_lies_nbt"));
                    tag.m_128359_("prison_of_lies", "");
                    tag.m_128379_("has_display", true);
                    this.tameEntity((LivingEntity)entity12, entity);
                    if (!(entity12 instanceof LivingEntity)) break;
                    LivingEntity living = (LivingEntity)entity12;
                    TensuraEPCapability.setLivingEP((LivingEntity)living, (double)0.0);
                    TensuraEPCapability.setCurrentLivingEP((LivingEntity)living, (double)0.0);
                    TensuraEPCapability.sync((LivingEntity)living);
                    break;
                }
                double minZ = entity.f_19853_.m_6857_().m_61956_();
                double maxZ = entity.f_19853_.m_6857_().m_61958_();
                double minX = entity.f_19853_.m_6857_().m_61955_();
                double maxX = entity.f_19853_.m_6857_().m_61957_();
                double minY = entity.f_19853_.m_141937_();
                double maxY = entity.f_19853_.m_151558_();
                List world_entities = entity.f_19853_.m_45933_((Entity)entity, new AABB(minZ, minX, minY, maxZ, maxX, maxY));
                world_entities.forEach(entity1 -> {
                    if (entity1.getPersistentData().m_128471_("is_display") && entity1.getPersistentData().m_128342_("ownerID") == entity.m_20148_()) {
                        System.out.println(entity1);
                        entity1.m_6074_();
                    }
                });
                tag.m_128379_("has_display", false);
            }
        }
    }

    private LivingEntity tameEntity(LivingEntity sub, LivingEntity owner) {
        double var10000;
        Level level = owner.m_9236_();
        if (owner instanceof Player) {
            Player player = (Player)owner;
            var10000 = TensuraPlayerCapability.getBaseMagicule((Player)player);
        } else {
            var10000 = TensuraEPCapability.getEP((LivingEntity)owner);
        }
        double MP = var10000;
        double EP = MP * 0.1;
        if (!SkillHelper.outOfMagicule((LivingEntity)owner, (double)EP)) {
            if (sub instanceof Player) {
                EquipmentSlot[] var10;
                Player player = (Player)sub;
                BlockHitResult result = SkillHelper.getPlayerPOVHitResult((Level)player.f_19853_, (Entity)player, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)0.0);
                CloneEntity clone = this.summonClone((LivingEntity)player, owner, level, EP, result.m_82450_());
                CloneEntity.copyEffects((LivingEntity)player, (LivingEntity)clone);
                for (EquipmentSlot slot : var10 = EquipmentSlot.values()) {
                    clone.m_8061_(slot, player.m_6844_(slot).m_41777_());
                }
                return clone;
            }
            if (sub instanceof TamableAnimal) {
                TamableAnimal animal = (TamableAnimal)sub;
                if (owner instanceof Player) {
                    Player player = (Player)owner;
                    animal.m_21828_(player);
                }
            } else {
                assert (sub instanceof LivingEntity);
                double ep = TensuraEPCapability.getEP((LivingEntity)sub);
                TensuraEPCapability.setLivingEP((LivingEntity)sub, (double)100.0);
                assert (owner instanceof ServerPlayer);
                this.name(sub, (ServerPlayer)owner, RequestNamingGUIPacket.NamingType.HIGH, "");
                sub.m_6593_((Component)Component.m_237119_());
                sub.m_20340_(false);
                TensuraEPCapability.setLivingEP((LivingEntity)sub, (double)ep);
            }
            return sub;
        }
        return null;
    }

    private CloneEntity summonClone(LivingEntity entity, LivingEntity owner, Level level, double EP, Vec3 position) {
        EntityType type = (EntityType)TensuraEntityTypes.CLONE_DEFAULT.get();
        CloneEntity clone = new CloneEntity(type, level);
        if (owner instanceof Player) {
            Player player = (Player)owner;
            clone.m_21828_(player);
        }
        clone.setSkill((ManasSkill)this);
        clone.copyStatsAndSkills(entity, true);
        TensuraEPCapability.setLivingEP((LivingEntity)clone, (double)EP);
        clone.m_21153_(clone.m_21233_());
        clone.m_146884_(position);
        CloneEntity.copyRotation((LivingEntity)entity, (LivingEntity)clone);
        level.m_7967_((Entity)clone);
        return clone;
    }

    private void name(LivingEntity sub, @Nullable ServerPlayer owner, RequestNamingGUIPacket.NamingType type, String name) {
        double var20000;
        if (sub instanceof Player) {
            Player player = (Player)sub;
            var20000 = TensuraPlayerCapability.getBaseEP((Player)player);
        } else {
            var20000 = TensuraEPCapability.getEP((LivingEntity)sub);
        }
        double subEP = var20000;
        TensuraEPCapability.getFrom((LivingEntity)sub).ifPresent(namingCap -> {
            double var10000 = 0.0;
            double originalCost = var10000;
            NamingEvent event = new NamingEvent(sub, (Player)owner, originalCost, type, name);
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                originalCost = event.getOriginalCost();
                double cost = Math.min(event.getCalculatedCost(), (Double)TensuraConfig.INSTANCE.namingConfig.maxCost.get());
                if (owner != null && TensuraPlayerCapability.getMagicule((Player)owner) < cost) {
                    owner.m_5661_((Component)Component.m_237115_((String)"tensura.skill.lack_magicule").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                } else {
                    namingCap.setName(event.getName());
                    sub.m_6593_((Component)Component.m_237113_((String)event.getName()));
                    if (owner != null) {
                        namingCap.setPermanentOwner(owner.m_20148_());
                        TensuraAdvancementsHelper.grant((ServerPlayer)owner, (ResourceLocation)TensuraAdvancementsHelper.Advancements.NAME_A_MOB);
                    }
                    if (sub instanceof Player) {
                        Player player = (Player)sub;
                        player.refreshDisplayName();
                        if (owner != null) {
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.naming.name_success", (Object[])new Object[]{event.getName(), owner.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                        } else {
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.naming.name_success.no_namer", (Object[])new Object[]{event.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                        }
                        TensuraPlayerCapability.setTrackedRace((LivingEntity)player, (Race)null);
                        TensuraPlayerCapability.sync((Player)player);
                        TensuraEPCapability.sync((LivingEntity)player);
                    } else if (owner != null) {
                        AbstractHorse horse;
                        TamableAnimal tamable;
                        if (sub instanceof TamableAnimal && !ForgeEventFactory.onAnimalTame((Animal)(tamable = (TamableAnimal)sub), (Player)owner)) {
                            tamable.m_21828_((Player)owner);
                        } else if (sub instanceof AbstractHorse && !ForgeEventFactory.onAnimalTame((Animal)(horse = (AbstractHorse)sub), (Player)owner)) {
                            horse.m_30637_((Player)owner);
                        }
                    }
                    sub.m_5634_(sub.m_21233_());
                    SkillHelper.removePredicateEffect((LivingEntity)sub, effect -> effect.m_19483_().equals((Object)MobEffectCategory.HARMFUL));
                }
            }
        });
    }

    public void onTakenDamage(ManasSkillInstance instance, LivingDamageEvent e) {
        if (instance.getMode() == 3) {
            DamageSource source;
            LivingEntity entity = e.getEntity();
            System.out.println(XezbethSkill.isFakingDeath(entity));
            if (XezbethSkill.isFakingDeath(entity) && !(source = e.getSource()).m_19378_()) {
                TensuraDamageSource damageSource;
                if (source instanceof TensuraDamageSource && (damageSource = (TensuraDamageSource)source).getIgnoreBarrier() >= 2.0f) {
                    return;
                }
                Level level = entity.m_9236_();
                EntityType type = entity.m_6144_() ? (EntityType)TensuraEntityTypes.CLONE_SLIM.get() : (EntityType)TensuraEntityTypes.CLONE_DEFAULT.get();
                CloneEntity clone = new CloneEntity(type, level);
                clone.setImmobile(true);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    clone.m_21828_(player);
                }
                clone.setSkill((ManasSkill)this);
                clone.copyStatsAndSkills(entity, CloneEntity.CopySkill.NONE, true);
                clone.m_21153_(entity.m_21223_());
                clone.m_146884_(entity.m_20182_());
                CloneEntity.copyRotation((LivingEntity)entity, (LivingEntity)clone);
                level.m_7967_((Entity)clone);
                e.setAmount(e.getAmount() / 2.0f);
                clone.m_6469_(source.m_19381_(), clone.m_21233_() * 10.0f);
                entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.FALSIFIER.get(), 60, 0, false, false, false));
                if (level.m_46469_().m_46207_(GameRules.f_46142_)) {
                    clone.m_21231_().m_19289_(source.m_19381_(), 1.0f, 1.0f);
                    Component deathMessage = clone.m_21231_().m_19293_();
                    for (Player everyone : level.m_6907_()) {
                        if (everyone == entity) continue;
                        everyone.m_213846_(deathMessage);
                    }
                }
            }
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() != 3) {
            return false;
        }
        if (entity.m_21023_((MobEffect)TensuraMobEffects.FALSIFIER.get())) {
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.FALSIFIER.get(), 20, 0, false, false, false));
        }
        return heldTicks <= 600;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 3 && this.isHeld(entity) && entity.m_21023_((MobEffect)TensuraMobEffects.FALSIFIER.get())) {
            instance.setCoolDown(this.isMastered(instance, entity) ? 5 : 10);
        }
    }

    public void onSubordinateDeath(ManasSkillInstance instance, LivingEntity owner, LivingDeathEvent e) {
        LivingEntity sub = e.getEntity();
        if (sub.getPersistentData().m_128471_("is_display")) {
            instance.getOrCreateTag().m_128379_("has_display", false);
        }
    }

    public void onDeath(ManasSkillInstance instance, LivingDeathEvent event) {
        CompoundTag tag = instance.getOrCreateTag();
        if (tag.m_128471_("disguise")) {
            String skin = tag.m_128461_("prison_of_lies_skin");
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof AbstractClientPlayer) {
                AbstractClientPlayer clientPlayer = (AbstractClientPlayer)livingEntity;
                ResourceLocation oldskin = (ResourceLocation)clientPlayer.m_108558_().f_105299_.get(MinecraftProfileTexture.Type.SKIN);
                clientPlayer.m_108558_().f_105299_.replace(MinecraftProfileTexture.Type.SKIN, oldskin, new ResourceLocation(skin));
                tag.m_128473_("prison_of_lies_skin");
            }
        }
    }

    public double getAttributeModifierAmplifier(ManasSkillInstance instance, LivingEntity entity, AttributeModifier modifier) {
        return modifier.m_22218_() * (instance.isMastered(entity) ? 0.5 : 1.0);
    }

    public void addHeldAttributeModifiers(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() == 3) {
            super.addHeldAttributeModifiers(instance, entity);
        }
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return this.isInSlot(entity);
    }

    public void onTick(ManasSkillInstance instance, LivingEntity living) {
        living.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get(), 200, 3, false, false, false));
    }

    public static boolean isFakingDeath(LivingEntity entity) {
        AttributeInstance attributeInstance = entity.m_21051_(Attributes.f_22279_);
        System.out.println(attributeInstance);
        if (attributeInstance == null) {
            return false;
        }
        return attributeInstance.m_22111_(UUID.fromString(FAKE)) != null;
    }
}

