/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.intrinsic.CharmSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.template.TensuraHorseEntity;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import io.github.Memoires.trmysticism.effect.instance.DazzledEffectInstance;
import io.github.Memoires.trmysticism.network.MysticismNetwork;
import io.github.Memoires.trmysticism.network.play2server.SyncLieModePacket;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CaptivatorSkill
extends Skill {
    private boolean lieMode;

    public CaptivatorSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    public int modes() {
        return 4;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1 -> 250.0;
            case 2 -> 300.0;
            case 3 -> 500.0;
            case 4 -> 1000.0;
            default -> 0.0;
        };
    }

    public void setLieModeClient(boolean lieMode) {
        this.lieMode = lieMode;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (!reverse) {
            if (this.lieMode) {
                return switch (instance.getMode()) {
                    case 1 -> 2;
                    case 2 -> {
                        if (instance.isMastered(entity)) {
                            yield 4;
                        }
                        yield 1;
                    }
                    default -> 1;
                };
            }
            return switch (instance.getMode()) {
                case 1 -> 3;
                case 3 -> {
                    if (instance.isMastered(entity)) {
                        yield 4;
                    }
                    yield 1;
                }
                default -> 1;
            };
        }
        if (this.lieMode) {
            return switch (instance.getMode()) {
                case 1 -> {
                    if (instance.isMastered(entity)) {
                        yield 4;
                    }
                    yield 2;
                }
                case 2 -> 1;
                case 4 -> 2;
                default -> 0;
            };
        }
        return switch (instance.getMode()) {
            case 1 -> {
                if (instance.isMastered(entity)) {
                    yield 4;
                }
                yield 3;
            }
            case 3 -> 1;
            case 4 -> 3;
            default -> 0;
        };
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.captivator.performance");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.captivator.masquerade");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.captivator.unveil");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.captivator.star_power");
            default -> Component.m_237119_();
        };
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", this.lieMode ? "textures/skill/unique/captivator/captivator_lie.png" : "textures/skill/unique/captivator/captivator_truth.png");
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public void onTick(ManasSkillInstance instance, LivingEntity living) {
        living.m_7292_(new MobEffectInstance(MobEffects.f_19595_, 240, 4, false, false, false));
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() == 2) {
            List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(15.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_());
            if (!list.isEmpty()) {
                int level = instance.isMastered(entity) ? 3 : 1;
                for (LivingEntity target : list) {
                    if (target.m_7307_((Entity)entity)) {
                        target.m_147207_(new MobEffectInstance(MobEffects.f_19596_, 200, level, false, false, false), (Entity)entity);
                        target.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.STRENGTHEN.get(), 200, level, false, false, false), (Entity)entity);
                        target.m_5634_((float)((double)target.m_21233_() * 0.25));
                        TensuraEPCapability.healSpiritualHealth((LivingEntity)target, (double)(TensuraEPCapability.getSpiritualHealth((LivingEntity)target) * 0.25));
                        continue;
                    }
                    if (target instanceof Player) {
                        Player targetPlayer = (Player)target;
                        if (targetPlayer.m_150110_().f_35934_) continue;
                    }
                    target.m_147207_(new MobEffectInstance(MobEffects.f_19610_, 200, level, false, false, false), (Entity)entity);
                }
                instance.addMasteryPoint(entity);
                instance.setCoolDown(30);
            }
        } else if (instance.getMode() == 3) {
            List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(15.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_());
            if (!list.isEmpty()) {
                for (LivingEntity target : list) {
                    if (target instanceof Player) {
                        Player targetPlayer = (Player)target;
                        if (targetPlayer.m_150110_().f_35934_) continue;
                    }
                    if (SkillHelper.isSubordinate((LivingEntity)target, (LivingEntity)entity) && target.m_7307_((Entity)entity)) continue;
                    if (instance.isMastered(entity)) {
                        SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.PARALYSIS.get()), (int)200, (int)1, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                        SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)MysticismMobEffects.MARKED_FOR_DEATH.get()), (int)200, (int)0, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                        continue;
                    }
                    SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.PARALYSIS.get()), (int)200, (int)1, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                }
                instance.addMasteryPoint(entity);
                instance.setCoolDown(30);
            }
        } else if (instance.getMode() == 4) {
            Level level = entity.m_9236_();
            Vec3 selfEyePos = entity.m_146892_();
            List nearby = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(20.0), e -> e.m_6084_() && !e.m_7306_((Entity)entity) && !e.m_7307_((Entity)entity));
            for (LivingEntity other : nearby) {
                Vec3 toPlayerVec;
                if (other instanceof Player) {
                    Player targetPlayer = (Player)other;
                    if (targetPlayer.m_150110_().f_35934_) continue;
                }
                Vec3 otherEyePos = other.m_146892_();
                Vec3 otherLookVec = other.m_20154_().m_82541_();
                double dot = otherLookVec.m_82526_(toPlayerVec = selfEyePos.m_82546_(otherEyePos).m_82541_());
                if (!(dot > 0.5)) continue;
                other.m_147207_((MobEffectInstance)new DazzledEffectInstance((MobEffect)MysticismMobEffects.DAZZLED.get(), 200, 0, entity, false, false, false), (Entity)entity);
            }
            instance.setCoolDown(40);
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() != 1 || !this.isHeld(entity)) {
            return false;
        }
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            return false;
        }
        if (heldTicks > 300) {
            instance.addMasteryPoint(entity);
            this.onRelease(instance, entity, heldTicks);
            return false;
        }
        UUID playerUUID = entity.m_20148_();
        Level level = entity.m_9236_();
        List list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(20.0), target -> !target.m_7306_((Entity)entity) && target.m_6084_());
        for (LivingEntity target2 : list) {
            if (target2 instanceof Player) {
                Player targetPlayer = (Player)target2;
                if (targetPlayer.m_150110_().f_35934_) continue;
            }
            TensuraEPCapability.getFrom((LivingEntity)target2).ifPresent(cap -> {
                int effectLevel;
                int n = effectLevel = instance.isMastered(entity) ? 1 : 0;
                if (Objects.equals(cap.getTemporaryOwner(), playerUUID) || Objects.equals(cap.getPermanentOwner(), playerUUID)) {
                    target2.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.INSPIRATION.get(), 240, effectLevel, false, false, false), (Entity)entity);
                    return;
                }
                if (CharmSkill.canMindControl((LivingEntity)target2, (Level)level) && !target2.m_21023_((MobEffect)TensuraMobEffects.RAMPAGE.get()) && !RaceHelper.isSpiritualLifeForm((LivingEntity)target2) && !SkillUtils.isSkillToggled((Entity)target2, (ManasSkill)((ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_NULLIFICATION.get()))) {
                    int duration = SkillUtils.isSkillToggled((Entity)target2, (ManasSkill)((ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_RESISTANCE.get())) ? 100 : 600;
                    SkillHelper.checkThenAddEffectSource((LivingEntity)target2, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.MIND_CONTROL.get()), (int)duration, (int)0);
                    if (target2.m_21023_((MobEffect)TensuraMobEffects.MIND_CONTROL.get())) {
                        cap.setTemporaryOwner(playerUUID);
                        if (target2 instanceof Mob) {
                            Mob mob = (Mob)target2;
                            SkillHelper.removeTarget((Mob)mob);
                        }
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            if (target2 instanceof TamableAnimal) {
                                TamableAnimal animal = (TamableAnimal)target2;
                                animal.m_21828_(player);
                            } else if (target2 instanceof TensuraHorseEntity) {
                                TensuraHorseEntity horse = (TensuraHorseEntity)target2;
                                horse.m_30637_(player);
                            }
                        }
                        TensuraEPCapability.sync((LivingEntity)target2);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target2, (ParticleOptions)ParticleTypes.f_123798_);
                        level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11733_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                }
            });
        }
        return true;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 1 && this.isHeld(entity)) {
            Player player;
            boolean bl = this.lieMode = !this.lieMode;
            if (entity.m_9236_().m_5776_() && entity instanceof Player) {
                player = (Player)entity;
                MysticismNetwork.sendToServer(new SyncLieModePacket(player.m_20148_(), this.lieMode));
            }
            instance.setCoolDown(5);
            if (entity instanceof Player) {
                player = (Player)entity;
                if (this.lieMode) {
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.captivator.performance.truth").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY)), false);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.captivator.performance.lie").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.LIGHT_PURPLE)), false);
                }
            }
        }
    }

    public boolean isLieMode() {
        return this.lieMode;
    }
}

