/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.human.CloneEntity;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import io.github.Memoires.trmysticism.registry.skill.UniqueSkills;
import io.github.Memoires.trmysticism.util.damage.MysticismDamageSources;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompulsorSkill
extends Skill {
    public CompulsorSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Nullable
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/unique/compulsor.png");
    }

    public int modes() {
        return 3;
    }

    @NotNull
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.compulsor.organic_distortion");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.compulsor.anatomy_manipulation");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.compulsor.clone_removal");
            default -> Component.m_237119_();
        };
    }

    public void onLearnSkill(@NotNull ManasSkillInstance instance, @NotNull LivingEntity living, @NotNull UnlockSkillEvent event) {
        if (living instanceof Player) {
            Player player = (Player)living;
            CompoundTag skillTag = instance.getOrCreateTag();
            if (!skillTag.m_128441_("OriginalOwner")) {
                skillTag.m_128362_("OriginalOwner", player.m_20148_());
                instance.markDirty();
            }
            skillTag.m_128405_("CloneCount", 0);
            skillTag.m_128405_("maxClones", 5);
        }
    }

    public int nextMode(@NotNull LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 3 ? 1 : instance.getMode() + 1;
    }

    public boolean canBeToggled(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        return instance.getMastery() >= 0;
    }

    public double magiculeCost(@NotNull LivingEntity entity, @NotNull ManasSkillInstance instance) {
        return 5000.0;
    }

    public void onDeath(@NotNull ManasSkillInstance instance, LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (this.isInSlot(event.getEntity()) && !instance.onCoolDown() && (livingEntity = event.getEntity()) instanceof CloneEntity) {
            CloneEntity clone = (CloneEntity)livingEntity;
            LivingEntity owner = null;
            double minZ = clone.f_19853_.m_6857_().m_61956_();
            double maxZ = clone.f_19853_.m_6857_().m_61958_();
            double minX = clone.f_19853_.m_6857_().m_61955_();
            double maxX = clone.f_19853_.m_6857_().m_61957_();
            double minY = clone.f_19853_.m_141937_();
            double maxY = clone.f_19853_.m_151558_();
            List world_entities = clone.f_19853_.m_45976_(LivingEntity.class, new AABB(minX, minY, minZ, maxX, maxY, maxZ));
            for (LivingEntity entity : world_entities) {
                if (!instance.getOrCreateTag().m_128342_("ClonedFrom").equals(entity.m_20148_())) continue;
                System.out.println(entity);
                owner = entity;
            }
            if (owner != null) {
                SkillStorage ownerStorage = SkillAPI.getSkillsFrom(owner);
                Optional compulsorInstance = ownerStorage.getSkill((ManasSkill)UniqueSkills.COMPULSOR.get());
                compulsorInstance.ifPresent(compulsor -> {
                    int newCloneCount = compulsor.getOrCreateTag().m_128451_("CloneCount") - 1;
                    compulsor.getOrCreateTag().m_128405_("CloneCount", Math.max(newCloneCount, 0));
                });
            }
            instance.setCoolDown(5);
        }
    }

    public void onBeingDamaged(@NotNull ManasSkillInstance instance, LivingAttackEvent event) {
        DamageSource source;
        LivingEntity user = event.getEntity();
        float remainingHealth = user.m_21223_() - event.getAmount();
        if (this.isInSlot(event.getEntity()) && !instance.onCoolDown() && !(source = event.getSource()).m_19378_() && (double)remainingHealth <= (double)user.m_21233_() * 0.2) {
            if (instance.getOrCreateTag().m_128451_("CloneCount") < instance.getOrCreateTag().m_128451_("maxClones")) {
                instance.getOrCreateTag().m_128405_("CloneCount", instance.getOrCreateTag().m_128451_("CloneCount") + 1);
                System.out.println(instance.getOrCreateTag());
                EntityType type = (EntityType)TensuraEntityTypes.CLONE_DEFAULT.get();
                CloneEntity clone = new CloneEntity(type, user.f_19853_);
                UUID originalOwnerUUID = instance.getOrCreateTag().m_128342_("OriginalOwner");
                Player originalOwner = user.f_19853_.m_46003_(originalOwnerUUID);
                if (originalOwner != null) {
                    clone.m_21828_(originalOwner);
                }
                clone.setSkill((ManasSkill)this);
                clone.copyStatsAndSkills(user, true);
                ManasSkillInstance cloneInstance = SkillUtils.getSkillOrNull((Entity)clone, (ManasSkill)((ManasSkill)UniqueSkills.COMPULSOR.get()));
                if (cloneInstance != null) {
                    System.out.println(user);
                    if (user instanceof CloneEntity) {
                        if (instance.getOrCreateTag().m_128471_("isCloneClone")) {
                            cloneInstance.getOrCreateTag().m_128405_("maxClones", 0);
                            cloneInstance.getOrCreateTag().m_128362_("ClonedFrom", user.m_20148_());
                        } else {
                            cloneInstance.getOrCreateTag().m_128379_("isCloneClone", true);
                            cloneInstance.getOrCreateTag().m_128405_("maxClones", 1);
                            cloneInstance.getOrCreateTag().m_128362_("ClonedFrom", user.m_20148_());
                        }
                    } else {
                        cloneInstance.getOrCreateTag().m_128405_("maxClones", 3);
                    }
                    cloneInstance.getOrCreateTag().m_128405_("CloneCount", 0);
                    cloneInstance.getOrCreateTag().m_128362_("ClonedFrom", user.m_20148_());
                }
                clone.setHeight(clone.getHeight());
                clone.setWidth(clone.getWidth());
                TensuraEPCapability.setLivingEP((LivingEntity)clone, (double)Math.round(TensuraEPCapability.getEP((LivingEntity)user) / 5.0));
                clone.m_146884_(user.m_20182_());
                clone.m_21153_(clone.m_21233_());
                user.f_19853_.m_7967_((Entity)clone);
                SkillHelper.setWander((LivingEntity)clone);
                instance.setCoolDown(5);
            } else if (user instanceof Player) {
                Player player = (Player)user;
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.compulsor.clone_limit").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            if (instance.isToggled()) {
                SkillStorage playerStorage = SkillAPI.getSkillsFrom((Entity)player);
                Collection playerStorageLearnedSkills = playerStorage.getLearnedSkills();
                List<ManasSkillInstance> resistSkills = playerStorageLearnedSkills.stream().filter(skillInstance -> skillInstance.getSkill() instanceof ResistSkill).toList();
                for (ManasSkillInstance resistance : resistSkills) {
                    ManasSkill manasSkill;
                    if (!(Math.random() < 0.1) || !((manasSkill = resistance.getSkill()) instanceof ResistSkill)) continue;
                    ResistSkill resistSkill = (ResistSkill)manasSkill;
                    if (!resistance.canBeToggled((LivingEntity)player) || !resistSkill.isDamageResisted(event.getSource(), resistance)) continue;
                    if (resistance.getMastery() >= 0) {
                        resistSkill.addMasteryPoint(resistance, user);
                    }
                    if (!resistSkill.isMastered(resistance, user)) continue;
                    resistSkill.evolveToNullification(resistance, user);
                }
            }
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity living, int heldTicks) {
        if (instance.getMode() == 2) {
            float size;
            CompoundTag tag = instance.getTag();
            float f = size = tag != null ? tag.m_128457_("size") : 5.0f;
            if (living instanceof Player) {
                Player player = (Player)living;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.output_number", (Object[])new Object[]{Float.valueOf(size / 5.0f)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
            }
            return true;
        }
        return false;
    }

    public void onPressed(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        if (instance.getMode() == 1) {
            LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)10.0, (boolean)true, (boolean)true);
            if (target != null) {
                this.addMasteryPoint(instance, entity);
                Vec3 particlePos = target.m_20318_(0.0f);
                target.m_7292_(new MobEffectInstance((MobEffect)MysticismMobEffects.DISTORTED.get(), 200, 0, false, false, false));
                TensuraParticleHelper.addServerParticlesAroundPos((RandomSource)target.m_217043_(), (Level)target.f_19853_, (Vec3)particlePos, (ParticleOptions)ParticleTypes.f_123766_, (double)3.0);
                DamageSource distorted = MysticismDamageSources.distorted((Entity)entity);
                target.m_6469_(distorted, 50.0f);
                target.f_19853_.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12053_, SoundSource.PLAYERS, 2.0f, 1.0f);
                if (target instanceof Player) {
                    Player player = (Player)target;
                    player.m_5496_(SoundEvents.f_11871_, 2.0f, 1.0f);
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.compulsor.organic_distortion.being_compromised").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
                instance.setCoolDown(20);
            }
        } else if (instance.getMode() == 3) {
            Level level = entity.m_9236_();
            List list = level.m_6443_(CloneEntity.class, entity.m_20191_().m_82400_(50.0), living -> living.m_6084_() && living.m_7307_((Entity)entity));
            for (CloneEntity clone : list) {
                CompoundTag targetTag;
                ManasSkillInstance cloneInstance = SkillUtils.getSkillOrNull((Entity)clone, (ManasSkill)((ManasSkill)UniqueSkills.COMPULSOR.get()));
                if (cloneInstance == null || !(targetTag = cloneInstance.getOrCreateTag()).m_128441_("ClonedFrom") || targetTag.m_128342_("ClonedFrom") != entity.m_20148_()) continue;
                entity.m_6469_(TensuraDamageSources.noEnergySource((Entity)entity), entity.m_21233_() * 1.0f);
            }
        }
    }

    public void onScroll(ManasSkillInstance instance, @NotNull LivingEntity entity, double delta) {
        if (instance.getMode() == 2 && this.isHeld(entity)) {
            float currentScale;
            float newScale;
            CompoundTag tag = instance.getOrCreateTag();
            tag.m_128405_("ActivatedTimes", tag.m_128451_("ActivatedTimes") + 1);
            if (tag.m_128451_("ActivatedTimes") % 10 == 0) {
                this.addMasteryPoint(instance, entity);
            }
            if ((newScale = (currentScale = tag.m_128457_("size")) + (float)((int)delta)) > 5.0f) {
                newScale = 1.0f;
            } else if (newScale < 1.0f) {
                newScale = 5.0f;
            }
            if (currentScale != newScale) {
                tag.m_128350_("size", newScale);
                instance.markDirty();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    this.adjustPlayerSize(player, newScale);
                    player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12053_, SoundSource.PLAYERS, 2.0f, 1.0f);
                }
            }
        }
    }

    private void adjustPlayerSize(Player player, float scale) {
        AttributeInstance sizeAttribute = player.m_21051_((Attribute)TensuraAttributeRegistry.SIZE.get());
        if (sizeAttribute != null) {
            double newSizeValue = (double)scale / 5.0;
            sizeAttribute.m_22100_(newSizeValue);
        }
    }
}

