/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import io.github.Memoires.trmysticism.util.TimerUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.jetbrains.annotations.Nullable;

public class ConstantSkill
extends Skill {
    public ConstantSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    public double getObtainingEpCost() {
        return 80000.0;
    }

    @Nullable
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/unique/constant.png");
    }

    public int modes() {
        return 4;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isMastered(entity);
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.constant.health");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.constant.physical");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.constant.destruction");
            case 4 -> Component.m_237115_((String)"trmysticism.skill.mode.constant.energy");
            default -> Component.m_237119_();
        };
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity living, UnlockSkillEvent event) {
        CompoundTag tag = instance.getOrCreateTag();
        tag.m_128350_("ConstantDestruction", 0.0f);
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        if (instance.getMode() == 3) {
            return 3000.0;
        }
        return 1000.0;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return switch (instance.getMode()) {
                case 1 -> {
                    if (instance.isMastered(entity)) {
                        yield 4;
                    }
                    if (instance.getOrCreateTag().m_128457_("ConstantDamage") != 0.0f) {
                        yield 3;
                    }
                    yield 2;
                }
                case 2 -> 1;
                case 3 -> 2;
                case 4 -> {
                    if (instance.getOrCreateTag().m_128457_("ConstantDamage") != 0.0f) {
                        yield 3;
                    }
                    yield 1;
                }
                default -> 0;
            };
        }
        return switch (instance.getMode()) {
            case 1 -> 2;
            case 2 -> {
                if (instance.isMastered(entity)) {
                    if (instance.getOrCreateTag().m_128457_("ConstantDamage") != 0.0f) {
                        yield 3;
                    }
                    yield 4;
                }
                if (instance.getOrCreateTag().m_128457_("ConstantDamage") != 0.0f) {
                    yield 3;
                }
                yield 1;
            }
            case 3 -> {
                if (instance.isMastered(entity)) {
                    yield 4;
                }
                yield 1;
            }
            default -> 1;
        };
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() == 1) {
            if (!SkillHelper.outOfMagicule((LivingEntity)entity, (double)1000.0)) {
                instance.getOrCreateTag().m_128379_("ConstantHealth", true);
                instance.getOrCreateTag().m_128350_("ConstantHP", entity.m_21223_());
                instance.getOrCreateTag().m_128347_("ConstantSHP", TensuraEPCapability.getSpiritualHealth((LivingEntity)entity));
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.constant.constant_health").m_6270_(Style.f_131099_).m_130940_(ChatFormatting.BLUE), false);
            }
        } else if (instance.getMode() == 2) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.constant.constant_physical").m_6270_(Style.f_131099_).m_130940_(ChatFormatting.BLUE), false);
            }
            this.addMasteryPoint(instance, entity);
            instance.getOrCreateTag().m_128350_("ConstantDamage", 0.0f);
            instance.getOrCreateTag().m_128379_("ConstantPhysical", true);
            instance.setCoolDown(10);
            TimerUtils.Timer timer = TimerUtils.getOrCreateTimer("ConstantPhysical");
            timer.start(100, () -> {
                instance.getOrCreateTag().m_128379_("ConstantPhysical", false);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.constant.constant_destruction.available", (Object[])new Object[]{Float.valueOf(instance.getOrCreateTag().m_128457_("ConstantDamage"))}).m_6270_(Style.f_131099_).m_130940_(ChatFormatting.BLUE), false);
                }
                timer.stop();
                timer.reset();
            });
        } else if (instance.getMode() == 3) {
            if (!SkillHelper.outOfMagicule((LivingEntity)entity, (double)3000.0)) {
                instance.getOrCreateTag().m_128379_("ConstantDestruction", true);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.constant.constant_destruction").m_6270_(Style.f_131099_).m_130940_(ChatFormatting.BLUE), false);
                }
            }
        } else if (instance.getMode() == 4) {
            this.addMasteryPoint(instance, entity);
            instance.getOrCreateTag().m_128347_("ConstantCostMP", 0.0);
            instance.getOrCreateTag().m_128347_("ConstantCostAP", 0.0);
            instance.getOrCreateTag().m_128379_("ConstantEnergy", true);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.constant.constant_energy").m_6270_(Style.f_131099_).m_130940_(ChatFormatting.BLUE), false);
            }
            instance.setCoolDown(10);
            TimerUtils.Timer timer = TimerUtils.getOrCreateTimer("ConstantEnergy");
            timer.start(200, () -> {
                instance.getOrCreateTag().m_128379_("ConstantEnergy", false);
                TensuraPlayerCapability.getFrom((Player)((Player)entity)).ifPresent(cap -> {
                    if (instance.getOrCreateTag().m_128459_("ConstantCostMP") > cap.getMagicule()) {
                        double maxMP = entity.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                        cap.setMagicule(Math.min(cap.getMagicule() * 0.25, maxMP));
                        SkillHelper.checkThenAddEffectSource((LivingEntity)entity, (Entity)entity, (MobEffect)((MobEffect)MysticismMobEffects.MAGICULE_REGEN_BLOCKADE.get()), (int)3600, (int)0, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                    } else {
                        TensuraPlayerCapability.decreaseMagicule((Player)((Player)entity), (double)instance.getOrCreateTag().m_128459_("ConstantCostMP"));
                    }
                    if (instance.getOrCreateTag().m_128459_("ConstantCostAP") > cap.getAura()) {
                        double maxAP = entity.m_21133_((Attribute)TensuraAttributeRegistry.MAX_AURA.get());
                        cap.setAura(Math.min(cap.getAura() * 0.25, maxAP));
                        SkillHelper.checkThenAddEffectSource((LivingEntity)entity, (Entity)entity, (MobEffect)((MobEffect)MysticismMobEffects.AURA_REGEN_BLOCKADE.get()), (int)3600, (int)0, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                    } else {
                        TensuraPlayerCapability.decreaseAura((Player)((Player)entity), (double)instance.getOrCreateTag().m_128459_("ConstantCostAP"));
                    }
                });
                timer.stop();
                timer.reset();
            });
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity living, int heldTicks) {
        if (instance.getMode() == 1) {
            if (heldTicks > 300) {
                instance.getOrCreateTag().m_128379_("ConstantHealth", false);
                this.addMasteryPoint(instance, living);
                instance.setCoolDown(15);
                return false;
            }
            if (heldTicks % 20 == 0) {
                return !SkillHelper.outOfMagicule((LivingEntity)living, (double)1000.0);
            }
            return true;
        }
        if (instance.getMode() == 3) {
            if (heldTicks > 200) {
                instance.getOrCreateTag().m_128379_("ConstantDestruction", false);
                this.addMasteryPoint(instance, living);
                instance.setCoolDown(15);
                return false;
            }
            if (heldTicks % 20 == 0) {
                return !SkillHelper.outOfMagicule((LivingEntity)living, (double)3000.0);
            }
            return true;
        }
        return false;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 1 && this.isHeld(entity)) {
            instance.getOrCreateTag().m_128379_("ConstantHealth", false);
            instance.setCoolDown(10);
        } else if (instance.getMode() == 3 && this.isHeld(entity)) {
            instance.getOrCreateTag().m_128379_("ConstantDestruction", false);
            instance.setCoolDown(15);
        }
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity entity, LivingHurtEvent event) {
        float highestDamage = instance.getOrCreateTag().m_128457_("ConstantDamage");
        if (instance.getOrCreateTag().m_128471_("ConstantPhysical") && event.getAmount() > highestDamage) {
            highestDamage = event.getAmount();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237113_((String)String.valueOf(highestDamage)).m_6270_(Style.f_131099_).m_130940_(ChatFormatting.GREEN), true);
            }
            instance.getOrCreateTag().m_128350_("ConstantDamage", highestDamage);
        }
        if (instance.getOrCreateTag().m_128471_("ConstantDestruction") && instance.getMode() == 3) {
            float constantDmg = instance.getOrCreateTag().m_128457_("ConstantDamage");
            event.setAmount(constantDmg);
        }
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        if (instance.getOrCreateTag().m_128471_("ConstantHealth")) {
            LivingEntity living = event.getEntity();
            living.m_21153_(instance.getOrCreateTag().m_128457_("ConstantHP"));
            TensuraEPCapability.setSpiritualHealth((LivingEntity)living, (double)instance.getOrCreateTag().m_128459_("ConstantSHP"));
        }
    }
}

