/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.dimensions.TensuraDimensions;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import io.github.Memoires.trmysticism.registry.dimensions.MysticismDimensions;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import io.github.Memoires.trmysticism.util.damage.MysticismDamageSources;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.network.PacketDistributor;

public class CrasherSkill
extends Skill {
    protected static final UUID ACCELERATION = UUID.fromString("eeac4dce-615e-4815-ab77-59bff44c8fdf");

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/unique/crasher.png");
    }

    public CrasherSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    public double getObtainingEpCost() {
        return 75000.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return instance.getMastery() >= 0;
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)true);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle((ManasSkillInstance)instance, (LivingEntity)entity, (UUID)ACCELERATION, (boolean)false);
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMastery() < 0) {
            return false;
        }
        return instance.getMode() == 1;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.crasher.destroyer_haki");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.crasher.dimension_hopper");
            default -> Component.m_237119_();
        };
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 2 -> 1000.0;
            default -> 500.0;
        };
    }

    public int modes() {
        return 2;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        if (this.isInSlot(event.getEntity())) {
            LivingEntity entity = event.getEntity();
            Level level = entity.m_9236_();
            if ((double)entity.m_21223_() <= (double)entity.m_21233_() * 0.1 && !instance.onCoolDown()) {
                float temporaryBarrier = entity.m_21233_() * 0.75f;
                entity.m_7911_(entity.m_6103_() + temporaryBarrier);
                AABB auraArea = entity.m_20191_().m_82400_(5.0);
                List nearbyEntities = level.m_6443_(LivingEntity.class, auraArea, e -> e != entity && e instanceof Enemy);
                for (LivingEntity nearbyEntity : nearbyEntities) {
                    Vec3 currentPosition = nearbyEntity.m_20182_();
                    Vec3 teleportPosition = currentPosition.m_82520_(level.f_46441_.m_188500_() * 20.0 - 10.0, 0.0, level.f_46441_.m_188500_() * 20.0 - 10.0);
                    if (!level.m_8055_(new BlockPos(teleportPosition)).m_60795_()) continue;
                    nearbyEntity.m_6021_(teleportPosition.f_82479_, teleportPosition.f_82480_, teleportPosition.f_82481_);
                }
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 0.0, 0.5, 0.0);
                instance.setCoolDown(120);
            }
        }
    }

    public void onTick(ManasSkillInstance instance, LivingEntity living) {
        if (this.isInSlot(living) && !TensuraSkillCapability.isSkillInSlot((LivingEntity)living, (ManasSkill)((ManasSkill)UltimateSkills.DIONYSUS.get()))) {
            int severance = instance.isMastered(living) ? 1 : 0;
            living.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.SEVERANCE_BLADE.get(), 200, severance, false, false, false));
        }
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        if (this.isInSlot(attacker) && this.isDamagePhysical(e.getSource(), attacker)) {
            EquipmentSlot[] slots;
            LivingEntity target = e.getEntity();
            int durabilityBreak = (int)Math.max(1.0f, e.getAmount() / 4.0f) * 2;
            if (instance.isMastered(attacker)) {
                durabilityBreak *= 2;
            }
            for (EquipmentSlot slot : slots = EquipmentSlot.values()) {
                ItemStack slotStack;
                if (slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) && !target.m_6844_(slot).canPerformAction(ToolActions.SHIELD_BLOCK) || !(slotStack = target.m_6844_(slot)).m_41619_() && slotStack.m_41784_().m_128459_("EP") >= 1000000.0) continue;
                slotStack.m_41622_(durabilityBreak, target, living -> living.m_21166_(slot));
            }
        }
    }

    private boolean isDamagePhysical(DamageSource source, LivingEntity attacker) {
        return source.m_7639_() == attacker && DamageSourceHelper.isPhysicalAttack((DamageSource)source);
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        String currentDimension;
        if (instance.getMode() == 1) {
            List list;
            if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                return false;
            }
            if (heldTicks % 60 == 0) {
                if (heldTicks > 0) {
                    this.addMasteryPoint(instance, entity);
                }
                if ((double)entity.m_217043_().m_188501_() <= 0.2) {
                    int level = 0;
                    MobEffectInstance insanity = entity.m_21124_((MobEffect)TensuraMobEffects.INSANITY.get());
                    if (insanity != null) {
                        level = insanity.m_19564_() + 1;
                    }
                    entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.INSANITY.get(), 240, level, false, false, false));
                }
            }
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12362_, SoundSource.PLAYERS, 0.5f, 0.5f);
            if (heldTicks % 10 == 0) {
                TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:strength_sap"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
            }
            if (!(list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(15.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity))).isEmpty()) {
                double ownerEP = TensuraEPCapability.getEP((LivingEntity)entity);
                for (LivingEntity target : list) {
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        if (player.m_150110_().f_35934_) continue;
                    }
                    int amount = instance.isMastered(entity) ? 50 : 25;
                    target.m_6469_(MysticismDamageSources.destroyerHaki((Entity)entity), (float)amount);
                    double targetEP = TensuraEPCapability.getEP((LivingEntity)target);
                    double difference = 1.0 - targetEP / ownerEP - 0.4;
                    if (instance.isMastered(entity)) {
                        difference += 0.2;
                    }
                    int level = 1 + (int)(difference / 0.1);
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, level));
                    target.m_6469_(MysticismDamageSources.destroyerHaki((Entity)entity), (float)amount);
                }
            }
            return true;
        }
        CompoundTag tag = instance.getTag();
        String string = currentDimension = tag != null ? tag.m_128461_("dimension") : "";
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.crasher.dimension_hopper.current_dimension", (Object[])new Object[]{currentDimension}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
        }
        return true;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        CompoundTag tag;
        String currentDimension;
        ResourceKey<Level> targetDimension;
        if (instance.getMode() == 2 && this.isHeld(entity) && (targetDimension = this.getTargetDimension(currentDimension = (tag = instance.getTag()) != null ? tag.m_128461_("dimension") : "")) != null && entity.m_20194_() != null) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (entity.f_19853_.m_46472_() == MysticismDimensions.FANTASY_WORLD) {
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.crasher.dimension_hopper.too_weak").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    return;
                }
                if (entity.f_19853_.m_46472_() == targetDimension) {
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.crasher.dimension_hopper.received_same").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    return;
                }
            }
            double targetX = entity.m_20185_();
            double targetY = entity.m_20186_();
            double targetZ = entity.m_20189_();
            ServerLevel targetLevel = entity.m_20194_().m_129880_(targetDimension);
            if (entity.f_19853_.m_46472_() == Level.f_46428_ && targetDimension == Level.f_46429_) {
                targetX /= 8.0;
                targetZ /= 8.0;
            } else if (entity.f_19853_.m_46472_() == Level.f_46429_ && targetDimension == Level.f_46428_) {
                targetX *= 8.0;
                targetZ *= 8.0;
            }
            if (targetLevel != null) {
                BlockPos safePos = this.findNearestSafeBlock(targetX, targetY, targetZ, targetLevel);
                SkillHelper.moveAcrossDimensionTo((Entity)entity, (double)safePos.m_123341_(), (double)safePos.m_123342_(), (double)safePos.m_123343_(), (float)entity.m_146908_(), (float)entity.m_146909_(), (ServerLevel)targetLevel);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (player.m_150110_().f_35936_) {
                        player.m_150110_().f_35935_ = true;
                        player.m_6885_();
                    }
                }
            }
            if (instance.isMastered(entity)) {
                instance.setCoolDown(300);
            } else {
                instance.setCoolDown(600);
            }
            this.addMasteryPoint(instance, entity);
        }
    }

    private BlockPos findNearestSafeBlock(double x, double y, double z, ServerLevel level) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int radius = 100;
        for (int r = 1; r <= radius; ++r) {
            for (int dx = -r; dx <= r; ++dx) {
                for (int dz = -r; dz <= r; ++dz) {
                    for (int dy = -r; dy <= r; ++dy) {
                        mutablePos.m_122169_(x + (double)dx, y + (double)dy, z + (double)dz);
                        BlockState blockState = level.m_8055_((BlockPos)mutablePos);
                        BlockState blockBelow = level.m_8055_(mutablePos.m_7495_());
                        if (!blockState.m_60795_() || !blockBelow.m_60815_()) continue;
                        return mutablePos.m_7949_();
                    }
                }
            }
        }
        return new BlockPos(x, y, z);
    }

    public void onScroll(ManasSkillInstance instance, LivingEntity living, double delta) {
        if (instance.getMode() == 2) {
            CompoundTag tag = instance.getOrCreateTag();
            List<String> dimensions = Arrays.asList("Overworld", "Nether", "The End", "Hell", "Elemental Realm");
            int currentIndex = tag.m_128451_("dimensionIndex");
            int newIndex = currentIndex + (int)delta;
            if (newIndex >= dimensions.size()) {
                newIndex = 0;
            } else if (newIndex < 0) {
                newIndex = dimensions.size() - 1;
            }
            if (currentIndex != newIndex) {
                tag.m_128405_("dimensionIndex", newIndex);
                tag.m_128359_("dimension", dimensions.get(newIndex));
                instance.markDirty();
            }
        }
    }

    private ResourceKey<Level> getTargetDimension(String dimensionName) {
        return switch (dimensionName) {
            case "Overworld" -> Level.f_46428_;
            case "Nether" -> Level.f_46429_;
            case "The End" -> Level.f_46430_;
            case "Hell" -> TensuraDimensions.HELL;
            case "Elemental Realm" -> MysticismDimensions.ELEMENTAL_REALM;
            default -> null;
        };
    }
}

