/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import io.github.Memoires.trmysticism.util.TimerUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.jetbrains.annotations.Nullable;

public class CultivatorSkill
extends Skill {
    public CultivatorSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Nullable
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/unique/cultivator.png");
    }

    public double getObtainingEpCost() {
        return 80000.0;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent event) {
        if (attacker.m_21205_().m_41619_() && attacker.m_21206_().m_41619_()) {
            if (instance.isMastered(attacker)) {
                event.setAmount(event.getAmount() + 100.0f);
            } else {
                event.setAmount(event.getAmount() + 50.0f);
            }
        }
    }

    public int modes() {
        return 1;
    }

    public Component getModeName(int mode) {
        return Component.m_237115_((String)"trmysticism.skill.mode.cultivator.breakthrough");
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getOrCreateTag().m_128471_("Cultivating");
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        if (tag.m_128471_("Cultivating")) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.cultivator.breakthrough.already_cultivating").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), false);
            }
            return;
        }
        int mobKills = tag.m_128451_("MobKills");
        if (mobKills < 1000) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.cultivator.breakthrough.not_enough_kills", (Object[])new Object[]{1000 - mobKills}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            tag.m_128405_("MobKills", 0);
            tag.m_128379_("Cultivating", true);
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.cultivator.breakthrough.cultivation_started").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
            player.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.STRENGTHEN.get(), 6000, 14, false, false, true));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 6000, 2, false, false, true));
            instance.setCoolDown(3600);
            TimerUtils.Timer timer = TimerUtils.getOrCreateTimer("Cultivator");
            timer.start(6000, () -> {
                tag.m_128405_("CultivationLevel", tag.m_128451_("CultivationLevel") + 1);
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.cultivator.breakthrough.broken_through", (Object[])new Object[]{tag.m_128451_("CultivationLevel")}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                this.addMasteryPoint(instance, (LivingEntity)player, 100);
                tag.m_128379_("Cultivating", false);
                player.m_21219_();
                timer.reset();
                timer.stop();
            });
        }
    }
}

