/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import io.github.Memoires.trmysticism.registry.dimensions.MysticismDimensions;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import io.github.Memoires.trmysticism.util.damage.MysticismDamageSources;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DreamerSkill
extends Skill {
    public DreamerSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    public double getObtainingEpCost() {
        return 50000.0;
    }

    public int getMaxMastery() {
        return 1000;
    }

    @Nullable
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/unique/dreamer.png");
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public void onTick(ManasSkillInstance instance, LivingEntity living) {
        if (this.isInSlot(living) && living instanceof Player) {
            Player player = (Player)living;
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                long lastDamageTime;
                CompoundTag tag = player.getPersistentData();
                long currentTime = player.f_19853_.m_46467_();
                if (currentTime - (lastDamageTime = tag.m_128454_("NoDamageTimer")) >= 300L) {
                    double maxMP = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                    double currentMP = cap.getMagicule();
                    double mpGain = maxMP * 0.02;
                    cap.setMagicule(Math.min(currentMP + mpGain, maxMP));
                }
            });
            TensuraPlayerCapability.sync((Player)player);
        }
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        DamageSource damageSource;
        LivingEntity entity;
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)event.getEntity());
        if (storage.getSkill((ManasSkill)UltimateSkills.MEPHISTO.get()).isPresent() || storage.getSkill((ManasSkill)UltimateSkills.SEPHIROT.get()).isPresent()) {
            return;
        }
        if (!this.isInSlot(event.getEntity())) {
            return;
        }
        if (!event.isCanceled() && this.isInSlot(entity = event.getEntity()) && !(damageSource = event.getSource()).m_19378_() && !(entity.m_217043_().m_188501_() > (instance.isMastered(entity) ? 0.2f : 0.1f))) {
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
            event.setCanceled(true);
            if (SkillUtils.canNegateDodge((LivingEntity)entity, (DamageSource)damageSource)) {
                event.setCanceled(false);
            }
        }
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 2 -> 50.0;
            case 3 -> 100.0;
            default -> 1000.0;
        };
    }

    @NotNull
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.dreamer.dream");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.dreamer.hypnosis");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.dreamer.dream_eater");
            default -> Component.m_237119_();
        };
    }

    public int modes() {
        return 3;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 3 : instance.getMode() - 1;
        }
        return instance.getMode() == 3 ? 1 : instance.getMode() + 1;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            Level level = entity.m_9236_();
            if (instance.getMode() == 1) {
                this.dream(instance, entity, level);
            }
        }
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getMode() == 2 || instance.getMode() == 3;
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity living, int heldTicks) {
        if (instance.getMode() != 1) {
            if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)living, (ManasSkillInstance)instance)) {
                return false;
            }
            Level level = living.m_9236_();
            switch (instance.getMode()) {
                case 2: {
                    level.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (heldTicks % 10 == 0) {
                        TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> living), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:fallen_hypno"), living.m_19879_(), 0.0, 1.0, 0.0, true));
                    }
                    if (heldTicks % 100 == 0 && heldTicks > 0) {
                        instance.addMasteryPoint(living);
                    }
                    float radius = instance.isMastered(living) ? 10.0f : 5.0f;
                    List list = level.m_6443_(LivingEntity.class, living.m_20191_().m_82400_((double)radius), entity -> entity != living && entity.m_6084_() && !entity.m_7307_((Entity)living));
                    if (list.isEmpty()) break;
                    for (LivingEntity target : list) {
                        int duration;
                        if (target instanceof Player) {
                            Player player = (Player)target;
                            if (player.m_150110_().f_35934_) continue;
                        }
                        MobEffectInstance drowsiness = target.m_21124_((MobEffect)TensuraMobEffects.DROWSINESS.get());
                        int n = duration = instance.isMastered(living) ? 400 : 200;
                        if (drowsiness == null) {
                            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.DROWSINESS.get(), duration, 0, false, false));
                            continue;
                        }
                        int currentDuration = drowsiness.m_19557_();
                        if (heldTicks % 20 != 0) continue;
                        target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.DROWSINESS.get(), currentDuration + 20, 0, false, false));
                    }
                    break;
                }
                case 3: {
                    CompoundTag tag = instance.getOrCreateTag();
                    int second = tag.m_128451_("heldSeconds");
                    LivingEntity target = (LivingEntity)SkillHelper.getTargetingEntity(LivingEntity.class, (LivingEntity)living, (double)30.0, (double)0.5, (boolean)true, (boolean)true);
                    if (target != null && target.m_21023_((MobEffect)TensuraMobEffects.DROWSINESS.get())) {
                        if (tag.m_128441_("target") && !Objects.equals(tag.m_128342_("target"), target.m_20148_())) break;
                        if (heldTicks % 100 == 0 && heldTicks > 0) {
                            this.addMasteryPoint(instance, living);
                        }
                        int controlling = 5;
                        if (heldTicks % 20 == 0) {
                            tag.m_128405_("heldSeconds", second + 1);
                        }
                        if (living instanceof Player) {
                            Player player = (Player)living;
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.time_held.max", (Object[])new Object[]{second, controlling}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
                            player.m_6330_(SoundEvents.f_11867_, SoundSource.PLAYERS, 0.2f, 1.0f);
                        }
                        if (second < controlling) break;
                        DamageSource damageSource = MysticismDamageSources.dreamEater((Entity)living);
                        target.m_6469_((DamageSource)this.sourceWithMP(damageSource, living, instance), 50.0f);
                        DamageSourceHelper.directSpiritualHurt((LivingEntity)target, (Entity)living, (float)50.0f);
                        tag.m_128405_("heldSeconds", 0);
                        instance.decreaseCoolDown(60);
                        break;
                    }
                    tag.m_128405_("heldSeconds", Math.max(0, second - 1));
                    if (tag.m_128451_("heldSeconds") <= 0 || target == null) {
                        tag.m_128473_("target");
                    }
                    if (!(living instanceof Player)) break;
                    Player player = (Player)living;
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.time_held", (Object[])new Object[]{second}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
                }
            }
            return true;
        }
        return false;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity entity, LivingHurtEvent event) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (storage.getSkill((ManasSkill)UltimateSkills.MEPHISTO.get()).isPresent() || storage.getSkill((ManasSkill)UltimateSkills.SEPHIROT.get()).isPresent()) {
            return;
        }
        if ((event.getEntity().m_21224_() || event.getEntity().m_21223_() - event.getAmount() <= 0.0f) && event.getEntity().m_21023_((MobEffect)TensuraMobEffects.DROWSINESS.get())) {
            if (event.getEntity() instanceof Player) {
                instance.decreaseCoolDown(60);
            } else {
                instance.decreaseCoolDown(10);
            }
        }
    }

    public void dream(ManasSkillInstance instance, LivingEntity entity, Level level) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (this.haveUpgrade(storage, entity)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CompoundTag tag = instance.getOrCreateTag();
            if (tag.m_128471_("Dream")) {
                if (player.m_6144_()) {
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.dream.cancel").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE)), false);
                    tag.m_128379_("Dream", false);
                } else {
                    ArrayList<Object> stats = this.readStatsFromTag(tag);
                    this.restoreStats(player, stats);
                    BlockPos position = this.readLocationFromTag(tag);
                    ResourceKey<Level> dimension = this.readLevelFromTag(tag);
                    if (!player.f_19853_.m_46472_().equals(dimension)) {
                        ServerLevel targetLevel = player.m_20194_().m_129880_(dimension);
                        if (targetLevel != null && !targetLevel.m_46472_().equals(MysticismDimensions.FANTASY_WORLD)) {
                            SkillHelper.moveAcrossDimensionTo((Entity)entity, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), (float)1.0f, (float)1.0f, (ServerLevel)targetLevel);
                        } else {
                            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.mephisto.checkpoint_bad_dimension").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                        }
                    } else {
                        player.m_6021_((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_());
                    }
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.dream.restore").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE)), false);
                    instance.setCoolDown(600);
                    tag.m_128379_("Dream", false);
                }
            } else {
                ArrayList<Object> stats = this.createDream(instance, entity);
                this.writeStatsToTag(tag, stats, player);
                tag.m_128379_("Dream", true);
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.dream.create").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.LIGHT_PURPLE)), false);
            }
        }
    }

    public void onDeath(ManasSkillInstance instance, LivingDeathEvent event) {
        CompoundTag tag = instance.getOrCreateTag();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (SkillUtils.hasSkill((Entity)event.getSource().m_7639_(), (ManasSkill)((ManasSkill)UltimateSkills.SUSANOO.get()))) {
                return;
            }
            if (tag.m_128471_("Dream")) {
                ServerLevel targetLevel;
                event.setCanceled(true);
                event.getEntity().m_21219_();
                event.getEntity().f_19802_ = 60;
                ArrayList<Object> stats = this.readStatsFromTag(tag);
                this.restoreStats(player, stats);
                BlockPos position = this.readLocationFromTag(tag);
                ResourceKey<Level> dimension = this.readLevelFromTag(tag);
                if (!player.f_19853_.m_46472_().equals(dimension)) {
                    targetLevel = player.m_20194_().m_129880_(dimension);
                    if (targetLevel != null && !targetLevel.equals(MysticismDimensions.FANTASY_WORLD)) {
                        SkillHelper.moveAcrossDimensionTo((Entity)event.getEntity(), (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), (float)1.0f, (float)1.0f, (ServerLevel)targetLevel);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.mephisto.checkpoint_bad_dimension").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                } else {
                    player.m_6021_((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_());
                }
                if (!player.f_19853_.m_46472_().equals(dimension)) {
                    targetLevel = player.m_20194_().m_129880_(dimension);
                    if (targetLevel != null && !targetLevel.m_46472_().equals(MysticismDimensions.FANTASY_WORLD)) {
                        SkillHelper.moveAcrossDimensionTo((Entity)event.getEntity(), (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), (float)1.0f, (float)1.0f, (ServerLevel)targetLevel);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.mephisto.checkpoint_bad_dimension").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                } else {
                    player.m_6021_((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_());
                }
                player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11757_, SoundSource.PLAYERS, 1.0f, 1.0f);
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.dream.death").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE)), false);
                instance.setCoolDown(1200);
                tag.m_128379_("Dream", false);
            }
        }
    }

    private ArrayList<Object> createDream(ManasSkillInstance instance, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float currentHealth = player.m_21223_();
            double currentMP = TensuraPlayerCapability.getMagicule((Player)player);
            double currentAP = TensuraPlayerCapability.getAura((Player)player);
            double currentSHP = TensuraEPCapability.getSpiritualHealth((LivingEntity)player);
            ArrayList<Object> stats = new ArrayList<Object>();
            stats.add(Float.valueOf(currentHealth));
            stats.add(currentMP);
            stats.add(currentAP);
            stats.add(currentSHP);
            return stats;
        }
        return new ArrayList<Object>();
    }

    private void restoreStats(Player player, ArrayList<Object> stats) {
        if (stats.size() == 4) {
            float health = ((Float)stats.get(0)).floatValue();
            double mp = (Double)stats.get(1);
            double ap = (Double)stats.get(2);
            double shp = (Double)stats.get(3);
            player.m_21153_(health);
            TensuraPlayerCapability.setMagicule((Player)player, (double)mp);
            TensuraPlayerCapability.setAura((Player)player, (double)ap);
            TensuraEPCapability.setSpiritualHealth((LivingEntity)player, (double)shp);
        } else {
            System.out.println("Invalid stats list!");
        }
    }

    private void writeStatsToTag(CompoundTag tag, ArrayList<Object> stats, Player player) {
        tag.m_128350_("Health", ((Float)stats.get(0)).floatValue());
        tag.m_128347_("MP", ((Double)stats.get(1)).doubleValue());
        tag.m_128347_("AP", ((Double)stats.get(2)).doubleValue());
        tag.m_128347_("SHP", ((Double)stats.get(3)).doubleValue());
        tag.m_128347_("PosX", player.m_20185_());
        tag.m_128347_("PosY", player.m_20186_());
        tag.m_128347_("PosZ", player.m_20189_());
        tag.m_128359_("Level", player.f_19853_.m_46472_().m_135782_().toString());
    }

    private ArrayList<Object> readStatsFromTag(CompoundTag tag) {
        ArrayList<Object> stats = new ArrayList<Object>();
        stats.add(Float.valueOf(tag.m_128457_("Health")));
        stats.add(tag.m_128459_("MP"));
        stats.add(tag.m_128459_("AP"));
        stats.add(tag.m_128459_("SHP"));
        return stats;
    }

    private BlockPos readLocationFromTag(CompoundTag tag) {
        double x = tag.m_128459_("PosX");
        double y = tag.m_128459_("PosY");
        double z = tag.m_128459_("PosZ");
        return new BlockPos(x, y, z);
    }

    private ResourceKey<Level> readLevelFromTag(CompoundTag tag) {
        String levelName = tag.m_128461_("Level");
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(levelName));
    }

    private boolean haveUpgrade(SkillStorage storage, LivingEntity entity) {
        if (storage.getSkill((ManasSkill)UltimateSkills.SEPHIROT.get()).isPresent() || storage.getSkill((ManasSkill)UltimateSkills.MEPHISTO.get()).isPresent()) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.dreamer_line.have_upgrade").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
            return true;
        }
        return false;
    }
}

