/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import io.github.Memoires.trmysticism.entity.skill.BubbleShieldBarrierEntity;
import io.github.Memoires.trmysticism.entity.skill.DispenserEntity;
import io.github.Memoires.trmysticism.entity.skill.SentryEntity;
import io.github.Memoires.trmysticism.registry.entity.MysticismEntityTypes;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class EngineerSkill
extends Skill {
    public EngineerSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Nullable
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/unique/engineer.png");
    }

    public double getObtainingEpCost() {
        return 75000.0;
    }

    public int modes() {
        return 2;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.engineer.build");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.engineer.bubble_shield");
            default -> Component.m_237119_();
        };
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity living, int heldTicks) {
        Level level = living.m_9236_();
        CompoundTag skillTag = instance.getOrCreateTag();
        if (instance.getMode() == 1) {
            String building;
            String string = building = skillTag != null ? skillTag.m_128461_("building") : "Sentry";
            if (living instanceof Player) {
                BlockPos blockPos;
                BlockHitResult pos;
                Player player = (Player)living;
                if (heldTicks < 100 && heldTicks % 20 == 0) {
                    level.m_5594_(null, living.m_20183_(), SoundEvents.f_12216_, SoundSource.PLAYERS, 0.4f, 1.5f + (float)heldTicks / 100.0f);
                }
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (heldTicks < 100) {
                        for (int i = 0; i < 5; ++i) {
                            double angle = Math.PI * 2 * (double)i / 5.0 + (double)heldTicks / 10.0;
                            double radius = 0.5 + (double)heldTicks / 100.0;
                            double offsetX = Math.cos(angle) * radius;
                            double offsetZ = Math.sin(angle) * radius;
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, living.m_20185_() + offsetX, living.m_20186_() + 1.0, living.m_20189_() + offsetZ, 1, 0.01, 0.01, 0.01, 0.001);
                        }
                    }
                }
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.output_number", (Object[])new Object[]{building}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                if (building.equals("Sentry") && heldTicks == 100) {
                    pos = SkillHelper.getPlayerPOVHitResult((Level)level, (Entity)player, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)3.0);
                    BlockPos blockPos2 = pos.m_82425_();
                    if (level.m_8055_(blockPos2.m_7495_()).m_60767_().m_76333_()) {
                        instance.addMasteryPoint(living);
                        SentryEntity sentry = new SentryEntity((EntityType<? extends TamableAnimal>)((EntityType)MysticismEntityTypes.SENTRY.get()), level);
                        sentry.m_7678_((double)blockPos2.m_123341_() + 0.5, (double)blockPos2.m_123342_() + 1.0, (double)blockPos2.m_123343_() + 0.5, living.m_146908_(), 0.0f);
                        sentry.setSentryLevel(1);
                        sentry.m_21828_(player);
                        sentry.m_6518_((ServerLevelAccessor)level, level.m_6436_(sentry.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                        sentry.m_21391_((Entity)living, 0.0f, 0.0f);
                        level.m_7967_((Entity)sentry);
                        level.m_5594_(null, blockPos2, SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)sentry, (ParticleOptions)ParticleTypes.f_123747_, (double)2.0);
                        instance.setCoolDown(instance.isMastered((LivingEntity)player) ? 15 : 30);
                    }
                } else if (building.equals("Dispenser") && heldTicks == 100 && level.m_8055_((blockPos = (pos = SkillHelper.getPlayerPOVHitResult((Level)level, (Entity)player, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)3.0)).m_82425_()).m_7495_()).m_60767_().m_76333_()) {
                    instance.addMasteryPoint(living);
                    DispenserEntity dispenser = new DispenserEntity((EntityType<? extends TensuraTamableEntity>)((EntityType)MysticismEntityTypes.DISPENSER.get()), level);
                    dispenser.m_7678_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 1.0, (double)blockPos.m_123343_() + 0.5, living.m_146908_(), 0.0f);
                    dispenser.setDispenserLevel(1);
                    dispenser.m_21828_(player);
                    dispenser.m_6518_((ServerLevelAccessor)level, level.m_6436_(dispenser.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    dispenser.m_21391_((Entity)living, 0.0f, 0.0f);
                    level.m_7967_((Entity)dispenser);
                    level.m_5594_(null, blockPos, SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)dispenser, (ParticleOptions)ParticleTypes.f_123747_, (double)2.0);
                    instance.setCoolDown(instance.isMastered((LivingEntity)player) ? 15 : 30);
                }
            }
            return true;
        }
        return false;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        BlockPos pos;
        Player player;
        Level level;
        if (instance.getMode() == 2 && entity instanceof Player && (level = (player = (Player)entity).m_9236_()).m_8055_((pos = player.m_20097_()).m_7495_()).m_60767_().m_76333_()) {
            instance.addMasteryPoint(entity);
            BubbleShieldBarrierEntity bubbleShieldBarrier = new BubbleShieldBarrierEntity((EntityType<? extends BubbleShieldBarrierEntity>)((EntityType)MysticismEntityTypes.BUBBLE_SHIELD.get()), level);
            bubbleShieldBarrier.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, entity.m_146908_(), 0.0f);
            if (instance.isMastered(entity)) {
                bubbleShieldBarrier.setLife(600);
            }
            BubbleShieldBarrierEntity.spawnBubbleShield(entity);
            level.m_5594_(null, pos, SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
            instance.setCoolDown(25);
        }
    }

    public void onScroll(ManasSkillInstance instance, LivingEntity entity, double delta) {
        if (instance.getMode() == 1 && this.isHeld(entity)) {
            int newIndex;
            CompoundTag tag = instance.getOrCreateTag();
            String[] buildings = new String[]{"Sentry", "Dispenser"};
            String currentBuilding = tag.m_128461_("building");
            int currentIndex = Arrays.asList(buildings).indexOf(currentBuilding);
            if (currentIndex == -1) {
                currentIndex = 0;
            }
            if ((newIndex = currentIndex + (delta > 0.0 ? -1 : 1)) >= buildings.length) {
                newIndex = 0;
            } else if (newIndex < 0) {
                newIndex = buildings.length - 1;
            }
            String newBuilding = buildings[newIndex];
            if (!newBuilding.equals(currentBuilding)) {
                tag.m_128359_("building", newBuilding);
                instance.markDirty();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.output_number", (Object[])new Object[]{newBuilding}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                    player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12053_, SoundSource.PLAYERS, 2.0f, 1.0f);
                }
            }
        }
    }
}

