/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.block.HipokuteGrass;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.jetbrains.annotations.Nullable;

public class GardenerSkill
extends Skill {
    public GardenerSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Nullable
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/unique/gardener.png");
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getMastery() >= 0;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled();
    }

    public double getObtainingEpCost() {
        return 60000.0;
    }

    public int modes() {
        return 1;
    }

    public Component getModeName(int mode) {
        return Component.m_237115_((String)"trmysticism.skill.mode.gardener.blessing");
    }

    public void onTick(ManasSkillInstance instance, LivingEntity living) {
        if (!instance.isToggled() || living.m_9236_().f_46443_) {
            return;
        }
        if (SkillHelper.outOfMagicule((LivingEntity)living, (double)20.0)) {
            return;
        }
        Level level = living.m_9236_();
        BlockPos origin = living.m_20183_();
        int radius = 10;
        BlockPos.m_121990_((BlockPos)origin.m_7918_(-radius, -2, -radius), (BlockPos)origin.m_7918_(radius, 2, radius)).forEach(pos -> {
            HipokuteGrass hipokuteGrass;
            Block patt4227$temp;
            int nextAge;
            int currentAge;
            IntegerProperty ageProp;
            CropBlock crop;
            BlockState state = level.m_8055_(pos);
            Block patt3373$temp = state.m_60734_();
            if (patt3373$temp instanceof CropBlock && !(crop = (CropBlock)patt3373$temp).m_52307_(state) && level.f_46441_.m_188501_() < 0.5f) {
                ageProp = crop.m_7959_();
                currentAge = (Integer)state.m_61143_((Property)ageProp);
                nextAge = Math.min(currentAge + 1, crop.m_7419_());
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)ageProp, (Comparable)Integer.valueOf(nextAge)), 2);
                level.m_6263_(null, (double)origin.m_123341_(), (double)origin.m_123342_(), (double)origin.m_123343_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5, 0.3, 0.3, 0.3, 0.05);
            }
            if ((patt4227$temp = state.m_60734_()) instanceof HipokuteGrass && (Integer)state.m_61143_((Property)(hipokuteGrass = (HipokuteGrass)patt4227$temp).getAgeProperty()) < hipokuteGrass.getMaxAge() && level.f_46441_.m_188501_() < 0.1f) {
                ageProp = hipokuteGrass.getAgeProperty();
                currentAge = (Integer)state.m_61143_((Property)ageProp);
                nextAge = Math.min(currentAge + 1, hipokuteGrass.getMaxAge());
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)ageProp, (Comparable)Integer.valueOf(nextAge)), 2);
                level.m_6263_(null, (double)origin.m_123341_(), (double)origin.m_123342_(), (double)origin.m_123343_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5, 0.3, 0.3, 0.3, 0.05);
            }
        });
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity entity, LivingHurtEvent event) {
        ItemStack heldItem = entity.m_21205_();
        Item item = heldItem.m_41720_();
        if (item instanceof HoeItem) {
            HoeItem hoe = (HoeItem)item;
            if (DamageSourceHelper.isPhysicalAttack((DamageSource)event.getSource())) {
                Tier material = hoe.m_43314_();
                float swordBaseDamage = 3.0f + material.m_6631_();
                event.setAmount(swordBaseDamage * 1.125f + 2.0f);
            }
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        ItemStack item = entity.m_21205_();
        boolean success = false;
        if (item.m_41784_().m_128471_("GardenerBlessed")) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.gardener.blessing.already_blessed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
            return;
        }
        if (!entity.m_9236_().f_46443_ && item.m_41614_()) {
            if (instance.isMastered(entity) ? SkillHelper.outOfMagicule((LivingEntity)entity, (double)(500 * item.m_41613_())) : SkillHelper.outOfMagicule((LivingEntity)entity, (double)(250 * item.m_41613_()))) {
                return;
            }
            success = true;
            item.m_41784_().m_128379_("GardenerBlessed", true);
            item.m_41784_().m_128379_("GardenerMastery", instance.isMastered(entity));
            long timeOfDay = entity.f_19853_.m_46468_() % 24000L;
            ListTag lore = new ListTag();
            if (timeOfDay >= 0L && timeOfDay < 6000L) {
                item.m_41784_().m_128379_("DaytimeBlessing", true);
                lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"Blessed by [Gardener] at Dawn").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD).m_131155_(Boolean.valueOf(false))))));
            } else if (timeOfDay >= 6000L && timeOfDay < 12000L) {
                item.m_41784_().m_128379_("NoonBlessing", true);
                lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"Blessed by [Gardener] at Noon").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW).m_131155_(Boolean.valueOf(false))))));
            } else if (timeOfDay >= 12000L) {
                item.m_41784_().m_128379_("NightBlessing", true);
                lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"Blessed by [Gardener] at Night").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE).m_131155_(Boolean.valueOf(false))))));
            }
            CompoundTag display = item.m_41784_().m_128469_("display");
            display.m_128365_("Lore", (Tag)lore);
            item.m_41784_().m_128365_("display", (Tag)display);
        }
        if (success) {
            this.addMasteryPoint(instance, entity, item.m_41613_() / 10 + SkillUtils.getBonusMasteryPoint((ManasSkillInstance)instance, (LivingEntity)entity, (int)(item.m_41613_() / 10)));
            instance.setCoolDown(instance.isMastered(entity) ? 1 : 3);
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

