/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import io.github.Memoires.trmysticism.api.IWeaponStorage;
import io.github.Memoires.trmysticism.entity.skill.GateEntity;
import io.github.Memoires.trmysticism.menu.container.WeaponStorageContainer;
import io.github.Memoires.trmysticism.registry.entity.MysticismEntityTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GatekeeperSkill
extends Skill
implements IWeaponStorage {
    private static final Map<UUID, List<GateEntity>> GATE_MAP = new HashMap<UUID, List<GateEntity>>();

    public GatekeeperSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Nullable
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/unique/gatekeeper.png");
    }

    public int modes() {
        return 3;
    }

    public double getObtainingEpCost() {
        return 85000.0;
    }

    public void onTick(ManasSkillInstance instance, LivingEntity living) {
        living.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 200, 4, false, false, true));
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getMastery() >= 0 && this.isInSlot(entity);
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 25000.0;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.gatekeeper.enkidu");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.gatekeeper.kings_storehouse");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.gatekeeper.gate_of_babylon");
            default -> Component.m_237119_();
        };
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 3 : instance.getMode() - 1;
        }
        return instance.getMode() == 3 ? 1 : instance.getMode() + 1;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() == 1) {
            LivingEntity target = (LivingEntity)SkillHelper.getTargetingEntity(LivingEntity.class, (LivingEntity)entity, (double)30.0, (double)0.2, (boolean)false, (boolean)true);
            if (!SkillHelper.outOfMagicule((LivingEntity)entity, (double)this.magiculeCost(entity, instance))) {
                if (target == null) {
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.not_targeted").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                    instance.setCoolDown(instance.isMastered(entity) ? 10 : 20);
                    return;
                }
                if (target.m_21023_((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get())) {
                    target.m_21195_((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get());
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123747_, (double)1.0);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123749_, (double)1.0);
                } else {
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        if (player.m_150110_().f_35934_) {
                            return;
                        }
                    }
                    if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                        return;
                    }
                    instance.addMasteryPoint(entity);
                    instance.setCoolDown(instance.isMastered(entity) ? 10 : 20);
                    int duration = this.isMastered(instance, entity) ? 4800 : 2400;
                    SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get()), (int)duration, (int)0, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                    DamageSourceHelper.markHurt((LivingEntity)target, (Entity)entity);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123747_, (double)1.0);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123813_, (double)1.0);
                    entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        } else if (instance.getMode() == 2) {
            this.openWeaponStorage(entity, instance);
        } else if (instance.getMode() == 3) {
            int mastery = instance.getMastery();
            int cooldown = mastery >= 1000 ? 3 : (mastery >= 500 ? 4 : 5);
            instance.setCoolDown(cooldown);
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() != 3) {
            return false;
        }
        int mastery = instance.getMastery();
        double cost = mastery >= 1000 ? 12500.0 : (mastery >= 750 ? 1000.0 : (mastery >= 500 ? 7500.0 : (mastery >= 250 ? 5000.0 : 2500.0)));
        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (double)cost)) {
            boolean surround;
            if (heldTicks % 20 == 0) {
                instance.addMasteryPoint(entity);
                Vec3 targetPos = this.getGateTarget(entity);
                boolean surround2 = entity.m_6144_();
                LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)30.0, (boolean)true, (boolean)true);
                this.spawnGates(entity, targetPos, surround2, instance, target);
            }
            Vec3 targetPos = (surround = entity.m_6144_()) ? this.getGateTarget(entity) : entity.m_146892_().m_82549_(entity.m_20154_().m_82490_(30.0));
            List<GateEntity> gates = GATE_MAP.get(entity.m_20148_());
            if (gates != null && !surround) {
                Iterator<GateEntity> iter = gates.iterator();
                while (iter.hasNext()) {
                    GateEntity gate = iter.next();
                    if (!gate.m_6084_()) {
                        iter.remove();
                        continue;
                    }
                    Vec3 toTarget = targetPos.m_82546_(gate.m_20182_()).m_82541_();
                    float yaw = (float)(Math.atan2(toTarget.f_82479_, toTarget.f_82481_) * 57.29577951308232);
                    float pitch = (float)(-Math.asin(toTarget.f_82480_) * 57.29577951308232);
                    gate.m_146922_(yaw);
                    gate.m_146926_(pitch);
                    gate.f_19859_ = yaw;
                    gate.f_19860_ = pitch;
                }
            }
        }
        return false;
    }

    private Vec3 getGateTarget(LivingEntity entity) {
        int distance = 30;
        LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)distance, (boolean)false, (boolean)true);
        if (target != null) {
            return target.m_146892_();
        }
        BlockHitResult result = SkillHelper.getPlayerPOVHitResult((Level)entity.f_19853_, (Entity)entity, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)distance);
        return result.m_82450_().m_82520_(0.0, 0.5, 0.0);
    }

    private void spawnGates(LivingEntity entity, Vec3 center, boolean surround, ManasSkillInstance instance, @Nullable LivingEntity target) {
        Level level = entity.f_19853_;
        int count = GatekeeperSkill.getCount(surround, instance);
        double radius = 3.0;
        Vec3 playerPos = entity.m_146892_().m_82492_(0.0, 0.5, 0.0);
        Vec3 lookDir = entity.m_20154_().m_82541_();
        Vec3 right = lookDir.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        Vec3 backward = lookDir.m_82490_(-1.0);
        Vec3 lineCenter = playerPos.m_82549_(backward.m_82490_(2.0));
        Vec3 rightOffset = right.m_82490_(3.0);
        Vec3 lineStart = lineCenter.m_82546_(rightOffset.m_82490_((double)(count - 1) / 2.0));
        for (int i = 0; i < count; ++i) {
            float pitch;
            float yaw;
            Vec3 spawnPos;
            if (surround) {
                double angle = Math.PI * 2 * (double)i / (double)count;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                spawnPos = center.m_82520_(xOffset, 1.0, zOffset);
            } else {
                spawnPos = lineStart.m_82549_(rightOffset.m_82490_((double)i));
            }
            if (surround) {
                Vec3 toCenter = center.m_82546_(spawnPos).m_82541_();
                yaw = (float)(Mth.m_14136_((double)(-toCenter.f_82479_), (double)(-toCenter.f_82481_)) * 57.29577951308232);
                pitch = (float)(-Mth.m_14136_((double)toCenter.f_82480_, (double)1.0) * 57.29577951308232);
            } else {
                yaw = (float)(Mth.m_14136_((double)(-lookDir.f_82479_), (double)(-lookDir.f_82481_)) * 57.29577951308232);
                pitch = (float)(-Mth.m_14136_((double)lookDir.f_82480_, (double)1.0) * 57.29577951308232);
            }
            GateEntity gate = new GateEntity((EntityType<? extends Entity>)((EntityType)MysticismEntityTypes.GATE.get()), level);
            if (surround) {
                gate.setSurround(true);
                if (target != null) {
                    gate.setTarget(target);
                }
            }
            gate.m_146884_(spawnPos);
            gate.m_146922_(yaw);
            gate.m_146926_(pitch);
            gate.f_19859_ = yaw;
            gate.f_19860_ = pitch;
            gate.setOwner(entity);
            gate.setSkill(instance);
            gate.setSkillInstance(instance);
            level.m_7967_((Entity)gate);
            GATE_MAP.computeIfAbsent(entity.m_20148_(), k -> new ArrayList()).add(gate);
        }
    }

    private static int getCount(boolean surround, ManasSkillInstance instance) {
        int mastery = instance.getMastery();
        int count = mastery >= 1000 ? 5 : (mastery >= 750 ? 4 : (mastery >= 500 ? 3 : (mastery >= 250 ? 2 : 1)));
        if (surround) {
            count += 2;
        }
        return count;
    }

    public static float getWeaponBaseDamage(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof SwordItem) {
            SwordItem sword = (SwordItem)item;
            float damage = sword.m_43299_();
            return damage;
        }
        Item damage = stack.m_41720_();
        if (damage instanceof TieredItem) {
            TieredItem tiered = (TieredItem)damage;
            float damage2 = tiered.m_43314_().m_6631_();
            return damage2;
        }
        return 10.0f;
    }

    @Override
    @NotNull
    public WeaponStorageContainer getWeaponStorage(ManasSkillInstance instance, LivingEntity entity) {
        boolean isMastered = instance.isMastered(entity);
        int size = isMastered ? 10 : 5;
        WeaponStorageContainer container = new WeaponStorageContainer(size, 5);
        container.m_7797_(instance.getOrCreateTag().m_128437_("SpatialStorage", 10));
        return container;
    }
}

