/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.intrinsic.CharmSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class HiddenRulerSkill
extends Skill {
    protected static final List<TensuraSkill> hiddenRulerSkills = new ArrayList<TensuraSkill>();

    public HiddenRulerSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/unique/hidden_ruler.png");
    }

    public int modes() {
        return 3;
    }

    public double getObtainingEpCost() {
        return 75000.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getMastery() >= 0;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return -100;
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        return (instance.getMode() == 1 || instance.getMode() == 2) && entity.m_6144_();
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1, 2 -> 500.0;
            case 3 -> 1000.0;
            default -> 0.0;
        };
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        if (instance.getMastery() >= 0 && !instance.isTemporarySkill()) {
            TensuraSkillInstance shadowMotion = new TensuraSkillInstance((ManasSkill)ExtraSkills.SHADOW_MOTION.get());
            shadowMotion.getOrCreateTag().m_128379_("NoMagiculeCost", true);
            if (SkillUtils.learnSkill((LivingEntity)entity, (ManasSkillInstance)shadowMotion) && entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{shadowMotion.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            }
        }
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getMastery() >= 0;
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(15.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && living.m_7307_((Entity)entity));
        if (!list.isEmpty()) {
            int level = instance.isMastered(entity) ? 1 : 0;
            for (LivingEntity target : list) {
                if (SkillHelper.isSubordinate((LivingEntity)target, (LivingEntity)entity)) {
                    return;
                }
                target.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.INSPIRATION.get(), 240, level, false, false, false), (Entity)entity);
            }
        }
        if (instance.isToggled()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_CONCEALMENT.get(), 240, 1, false, false, false));
        }
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 3 : instance.getMode() - 1;
        }
        return instance.getMode() == 3 ? 1 : instance.getMode() + 1;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.hidden_ruler.copy");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.hidden_ruler.paste");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.hidden_ruler.recruitment");
            default -> Component.m_237119_();
        };
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            MinecraftServer server = player.m_20194_();
            PlayerList playerList = player.m_20194_().m_6846_();
            ClientboundPlayerInfoPacket packet = new ClientboundPlayerInfoPacket(ClientboundPlayerInfoPacket.Action.REMOVE_PLAYER, new ServerPlayer[]{player});
            MutableComponent leaveMessage = Component.m_237110_((String)"multiplayer.player.left", (Object[])new Object[]{player.m_5446_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
            for (ServerPlayer target : playerList.m_11314_()) {
                MobEffectInstance effect = target.m_21124_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get());
                if (server.m_129944_(target.m_36316_()) >= 2 && (effect == null || effect.m_19564_() <= 1)) continue;
                target.f_8906_.m_9829_((Packet)packet);
                target.m_213846_((Component)leaveMessage);
            }
        }
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            MinecraftServer server = player.m_20194_();
            PlayerList playerList = player.m_20194_().m_6846_();
            ClientboundPlayerInfoPacket packet = new ClientboundPlayerInfoPacket(ClientboundPlayerInfoPacket.Action.ADD_PLAYER, new ServerPlayer[]{player});
            MutableComponent joinMessage = Component.m_237110_((String)"multiplayer.player.joined", (Object[])new Object[]{player.m_5446_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
            for (ServerPlayer target : playerList.m_11314_()) {
                MobEffectInstance effect = target.m_21124_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get());
                if (server.m_129944_(target.m_36316_()) >= 2 && (effect == null || effect.m_19564_() <= 1)) continue;
                target.f_8906_.m_9829_((Packet)packet);
                target.m_213846_((Component)joinMessage);
            }
        }
    }

    public void onDeath(ManasSkillInstance instance, LivingDeathEvent event) {
        hiddenRulerSkills.clear();
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        block40: {
            LivingEntity target;
            block44: {
                int chance;
                SkillStorage storage;
                block46: {
                    block45: {
                        block39: {
                            boolean failed;
                            ServerLevel level;
                            block43: {
                                List<ManasSkillInstance> collection;
                                int chance2;
                                block42: {
                                    Player player;
                                    block41: {
                                        storage = SkillAPI.getSkillsFrom((Entity)entity);
                                        target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)10.0, (boolean)false);
                                        if (instance.getMode() != 1) break block39;
                                        if (entity.m_6144_()) {
                                            if (!hiddenRulerSkills.isEmpty()) {
                                                if (entity instanceof Player) {
                                                    Player player2 = (Player)entity;
                                                    player2.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.hidden_ruler.collection_header").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), false);
                                                    for (TensuraSkill skill : hiddenRulerSkills) {
                                                        player2.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.hidden_ruler.collection", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), false);
                                                    }
                                                }
                                            } else if (entity instanceof Player) {
                                                Player player3 = (Player)entity;
                                                player3.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.hidden_ruler.collection_empty").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                                            }
                                            return;
                                        }
                                        if (target == null || !target.m_6084_()) break block40;
                                        if (!(target instanceof Player)) break block41;
                                        player = (Player)target;
                                        if (player.m_150110_().f_35934_) break block40;
                                    }
                                    if ((long)hiddenRulerSkills.size() != 5L) break block42;
                                    if (entity instanceof Player) {
                                        player = (Player)entity;
                                        player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.hidden_ruler.max_collection").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                                    }
                                    break block40;
                                }
                                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                                level = (ServerLevel)entity.m_9236_();
                                int n = chance2 = instance.isMastered(entity) ? 50 : 25;
                                if (entity instanceof Player) {
                                    Player player = (Player)entity;
                                    if (player.m_150110_().f_35937_) {
                                        chance2 = 100;
                                    }
                                }
                                failed = true;
                                if (entity.m_217043_().m_188503_(100) > chance2 || (collection = SkillAPI.getSkillsFrom((Entity)target).getLearnedSkills().stream().filter(this::canCopy).toList()).isEmpty()) break block43;
                                this.addMasteryPoint(instance, entity);
                                ManasSkill skill = collection.get(target.m_217043_().m_188503_(collection.size())).getSkill();
                                if (hiddenRulerSkills.contains(skill)) break block40;
                                if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)skill)) {
                                    instance.setCoolDown(10);
                                    failed = false;
                                    if (entity instanceof Player) {
                                        Player player = (Player)entity;
                                        player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.viciel.copy_bank", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
                                        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                                    }
                                    hiddenRulerSkills.add((TensuraSkill)skill);
                                    level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                                } else if (SkillUtils.learnSkill((LivingEntity)entity, (ManasSkill)skill, (int)-2)) {
                                    instance.setCoolDown(10);
                                    failed = false;
                                    if (entity instanceof Player) {
                                        Player player = (Player)entity;
                                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.success_drain", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
                                        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                                        storage.syncChanges();
                                    }
                                    hiddenRulerSkills.add((TensuraSkill)skill);
                                    level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                                }
                            }
                            if (failed && entity instanceof Player) {
                                Player player = (Player)entity;
                                player.m_5661_((Component)Component.m_237115_((String)"tensura.ability.activation_failed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                                level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
                                instance.setCoolDown(5);
                            }
                            break block40;
                        }
                        if (instance.getMode() != 2) break block44;
                        if (!hiddenRulerSkills.isEmpty()) break block45;
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.hidden_ruler.paste.collection_empty").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                        }
                        break block40;
                    }
                    if (entity.m_6144_()) {
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.hidden_ruler.collection_header").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), false);
                            for (TensuraSkill skill : hiddenRulerSkills) {
                                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.hidden_ruler.collection", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), false);
                            }
                        }
                        return;
                    }
                    if (target == null || !target.m_6084_()) break block40;
                    if (!(target instanceof Player)) break block46;
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) break block40;
                }
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                ServerLevel level = (ServerLevel)entity.m_9236_();
                int n = chance = instance.isMastered(entity) ? 50 : 25;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (player.m_150110_().f_35937_) {
                        chance = 100;
                    }
                }
                boolean failed = true;
                TensuraSkill skill = hiddenRulerSkills.get(target.m_217043_().m_188503_(hiddenRulerSkills.size()));
                TensuraSkillInstance pastedInstance = new TensuraSkillInstance((ManasSkill)skill);
                if (entity.m_217043_().m_188503_(100) <= chance && !hiddenRulerSkills.isEmpty()) {
                    if (SkillUtils.learnSkill((LivingEntity)target, (ManasSkill)skill, (int)-2) && target instanceof Player) {
                        if (target instanceof Player) {
                            Player targetPlayer = (Player)target;
                            targetPlayer.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.success_drain", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
                            targetPlayer.m_9236_().m_6263_(null, targetPlayer.m_20185_(), targetPlayer.m_20186_(), targetPlayer.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            storage.syncChanges();
                        }
                    } else if (target instanceof Mob) {
                        SkillAPI.getSkillsFrom((Entity)target).learnSkill((ManasSkillInstance)pastedInstance);
                        Optional storedInstance = SkillAPI.getSkillsFrom((Entity)target).getSkill((ManasSkill)skill);
                        if (storedInstance.isPresent() && ((ManasSkillInstance)storedInstance.get()).canBeToggled(target)) {
                            ((ManasSkillInstance)storedInstance.get()).setToggled(true);
                        }
                    }
                    SkillAPI.getSkillsFrom((Entity)target).syncChanges();
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.hidden_ruler.paste.success", (Object[])new Object[]{skill.getName(), target.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
                    }
                    this.addMasteryPoint(instance, entity);
                    instance.setCoolDown(10);
                    failed = false;
                    hiddenRulerSkills.remove(skill);
                    ManasSkillInstance instanceSkill = SkillUtils.getSkillOrNull((Entity)entity, (ManasSkill)skill);
                    CompoundTag skillTag = instanceSkill.getOrCreateTag();
                    if (instanceSkill.isTemporarySkill()) {
                        storage.forgetSkill((ManasSkill)skill);
                    }
                    level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    return;
                }
                if (failed && entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"tensura.ability.activation_failed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.remove", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    instance.setCoolDown(10);
                    ManasSkillInstance instanceSkill = SkillUtils.getSkillOrNull((Entity)entity, (ManasSkill)skill);
                    hiddenRulerSkills.remove(skill);
                    if (instanceSkill.isTemporarySkill()) {
                        storage.forgetSkill((ManasSkill)skill);
                    }
                }
                break block40;
            }
            if (target != null) {
                double targetEP = TensuraEPCapability.getEP((LivingEntity)target);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (TensuraPlayerCapability.getCurrentEP((Player)player) > targetEP * 5.0) {
                        CharmSkill.charm((ManasSkillInstance)instance, (LivingEntity)entity);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.hidden_ruler.recruitment.fail").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                }
            }
        }
    }

    public boolean canCopy(ManasSkillInstance instance) {
        if (!instance.isTemporarySkill() && instance.getMastery() >= 0) {
            ManasSkill copiedSKill = instance.getSkill();
            if (!(copiedSKill instanceof Skill)) {
                return false;
            }
            Skill skill = (Skill)copiedSKill;
            return skill.getType().equals((Object)Skill.SkillType.COMMON) || skill.getType().equals((Object)Skill.SkillType.EXTRA) || skill.getType().equals((Object)Skill.SkillType.INTRINSIC);
        }
        return false;
    }
}

