/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.effect.template.MobEffectHelper;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import io.github.Memoires.trmysticism.registry.particles.MysticismParticles;
import io.github.Memoires.trmysticism.registry.skill.UniqueSkills;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class InverseSkill
extends Skill {
    public InverseSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/unique/inverse.png");
    }

    public int modes() {
        return 2;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.inverse.malice_exchange");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.inverse.redirect");
            default -> Component.m_237119_();
        };
    }

    public double getObtainingEpCost() {
        return 60000.0;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return entity.m_21223_() < entity.m_21233_() / 4.0f && instance.isMastered(entity) && instance.isToggled();
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return instance.getMastery() >= 0;
    }

    public static boolean hasFullCounter(ManasSkillInstance instance, LivingAttackEvent event) {
        DamageSource damageSource = event.getSource();
        return instance.isToggled() && damageSource.m_19387_();
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (!SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            switch (instance.getMode()) {
                case 1: {
                    this.maliceExchange(instance, entity);
                    break;
                }
                case 2: {
                    this.redirect(instance, entity);
                }
            }
        }
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        DamageSource damageSource;
        LivingEntity entity = event.getEntity();
        if (InverseSkill.hasFullCounter(instance, event) && !(damageSource = event.getSource()).m_19378_() && damageSource.m_7640_() != null) {
            Entity sourceEntity;
            if (damageSource instanceof TensuraDamageSource) {
                TensuraDamageSource source = (TensuraDamageSource)damageSource;
                if (source.getIgnoreBarrier() >= 1.0f) {
                    return;
                }
                if (SkillUtils.hasSkill((Entity)event.getSource().m_7639_(), (ManasSkill)((ManasSkill)UniqueSkills.INVERSE.get()))) {
                    return;
                }
            }
            if ((sourceEntity = event.getSource().m_7639_()) != null) {
                sourceEntity.f_19802_ = 0;
                sourceEntity.m_6469_((DamageSource)DamageSourceHelper.turnTensura((DamageSource)event.getSource(), (Entity)entity), event.getAmount() * (float)(instance.isMastered(entity) ? 2 : 1));
            }
            event.setCanceled(true);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)((ParticleOptions)MysticismParticles.DARK_BLUE_LIGHTNING_SPARK.get()));
            TensuraParticleHelper.spawnServerParticles((Level)entity.f_19853_, (ParticleOptions)((ParticleOptions)MysticismParticles.DARK_BLUE_LIGHTNING_SPARK.get()), (double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_(), (int)55, (double)0.08, (double)0.08, (double)0.08, (double)0.5, (boolean)true);
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        double maxDistance = 40.0;
        Entity farthestEntity = null;
        double maxDistSquared = 0.0;
        for (Entity e : level.m_45933_((Entity)entity, entity.m_20191_().m_82400_(maxDistance))) {
            double distanceSquared;
            if (!(e instanceof LivingEntity) || e == entity || !((distanceSquared = entity.m_20280_(e)) > maxDistSquared)) continue;
            maxDistSquared = distanceSquared;
            farthestEntity = e;
        }
        if (!instance.onCoolDown() && farthestEntity != null) {
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            this.addMasteryPoint(instance, entity);
            Vec3 targetPos = farthestEntity.m_20182_();
            Vec3 userPos = entity.m_20182_();
            farthestEntity.m_183634_();
            farthestEntity.m_19877_();
            farthestEntity.m_146884_(userPos);
            farthestEntity.f_19812_ = true;
            farthestEntity.f_19864_ = true;
            entity.m_183634_();
            entity.m_19877_();
            entity.m_20219_(targetPos);
            entity.f_19812_ = true;
            entity.f_19864_ = true;
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)farthestEntity, (ParticleOptions)ParticleTypes.f_123760_, (double)1.0);
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123760_, (double)1.0);
            level.m_6263_(null, farthestEntity.m_20185_(), farthestEntity.m_20186_(), farthestEntity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
            instance.setCoolDown(120);
        }
    }

    public void maliceExchange(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag skillTag = instance.getOrCreateTag();
        ArrayList<MobEffectInstance> savedEffects = new ArrayList<MobEffectInstance>();
        if (skillTag.m_128425_("SavedEffects", 9)) {
            ListTag savedEffectsTag = skillTag.m_128437_("SavedEffects", 10);
            for (int i = 0; i < savedEffectsTag.size(); ++i) {
                CompoundTag compoundTag = savedEffectsTag.m_128728_(i);
                MobEffectInstance effectInstance = MobEffectInstance.m_19560_((CompoundTag)compoundTag);
                if (effectInstance == null) continue;
                savedEffects.add(effectInstance);
            }
        }
        if (entity.m_6144_()) {
            if (!savedEffects.isEmpty()) {
                for (MobEffectInstance effect2 : savedEffects) {
                    entity.m_7292_(new MobEffectInstance(effect2));
                }
                savedEffects.clear();
                skillTag.m_128473_("SavedEffects");
                entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                List playerHarmfulEffects = entity.m_21220_().stream().filter(effect -> !effect.m_19544_().m_19486_()).collect(Collectors.toList());
                if (!playerHarmfulEffects.isEmpty()) {
                    for (MobEffectInstance mobEffectInstance : playerHarmfulEffects) {
                        entity.m_21195_(mobEffectInstance.m_19544_());
                        savedEffects.add(new MobEffectInstance(mobEffectInstance));
                    }
                    ListTag effectsToSave = new ListTag();
                    for (MobEffectInstance effect4 : savedEffects) {
                        CompoundTag effectTag = new CompoundTag();
                        effect4.m_19555_(effectTag);
                        effectsToSave.add((Object)effectTag);
                    }
                    skillTag.m_128365_("SavedEffects", (Tag)effectsToSave);
                    entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (entity instanceof Player) {
                        ((Player)entity).m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.malice_exchange.target_harmful_effects_saved").m_130940_(ChatFormatting.RED), true);
                    }
                    instance.setCoolDown(instance.isMastered(entity) ? 5 : 10);
                } else if (entity instanceof Player) {
                    ((Player)entity).m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.malice_exchange.no_harmful_effects").m_130940_(ChatFormatting.RED), true);
                }
            }
            return;
        }
        LivingEntity target = (LivingEntity)SkillHelper.getTargetingEntity(LivingEntity.class, (LivingEntity)entity, (double)30.0, (double)0.5, (boolean)true, (boolean)true);
        if (target == null) {
            if (entity instanceof Player) {
                ((Player)entity).m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.malice_exchange.no_target").m_130940_(ChatFormatting.RED), true);
            }
            return;
        }
        if (!savedEffects.isEmpty()) {
            for (MobEffectInstance mobEffectInstance : savedEffects) {
                target.m_7292_(new MobEffectInstance(mobEffectInstance));
            }
            savedEffects.clear();
            skillTag.m_128473_("SavedEffects");
            entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (entity instanceof Player) {
                ((Player)entity).m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.malice_exchange.saved_effects_applied").m_130940_(ChatFormatting.GREEN), true);
            }
        } else {
            List harmfulEffects = target.m_21220_().stream().filter(effect -> !effect.m_19544_().m_19486_()).collect(Collectors.toList());
            if (!harmfulEffects.isEmpty()) {
                for (MobEffectInstance effect2 : harmfulEffects) {
                    target.m_21195_(effect2.m_19544_());
                    savedEffects.add(new MobEffectInstance(effect2));
                }
                ListTag listTag = new ListTag();
                for (MobEffectInstance effect5 : savedEffects) {
                    CompoundTag effectTag = new CompoundTag();
                    effect5.m_19555_(effectTag);
                    listTag.add((Object)effectTag);
                }
                skillTag.m_128365_("SavedEffects", (Tag)listTag);
                entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (entity instanceof Player) {
                    ((Player)entity).m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.malice_exchange.target_harmful_effects_saved").m_130940_(ChatFormatting.RED), true);
                }
                instance.setCoolDown(instance.isMastered(entity) ? 5 : 10);
            } else if (entity instanceof Player) {
                ((Player)entity).m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.malice_exchange.no_harmful_effects").m_130940_(ChatFormatting.RED), true);
            }
        }
    }

    public void redirect(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        if (MobEffectHelper.noTeleportation((LivingEntity)entity)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.spatial_blockade").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return;
        }
        Entity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)30.0, (double)0.2, (boolean)false, (boolean)false);
        if (target == null) {
            return;
        }
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        this.addMasteryPoint(instance, entity);
        Vec3 targetPos = new Vec3(target.m_20182_().m_7096_(), target.m_20182_().m_7098_(), target.m_20182_().m_7094_());
        Vec3 userPos = new Vec3(entity.m_20182_().m_7096_(), entity.m_20182_().m_7098_(), entity.m_20182_().m_7094_());
        target.m_183634_();
        target.m_19877_();
        target.m_146884_(userPos);
        target.f_19812_ = true;
        target.f_19864_ = true;
        entity.m_183634_();
        entity.m_19877_();
        entity.m_20219_(targetPos);
        entity.f_19812_ = true;
        entity.f_19864_ = true;
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123760_, (double)1.0);
        level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123760_, (double)1.0);
        level.m_6263_((Player)null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

