/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import io.github.Memoires.trmysticism.data.repeater.JumpTracker;
import io.github.Memoires.trmysticism.data.repeater.PlayerActionFrame;
import io.github.Memoires.trmysticism.util.TimerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.jetbrains.annotations.Nullable;

public class RepeaterSkill
extends Skill {
    private static final ThreadLocal<Boolean> isRepeating = ThreadLocal.withInitial(() -> false);
    private static boolean recursionDepth;
    public static final Map<UUID, List<PlayerActionFrame>> PLAYBACK_FRAMES;

    public RepeaterSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    public double getObtainingEpCost() {
        return 75000.0;
    }

    @Nullable
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/unique/repeater.png");
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getMastery() >= 0;
    }

    public int modes() {
        return 2;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        if (instance.getMode() == 1) {
            return 500.0;
        }
        return 1000.0;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.repeater.recursion_depth");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.repeater.playback");
            default -> Component.m_237119_();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDamageEntity(ManasSkillInstance instance, LivingEntity entity, LivingHurtEvent event) {
        CompoundTag tag = instance.getOrCreateTag();
        if (!DamageSourceHelper.isPhysicalAttack((DamageSource)event.getSource())) {
            return;
        }
        if (entity.m_21224_() || !entity.m_6084_()) {
            return;
        }
        DamageSource repeater = null;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            repeater = DamageSource.m_19344_((Player)player);
        } else if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            repeater = DamageSource.m_19370_((LivingEntity)mob);
        }
        if (recursionDepth && !isRepeating.get().booleanValue()) {
            int count = tag.m_128451_("RecursionDepth");
            float multiplier = (float)Math.pow(2.0, count);
            float bonusDamage = event.getAmount() * multiplier;
            tag.m_128405_("RecursionDepth", tag.m_128451_("RecursionDepth") + 1);
            event.setAmount(bonusDamage);
        }
        if (instance.isToggled() && !isRepeating.get().booleanValue() && repeater != null) {
            isRepeating.set(true);
            try {
                event.getEntity().f_19802_ = 0;
                event.getEntity().m_6469_(repeater, event.getAmount());
            }
            finally {
                isRepeating.set(false);
            }
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() == 1) {
            instance.addMasteryPoint(entity);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.repeater.recursion_depth.activated").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE)), true);
            }
            recursionDepth = true;
            TimerUtils.Timer timer = TimerUtils.getOrCreateTimer("Repeater");
            timer.start(100, () -> {
                recursionDepth = false;
                instance.getOrCreateTag().m_128405_("RecursionDepth", 0);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.repeater.recursion_depth.deactivated").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE)), true);
                }
                timer.stop();
                timer.reset();
            });
            if (instance.isMastered(entity)) {
                instance.setCoolDown(15);
            } else {
                instance.setCoolDown(30);
            }
        } else {
            if (!(entity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)entity;
            UUID uuid = player.m_20148_();
            instance.addMasteryPoint((LivingEntity)player);
            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.repeater.playback.activated").m_130940_(ChatFormatting.LIGHT_PURPLE), true);
            ArrayList frames = new ArrayList();
            PLAYBACK_FRAMES.put(uuid, frames);
            TimerUtils.RepeatingTimer recordTimer = TimerUtils.getOrCreateRepeatingTimer("Repeater_Record_" + uuid);
            recordTimer.start(200, () -> {
                ServerPlayer serverPlayer = player.m_20194_().m_6846_().m_11259_(uuid);
                if (serverPlayer != null) {
                    frames.add(PlayerActionFrame.capture((Player)serverPlayer));
                    JumpTracker.clear(serverPlayer);
                }
            }, () -> {
                List<PlayerActionFrame> toPlay;
                ServerPlayer serverPlayer = player.m_20194_().m_6846_().m_11259_(uuid);
                if (serverPlayer != null && (toPlay = PLAYBACK_FRAMES.remove(uuid)) != null) {
                    toPlay.forEach(frame -> frame.playback((Player)serverPlayer));
                }
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.repeater.playback.deactivated").m_130940_(ChatFormatting.LIGHT_PURPLE), true);
            });
            instance.setCoolDown(instance.isMastered((LivingEntity)player) ? 45 : 60);
        }
    }

    static {
        PLAYBACK_FRAMES = new HashMap<UUID, List<PlayerActionFrame>>();
    }
}

