/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.attribute.ManasCoreAttributes;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import io.github.Memoires.trmysticism.registry.items.MysticismWeaponItems;
import io.github.Memoires.trmysticism.registry.sound.MysticismSoundEvents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.jetbrains.annotations.Nullable;

public class SpiritualistSkill
extends Skill {
    public SpiritualistSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Nullable
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/unique/spiritualist.png");
    }

    public double getObtainingEpCost() {
        return 80000.0;
    }

    public int modes() {
        return 3;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.spiritualist.summon_scythe");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.spiritualist.carve");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.spiritualist.enhance");
            default -> Component.m_237119_();
        };
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 3 : instance.getMode() - 1;
        }
        return instance.getMode() == 3 ? 1 : instance.getMode() + 1;
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 500.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getMastery() >= 0;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity entity, LivingHurtEvent event) {
        if (this.isInSlot(entity) && entity instanceof Player) {
            TensuraDamageSource tensuraDamageSource;
            Player player = (Player)entity;
            float damage = event.getAmount();
            float soulPercent = instance.getOrCreateTag().m_128457_("soulPercent") * 10.0f;
            DamageSource source = event.getSource();
            if (source instanceof TensuraDamageSource && (tensuraDamageSource = (TensuraDamageSource)source).getSkill() != null && tensuraDamageSource.getSkill().getSkill() instanceof SpiritualMagic) {
                event.setAmount(damage + damage * (soulPercent + 10.0f) / 100.0f);
                TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                    int soulPoints = cap.getSoulPoints();
                    int reduceBy = (int)((float)soulPoints * (soulPercent / 100.0f));
                    cap.setSoulPoints(soulPoints - reduceBy);
                });
            }
        }
    }

    public void onTakenDamage(ManasSkillInstance instance, LivingDamageEvent event) {
        if (this.isInSlot(event.getEntity())) {
            DamageSource source = event.getSource();
            if (DamageSourceHelper.isNaturalEffects((DamageSource)source) || DamageSourceHelper.isSpiritual((DamageSource)source)) {
                event.setAmount((float)((double)event.getAmount() * 0.75));
            } else if (DamageSourceHelper.isPhysicalAttack((DamageSource)source)) {
                event.setAmount((float)((double)event.getAmount() * 0.8));
            }
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        if (instance.getMode() == 1) {
            ItemStack mainHand = entity.m_21205_();
            if (mainHand.m_150930_((Item)MysticismWeaponItems.RITUAL_SCYTHE.get())) {
                entity.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            } else {
                ItemStack scytheStack = new ItemStack((ItemLike)MysticismWeaponItems.RITUAL_SCYTHE.get());
                if (entity.m_21033_(EquipmentSlot.MAINHAND)) {
                    return;
                }
                entity.m_21008_(InteractionHand.MAIN_HAND, scytheStack);
            }
        }
        if (instance.getMode() == 2 && entity.m_21205_().m_150930_((Item)MysticismWeaponItems.RITUAL_SCYTHE.get()) && entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack stack = entity.m_21205_();
            if (stack.m_41720_() == MysticismWeaponItems.RITUAL_SCYTHE.get()) {
                this.addMasteryPoint(instance, entity);
                float weaponDamage = DamageSourceHelper.getWeaponBaseDamage((Item)stack.m_41720_());
                List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(5.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity));
                if (!list.isEmpty()) {
                    for (LivingEntity target : list) {
                        if (!target.m_6469_((DamageSource)this.sourceWithMP(DamageSource.m_19370_((LivingEntity)entity), entity, instance), weaponDamage)) continue;
                        stack.m_41720_().m_7579_(stack, target, entity);
                        if (!(level instanceof ServerLevel)) continue;
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_7726_().m_8394_((Entity)entity, (Packet)new ClientboundAnimatePacket((Entity)entity, 4));
                    }
                    TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> cap.setSoulPoints((int)((double)cap.getSoulPoints() + ((double)weaponDamage + player.m_21172_(Attributes.f_22281_)) * player.m_21133_((Attribute)ManasCoreAttributes.CRIT_MULTIPLIER.get()) / 5.0 * 1000.0)));
                }
                if (instance.isMastered(entity)) {
                    instance.setCoolDown(5);
                } else {
                    instance.setCoolDown(10);
                }
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)MysticismSoundEvents.SCYTHE_SLASH.get(), SoundSource.PLAYERS, 2.0f, 0.25f);
            }
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity living, int heldTicks) {
        if (instance.getMode() == 3) {
            float soulPercent;
            CompoundTag tag = instance.getTag();
            float f = soulPercent = tag != null ? tag.m_128457_("soulPercent") : 0.0f;
            if (living instanceof Player) {
                Player player = (Player)living;
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.output_percentage", (Object[])new Object[]{Float.valueOf(soulPercent * 10.0f)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
            }
            return true;
        }
        return false;
    }

    public void onScroll(ManasSkillInstance instance, LivingEntity entity, double delta) {
        if (instance.getMode() == 3 && this.isHeld(entity)) {
            CompoundTag tag = instance.getOrCreateTag();
            float currentScale = tag.m_128457_("soulPercent");
            float newScale = currentScale + (float)((int)delta);
            if (newScale > 10.0f) {
                newScale = 10.0f;
            } else if (newScale < 0.0f) {
                newScale = 0.0f;
            }
            if (currentScale != newScale) {
                tag.m_128350_("soulPercent", newScale);
                instance.markDirty();
            }
        }
    }
}

