/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class StagnatorSkill
extends Skill {
    protected static final UUID BARRIER_UUID = UUID.fromString("74e58db3-6fd7-4fac-9dfd-cb6fc94bcc22");
    protected static final String BARRIER_NAME = "Multilayer Barrier";

    public StagnatorSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/unique/stagnator.png");
    }

    public boolean canTick(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        return instance.isMastered(entity) && instance.isToggled();
    }

    @NotNull
    public String modeLearningId(int mode) {
        return mode == 3 ? "StasisCoat" : "None";
    }

    public double getObtainingEpCost() {
        return 50000.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, @NotNull LivingEntity living) {
        return instance.isMastered(living);
    }

    public double magiculeCost(@NotNull LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 2 -> 50.0;
            case 3 -> 0.0;
            default -> 500.0;
        };
    }

    @NotNull
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.stagnator.stagnate");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.stagnator.inaction");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.stagnator.stasis_coat");
            default -> Component.m_237119_();
        };
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        return instance.getMode() == 2 && entity.m_6144_();
    }

    public int modes() {
        return 3;
    }

    public int nextMode(@NotNull LivingEntity entity, @NotNull TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 3 : instance.getMode() - 1;
        }
        return instance.getMode() == 3 ? 1 : instance.getMode() + 1;
    }

    public void onTick(@NotNull ManasSkillInstance instance, @NotNull LivingEntity entity) {
        CompoundTag tag;
        int tickCounter;
        if (SkillHelper.outOfMagicule((LivingEntity)entity, (double)this.magiculeCost(entity, instance)) && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.lack_magicule.toggled_off", (Object[])new Object[]{instance.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
        }
        if ((tickCounter = (tag = instance.getOrCreateTag()).m_128451_("TickCounter")) == 1) {
            this.incrementBarrierPoints(entity, instance);
            tag.m_128405_("TickCounter", 0);
        } else {
            tag.m_128405_("TickCounter", tickCounter + 1);
        }
        instance.markDirty();
    }

    public void onToggleOn(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        instance.getOrCreateTag().m_128405_("TickCounter", 0);
        instance.markDirty();
    }

    public void onPressed(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        switch (instance.getMode()) {
            case 1: {
                LivingEntity target = (LivingEntity)SkillHelper.getTargetingEntity(LivingEntity.class, (LivingEntity)entity, (double)30.0, (double)0.2, (boolean)false, (boolean)true);
                if (target == null) {
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.not_targeted").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                    instance.setCoolDown(instance.isMastered(entity) ? 10 : 20);
                    break;
                }
                if (target.m_21023_((MobEffect)MysticismMobEffects.STAGNATE.get())) {
                    target.m_21195_((MobEffect)MysticismMobEffects.STAGNATE.get());
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123747_, (double)1.0);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123749_, (double)1.0);
                    break;
                }
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) break;
                }
                if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) break;
                instance.addMasteryPoint(entity);
                instance.setCoolDown(instance.isMastered(entity) ? 10 : 20);
                int duration = this.isMastered(instance, entity) ? 200 : 100;
                SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)MysticismMobEffects.STAGNATE.get()), (int)duration, (int)0, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 2: {
                if (entity.m_6144_() && entity instanceof Player) {
                    this.removeBarrierPoints(entity, instance);
                    entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11738_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                instance.markDirty();
                break;
            }
            case 3: {
                int learnPoint = tag.m_128451_("StasisCoat");
                if (learnPoint < 100) {
                    tag.m_128405_("StasisCoat", learnPoint + SkillUtils.getEarningLearnPoint((ManasSkillInstance)instance, (LivingEntity)entity, (boolean)true));
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (tag.m_128451_("StasisCoat") >= 100) {
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(3)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                        } else {
                            instance.setCoolDown(10);
                            SkillUtils.learningFailPenalty((LivingEntity)entity);
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(3)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                        }
                        player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    instance.markDirty();
                    break;
                }
                if (entity.m_21023_((MobEffect)TensuraMobEffects.SEVERANCE_BLADE.get())) {
                    entity.m_21195_((MobEffect)TensuraMobEffects.SEVERANCE_BLADE.get());
                    entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                int severance = instance.isMastered(entity) ? 2 : 0;
                entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.SEVERANCE_BLADE.get(), 1200, severance, false, false, false));
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public boolean onHeld(ManasSkillInstance instance, @NotNull LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 2) {
            if (instance.isToggled() && instance.isMastered(entity)) {
                return false;
            }
            if (entity.m_6144_()) {
                return false;
            }
            entity.m_7292_(new MobEffectInstance((MobEffect)MysticismMobEffects.INACTION.get(), 5, 0, false, false, false));
            if (heldTicks % 20 == 0) {
                if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                    return false;
                }
                this.incrementBarrierPoints(entity, instance);
            }
            if (heldTicks % 100 == 0) {
                instance.addMasteryPoint(entity);
            }
            return true;
        }
        return false;
    }

    public void onRelease(ManasSkillInstance instance, @NotNull LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 2 && this.isHeld(entity)) {
            instance.setCoolDown(10);
        }
    }

    private void incrementBarrierPoints(LivingEntity entity, ManasSkillInstance instance) {
        AttributeInstance barrierAttribute = entity.m_21051_((Attribute)TensuraAttributeRegistry.BARRIER.get());
        if (barrierAttribute == null) {
            return;
        }
        double currentBarrier = 0.0;
        AttributeModifier currentModifier = barrierAttribute.m_22111_(BARRIER_UUID);
        if (currentModifier != null) {
            currentBarrier = currentModifier.m_22218_();
        }
        double newBarrier = currentBarrier + 1.0;
        if (currentModifier != null) {
            barrierAttribute.m_22120_(BARRIER_UUID);
        }
        barrierAttribute.m_22125_(new AttributeModifier(BARRIER_UUID, BARRIER_NAME, newBarrier, AttributeModifier.Operation.ADDITION));
        instance.markDirty();
    }

    private void removeBarrierPoints(LivingEntity entity, ManasSkillInstance instance) {
        AttributeInstance barrierAttribute = entity.m_21051_((Attribute)TensuraAttributeRegistry.BARRIER.get());
        if (barrierAttribute == null) {
            return;
        }
        AttributeModifier currentModifier = barrierAttribute.m_22111_(BARRIER_UUID);
        if (currentModifier != null) {
            barrierAttribute.m_22120_(BARRIER_UUID);
            instance.markDirty();
        }
    }
}

