/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.attribute.ManasCoreAttributes;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import io.github.Memoires.trmysticism.util.damage.MysticismDamageSources;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class TheBalanceSkill
extends Skill {
    public TheBalanceSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/unique/the_balance.png");
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    public int getMaxMastery() {
        return 1000;
    }

    public int modes() {
        return 1;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.the_balance.misfortune_release");
            default -> Component.m_237119_();
        };
    }

    public double getObtainingEpCost() {
        return 70000.0;
    }

    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        LivingEntity entity;
        DamageSource source = e.getSource();
        if (source.m_7640_() == attacker && DamageSourceHelper.isPhysicalAttack((DamageSource)source) && !((double)attacker.m_217043_().m_188501_() <= (double)(instance.isMastered(attacker) ? 0.65f : 0.45f)) && !SkillUtils.canNegateCritChance((Entity)(entity = e.getEntity()))) {
            double critical = attacker.m_21133_((Attribute)ManasCoreAttributes.CRIT_MULTIPLIER.get());
            e.setAmount((float)((double)e.getAmount() * critical));
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12313_, attacker.m_5720_(), 1.0f, 1.0f);
            Level var9 = attacker.m_9236_();
            if (var9 instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)var9;
                level.m_7726_().m_8394_((Entity)attacker, (Packet)new ClientboundAnimatePacket((Entity)entity, 4));
            }
        }
        e.setAmount(e.getAmount() * 0.75f);
    }

    public void onTakenDamage(ManasSkillInstance instance, LivingDamageEvent event) {
        if (this.isInSlot(event.getEntity()) && !event.isCanceled()) {
            float previousFreund = instance.getOrCreateTag().m_128457_("FreundDamage");
            instance.getOrCreateTag().m_128350_("FreundDamage", previousFreund + event.getAmount());
            if (instance.getOrCreateTag().m_128457_("FreundDamage") > 1000.0f) {
                int previousPoints = instance.getOrCreateTag().m_128451_("MisfortunePoint");
                instance.getOrCreateTag().m_128405_("MisfortunePoint", previousPoints + 1);
                instance.getOrCreateTag().m_128350_("FreundDamage", 0.0f);
            }
        }
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        if (instance.isToggled() && !event.isCanceled()) {
            LivingEntity attacker = event.getSource().m_7639_() instanceof LivingEntity ? (LivingEntity)event.getSource().m_7639_() : null;
            LivingEntity target = event.getEntity();
            DamageSource damageSource = event.getSource();
            if (!(damageSource.m_19378_() || damageSource.m_19387_() || damageSource.m_7640_() == null || damageSource.m_7640_() != damageSource.m_7639_() || target.m_217043_().m_188501_() > (instance.isMastered(target) ? 0.7f : 0.5f))) {
                target.m_9236_().m_6263_((Player)null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
                event.setCanceled(true);
                if (SkillUtils.canNegateDodge((LivingEntity)target, (DamageSource)damageSource)) {
                    event.setCanceled(false);
                }
            }
            if (attacker != null) {
                float damage = event.getAmount();
                if (!damageSource.m_19378_()) {
                    TensuraDamageSource tensuraSource;
                    if (damageSource instanceof TensuraDamageSource && (tensuraSource = (TensuraDamageSource)damageSource).getIgnoreBarrier() >= 2.0f) {
                        return;
                    }
                    Entity var6 = damageSource.m_7639_();
                    if (var6 instanceof LivingEntity) {
                        LivingEntity source = (LivingEntity)var6;
                        if (TensuraEPCapability.getEP((LivingEntity)source) >= TensuraEPCapability.getEP((LivingEntity)target) * 0.75) {
                            return;
                        }
                        if (target instanceof Player) {
                            Player player = (Player)target;
                            double cost = event.getAmount() * 25.0f;
                            if (TensuraPlayerCapability.getMagicule((Player)player) < cost) {
                                return;
                            }
                            TensuraPlayerCapability.decreaseMagicule((Player)player, (double)cost);
                        }
                    }
                }
            }
        }
    }

    public void onProjectileHit(ManasSkillInstance instance, LivingEntity entity, ProjectileImpactEvent event) {
        if (instance.isToggled() && !SkillUtils.isProjectileAlwaysHit((Projectile)event.getProjectile()) && !(entity.m_217043_().m_188501_() > 0.5f)) {
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
            event.setCanceled(true);
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() == 1) {
            if (SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
                return;
            }
            LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)8.0, (boolean)false);
            int misfortunePoints = instance.getOrCreateTag().m_128451_("MisfortunePoint");
            if (target != null) {
                if (instance.getOrCreateTag().m_128451_("MisfortunePoint") < 10 && instance.getOrCreateTag().m_128451_("MisfortunePoint") > 0) {
                    target.m_6469_(MysticismDamageSources.balance((Entity)entity), (float)(1000 * misfortunePoints));
                    instance.getOrCreateTag().m_128405_("MisfortunePoint", misfortunePoints * 0);
                    instance.addMasteryPoint(entity);
                } else if (instance.getOrCreateTag().m_128451_("MisfortunePoint") > 10) {
                    target.m_6469_(MysticismDamageSources.balance((Entity)entity), 10000.0f);
                    instance.getOrCreateTag().m_128405_("MisfortunePoint", misfortunePoints - 10);
                    instance.addMasteryPoint(entity);
                } else if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.the_balance.not_enough_points").m_130940_(ChatFormatting.RED), true);
                }
            }
        }
    }
}

